/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.fi.ar.mservice.SettleServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class AbstractRecSettleService
extends AbstractSettleTemplate {
    protected List<BillSettleVO> getMainListVO(DynamicObject[] mains) {
        return RecBillHandlerHelper.getMainListVO((DynamicObject[])mains);
    }

    protected List<SettleRecordVO> doSettle(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        if (ObjectUtils.isEmpty(mainList) || !new InitHelper(mainList.get(0).getOrgId(), "ar_init").isFinishSetting()) {
            return null;
        }
        if (scheme.isDiffCurrencySettle()) {
            return SettleServiceHelper.diffCurrencySettle(mainList, asstList, scheme, settleType);
        }
        return SettleServiceHelper.settle(mainList, asstList, scheme, settleType);
    }

    protected void afterSettle(List<SettleRecordVO> resultList, SettleSchemeVO scheme) {
        if (resultList != null && resultList.size() > 0) {
            for (SettleRecordVO settleRecordVO : resultList) {
                settleRecordVO.setSettleRela(this.getSettleRelation());
                settleRecordVO.setAutoSettleType(scheme.isOnlyByBotp() ? "1" : (scheme.isOnlyByCoreBill() ? "2" : "3"));
            }
            this.batchDisposeMainBill(resultList, scheme);
            ArrayList entryList = new ArrayList(64);
            for (SettleRecordVO settleRecordVO : resultList) {
                entryList.addAll(settleRecordVO.getEntrys());
            }
            this.disposeAsstBill(entryList, scheme);
            boolean bl = scheme.isDiffCurrencySettle();
            for (SettleRecordVO result : resultList) {
                if (!bl) {
                    CommonSettleServiceHelper.resolveSwapPL((SettleRecordVO)result, (SettleSchemeVO)scheme);
                    continue;
                }
                CommonSettleServiceHelper.resolveSwapPLForDiffCurrencySettle((SettleRecordVO)result, (SettleSchemeVO)scheme);
            }
            DynamicObject[] dynamicObjectArray = SettleServiceHelper.converVO2Dyn(resultList);
            if (dynamicObjectArray.length > 0) {
                List<Object> settleRecordIds = SettleServiceHelper.saveSettleRecord(dynamicObjectArray);
                scheme.setRecordPks(settleRecordIds);
            }
        }
    }

    protected SettleRecordVO getSettleRecordVO(DynamicObject result) {
        return SettleServiceHelper.converDyn2VO(result);
    }

    protected void batchDisposeMainBill(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        RecBillHandlerHelper.batchDisposeByMainBill(voList, (SettleSchemeVO)scheme);
    }

    public void disposeMainBill(SettleRecordVO vo, SettleSchemeVO scheme) {
        RecBillHandlerHelper.disposeByMainBill((SettleRecordVO)vo, (SettleSchemeVO)scheme);
    }
}

