/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.mservice.ArAdjustSettleService;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ArAdjustAutoSettleService
extends AbsAutoSettleService {
    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        if (isMain) {
            return;
        }
        BigDecimal adjustRecAmount = obj.getBigDecimal("recamount");
        if (adjustRecAmount.compareTo(BigDecimal.ZERO) >= 0) {
            return;
        }
        DynamicObject[] sourceFinBills = this.getMainObjs(obj);
        if (EmptyUtils.isEmpty((Object)sourceFinBills)) {
            return;
        }
        DynamicObject sourceFinBill = sourceFinBills[0];
        DynamicObjectCollection planentitys = sourceFinBill.getDynamicObjectCollection("planentity");
        for (Object planentity : planentitys) {
            planentity.set("unplansettleamt", planentity.get("unplanlockamt"));
        }
        DynamicObjectCollection entrys = sourceFinBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            entry.set("e_unsettleamt", entry.get("e_unlockamt"));
        }
        BigDecimal sourceRecAmount = sourceFinBill.getBigDecimal("unsettleamount");
        if (sourceRecAmount.abs().compareTo(adjustRecAmount.abs()) < 0) {
            return;
        }
        SettleSchemeVO settleScheme = new SettleSchemeVO();
        settleScheme.setOnlyByBotp(true);
        settleScheme.setAdjust(true);
        DynamicObject[] assts = new DynamicObject[]{obj};
        ArAdjustSettleService settleService = new ArAdjustSettleService();
        this.addSettleLock(sourceFinBills, assts);
        settleService.settle(sourceFinBills, assts, settleScheme, SettleTypeEnum.AUTO.getValue());
    }

    private DynamicObject[] getMainObjs(DynamicObject obj) {
        long sourceBillId = obj.getLong("sourcebillid");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)};
        return FinArBillHandleHelper.load((QFilter[])filters);
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        if (SettleRelationEnum.ARSELF.getValue().equals(settleRelation)) {
            return new ArAdjustSettleService();
        }
        return SettleServiceFactory.getService(settleRelation);
    }
}

