/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.mservice.ArFinTransferSettleService;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ArFinTransferAutoSettleService
extends AbsAutoSettleService {
    private ArFinTransferSettleService settleService = new ArFinTransferSettleService();
    private Map<Long, Boolean> orgParamMap = new HashMap<Long, Boolean>(8);

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        DynamicObject[] assts = new DynamicObject[]{obj};
        DynamicObject[] mains = this.getFinArBills(obj);
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setOnlyByBotp(true);
        scheme.setTransferPay(true);
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            this.addSettleLock(mains, assts);
            this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
        }
    }

    private DynamicObject[] getFinArBills(DynamicObject asst) {
        long orgId = asst.getLong("org.id");
        Boolean isMaterialSettle = this.orgParamMap.get(orgId);
        if (isMaterialSettle == null) {
            isMaterialSettle = "1".equals(SystemParameterHelper.getARAppParameter((Long)orgId, (String)"ar_003"));
            this.orgParamMap.put(orgId, isMaterialSettle);
        }
        HashSet<Long> billEntryIdSet = new HashSet<Long>();
        DynamicObjectCollection entryColl = asst.getDynamicObjectCollection(isMaterialSettle != false ? "entry" : "planentity");
        for (DynamicObject entry : entryColl) {
            billEntryIdSet.add(entry.getLong("id"));
        }
        Map idAndIdListMap = BOTPNewHelper.loadNearSourceBillIds((String)"ar_finarbill", (String)(isMaterialSettle != false ? "entry" : "planentity"), (Long[])new Long[]{asst.getLong("id")}, (Long[])billEntryIdSet.toArray(new Long[0]), (String)"ar_finarbill");
        HashSet souBillIdSet = new HashSet(idAndIdListMap.size());
        for (Map.Entry entry : idAndIdListMap.entrySet()) {
            souBillIdSet.addAll((Collection)entry.getValue());
        }
        String entryUnSettleamtKey = "entry.e_unsettleamt";
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", souBillIdSet), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter(entryUnSettleamtKey, "!=", (Object)0)};
        return FinArBillHandleHelper.load((QFilter[])filter);
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }
}

