/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.ArPaySettleService;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ArPayAutoSettleService
extends AbsAutoSettleService {
    public static final String BILLKEY = "cas_paybill";
    private final ArPaySettleService settleService = new ArPaySettleService();

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        DynamicObject[] objArr = new DynamicObject[]{obj};
        this.batchAutoSettle(objArr, isMain);
    }

    public void batchAutoSettle(DynamicObject[] objArr, boolean isMain) throws KDBizException {
        this.batchAutoSettle(objArr, isMain, new SettleSchemeVO());
    }

    public void batchAutoSettle(DynamicObject[] objArr, boolean isMain, SettleSchemeVO scheme) throws KDBizException {
        DynamicObject[] assts;
        DynamicObject[] mains;
        scheme.setMainOp(isMain);
        if (isMain) {
            mains = objArr;
            assts = this.getAsstObjs(objArr, scheme);
        } else {
            assts = objArr;
            mains = this.getMainObjs(objArr, scheme);
        }
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            this.addSettleLock(mains, assts);
            this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
        }
    }

    public void batchAutoSettle(Set<Long> mainIds, String asstEntity, Set<Long> asstIds, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(mainIds) || ObjectUtils.isEmpty(asstIds) || ObjectUtils.isEmpty((Object)scheme)) {
            return;
        }
        DynamicObject[] mains = FinArBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", mainIds)});
        QFilter filter = new QFilter("id", "in", asstIds);
        filter.and(new QFilter("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
        DynamicObject[] assts = PayBillHandleHelper.loadPay((QFilter[])new QFilter[]{filter});
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
        }
    }

    private DynamicObject[] getAsstObjs(DynamicObject[] objArr, SettleSchemeVO scheme) {
        HashSet<String> coreBillNos = new HashSet<String>(objArr.length);
        HashSet<String> coreBillSeqs = new HashSet<String>(objArr.length);
        for (DynamicObject main : objArr) {
            DynamicObjectCollection mainEntrys = main.getDynamicObjectCollection("entry");
            for (DynamicObject mainEntry : mainEntrys) {
                String coreBillNo = mainEntry.getString("e_corebillno");
                String coreBillseq = mainEntry.getString("e_corebillentryseq");
                if (StringUtils.isEmpty((String)coreBillNo) || StringUtils.isEmpty((String)coreBillseq)) continue;
                coreBillNos.add(coreBillNo);
                coreBillSeqs.add(coreBillseq);
            }
        }
        DynamicObject[] asstObjs = null;
        if (coreBillNos.size() > 0 && coreBillSeqs.size() > 0) {
            QFilter[] billFilter = new QFilter[]{new QFilter("billstatus", "=", (Object)"D"), new QFilter("entry.e_corebillno", "in", coreBillNos), new QFilter("entry.e_unsettledamt", ">", (Object)0)};
            Object[] billObjs = PayBillHandleHelper.loadPay((QFilter[])billFilter);
            QFilter[] preBillFilter = new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("entry.e_corebillno", "in", coreBillNos), new QFilter("entry.e_unsettledamt", ">", (Object)0)};
            Object[] preBillObjs = PayBillHandleHelper.loadPaid((QFilter[])preBillFilter);
            asstObjs = (DynamicObject[])ArrayUtils.addAll((Object[])billObjs, (Object[])preBillObjs);
        }
        scheme.setOnlyByCoreBill(true);
        return asstObjs;
    }

    private DynamicObject[] getMainObjs(DynamicObject[] assts, SettleSchemeVO scheme) {
        DynamicObject[] mainBills = null;
        List<Long> asstIds = Arrays.stream(assts).map(asst -> asst.getLong("id")).collect(Collectors.toList());
        Map finArBillMap = BOTPHelper.loadNearUpBillIds((String)BILLKEY, (String)"ar_finarbill", (Long[])asstIds.toArray(new Long[0]));
        if (finArBillMap.size() > 0) {
            HashSet finArBillIds = new HashSet(10);
            for (Map.Entry mapEntry : finArBillMap.entrySet()) {
                finArBillIds.addAll((Collection)mapEntry.getValue());
            }
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", finArBillIds), new QFilter("entry.e_unsettleamt", "<", (Object)0)};
            mainBills = FinArBillHandleHelper.load((QFilter[])filter);
            scheme.setOnlyByBotp(true);
            return mainBills;
        }
        DynamicObjectCollection asstColl = QueryServiceHelper.query((String)BILLKEY, (String)"id,entry.id,entry.e_corebillno,entry.e_corebillentryseq", (QFilter[])new QFilter[]{new QFilter("id", "in", asstIds)});
        HashSet<String> coreBillNos = new HashSet<String>();
        HashSet<String> coreBillSeqs = new HashSet<String>();
        for (DynamicObject asstObj : asstColl) {
            String coreBillNo = asstObj.getString("entry.e_corebillno");
            String coreBillseq = asstObj.getString("entry.e_corebillentryseq");
            if (StringUtils.isEmpty((String)coreBillNo) || StringUtils.isEmpty((String)coreBillseq)) continue;
            coreBillNos.add(coreBillNo);
            coreBillSeqs.add(coreBillseq);
        }
        if (coreBillNos.size() > 0 && coreBillSeqs.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("entry.e_corebillno", "in", coreBillNos), new QFilter("entry.e_unsettleamt", ">", (Object)0), new QFilter("billstatus", "=", (Object)"C")};
            mainBills = FinArBillHandleHelper.load((QFilter[])filter);
            scheme.setOnlyByCoreBill(true);
        }
        return mainBills;
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }
}

