/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.mservice.AbstractArSettleService;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.settle.writeback.FinArSettleWriteBacker;
import kd.fi.arapcommon.service.settle.writeback.SettleWriteBackerParam;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.writeback.settle.ArPreSettleWBService;

public class ArPremSettleService
extends AbstractArSettleService {
    @Override
    protected List<BillSettleVO> getMainListVO(DynamicObject[] mains) {
        List<BillSettleVO> mainListVO = super.getMainListVO(mains);
        if (2 == this.scheme.getSettleEntryParam()) {
            for (BillSettleVO vo : mainListVO) {
                block1: for (DynamicObject main : mains) {
                    DynamicObjectCollection planEntrys = main.getDynamicObjectCollection("planentity");
                    for (DynamicObject planEntry : planEntrys) {
                        if (planEntry.getLong("id") != vo.getEntryId()) continue;
                        vo.setEntryUnSettleAmt(planEntry.getBigDecimal("planlockedamt"));
                        continue block1;
                    }
                }
            }
        } else {
            for (BillSettleVO vo : mainListVO) {
                block4: for (DynamicObject main : mains) {
                    DynamicObjectCollection detailEntrys = main.getDynamicObjectCollection("entry");
                    for (DynamicObject detailEntry : detailEntrys) {
                        if (detailEntry.getLong("id") != vo.getEntryId()) continue;
                        vo.setEntryUnSettleAmt(detailEntry.getBigDecimal("e_lockedamt"));
                        continue block4;
                    }
                }
            }
        }
        return mainListVO;
    }

    protected List<BillSettleVO> getAsstListVO(DynamicObject[] assts) {
        return FinArBillHandleHelper.getAsstListVOForPrem((DynamicObject[])assts, (SettleSchemeVO)this.scheme);
    }

    protected String getSettleRelation() {
        return SettleRelationEnum.ARPREMSETTLE.getValue();
    }

    @Override
    protected void batchDisposeMainBill(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        Set billIdSet = voList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
        DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org,settleversion", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, String> billVersion = new HashMap<Long, String>(8);
        for (DynamicObject arBill : arBills) {
            billVersion.put(arBill.getLong("id"), arBill.getString("settleversion"));
        }
        ArrayList<SettleRecordVO> oldList = new ArrayList<SettleRecordVO>(8);
        ArrayList<SettleRecordVO> newList = new ArrayList<SettleRecordVO>(8);
        boolean allowNewSettleByOrg = SettleVersionServiceHelper.isAllowNewSettleByOrg((long)arBills[0].getLong("org.id"));
        boolean newCustomerUseNewSettle = SettleVersionServiceHelper.isNewCustomerUseNewSettle();
        for (SettleRecordVO vo : voList) {
            long mainBillId = vo.getMainBillId();
            String version = (String)billVersion.get(mainBillId);
            if (newCustomerUseNewSettle) {
                newList.add(vo);
                continue;
            }
            if ("0".equals(version) || "".equals(version)) {
                oldList.add(vo);
                continue;
            }
            if (allowNewSettleByOrg) {
                newList.add(vo);
                continue;
            }
            oldList.add(vo);
        }
        if (oldList.size() > 0) {
            ArPreSettleWBService premWBService = (ArPreSettleWBService)BeanFactory.getBean(ArPreSettleWBService.class, (Object[])new Object[0]);
            premWBService.writeBack(oldList, scheme);
        }
        if (newList.size() > 0) {
            FinArSettleWriteBacker finArSettleWriteBacker = (FinArSettleWriteBacker)BeanFactory.getBean(FinArSettleWriteBacker.class, (Object[])new Object[0]);
            finArSettleWriteBacker.initParam(new SettleWriteBackerParam(scheme, "ar_finarbill"));
            finArSettleWriteBacker.writeBackAsMain(newList);
        }
    }

    public void disposeAsstBill(List<SettleRecordEntryVO> entryList, SettleSchemeVO scheme) {
    }
}

