/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.ArReceiveSettleService;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ArReceiveAutoSettleService
extends AbsAutoSettleService {
    private static final Log logger = LogFactory.getLog(ArReceiveAutoSettleService.class);
    public static final String ASST_CAS_RECEIVEBILL = "cas_recbill";
    public static final String ASST_AR_RECEIVEDILL = "ar_receivedbill";
    private ArReceiveSettleService settleService = new ArReceiveSettleService();

    public void batchAutoSettle(DynamicObject[] objArr, boolean isMain) throws KDBizException {
        DynamicObject[] assts;
        DynamicObject[] mains;
        SettleSchemeVO scheme = new SettleSchemeVO();
        if (isMain) {
            mains = objArr;
            assts = this.getAsstObjs(objArr, scheme);
        } else {
            assts = objArr;
            mains = this.getMainObjs(objArr[0], scheme);
        }
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            this.addSettleLock(mains, assts);
            List mainIdList = DynamicObjectHelper.getIdList((DynamicObject[])mains);
            mains = FinArBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", (Object)mainIdList)});
            List asstIdList = DynamicObjectHelper.getIdList((DynamicObject[])assts);
            assts = RecBillHandlerHelper.loadRecById((List)asstIdList);
            if (scheme.isOnlyByBotp()) {
                this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
            } else {
                this.settleByCoreBill(mains, assts, scheme);
            }
        }
    }

    public void batchAutoSettle(Set<Long> mainIds, String asstEntity, Set<Long> asstIds, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(mainIds) || ObjectUtils.isEmpty(asstIds) || ObjectUtils.isEmpty((Object)scheme)) {
            logger.info("ArReceiveAutoSettleService batchAutoSettle param is null;return;");
            return;
        }
        DynamicObject[] mains = FinArBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", mainIds)});
        DynamicObject[] assts = null;
        if (ASST_CAS_RECEIVEBILL.equals(asstEntity)) {
            assts = RecBillHandlerHelper.loadRec((QFilter[])new QFilter[]{new QFilter("id", "in", asstIds)});
        } else if (ASST_AR_RECEIVEDILL.equals(asstEntity)) {
            assts = RecBillHandlerHelper.loadReced((QFilter[])new QFilter[]{new QFilter("id", "in", asstIds)});
        }
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            if (scheme.isOnlyByBotp()) {
                this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
            } else {
                this.settleByCoreBill(mains, assts, scheme);
            }
        }
    }

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        DynamicObject[] objArr = new DynamicObject[]{obj};
        this.batchAutoSettle(objArr, isMain);
    }

    private DynamicObject[] getAsstObjs(DynamicObject[] objArr, SettleSchemeVO scheme) {
        HashSet<String> coreBillNos = new HashSet<String>();
        HashSet<String> coreBillSeqs = new HashSet<String>();
        for (DynamicObject main : objArr) {
            DynamicObjectCollection mainEntrys = main.getDynamicObjectCollection("entry");
            for (DynamicObject mainEntry : mainEntrys) {
                String coreBillNo = mainEntry.getString("e_corebillno");
                String coreBillseq = mainEntry.getString("e_corebillentryseq");
                if (StringUtils.isEmpty((String)coreBillNo) || StringUtils.isEmpty((String)coreBillseq)) continue;
                coreBillNos.add(coreBillNo);
                coreBillSeqs.add(coreBillseq);
            }
        }
        DynamicObject[] asstObjs = null;
        if (coreBillNos.size() > 0 && coreBillSeqs.size() > 0) {
            QFilter[] recFilter = new QFilter[]{new QFilter("entry.e_corebillno", "in", coreBillNos), new QFilter("entry.e_unsettledamt", "<>", (Object)0)};
            Object[] recObjs = RecBillHandlerHelper.loadRec((QFilter[])recFilter);
            QFilter[] recedFilter = new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("entry.e_corebillno", "in", coreBillNos), new QFilter("entry.e_unsettledamt", "<>", (Object)0)};
            Object[] recedObjs = RecBillHandlerHelper.loadReced((QFilter[])recedFilter);
            asstObjs = (DynamicObject[])ArrayUtils.addAll((Object[])recObjs, (Object[])recedObjs);
        }
        scheme.setOnlyByCoreBill(true);
        return asstObjs;
    }

    private DynamicObject[] getMainObjs(DynamicObject asst, SettleSchemeVO scheme) {
        DynamicObject[] mainBills = null;
        Set souBillIdSet = BOTPHelper.findSouBillIds((String)ASST_CAS_RECEIVEBILL, (Long)asst.getLong("id"), (String)"ar_finarbill");
        if (souBillIdSet != null && souBillIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)souBillIdSet), new QFilter("entry.e_unsettleamt", "<>", (Object)0)};
            mainBills = FinArBillHandleHelper.load((QFilter[])filter);
            scheme.setOnlyByBotp(true);
            return mainBills;
        }
        DynamicObjectCollection asstColl = QueryServiceHelper.query((String)ASST_CAS_RECEIVEBILL, (String)"id,entry.id,entry.e_corebillno,entry.e_corebillentryseq, entry.e_corebilltype,entry.e_settleorg", (QFilter[])new QFilter[]{new QFilter("id", "=", asst.getPkValue())});
        HashSet<String> coreBillNos = new HashSet<String>();
        HashSet<String> coreBillSeqs = new HashSet<String>();
        HashSet<Long> settleOrgIds = new HashSet<Long>(asstColl.size());
        HashSet<String> coreBillTypes = new HashSet<String>(asstColl.size());
        for (DynamicObject asstObj : asstColl) {
            String coreBillNo = asstObj.getString("entry.e_corebillno");
            String coreBillseq = asstObj.getString("entry.e_corebillentryseq");
            String coreBillType = asstObj.getString("entry.e_corebilltype");
            long settleOrgId = asstObj.getLong("entry.e_settleorg");
            if (StringUtils.isEmpty((String)coreBillNo) || StringUtils.isEmpty((String)coreBillseq)) continue;
            coreBillNos.add(coreBillNo);
            coreBillSeqs.add(coreBillseq);
            coreBillTypes.add(coreBillType);
            if (settleOrgId == 0L) continue;
            settleOrgIds.add(settleOrgId);
        }
        if (coreBillNos.size() > 0 && coreBillSeqs.size() > 0) {
            QFilter billNoFilter = new QFilter("billno", "in", coreBillNos);
            billNoFilter.and(new QFilter("entry.e_unsettleamt", "<>", (Object)0));
            billNoFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            QFilter coreBillNoFilter = new QFilter("entry.e_corebillno", "in", coreBillNos);
            coreBillNoFilter.and(new QFilter("entry.e_unsettleamt", "<>", (Object)0));
            coreBillNoFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            if (settleOrgIds.size() > 0) {
                coreBillNoFilter.and(new QFilter("org", "in", settleOrgIds));
            }
            Object[] billNoBills = null;
            if (coreBillTypes.contains("ar_finarbill")) {
                billNoBills = FinArBillHandleHelper.load((QFilter[])billNoFilter.toArray());
            }
            Object[] coreBillNoBills = FinArBillHandleHelper.load((QFilter[])coreBillNoFilter.toArray());
            mainBills = (DynamicObject[])ArrayUtils.addAll((Object[])billNoBills, (Object[])coreBillNoBills);
            mainBills = Arrays.stream(mainBills).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(bill -> bill.getLong("id")))), ArrayList::new)).toArray(new DynamicObject[0]);
            scheme.setOnlyByCoreBill(true);
        }
        return mainBills;
    }

    private void settleByCoreBill(DynamicObject[] mains, DynamicObject[] assts, SettleSchemeVO scheme) {
        int arSettleParam = ArApHelper.getArSettleParam((Object)mains[0].get("org.id"));
        scheme.setSettleEntryParam(arSettleParam);
        scheme.setSettle(true);
        if (arSettleParam == 2) {
            ArrayList mainList = new ArrayList();
            for (DynamicObject main : mains) {
                Object detailEntry2;
                DynamicObjectCollection detailEntrys = main.getDynamicObjectCollection("entry");
                HashSet<String> coreBillNoSet = new HashSet<String>();
                for (Object detailEntry2 : detailEntrys) {
                    String coreBillNo = detailEntry2.getString("e_corebillno");
                    if (ObjectUtils.isEmpty((Object)coreBillNo)) continue;
                    coreBillNoSet.add(coreBillNo);
                }
                List mainPlanVO = FinArBillHandleHelper.getMainListVO((DynamicObject[])new DynamicObject[]{main}, (SettleSchemeVO)scheme);
                detailEntry2 = mainPlanVO.iterator();
                while (detailEntry2.hasNext()) {
                    BillSettleVO vo = (BillSettleVO)detailEntry2.next();
                    vo.setCoreBillNum(coreBillNoSet);
                }
                if (scheme.isOnlyByCoreBill() && this.isNeedRemoveListVo(main, "plancorebillno")) {
                    Iterator mainPlanVOIterator = mainPlanVO.iterator();
                    while (mainPlanVOIterator.hasNext()) {
                        BillSettleVO bill = (BillSettleVO)mainPlanVOIterator.next();
                        Map extFields = bill.getExtFields();
                        if (!ObjectUtils.isEmpty(extFields.get("corebillno"))) continue;
                        mainPlanVOIterator.remove();
                    }
                }
                mainList.addAll(mainPlanVO);
            }
            List asstList = RecBillHandlerHelper.getAsstListVO((DynamicObject[])assts);
            this.settleService.settleByVO(mainList, asstList, scheme, SettleTypeEnum.AUTO.getValue());
        } else {
            this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
        }
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }

    private boolean isNeedRemoveListVo(DynamicObject main, String fieldKey) {
        boolean isNeedRemove = false;
        DynamicObjectCollection planEntrys = main.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntrys) {
            if (ObjectUtils.isEmpty((Object)planEntry.getString(fieldKey))) continue;
            isNeedRemove = true;
            break;
        }
        return isNeedRemove;
    }
}

