/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.ar.mservice.AbstractArSettleService;
import kd.fi.ar.mservice.SettleServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ArSelfSettleService
extends AbstractArSettleService {
    @Override
    protected List<BillSettleVO> getMainListVO(DynamicObject[] mains) {
        List<BillSettleVO> mainList = super.getMainListVO(mains);
        for (int i = mainList.size() - 1; i >= 0; --i) {
            BillSettleVO mainVO = mainList.get(i);
            if (mainVO.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0) continue;
            mainList.remove(mainVO);
        }
        return mainList;
    }

    protected List<BillSettleVO> getAsstListVO(DynamicObject[] assts) {
        List asstList = FinArBillHandleHelper.getAsstListVO((DynamicObject[])assts, (SettleSchemeVO)this.scheme);
        for (int i = asstList.size() - 1; i >= 0; --i) {
            BillSettleVO asstVO = (BillSettleVO)asstList.get(i);
            if (asstVO.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0) continue;
            asstList.remove(asstVO);
        }
        return asstList;
    }

    @Override
    protected List<SettleRecordVO> doSettle(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        scheme.setSettleSelf(true);
        if (scheme.isDiffCurrencySettle()) {
            return SettleServiceHelper.diffCurrencySettle(mainList, asstList, scheme, settleType);
        }
        return SettleServiceHelper.settleSelf(mainList, asstList, scheme, settleType);
    }

    @Override
    public void disposeMainBill(SettleRecordVO result, SettleSchemeVO scheme) {
        scheme.setSettleSelf(true);
        super.disposeMainBill(result, scheme);
    }

    @Override
    protected void batchDisposeMainBill(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        scheme.setSettleSelf(true);
        super.batchDisposeMainBill(voList, scheme);
    }

    public void disposeAsstBill(List<SettleRecordEntryVO> entryList, SettleSchemeVO scheme) {
        FinArBillHandleHelper.disposeByAsstBill(entryList, (SettleSchemeVO)scheme);
    }

    protected String getSettleRelation() {
        return SettleRelationEnum.ARSELF.getValue();
    }
}

