/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.List;
import java.util.Set;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ar.mservice.api.settle.ArUnSettleServiceImpl;
import kd.fi.arapcommon.helper.CasCancelUnSettleServiceHelper;
import kd.fi.arapcommon.service.log.LogUtil;

public class ArUniversalUnSettleService {
    public static final Log logger = LogFactory.getLog(ArUniversalUnSettleService.class);

    public void unSettle(String billEntity, Set<Long> billIds) {
        ArUnSettleServiceImpl service = new ArUnSettleServiceImpl();
        service.unSettleByBillId(billEntity, billIds);
    }

    public void canCelUnSettle(List<Long> recBillPks) {
        logger.info("RecBillListener cancelRec recBillPks is :" + recBillPks);
        try (TXHandle tx = TX.required();){
            try {
                CasCancelUnSettleServiceHelper.cancelRec(recBillPks);
                LogUtil.addInvokeLog((String)"RecBillListener_cancelRec", (Object[])new Object[]{recBillPks}, null, (boolean)true);
            }
            catch (Exception e) {
                logger.info("RecBillListener cancelRec exception:" + e);
                LogUtil.addInvokeLog((String)"RecBillListener_cancelRec_error", (Object[])new Object[]{recBillPks}, (Object)e, (boolean)true);
                tx.markRollback();
                throw e;
            }
            logger.info("RecBillListener cancelRec end");
        }
    }
}

