/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class AutoGenerateOriginalService {
    private static final Log logger = LogFactory.getLog(AutoGenerateOriginalService.class);

    public Map<String, Object> getOriginalIds(List<Long> idList, String entityName) {
        List originalBillList;
        List busBillList;
        logger.info("AutoGenerateOriginalService.getOriginalIds.idList\uff1a" + idList);
        logger.info("AutoGenerateOriginalService.getOriginalIds.entityName\uff1a" + entityName);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        if (ObjectUtils.isEmpty(idList) || ObjectUtils.isEmpty((Object)entityName)) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("errMsg", "received data is null");
            return resultMap;
        }
        try {
            busBillList = "sm_salorder".equals(entityName) ? BOTPHelper.push((String)entityName, (String)"ar_busbill", (String)"1683401792949442560", idList, (boolean)false, (String)"ar") : BOTPHelper.push((String)entityName, (String)"ar_busbill", idList, (boolean)false, (String)"ar");
        }
        catch (Exception e) {
            logger.info("AutoGenerateOriginalService push busarbill error is " + e.getMessage());
            resultMap.put("success", Boolean.FALSE);
            String tipMessage = "sm_salorder".equals(entityName) ? ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355", (String)"AutoGenerateOriginalService_13", (String)"fi-ar-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9500\u552e\u5408\u540c", (String)"AutoGenerateOriginalService_14", (String)"fi-ar-mservice", (Object[])new Object[0]);
            resultMap.put("errMsg", String.format(ResManager.loadKDString((String)"%1$s\u4e0b\u63a8\u6682\u4f30\u5e94\u6536\u5355\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"AutoGenerateOriginalService_0", (String)"fi-ar-mservice", (Object[])new Object[0]), tipMessage, e.getMessage()));
            return resultMap;
        }
        Map<Long, DynamicObject> idPayproperty = this.getPayproperties(busBillList);
        for (DynamicObject busBill : busBillList) {
            DynamicObject payproperty = busBill.getDynamicObject("payproperty");
            if (payproperty != null && payproperty.getLong("id") != 0L || ObjectUtils.isEmpty((Object)(payproperty = idPayproperty.get(busBill.getLong("id"))))) continue;
            busBill.set("payproperty", (Object)payproperty);
        }
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_busbill", (DynamicObject[])busBillList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        Map<Long, String> busIdNumberMap = busBillList.stream().collect(Collectors.toMap(a -> a.getLong("id"), a -> a.getString("billno")));
        List saveSuccessIdList = saveResult.getSuccessPkIds();
        Map<String, List<String>> saveBillNumberMap = this.getBillNumber(saveSuccessIdList, busIdNumberMap);
        if (!saveResult.isSuccess()) {
            resultMap.put("success", Boolean.FALSE);
            StringBuffer errMsg = new StringBuffer();
            List<String> successList = saveBillNumberMap.get("success");
            int failNum = saveBillNumberMap.get("noSuccess").size();
            String assertMsg = this.assertResult(saveResult);
            logger.info("------AutoGenerateOriginalService.busSave.fail.num------" + failNum);
            logger.info("------AutoGenerateOriginalService.busSave.fail.failMsg------" + assertMsg);
            if (!ObjectUtils.isEmpty(successList)) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u9884\u5f00\u7968\u5931\u8d25\uff1a\u6682\u4f30\u5e94\u6536\u5355%1$s\u4fdd\u5b58\u6210\u529f\u3002", (String)"AutoGenerateOriginalService_1", (String)"fi-ar-mservice", (Object[])new Object[0]), successList.toString()));
            }
            errMsg.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728%1$s\u5f20\u6682\u4f30\u5e94\u6536\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"AutoGenerateOriginalService_2", (String)"fi-ar-mservice", (Object[])new Object[0]), failNum, assertMsg));
            resultMap.put("errMsg", errMsg);
            return resultMap;
        }
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_busbill", (Object[])saveSuccessIdList.toArray(), (OperateOption)OperateOption.create());
        List submitSuccessIdList = submitResult.getSuccessPkIds();
        Map<String, List<String>> submitBillNumberMap = this.getBillNumber(submitSuccessIdList, busIdNumberMap);
        if (!submitResult.isSuccess()) {
            resultMap.put("success", Boolean.FALSE);
            String failBillNo = submitBillNumberMap.get("noSuccess").toString();
            String assertMsg = this.assertResult(submitResult);
            logger.info("------AutoGenerateOriginalService.busSubmit.fail.billno------" + failBillNo);
            logger.info("------AutoGenerateOriginalService.busSubmit.fail.failMsg------" + assertMsg);
            StringBuffer errMsg = new StringBuffer(String.format(ResManager.loadKDString((String)"\u9884\u5f00\u7968\u5931\u8d25\uff1a\u6682\u4f30\u5e94\u6536\u5355%1$s\u63d0\u4ea4\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"AutoGenerateOriginalService_3", (String)"fi-ar-mservice", (Object[])new Object[0]), failBillNo, assertMsg));
            List<String> successList = submitBillNumberMap.get("success");
            if (!ObjectUtils.isEmpty(successList)) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\u63d0\u4ea4\u6210\u529f\u3002", (String)"AutoGenerateOriginalService_4", (String)"fi-ar-mservice", (Object[])new Object[0]), successList.toString()));
            }
            resultMap.put("errMsg", errMsg);
            return resultMap;
        }
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_busbill", (Object[])submitSuccessIdList.toArray(), (OperateOption)OperateOption.create());
        List auditSuccessIdList = auditResult.getSuccessPkIds();
        Map<String, List<String>> auditBillNumberMap = this.getBillNumber(auditSuccessIdList, busIdNumberMap);
        if (!auditResult.isSuccess()) {
            resultMap.put("success", Boolean.FALSE);
            String failBillNo = auditBillNumberMap.get("noSuccess").toString();
            String assertMsg = this.assertResult(auditResult);
            logger.info("------AutoGenerateOriginalService.busAudit.fail.billno------" + failBillNo);
            logger.info("------AutoGenerateOriginalService.busAudit.fail.failMsg------" + assertMsg);
            StringBuffer errMsg = new StringBuffer(String.format(ResManager.loadKDString((String)"\u9884\u5f00\u7968\u5931\u8d25\uff1a\u6682\u4f30\u5e94\u6536\u5355%1$s\u5ba1\u6838\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"AutoGenerateOriginalService_6", (String)"fi-ar-mservice", (Object[])new Object[0]), failBillNo, assertMsg));
            List<String> successList = auditBillNumberMap.get("success");
            if (!ObjectUtils.isEmpty(successList)) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\u5ba1\u6838\u6210\u529f\u3002", (String)"AutoGenerateOriginalService_7", (String)"fi-ar-mservice", (Object[])new Object[0]), successList.toString()));
            }
            resultMap.put("errMsg", errMsg);
            return resultMap;
        }
        List busBillIdList = busBillList.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
        try {
            originalBillList = BOTPHelper.push((String)"ar_busbill", (String)"sim_original_bill", busBillIdList, (boolean)false, (String)"sim");
        }
        catch (Exception e) {
            logger.info("AutoGenerateOriginalService push original error is " + e.getMessage());
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("errMsg", String.format(ResManager.loadKDString((String)"\u9884\u5f00\u7968\u5931\u8d25\uff1a\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25\uff0c\u8bf7\u53bb\u67e5\u770b\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6682\u4f30\u5e94\u6536\u5355\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"AutoGenerateOriginalService_9", (String)"fi-ar-mservice", (Object[])new Object[0]), this.getBillNumber(new ArrayList<Object>(8), busIdNumberMap).get("noSuccess").toString(), e.getMessage()));
            return resultMap;
        }
        Set originalIdSet = originalBillList.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet());
        OperationResult saveOriginalBillResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_original_bill", (DynamicObject[])originalBillList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        Map<Long, String> originalIdNumberMap = originalBillList.stream().collect(Collectors.toMap(a -> a.getLong("id"), a -> a.getString("billno")));
        List saveOriginalSuccessIdList = saveOriginalBillResult.getSuccessPkIds();
        Map<String, List<String>> saveOriginalBillNumberMap = this.getBillNumber(saveOriginalSuccessIdList, originalIdNumberMap);
        if (!saveOriginalBillResult.isSuccess()) {
            resultMap.put("success", Boolean.FALSE);
            StringBuffer errMsg = new StringBuffer(ResManager.loadKDString((String)"\u9884\u5f00\u7968\u5931\u8d25\uff1a", (String)"AutoGenerateOriginalService_10", (String)"fi-ar-mservice", (Object[])new Object[0]));
            List<String> successList = saveOriginalBillNumberMap.get("success");
            Map<String, String> busNumOriginalNumMap = this.busToOriginalNumber(originalBillList, originalIdNumberMap, busIdNumberMap, saveOriginalSuccessIdList);
            if (!ObjectUtils.isEmpty(successList)) {
                for (Map.Entry<String, String> entry : busNumOriginalNumMap.entrySet()) {
                    String key = entry.getKey();
                    errMsg.append(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355%1$s\u4e0b\u6e38\u5f00\u7968\u7533\u8bf7\u5355%2$s\u4fdd\u5b58\u6210\u529f\u3002", (String)"AutoGenerateOriginalService_11", (String)"fi-ar-mservice", (Object[])new Object[0]), key, busNumOriginalNumMap.get(key)));
                }
            }
            Map<Long, Long> busIdOriginalIdMap = this.getBusIdOriginalId(originalBillList, saveOriginalSuccessIdList);
            Map<String, List<String>> billNumberMap = this.getBillNumber(new ArrayList<Object>(busIdOriginalIdMap.values()), busIdNumberMap);
            String failBillNo = billNumberMap.get("noSuccess").toString();
            String assertMsg = this.assertResult(saveOriginalBillResult);
            logger.info("------AutoGenerateOriginalService.originalSave.fail.billno------" + failBillNo);
            logger.info("------AutoGenerateOriginalService.originalSave.fail.failMsg------" + assertMsg);
            errMsg.append(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355%1$s\u4e0b\u6e38\u5f00\u7968\u7533\u8bf7\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s\u8bf7\u624b\u5de5\u91cd\u65b0\u4e0b\u63a8\u3002", (String)"AutoGenerateOriginalService_12", (String)"fi-ar-mservice", (Object[])new Object[0]), failBillNo, assertMsg));
            resultMap.put("errMsg", errMsg);
            return resultMap;
        }
        resultMap.put("success", Boolean.TRUE);
        resultMap.put("originalIds", originalIdSet);
        logger.info("AutoGenerateOriginalService.getOriginalIds.end");
        return resultMap;
    }

    private Map<Long, DynamicObject> getPayproperties(List<DynamicObject> busBillList) {
        List orgIdList = busBillList.stream().map(busbill -> busbill.getLong("org.id")).collect(Collectors.toList());
        Map lineTypeParamMap = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, orgIdList, (String)"ar_025");
        Map payproperMap = BusinessDataServiceHelper.loadFromCache((String)"ar_payproperty", (String)"id,isbasedonamt", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        ArrayList payproperties = new ArrayList(payproperMap.values());
        HashMap<Long, DynamicObject> idPaypropertyMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject busBill : busBillList) {
            long orgId = busBill.getLong("org.id");
            long billId = busBill.getLong("id");
            Object lineTypeParam = lineTypeParamMap.get(orgId);
            if (lineTypeParam != null && ((Boolean)lineTypeParam).booleanValue()) {
                List paypropertyList;
                DynamicObjectCollection busBillEntrys = busBill.getDynamicObjectCollection("entry");
                DynamicObject linetype = ((DynamicObject)busBillEntrys.get(0)).getDynamicObject("linetype");
                if (linetype == null) continue;
                String controlcriterion = linetype.getString("controlcriterion");
                if ("0".equals(controlcriterion)) {
                    paypropertyList = payproperties.stream().filter(a -> a.getLong("id") == 503272215320499200L).collect(Collectors.toList());
                    if (!ObjectUtils.isEmpty(paypropertyList)) {
                        idPaypropertyMap.put(billId, (DynamicObject)paypropertyList.get(0));
                        continue;
                    }
                    List qtyPaypropertyList = payproperties.stream().filter(a -> !a.getBoolean("isbasedonamt")).collect(Collectors.toList());
                    if (ObjectUtils.isEmpty(qtyPaypropertyList)) continue;
                    idPaypropertyMap.put(billId, (DynamicObject)qtyPaypropertyList.get(0));
                    continue;
                }
                paypropertyList = payproperties.stream().filter(a -> a.getBoolean("isbasedonamt")).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(paypropertyList)) continue;
                idPaypropertyMap.put(billId, (DynamicObject)paypropertyList.get(0));
                continue;
            }
            List paypropertyList = payproperties.stream().filter(a -> a.getLong("id") == 503272215320499200L).collect(Collectors.toList());
            if (ObjectUtils.isEmpty(paypropertyList)) continue;
            idPaypropertyMap.put(billId, (DynamicObject)paypropertyList.get(0));
        }
        return idPaypropertyMap;
    }

    private Map<String, List<String>> getBillNumber(List<Object> successIdList, Map<Long, String> busIdNumberMap) {
        ArrayList<String> successNumerList = new ArrayList<String>(successIdList.size());
        ArrayList<String> nosuccessNumerList = new ArrayList<String>(busIdNumberMap.size() - successIdList.size());
        for (Map.Entry<Long, String> entry : busIdNumberMap.entrySet()) {
            Long key = entry.getKey();
            String billNumber = busIdNumberMap.get(key);
            if (successIdList.contains(key)) {
                successNumerList.add(billNumber);
                continue;
            }
            nosuccessNumerList.add(billNumber);
        }
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(2);
        resultMap.put("success", successNumerList);
        resultMap.put("noSuccess", nosuccessNumerList);
        return resultMap;
    }

    private String assertResult(OperationResult result) {
        List validateInfos = result.getAllErrorOrValidateInfo();
        if (validateInfos == null || validateInfos.isEmpty()) {
            return result.getMessage();
        }
        logger.info("------AutoGenerateOriginalService.asserResult.validateInfos------" + validateInfos);
        StringBuilder sb = new StringBuilder();
        for (IOperateInfo err : validateInfos) {
            String errMsg = err.getMessage();
            if ("".equals(errMsg)) continue;
            sb.append(errMsg).append('\n');
        }
        String returnStr = sb.toString();
        if ("".equals(returnStr)) {
            returnStr = result.getMessage();
        }
        return returnStr;
    }

    private Map<String, String> busToOriginalNumber(List<DynamicObject> originalBillList, Map<Long, String> originalIdNumberMap, Map<Long, String> busIdNumberMap, List<Object> filterIdList) {
        HashMap<String, String> busNumOriginalNumMap = new HashMap<String, String>(originalBillList.size());
        Map<Long, Long> busIdOriginalIdMap = this.getBusIdOriginalId(originalBillList, filterIdList);
        for (Map.Entry<Long, Long> entry : busIdOriginalIdMap.entrySet()) {
            Long originalId = entry.getKey();
            Long busId = busIdOriginalIdMap.get(originalId);
            busNumOriginalNumMap.put(busIdNumberMap.get(busId), originalIdNumberMap.get(originalId));
        }
        return busNumOriginalNumMap;
    }

    private Map<Long, Long> getBusIdOriginalId(List<DynamicObject> originalBillList, List<Object> filterIdList) {
        HashMap<Long, Long> busIdOriginalIdMap = new HashMap<Long, Long>(originalBillList.size());
        for (DynamicObject original : originalBillList) {
            DynamicObjectCollection orginalItems;
            long originalId = original.getLong("id");
            if (filterIdList == null) {
                orginalItems = original.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject orginalItem : orginalItems) {
                    if (busIdOriginalIdMap.containsKey(originalId)) continue;
                    busIdOriginalIdMap.put(originalId, orginalItem.getLong("billsourceid"));
                }
                continue;
            }
            if (!filterIdList.contains(originalId)) continue;
            orginalItems = original.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject orginalItem : orginalItems) {
                if (busIdOriginalIdMap.containsKey(originalId)) continue;
                busIdOriginalIdMap.put(originalId, orginalItem.getLong("billsourceid"));
            }
        }
        return busIdOriginalIdMap;
    }
}

