/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.ar.mservice.BaddebtLossSettleService;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class BaddebtLossAutoSettleService
extends AbsAutoSettleService {
    private BaddebtLossSettleService settleService = new BaddebtLossSettleService();

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        DynamicObject[] assts = new DynamicObject[]{obj};
        DynamicObject[] mains = this.getFinArBills(obj);
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setOnlyByBotp(true);
        if (mains != null && mains.length > 0) {
            this.addSettleLock(mains, assts);
            this.settleService.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
        }
    }

    private DynamicObject[] getFinArBills(DynamicObject asst) {
        List bfRows = BFTrackerServiceHelper.loadBillLinkUp((String)"ar_baddebtlossbill", (Long[])new Long[]{asst.getLong("id")}, (boolean)true);
        List idList = bfRows.stream().map(row -> row.getSId().getBillId()).collect(Collectors.toList());
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", idList), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("entry.e_unsettleamt", ">", (Object)0)};
        return FinArBillHandleHelper.load((QFilter[])filter);
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }
}

