/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.mservice.BaddebtRecoverySettleService;
import kd.fi.ar.mservice.RecSelfSettleService;
import kd.fi.ar.mservice.helper.BaddebtLossSettleHelper;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.ManualSettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class BaddebtRecoveryManualSettleService
implements IManualSettleService {
    public static final String ASST_RECBILL = "cas_recbill";
    private BaddebtRecoverySettleService service;

    public BaddebtRecoveryManualSettleService() {
        this.service = new BaddebtRecoverySettleService();
    }

    public BaddebtRecoveryManualSettleService(BaddebtRecoverySettleService service) {
        this.service = service;
    }

    public void manualSettle(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualSettleParam manualParam) throws KDBizException {
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("id"));
            mainEntryIdSet.add(main.getLong("entryid"));
        }
        HashSet<Long> recBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> recEntryIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> recedBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> recedEntryIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            String entityName = asst.getString("asst_billtype");
            if (ASST_RECBILL.equals(entityName)) {
                recBillIdSet.add(asst.getLong("asst_id"));
                recEntryIdSet.add(asst.getLong("asst_entryid"));
                continue;
            }
            recedBillIdSet.add(asst.getLong("asst_id"));
            recedEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        DynamicObject[] mainArr = this.reloadMainArr(mainBillIdSet);
        Object[] recArr = this.reloadAsstRecArr(recBillIdSet);
        Object[] recedArr = this.reloadAsstRecedArr(recedBillIdSet);
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setDiffCurrencySettle(manualParam.isDiffCurrencySettle());
        scheme.setSettleEntryParam(manualParam.getSettleEntryParam());
        scheme.setSettleDate(manualParam.getSettleDate());
        this.processMain(mainArr, mainRows, mainEntryIdSet, manualParam);
        this.processAsst((DynamicObject[])recArr, asstRows, recEntryIdSet, manualParam);
        this.processAsst((DynamicObject[])recedArr, asstRows, recedEntryIdSet, manualParam);
        DynamicObject[] recMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])recArr, (Object[])recedArr);
        List<BillSettleVO> mainListVO = BaddebtLossSettleHelper.getMainListVO(mainArr, scheme);
        List asstListVO = RecBillHandlerHelper.getAsstListVO((DynamicObject[])recMergeArr);
        if (manualParam.isSingleSettle()) {
            scheme.setSettleSelf(true);
            this.settleSelfFirst(asstListVO, scheme);
        } else if (manualParam.isSettleSelfFirst() || manualParam.isTotal()) {
            if (!manualParam.isDiffCurrencySettle()) {
                scheme.setSettleSelf(true);
                this.settleSelfFirst(asstListVO, scheme);
            }
            this.service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.MANUAL.getValue());
        } else {
            this.service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.MANUAL.getValue());
            if (!manualParam.isDiffCurrencySettle()) {
                scheme.setSettleSelf(true);
                this.settleSelfFirst(asstListVO, scheme);
            }
        }
    }

    private void settleSelfFirst(List<BillSettleVO> asstListVO, SettleSchemeVO scheme) {
        List asstPositiveList = this.getPositiveList(asstListVO);
        List asstNegativeList = this.getNegativeList(asstListVO);
        if (asstPositiveList.size() > 0 && asstNegativeList.size() > 0) {
            RecSelfSettleService recSelf = new RecSelfSettleService();
            recSelf.settleByVO(asstPositiveList, asstNegativeList, scheme, SettleTypeEnum.MANUAL.getValue());
        }
        scheme.setSettleSelf(false);
    }

    private void processMain(DynamicObject[] mainArr, DynamicObject[] mainRows, Set<Long> mainEntryIdSet, ManualSettleParam param) {
        int settleEntryParam = param.getSettleEntryParam();
        if (param.isTotal()) {
            for (DynamicObject main : mainRows) {
                BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                long id = main.getLong("id");
                for (DynamicObject mainObj : mainArr) {
                    if (id != mainObj.getLong("id")) continue;
                    DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getBadEntryKey(settleEntryParam));
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal(this.getBadEntryAmtKey(settleEntryParam));
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set(this.getBadEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject mainObj : mainArr) {
                long id = mainObj.getLong("id");
                DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection(this.getBadEntryKey(settleEntryParam));
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal(this.getBadEntryAmtKey(settleEntryParam));
                    if (mainEntryIdSet.contains(entryId)) {
                        for (DynamicObject main : mainRows) {
                            if (id != main.getLong("id") || entryId != main.getLong("entryid")) continue;
                            BigDecimal curSettleAmt = main.getBigDecimal("curSettleAmt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set(this.getBadEntryAmtKey(settleEntryParam), (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    private void processAsst(DynamicObject[] asstArr, DynamicObject[] asstRows, Set<Long> asstEntryIdSet, ManualSettleParam param) {
        if (param.isTotal()) {
            for (DynamicObject asst : asstRows) {
                BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                long id = asst.getLong("asst_id");
                for (DynamicObject asstObj : asstArr) {
                    if (id != asstObj.getLong("id")) continue;
                    DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (ASST_RECBILL.equals(asstObj.getDataEntityType().getName()) && (!param.getOrgPk().equals(entry.get("e_settleorg.id")) || ObjectUtils.isEmpty((Object)entry.getDynamicObject("e_receivingtype")) || !entry.getDynamicObject("e_receivingtype").getBoolean("ispartreceivable"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject asstObj : asstArr) {
                long id = asstObj.getLong("id");
                DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (asstEntryIdSet.contains(entryId)) {
                        for (DynamicObject asst : asstRows) {
                            if (id != asst.getLong("asst_id") || entryId != asst.getLong("asst_entryid")) continue;
                            BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set("e_unsettledamt", (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    protected DynamicObject[] reloadMainArr(Set<Long> mainBillIdSet) {
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", mainBillIdSet)};
        DynamicObject[] mainObjs = BaddebtLossSettleHelper.load(filter);
        return mainObjs;
    }

    protected DynamicObject[] reloadAsstRecArr(Set<Long> recBillIdSet) {
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", recBillIdSet)};
        DynamicObject[] recBills = RecBillHandlerHelper.loadRec((QFilter[])filter);
        return recBills;
    }

    protected DynamicObject[] reloadAsstRecedArr(Set<Long> recedBillIdSet) {
        QFilter[] filter = new QFilter[]{new QFilter("id", "in", recedBillIdSet)};
        DynamicObject[] recedObjs = RecBillHandlerHelper.loadReced((QFilter[])filter);
        return recedObjs;
    }
}

