/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.enums.FiBotpReplayEnum;
import kd.fi.ar.vo.FiBotpCallBackArBillItemVo;
import kd.fi.ar.vo.FiBotpCallBackArBillVo;
import kd.fi.ar.vo.FiBotpCallBackReplayVo;
import kd.fi.ar.vo.FiBotpCallBackVo;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.model.BusArBillModel;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import org.apache.commons.lang.StringUtils;

public class BusOriginalCallBackService {
    private static final Log logger = LogFactory.getLog(BusOriginalCallBackService.class);
    private static final String RIGHTSTATUS = "0";
    private static final String CANCELSTATUS = "6";
    private BusArBillModel busArBillModel = new BusArBillModel();
    private boolean isWriteNoFinByInvno = false;

    public String updateBusArBill(String ars) {
        if (EmptyUtils.isNotEmpty((Object)ars)) {
            logger.info("BusOriginalCallBackService reveiced data is " + ars);
            this.isWriteNoFinByInvno = "true".equals(StdConfig.get((String)"writeNoFinByInvno"));
            FiBotpCallBackVo result = (FiBotpCallBackVo)JSONObject.parseObject((String)ars, FiBotpCallBackVo.class);
            String replayVoJson = this.selectAndBackResult(result);
            LogUtil.addInvokeLog((String)"BusOriginalCallBackService.updateBusArBill", (Object[])new Object[]{ars}, null, (boolean)true);
            return replayVoJson;
        }
        LogUtil.addInvokeLog((String)"BusOriginalCallBackService.updateBusArBill", (Object[])new Object[]{"received data is null"}, null, (boolean)true);
        return JSONObject.toJSONString((Object)new FiBotpCallBackReplayVo("received data is null", FiBotpReplayEnum.fail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectAndBackResult(FiBotpCallBackVo result) {
        FiBotpCallBackReplayVo replayVo;
        List arBillVos = result.getArs();
        Set arPks = arBillVos.stream().map(FiBotpCallBackArBillVo::getArBillPk).collect(Collectors.toSet());
        try {
            DynamicObject[] busArBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)this.getSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)arPks.toArray())});
            if (busArBills != null && busArBills.length > 0) {
                MutexLockHelper.requireMutex((String)"ar_busbill", arPks, (String)"updateBusArBill", (String)"");
                for (DynamicObject busArBill : busArBills) {
                    this.updaeBillByNormalStu(busArBill, result, arBillVos);
                }
                SaveServiceHelper.save((DynamicObject[])busArBills);
            }
            replayVo = new FiBotpCallBackReplayVo("", FiBotpReplayEnum.Success);
        }
        catch (Exception e) {
            logger.info("BusOriginalCallBackService error is " + e.getMessage());
            replayVo = new FiBotpCallBackReplayVo(e.getMessage(), FiBotpReplayEnum.fail);
        }
        finally {
            MutexLockHelper.batchRelease((String)"ar_busbill", arPks, (String)"updateBusArBill");
        }
        return JSONObject.toJSONString((Object)replayVo);
    }

    private String getSelectors() {
        ArrayList<String> arBusField = new ArrayList<String>(16);
        arBusField.add(this.busArBillModel.HEAD_ORG);
        arBusField.add(this.busArBillModel.HEAD_BILLNO);
        arBusField.add(this.busArBillModel.HEAD_BIZDATE);
        arBusField.add(this.busArBillModel.HEAD_ASSTACTTYPE);
        arBusField.add(this.busArBillModel.HEAD_ASSTACT);
        arBusField.add(this.busArBillModel.HEAD_PAYPROPERTY);
        arBusField.add(this.busArBillModel.HEAD_CURRENCY);
        arBusField.add(this.busArBillModel.HEAD_EXRATETABLE);
        arBusField.add(this.busArBillModel.HEAD_EXRATEDATE);
        arBusField.add(this.busArBillModel.HEAD_QUOTATION);
        arBusField.add(this.busArBillModel.HEAD_EXCHANGERATE);
        arBusField.add(this.busArBillModel.HEAD_BASECURRENCY);
        arBusField.add(this.busArBillModel.HEAD_PRICETAXTOTAL);
        arBusField.add(this.busArBillModel.HEAD_PRICETAXTOTALLOC);
        arBusField.add(this.busArBillModel.HEAD_AMOUNT);
        arBusField.add(this.busArBillModel.HEAD_LOCALAMT);
        arBusField.add(this.busArBillModel.HEAD_TAX);
        arBusField.add(this.busArBillModel.HEAD_TAXLOCAMT);
        arBusField.add(this.busArBillModel.HEAD_UNRELATEINVAMT);
        arBusField.add(this.busArBillModel.HEAD_UNRELATEINVLOCAMT);
        arBusField.add(this.busArBillModel.HEAD_RELATEINVAMT);
        arBusField.add(this.busArBillModel.HEAD_RELATEINVLOCAMT);
        arBusField.add(this.busArBillModel.HEAD_INVAMT);
        arBusField.add(this.busArBillModel.HEAD_INVLOCAMT);
        arBusField.add(this.busArBillModel.HEAD_INVOICENO);
        arBusField.add(this.busArBillModel.HEAD_INVOICECODE);
        arBusField.add(this.busArBillModel.E_PRICETAXTOTAL);
        arBusField.add(this.busArBillModel.E_PRICETAXTOTALLOC);
        arBusField.add(this.busArBillModel.E_QUANTITY);
        arBusField.add(this.busArBillModel.E_TAXUNITPRICE);
        arBusField.add(this.busArBillModel.E_AMOUNT);
        arBusField.add(this.busArBillModel.E_LOCALAMT);
        arBusField.add(this.busArBillModel.E_RELATEINVQTY);
        arBusField.add(this.busArBillModel.E_UNRELATEINVQTY);
        arBusField.add(this.busArBillModel.E_UNRELATEINVAMT);
        arBusField.add(this.busArBillModel.E_UNRELATEINVLOCAMT);
        arBusField.add(this.busArBillModel.E_RELATEINVAMT);
        arBusField.add(this.busArBillModel.E_RELATEINVLOCAMT);
        arBusField.add(this.busArBillModel.E_INVOICECODE);
        arBusField.add(this.busArBillModel.E_INVOICENO);
        arBusField.add(this.busArBillModel.E_INVQTY);
        arBusField.add(this.busArBillModel.E_INVNOTAXAMT);
        arBusField.add(this.busArBillModel.E_INVNOTAXLOCAMT);
        arBusField.add(this.busArBillModel.E_INVOICEDTAX);
        arBusField.add(this.busArBillModel.E_INVOICEDLOCTAX);
        arBusField.add(this.busArBillModel.E_INVAMT);
        arBusField.add(this.busArBillModel.E_INVLOCAMT);
        return StringUtils.join((Object[])arBusField.toArray(), (String)",");
    }

    public void updaeBillByNormalStu(DynamicObject busArBill, FiBotpCallBackVo result, List<FiBotpCallBackArBillVo> arBillVos) throws Exception {
        String invoiceStatus = result.getInvoiceStatus();
        List arBillVoTarget = arBillVos.stream().filter(p -> p.getArBillPk().longValue() == busArBill.getLong("id")).collect(Collectors.toList());
        FiBotpCallBackArBillVo arBillVo = (FiBotpCallBackArBillVo)arBillVoTarget.get(0);
        logger.info("selcet busarbill billno is" + busArBill.getString(this.busArBillModel.HEAD_BILLNO));
        String invoiceCode = busArBill.getString(this.busArBillModel.HEAD_INVOICECODE);
        String invoiceNo = busArBill.getString(this.busArBillModel.HEAD_INVOICENO);
        logger.info("busarbill old invoicecode , invoiceno is" + invoiceCode + ";" + invoiceNo);
        Map<String, String> returnMap = this.setInvoiceCode(invoiceStatus, invoiceCode, invoiceNo, result);
        busArBill.set(this.busArBillModel.HEAD_INVOICECODE, (Object)returnMap.get("invoiceCode"));
        busArBill.set(this.busArBillModel.HEAD_INVOICENO, (Object)returnMap.get("invoiceNo"));
        logger.info("busarbill afterupdate invoicecode , invoiceno is" + returnMap.get("invoiceCode") + ";" + returnMap.get("invoiceNo"));
        DynamicObjectCollection entry = busArBill.getDynamicObjectCollection("entry");
        List billItemVos = arBillVo.getArItems();
        boolean isBaseDonAmt = busArBill.getBoolean("payproperty.isbasedonamt");
        this.updaeBillEntry(billItemVos, entry, invoiceStatus, isBaseDonAmt, result);
        BigDecimal issueInvRecAmtSum = BigDecimal.ZERO;
        BigDecimal unInvoicedAmtSum = BigDecimal.ZERO;
        BigDecimal invoicedAmtSum = BigDecimal.ZERO;
        BigDecimal issueInvRecAmtlocalSum = BigDecimal.ZERO;
        BigDecimal unInvoicedAmtLocalSum = BigDecimal.ZERO;
        BigDecimal invoicedAmtLocalSum = BigDecimal.ZERO;
        for (DynamicObject row : entry) {
            issueInvRecAmtSum = issueInvRecAmtSum.add(row.getBigDecimal(this.busArBillModel.E_INVAMT));
            unInvoicedAmtSum = unInvoicedAmtSum.add(row.getBigDecimal(this.busArBillModel.E_UNRELATEINVAMT));
            invoicedAmtSum = invoicedAmtSum.add(row.getBigDecimal(this.busArBillModel.E_RELATEINVAMT));
            issueInvRecAmtlocalSum = issueInvRecAmtlocalSum.add(row.getBigDecimal(this.busArBillModel.E_INVLOCAMT));
            unInvoicedAmtLocalSum = unInvoicedAmtLocalSum.add(row.getBigDecimal(this.busArBillModel.E_UNRELATEINVLOCAMT));
            invoicedAmtLocalSum = invoicedAmtLocalSum.add(row.getBigDecimal(this.busArBillModel.E_RELATEINVLOCAMT));
        }
        busArBill.set(this.busArBillModel.HEAD_INVAMT, (Object)issueInvRecAmtSum);
        busArBill.set(this.busArBillModel.HEAD_UNRELATEINVAMT, (Object)unInvoicedAmtSum);
        busArBill.set(this.busArBillModel.HEAD_RELATEINVAMT, (Object)invoicedAmtSum);
        busArBill.set(this.busArBillModel.HEAD_INVLOCAMT, (Object)issueInvRecAmtlocalSum);
        busArBill.set(this.busArBillModel.HEAD_UNRELATEINVLOCAMT, (Object)unInvoicedAmtLocalSum);
        busArBill.set(this.busArBillModel.HEAD_RELATEINVLOCAMT, (Object)invoicedAmtLocalSum);
        logger.info("set busarbill entry end");
    }

    private Map<String, String> setInvoiceCode(String invoiceStatus, String invoiceCode, String invoiceNo, FiBotpCallBackVo result) {
        String cbinCode = result.getInvoiceCode();
        String cbinNo = result.getInvoiceNo();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        ArrayList<String> inNosList = new ArrayList<String>(Arrays.asList(invoiceNo.split(", ")));
        ArrayList<String> inCodesList = new ArrayList<String>(Arrays.asList(invoiceCode.split(", ")));
        if (CANCELSTATUS.equals(invoiceStatus)) {
            List removeNo = inNosList.stream().filter(t -> t.equals(cbinNo)).collect(Collectors.toList());
            List removeCode = inCodesList.stream().filter(t -> t.equals(cbinCode)).collect(Collectors.toList());
            if (removeNo.size() > 0) {
                int i;
                for (i = inNosList.size() - 1; i >= 0; --i) {
                    if (!((String)inNosList.get(i)).equals(cbinNo)) continue;
                    inNosList.remove(i);
                }
                if (removeCode.size() > 0) {
                    for (i = inCodesList.size() - 1; i >= 0; --i) {
                        if (!((String)inCodesList.get(i)).equals(cbinCode)) continue;
                        inCodesList.remove(i);
                    }
                }
            } else {
                returnMap.put("remNotExist", "yes");
            }
        } else if (EmptyUtils.isNotEmpty((Object)cbinNo) && !inNosList.contains(cbinNo)) {
            inNosList.add(cbinNo);
            inCodesList.add(cbinCode);
        } else {
            returnMap.put("isexist", "yes");
        }
        inCodesList.remove("");
        inNosList.remove("");
        returnMap.put("invoiceCode", ((Object)inCodesList).toString().replace("[", "").replace("]", ""));
        returnMap.put("invoiceNo", ((Object)inNosList).toString().replace("[", "").replace("]", ""));
        return returnMap;
    }

    public void updaeBillEntry(List<FiBotpCallBackArBillItemVo> billItemVos, DynamicObjectCollection entryColls, String invoiceStatus, boolean isBaseDonAmt, FiBotpCallBackVo result) throws Exception {
        for (FiBotpCallBackArBillItemVo itemVo : billItemVos) {
            Long entryPk = itemVo.getEntryPk();
            DynamicObject tarRow = entryColls.stream().filter(v -> v.getLong("id") == entryPk.longValue()).findFirst().orElse(null);
            if (EmptyUtils.isEmpty((Object)tarRow)) {
                throw new Exception(entryPk + ",entryid No match");
            }
            boolean closed = itemVo.isClosed();
            if (closed) {
                this.disposeEntryInvoiceRelate(itemVo, tarRow, isBaseDonAmt);
            }
            this.disposeEntryIssueInvRelate(itemVo, tarRow, invoiceStatus, isBaseDonAmt, result);
        }
    }

    private void disposeEntryInvoiceRelate(FiBotpCallBackArBillItemVo itemVo, DynamicObject tarRow, boolean isBaseDonAmt) {
        BigDecimal influenceAmountIncludeTax = itemVo.getInfluenceAmountIncludeTax();
        BigDecimal includeTaxLocalAmt = itemVo.getInfluenceFromTaxAmount();
        BigDecimal influenceNum = itemVo.getInfluenceNum();
        BigDecimal recAmount = tarRow.getBigDecimal(this.busArBillModel.E_PRICETAXTOTAL);
        BigDecimal recLocalAmount = tarRow.getBigDecimal(this.busArBillModel.E_PRICETAXTOTALLOC);
        BigDecimal quantity = tarRow.getBigDecimal(this.busArBillModel.E_QUANTITY);
        BigDecimal invoicedQty = tarRow.getBigDecimal(this.busArBillModel.E_RELATEINVQTY);
        BigDecimal invoicedAmt = tarRow.getBigDecimal(this.busArBillModel.E_RELATEINVAMT);
        BigDecimal invoicedLocalAmt = tarRow.getBigDecimal(this.busArBillModel.E_RELATEINVLOCAMT);
        BigDecimal newInvoicedAmt = invoicedAmt.add(influenceAmountIncludeTax);
        BigDecimal newInvoicedLocalAmt = invoicedLocalAmt.add(includeTaxLocalAmt);
        BigDecimal newUnInvoicedAmt = recAmount.subtract(newInvoicedAmt);
        BigDecimal newUnInvoicedLocalAmt = recLocalAmount.subtract(newInvoicedLocalAmt);
        tarRow.set(this.busArBillModel.E_RELATEINVAMT, (Object)newInvoicedAmt);
        tarRow.set(this.busArBillModel.E_RELATEINVLOCAMT, (Object)newInvoicedLocalAmt);
        tarRow.set(this.busArBillModel.E_UNRELATEINVAMT, (Object)newUnInvoicedAmt);
        tarRow.set(this.busArBillModel.E_UNRELATEINVLOCAMT, (Object)newUnInvoicedLocalAmt);
        if (isBaseDonAmt) {
            if (recAmount.compareTo(BigDecimal.ZERO) == 0 && tarRow.getBigDecimal(this.busArBillModel.E_TAXUNITPRICE).compareTo(BigDecimal.ZERO) != 0) {
                if (itemVo.getInfluenceNum().compareTo(BigDecimal.ZERO) < 0) {
                    tarRow.set(this.busArBillModel.E_UNRELATEINVQTY, (Object)quantity);
                    tarRow.set(this.busArBillModel.E_RELATEINVQTY, (Object)BigDecimal.ZERO);
                } else {
                    tarRow.set(this.busArBillModel.E_RELATEINVQTY, (Object)quantity);
                    tarRow.set(this.busArBillModel.E_UNRELATEINVQTY, (Object)BigDecimal.ZERO);
                }
            } else if (recAmount.abs().compareTo(newInvoicedAmt.abs()) <= 0) {
                tarRow.set(this.busArBillModel.E_RELATEINVQTY, (Object)quantity);
                tarRow.set(this.busArBillModel.E_UNRELATEINVQTY, (Object)BigDecimal.ZERO);
            } else {
                tarRow.set(this.busArBillModel.E_UNRELATEINVQTY, (Object)quantity);
                tarRow.set(this.busArBillModel.E_RELATEINVQTY, (Object)BigDecimal.ZERO);
            }
        } else {
            tarRow.set(this.busArBillModel.E_RELATEINVQTY, (Object)invoicedQty.add(influenceNum));
            tarRow.set(this.busArBillModel.E_UNRELATEINVQTY, (Object)quantity.subtract(tarRow.getBigDecimal(this.busArBillModel.E_RELATEINVQTY)));
        }
    }

    private void disposeEntryIssueInvRelate(FiBotpCallBackArBillItemVo itemVo, DynamicObject tarRow, String invoiceStatus, boolean isBaseDonAmt, FiBotpCallBackVo result) {
        String entryinvoiceNo;
        BigDecimal influenceAmountIncludeTax = itemVo.getInfluenceAmountIncludeTax();
        BigDecimal influenceAmount = itemVo.getInfluenceAmount();
        BigDecimal influenceTax = itemVo.getInfluencetax();
        BigDecimal influenceNum = itemVo.getInfluenceNum();
        BigDecimal includeLocalTaxAmt = itemVo.getInfluenceFromTaxAmount();
        BigDecimal influenceLocalAmt = itemVo.getInfluenceFromAmount();
        BigDecimal influenceLocalTaxAmt = itemVo.getInfluenceFromTax();
        BigDecimal recAmount = tarRow.getBigDecimal(this.busArBillModel.E_PRICETAXTOTAL);
        BigDecimal quantity = tarRow.getBigDecimal(this.busArBillModel.E_QUANTITY);
        String entryInvoiceCode = tarRow.getString(this.busArBillModel.E_INVOICECODE);
        Map<String, String> returnEntryMap = this.setInvoiceCode(invoiceStatus, entryInvoiceCode, entryinvoiceNo = tarRow.getString(this.busArBillModel.E_INVOICENO), result);
        if (("yes".equals(returnEntryMap.get("isexist")) || "yes".equals(returnEntryMap.get("remNotExist"))) && !this.isWriteNoFinByInvno) {
            return;
        }
        logger.info("busarbill target entryRowid is" + tarRow.getLong("id"));
        logger.info("busarbill entry old invoicecode , invoiceno is" + entryInvoiceCode + ";" + entryinvoiceNo);
        BigDecimal issueInvAmt = tarRow.getBigDecimal(this.busArBillModel.E_INVNOTAXAMT);
        BigDecimal issueInvLocalAmt = tarRow.getBigDecimal(this.busArBillModel.E_INVNOTAXLOCAMT);
        BigDecimal issueInvrecAmt = tarRow.getBigDecimal(this.busArBillModel.E_INVAMT);
        BigDecimal issueInvrecLocalAmt = tarRow.getBigDecimal(this.busArBillModel.E_INVLOCAMT);
        BigDecimal issueInvTax = tarRow.getBigDecimal(this.busArBillModel.E_INVOICEDTAX);
        BigDecimal issueInvLocalTax = tarRow.getBigDecimal(this.busArBillModel.E_INVOICEDLOCTAX);
        BigDecimal issueInvQty = tarRow.getBigDecimal(this.busArBillModel.E_INVQTY);
        tarRow.set(this.busArBillModel.E_INVOICECODE, (Object)returnEntryMap.get("invoiceCode"));
        tarRow.set(this.busArBillModel.E_INVOICENO, (Object)returnEntryMap.get("invoiceNo"));
        logger.info("busarbill entry afterupdate invoicecode , invoiceno is" + returnEntryMap.get("invoiceCode") + ";" + returnEntryMap.get("invoiceNo"));
        tarRow.set(this.busArBillModel.E_INVNOTAXAMT, (Object)influenceAmount.add(issueInvAmt));
        tarRow.set(this.busArBillModel.E_INVNOTAXLOCAMT, (Object)influenceLocalAmt.add(issueInvLocalAmt));
        tarRow.set(this.busArBillModel.E_INVAMT, (Object)influenceAmountIncludeTax.add(issueInvrecAmt));
        tarRow.set(this.busArBillModel.E_INVLOCAMT, (Object)includeLocalTaxAmt.add(issueInvrecLocalAmt));
        tarRow.set(this.busArBillModel.E_INVOICEDTAX, (Object)influenceTax.add(issueInvTax));
        tarRow.set(this.busArBillModel.E_INVOICEDLOCTAX, (Object)influenceLocalTaxAmt.add(issueInvLocalTax));
        if (isBaseDonAmt) {
            if (recAmount.compareTo(BigDecimal.ZERO) == 0 && tarRow.getBigDecimal(this.busArBillModel.E_TAXUNITPRICE).compareTo(BigDecimal.ZERO) != 0) {
                if (itemVo.getInfluenceNum().compareTo(BigDecimal.ZERO) < 0) {
                    tarRow.set(this.busArBillModel.E_INVQTY, (Object)BigDecimal.ZERO);
                } else {
                    tarRow.set(this.busArBillModel.E_INVQTY, (Object)quantity);
                }
            } else if (recAmount.abs().compareTo(tarRow.getBigDecimal(this.busArBillModel.E_INVAMT).abs()) <= 0) {
                tarRow.set(this.busArBillModel.E_INVQTY, (Object)quantity);
            } else {
                tarRow.set(this.busArBillModel.E_INVQTY, (Object)BigDecimal.ZERO);
            }
        } else {
            boolean isMerge;
            String mergeLable = result.getMergeLable();
            boolean bl = isMerge = recAmount.compareTo(tarRow.getBigDecimal(this.busArBillModel.E_INVAMT)) == 0;
            if (EmptyUtils.isNotEmpty((Object)mergeLable) && ("1".equals(mergeLable) || "2".equals(mergeLable))) {
                tarRow.set(this.busArBillModel.E_INVQTY, (Object)(isMerge ? quantity : Integer.valueOf(0)));
            } else {
                tarRow.set(this.busArBillModel.E_INVQTY, (Object)influenceNum.add(issueInvQty));
            }
        }
    }
}

