/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceSwitch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.enums.FiBotpReplayEnum;
import kd.fi.ar.mservice.invoice.FinArBillIssueCallbackService;
import kd.fi.ar.vo.FiBotpCallBackArBillItemVo;
import kd.fi.ar.vo.FiBotpCallBackArBillVo;
import kd.fi.ar.vo.FiBotpCallBackReplayVo;
import kd.fi.ar.vo.FiBotpCallBackVo;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class FiBotpCallBackService {
    private static final Log logger = LogFactory.getLog(FiBotpCallBackService.class);
    private static final String RIGHTSTATUS = "0";
    private static final String CANCELSTATUS = "6";
    private boolean isWriteNoFinByInvno = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateFinArBill(String ars) {
        if (EmptyUtils.isNotEmpty((Object)ars)) {
            String replayVoJson;
            block19: {
                logger.info("FiBotpCallBackService reveice data is " + ars);
                this.isWriteNoFinByInvno = "true".equals(StdConfig.get((String)"writeNoFinByInvno"));
                FiBotpCallBackVo result = (FiBotpCallBackVo)JSONObject.parseObject((String)ars, FiBotpCallBackVo.class);
                try (TXHandle tx = TX.requiresNew((String)"FiBotpCallBackService");){
                    List arBillVos = result.getArs();
                    Set arPks = arBillVos.stream().map(FiBotpCallBackArBillVo::getArBillPk).collect(Collectors.toSet());
                    IBillConcurrencyCtrlStrategy ctrlStrategy = ConcurrencyCtrlUtil.addCtrl((String)"ar_finarbill", (String)"FiBotpCallBackService", arPks, (boolean)false);
                    try {
                        replayVoJson = this.selectAndBackResult(result);
                        FiBotpCallBackReplayVo vo = (FiBotpCallBackReplayVo)JSONObject.parseObject((String)replayVoJson, FiBotpCallBackReplayVo.class);
                        if (FiBotpReplayEnum.fail.getStatus().equals(vo.getReplayStatus().getStatus())) {
                            throw new KDBizException(vo.getErrorMsg());
                        }
                        BizExtendHelper.invokeIssueCallbackExt((String)ars);
                        LogUtil.addInvokeLog((String)"FiBotpCallBackService.updateFinArBill", (Object[])new Object[]{ars}, null, (boolean)true);
                    }
                    catch (Throwable e) {
                        try {
                            LogUtil.addInvokeErrorLog((String)"FiBotpCallBackService failed", (Object[])new Object[]{ars}, (Throwable)e, (boolean)true);
                            tx.markRollback();
                            FiBotpCallBackReplayVo replayVo = new FiBotpCallBackReplayVo(e.getMessage(), FiBotpReplayEnum.fail);
                            replayVoJson = JSONObject.toJSONString((Object)replayVo);
                            break block19;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ctrlStrategy.releaseCtrl();
                        }
                    }
                    ctrlStrategy.releaseCtrl();
                }
            }
            return replayVoJson;
        }
        LogUtil.addInvokeLog((String)"FiBotpCallBackService.updateFinArBill", (Object[])new Object[]{"receive data is null"}, null, (boolean)true);
        return JSONObject.toJSONString((Object)new FiBotpCallBackReplayVo("receive data is null", FiBotpReplayEnum.fail));
    }

    private String getSelectors() {
        return "billno,invoicedate,org,bookdate,settlestatus,asstact,basecurrency,currency,invoicecode,invoiceno,payproperty,relationpay,e_issueinvrecamt,e_uninvoicedamt,e_invoicedamt,issueinvrecamt,uninvoicedamt,invoicedamt,e_recamount,e_quantity,e_invoicedqty,e_uninvoicedqty,e_invoicecode,e_invoiceno,invoicedlocalamt,uninvoicedlocalamt,issueinvreclocalamt,e_taxunitprice,e_issueinvamt,e_issueinvtax,e_issueinvqty,e_invoicedlocalamt,e_uninvoicedlocalamt,e_issueinvlocalamt,e_issueinvlocaltax,e_issueinvreclocalamt,e_reclocalamt,e_settledamt,e_amount,e_localamt,e_tax,recamount,reclocalamt,amount,localamt,tax,e_confirmedamt,e_unconfirmamt,e_unverifyamt,e_unlockamt,e_unsettleamt,e_unsettlelocalamt,e_material,planpricetax,planpricetaxloc,unplanlockamt,unplansettleamt,unplansettlelocamt,unsettleamount,unsettlelocalamt,unverifyamount,isvoucher,e_taxlocalamt,taxlocamt,e_expenseitem,e_verifiedamt,ispremium";
    }

    public String selectAndBackResult(FiBotpCallBackVo result) {
        FiBotpCallBackReplayVo replayVo;
        List arBillVos = result.getArs();
        Set arPks = arBillVos.stream().map(FiBotpCallBackArBillVo::getArBillPk).collect(Collectors.toSet());
        try {
            DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)this.getSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)arPks.toArray())});
            if (finArBills != null && finArBills.length > 0) {
                for (DynamicObject finArBill : finArBills) {
                    this.updaeBillByNormalStu(finArBill, result, arBillVos);
                }
                SaveServiceHelper.save((DynamicObject[])finArBills);
                this.invoiceCoordination(finArBills, result);
                this.updateBusBillWhenEntryClose(arBillVos);
            }
            replayVo = new FiBotpCallBackReplayVo("", FiBotpReplayEnum.Success);
            logger.info(String.format("FiBotpCallBackService InvoiceStatus is [%s], OriInvoiceCode is [%s],OriInvoiceNo is [%s],ReplayStatus is[%s]", result.getInvoiceStatus(), result.getOriInvoiceCode(), result.getOriInvoiceNo(), replayVo.getReplayStatus().getStatus()));
            if (RIGHTSTATUS.equals(result.getInvoiceStatus()) && EmptyUtils.isEmpty((Object)result.getOriInvoiceCode()) && EmptyUtils.isEmpty((Object)result.getOriInvoiceNo()) && FiBotpReplayEnum.Success.getStatus().equals(replayVo.getReplayStatus().getStatus())) {
                logger.info("FiBotpCallBackService begin to repairFinArTailData");
                ConfigCache.put((String)"FiBotpCallBackService", (String)"invoiceCode", (Object)result.getInvoiceCode());
                ConfigCache.put((String)"FiBotpCallBackService", (String)"invoiceNo", (Object)result.getInvoiceNo());
                FinArBillIssueCallbackService issueService = new FinArBillIssueCallbackService();
                issueService.afterProcess(finArBills);
            }
        }
        catch (Exception e) {
            logger.error("FiBotpCallBackService error is " + e.getMessage());
            replayVo = new FiBotpCallBackReplayVo(e.getMessage(), FiBotpReplayEnum.fail);
        }
        return JSONObject.toJSONString((Object)replayVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBusBillWhenEntryClose(List<FiBotpCallBackArBillVo> arBillVos) {
        HashSet<Long> closedFinArBillId = new HashSet<Long>(8);
        HashSet<Long> closedFinArEntryId = new HashSet<Long>(8);
        HashMap<Long, FiBotpCallBackArBillItemVo> closedEntryIdAndItemVo = new HashMap<Long, FiBotpCallBackArBillItemVo>(8);
        for (FiBotpCallBackArBillVo arBillVo : arBillVos) {
            for (FiBotpCallBackArBillItemVo arItem : arBillVo.getArItems()) {
                if (!arItem.isClosed()) continue;
                closedFinArBillId.add(arBillVo.getArBillPk());
                closedFinArEntryId.add(arItem.getEntryPk());
                closedEntryIdAndItemVo.put(arItem.getEntryPk(), arItem);
            }
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)"ar_busbill", (String)"ar_busbill");
        Long busArTableId = tableDefine.getTableId();
        if (busArTableId == 0L) {
            throw new KDBizException("FiBotpCallBackService-updateBusBillWhenEntryClose:busArTableId is null");
        }
        HashMap<Long, Long> srcEntryIdAndFinEntryId = new HashMap<Long, Long>(8);
        HashSet<Long> busArBillIds = new HashSet<Long>(8);
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)"ar_finarbill", (String)"entry", (Long[])closedFinArBillId.toArray(new Long[0]), (Long[])closedFinArEntryId.toArray(new Long[0]), null);
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return;
        }
        for (Long entryId : closedFinArEntryId) {
            BFRowLinkUpNode entryNode;
            List<BFRowLinkUpNode> sourceNodes;
            Optional<BFRowLinkUpNode> entryNodeOptional = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getEntryId().compareTo(entryId) == 0).findFirst();
            if (!entryNodeOptional.isPresent() || ObjectUtils.isEmpty(sourceNodes = this.findSourceEntryNodes(entryNode = entryNodeOptional.get(), busArTableId, entryId))) continue;
            srcEntryIdAndFinEntryId.put(sourceNodes.get(0).getRowId().getEntryId(), entryId);
            busArBillIds.add(sourceNodes.get(0).getRowId().getBillId());
        }
        if (busArBillIds.isEmpty()) {
            return;
        }
        DynamicObject[] busArBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)this.getBusSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", busArBillIds)});
        try {
            MutexLockHelper.requireMutex((String)"ar_busbill", busArBillIds, (String)"updateFinArBill", (String)"");
            this.caculateRelationAmt(busArBills, srcEntryIdAndFinEntryId, closedEntryIdAndItemVo);
            SaveServiceHelper.save((DynamicObject[])busArBills);
        }
        finally {
            MutexLockHelper.batchRelease((String)"ar_busbill", busArBillIds, (String)"updateFinArBill");
        }
    }

    private String getBusSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(8);
        selectors.add("billno");
        selectors.add("unrelateinvamt");
        selectors.add("unrelateinvlocamt");
        selectors.add("relateinvamt");
        selectors.add("relateinvlocamt");
        selectors.add("payproperty");
        selectors.add("payproperty");
        selectors.add("e_recamount");
        selectors.add("e_reclocalamt");
        selectors.add("e_quantity");
        selectors.add("e_taxunitprice");
        selectors.add("e_unrelateinvqty");
        selectors.add("e_relateinvqty");
        selectors.add("e_unrelateinvamt");
        selectors.add("e_unrelateinvlocamt");
        selectors.add("e_relateinvamt");
        selectors.add("e_relateinvlocamt");
        return String.join((CharSequence)",", selectors);
    }

    private void caculateRelationAmt(DynamicObject[] busArBills, Map<Long, Long> srcEntryIdAndFinEntryId, Map<Long, FiBotpCallBackArBillItemVo> closedEntryIdAndItemVo) {
        for (DynamicObject busArBill : busArBills) {
            logger.info("selcet busarbill billno is" + busArBill.getString("billno"));
            BigDecimal relateinvamt = BigDecimal.ZERO;
            BigDecimal relateinvlocamt = BigDecimal.ZERO;
            BigDecimal unrelateinvamt = BigDecimal.ZERO;
            BigDecimal unrelateinvlocamt = BigDecimal.ZERO;
            DynamicObjectCollection entries = busArBill.getDynamicObjectCollection("entry");
            boolean isBaseDonAmt = busArBill.getBoolean("payproperty.isbasedonamt");
            for (DynamicObject entry : entries) {
                Long finEntryId = srcEntryIdAndFinEntryId.get(entry.getLong("id"));
                if (finEntryId == null) continue;
                FiBotpCallBackArBillItemVo itemVo = closedEntryIdAndItemVo.get(finEntryId);
                BigDecimal influenceAmountIncludeTax = itemVo.getInfluenceAmountIncludeTax();
                BigDecimal includeTaxLocalAmt = itemVo.getInfluenceFromTaxAmount();
                BigDecimal influenceNum = itemVo.getInfluenceNum();
                BigDecimal recAmount = entry.getBigDecimal("e_recamount");
                BigDecimal recLocalAmount = entry.getBigDecimal("e_reclocalamt");
                BigDecimal quantity = entry.getBigDecimal("e_quantity");
                BigDecimal invoicedQty = entry.getBigDecimal("e_relateinvqty");
                BigDecimal invoicedAmt = entry.getBigDecimal("e_relateinvamt");
                BigDecimal invoicedLocalAmt = entry.getBigDecimal("e_relateinvlocamt");
                BigDecimal newInvoicedAmt = invoicedAmt.add(influenceAmountIncludeTax);
                BigDecimal newInvoicedLocalAmt = invoicedLocalAmt.add(includeTaxLocalAmt);
                BigDecimal newUnInvoicedAmt = recAmount.subtract(newInvoicedAmt);
                BigDecimal newUnInvoicedLocalAmt = recLocalAmount.subtract(newInvoicedLocalAmt);
                entry.set("e_relateinvamt", (Object)newInvoicedAmt);
                entry.set("e_relateinvlocamt", (Object)newInvoicedLocalAmt);
                entry.set("e_unrelateinvamt", (Object)newUnInvoicedAmt);
                entry.set("e_unrelateinvlocamt", (Object)newUnInvoicedLocalAmt);
                relateinvamt = relateinvamt.add(newInvoicedAmt);
                relateinvlocamt = relateinvlocamt.add(newInvoicedLocalAmt);
                unrelateinvamt = unrelateinvamt.add(newUnInvoicedAmt);
                unrelateinvlocamt = unrelateinvlocamt.add(newUnInvoicedLocalAmt);
                if (isBaseDonAmt) {
                    if (recAmount.compareTo(BigDecimal.ZERO) == 0 && entry.getBigDecimal("e_taxunitprice").compareTo(BigDecimal.ZERO) != 0) {
                        if (itemVo.getInfluenceNum().compareTo(BigDecimal.ZERO) < 0) {
                            entry.set("e_unrelateinvqty", (Object)quantity);
                            entry.set("e_relateinvqty", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        entry.set("e_relateinvqty", (Object)quantity);
                        entry.set("e_unrelateinvqty", (Object)BigDecimal.ZERO);
                        continue;
                    }
                    if (recAmount.abs().compareTo(newInvoicedAmt.abs()) <= 0) {
                        entry.set("e_relateinvqty", (Object)quantity);
                        entry.set("e_unrelateinvqty", (Object)BigDecimal.ZERO);
                        continue;
                    }
                    entry.set("e_unrelateinvqty", (Object)quantity);
                    entry.set("e_relateinvqty", (Object)BigDecimal.ZERO);
                    continue;
                }
                entry.set("e_relateinvqty", (Object)invoicedQty.add(influenceNum));
                entry.set("e_unrelateinvqty", (Object)quantity.subtract(entry.getBigDecimal("e_relateinvqty")));
            }
            busArBill.set("relateinvamt", (Object)relateinvamt);
            busArBill.set("relateinvlocamt", (Object)relateinvlocamt);
            busArBill.set("unrelateinvamt", (Object)unrelateinvamt);
            busArBill.set("unrelateinvlocamt", (Object)unrelateinvlocamt);
            logger.info("set busarbill end:" + busArBill.getString("billno"));
        }
    }

    private List<BFRowLinkUpNode> findSourceEntryNodes(BFRowLinkUpNode node, Long sMainTableId, Long entryId) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getEntryId().compareTo(entryId) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(this.findSourceEntryNodes(sNode, sMainTableId, entryId));
            }
        }
        return nodes;
    }

    private void invoiceCoordination(DynamicObject[] finArBills, FiBotpCallBackVo result) {
        boolean isCoorDinate;
        logger.info("\u8fdb\u5165\u6536\u7968\u534f\u540c\u6d41\u7a0b");
        String invoiceStatus = result.getInvoiceStatus();
        String oriInvoiceStatus = result.getOriInvoiceStatus();
        String invoiceCode = result.getInvoiceCode();
        String invoiceNo = result.getInvoiceNo();
        if ("3".equals(oriInvoiceStatus)) {
            invoiceStatus = oriInvoiceStatus;
            invoiceCode = result.getOriInvoiceCode();
            invoiceNo = result.getOriInvoiceNo();
        }
        DynamicObject arBill = finArBills[0];
        DynamicObject asstact = arBill.getDynamicObject("asstact");
        Long orgId = this.getBizPartnerId(asstact);
        if (RIGHTSTATUS.equals(invoiceStatus) && !(isCoorDinate = SystemParameterHelper.getAPBooleanParam((long)orgId, (String)"ap_023"))) {
            return;
        }
        logger.info("\u5f80\u6765\u6237\u5185\u90e8\u5355\u5143\u4e3a\uff1a" + orgId);
        if (orgId == 0L) {
            return;
        }
        List finArBillIds = Arrays.stream(finArBills).map(v -> v.getLong("id")).collect(Collectors.toList());
        for (DynamicObject finArBill : finArBills) {
            DynamicObject expenseitem;
            boolean isBizPartner = finArBill.getBoolean("relationpay");
            if (!isBizPartner) continue;
            logger.info("\u5f00\u59cb\u6267\u884c\u534f\u540c\u6536\u7968");
            DynamicObject material = ((DynamicObject)finArBill.getDynamicObjectCollection("entry").get(0)).getDynamicObject("e_material");
            String biztype = "PUR";
            if (material == null && (expenseitem = ((DynamicObject)finArBill.getDynamicObjectCollection("entry").get(0)).getDynamicObject("e_expenseitem")) != null) {
                biztype = "FEE";
            }
            HashMap<String, Object> invoiceParam = new HashMap<String, Object>(2);
            invoiceParam.put("invoicecode", invoiceCode);
            invoiceParam.put("invoiceno", invoiceNo);
            invoiceParam.put("orgid", orgId);
            invoiceParam.put("biztype", biztype);
            invoiceParam.put("invoicestatus", invoiceStatus);
            invoiceParam.put("finarbillids", finArBillIds);
            this.invokeCoorDinate(invoiceParam);
            break;
        }
    }

    private Long getBizPartnerId(DynamicObject custsupper) {
        DynamicObject asstact;
        DynamicObject intercompany;
        Long bizPartnerId = 0L;
        if (custsupper != null && (custsupper.getDataEntityType().getName().equals("bd_supplier") || custsupper.getDataEntityType().getName().equals("bd_customer")) && (intercompany = (asstact = BusinessDataServiceHelper.loadSingle((Object)((Long)custsupper.getPkValue()), (String)custsupper.getDynamicObjectType().getName(), (String)"internal_company")).getDynamicObject("internal_company")) != null) {
            bizPartnerId = intercompany.getLong("id");
        }
        return bizPartnerId;
    }

    private void invokeCoorDinate(Map<String, Object> invoiceParam) {
        if (ECServiceSwitch.isOpened()) {
            CommonParam param = new CommonParam();
            param.put((Object)"invoiceparam", invoiceParam);
            logger.info("\u534f\u540c\u4f20\u9012\u7684\u53c2\u6570\u4e3a: " + invoiceParam);
            try (TXHandle tx = TX.requiresNew((String)"coordination");){
                try {
                    ECServiceHelper.beginAndRegister((String)"ap_coordnation", (String)"", (String)"fi", (String)"ap", (String)"InvoiceCoordinationService", (Param)param, (String)"");
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public void updaeBillByNormalStu(DynamicObject finArBill, FiBotpCallBackVo result, List<FiBotpCallBackArBillVo> arBillVos) throws Exception {
        String invoiceStatus = result.getInvoiceStatus();
        List arBillVoTarget = arBillVos.stream().filter(p -> p.getArBillPk().longValue() == finArBill.getLong("id")).collect(Collectors.toList());
        FiBotpCallBackArBillVo arBillVo = (FiBotpCallBackArBillVo)arBillVoTarget.get(0);
        logger.info("selcet finarbill billno is" + finArBill.getString("billno"));
        String invoiceCode = finArBill.getString("invoicecode");
        String invoiceNo = finArBill.getString("invoiceno");
        logger.info("finarbill old invoicecode , invoiceno is" + invoiceCode + ";" + invoiceNo);
        Map<String, String> returnMap = this.setInvoiceCode(invoiceStatus, invoiceCode, invoiceNo, result);
        finArBill.set("invoicecode", (Object)returnMap.get("invoiceCode"));
        finArBill.set("invoiceno", (Object)returnMap.get("invoiceNo"));
        logger.info("finarbill afterupdate invoicecode , invoiceno is" + returnMap.get("invoiceCode") + ";" + returnMap.get("invoiceNo"));
        DynamicObjectCollection entry = finArBill.getDynamicObjectCollection("entry");
        List billItemVos = arBillVo.getArItems();
        boolean isBaseDonAmt = finArBill.getBoolean("payproperty.isbasedonamt");
        this.updaeBillEntry(billItemVos, entry, invoiceStatus, isBaseDonAmt, result);
        BigDecimal issueInvRecAmtSum = BigDecimal.ZERO;
        BigDecimal unInvoicedAmtSum = BigDecimal.ZERO;
        BigDecimal invoicedAmtSum = BigDecimal.ZERO;
        BigDecimal issueInvRecAmtlocalSum = BigDecimal.ZERO;
        BigDecimal unInvoicedAmtLocalSum = BigDecimal.ZERO;
        BigDecimal invoicedAmtLocalSum = BigDecimal.ZERO;
        for (DynamicObject row : entry) {
            issueInvRecAmtSum = issueInvRecAmtSum.add(row.getBigDecimal("e_issueinvrecamt"));
            unInvoicedAmtSum = unInvoicedAmtSum.add(row.getBigDecimal("e_uninvoicedamt"));
            invoicedAmtSum = invoicedAmtSum.add(row.getBigDecimal("e_invoicedamt"));
            issueInvRecAmtlocalSum = issueInvRecAmtlocalSum.add(row.getBigDecimal("e_issueinvreclocalamt"));
            unInvoicedAmtLocalSum = unInvoicedAmtLocalSum.add(row.getBigDecimal("e_uninvoicedlocalamt"));
            invoicedAmtLocalSum = invoicedAmtLocalSum.add(row.getBigDecimal("e_invoicedlocalamt"));
        }
        finArBill.set("issueinvrecamt", (Object)issueInvRecAmtSum);
        finArBill.set("uninvoicedamt", (Object)unInvoicedAmtSum);
        finArBill.set("invoicedamt", (Object)invoicedAmtSum);
        finArBill.set("issueinvreclocalamt", (Object)issueInvRecAmtlocalSum);
        finArBill.set("uninvoicedlocalamt", (Object)unInvoicedAmtLocalSum);
        finArBill.set("invoicedlocalamt", (Object)invoicedAmtLocalSum);
        Long issueDateTime = result.getIssueDate();
        if (issueDateTime != null) {
            finArBill.set("invoicedate", (Object)new Date(issueDateTime));
        }
        logger.info("set finarbill entry end");
    }

    public void updaeBillEntry(List<FiBotpCallBackArBillItemVo> billItemVos, DynamicObjectCollection entryColls, String invoiceStatus, boolean isBaseDonAmt, FiBotpCallBackVo result) throws Exception {
        for (FiBotpCallBackArBillItemVo itemVo : billItemVos) {
            Long entryPk = itemVo.getEntryPk();
            DynamicObject tarRow = entryColls.stream().filter(v -> v.getLong("id") == entryPk.longValue()).findFirst().orElse(null);
            if (EmptyUtils.isEmpty((Object)tarRow)) {
                throw new Exception(entryPk + ",entryid No match");
            }
            boolean closed = itemVo.isClosed();
            if (closed) {
                this.disposeEntryInvoiceRelate(itemVo, tarRow, isBaseDonAmt);
            }
            this.disposeEntryIssueInvRelate(itemVo, tarRow, invoiceStatus, isBaseDonAmt, result);
        }
    }

    private Map<String, String> setInvoiceCode(String invoiceStatus, String invoiceCode, String invoiceNo, FiBotpCallBackVo result) {
        String cbinCode = result.getInvoiceCode();
        String cbinNo = result.getInvoiceNo();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        ArrayList<String> inNosList = new ArrayList<String>(Arrays.asList(invoiceNo.split(", ")));
        ArrayList<String> inCodesList = new ArrayList<String>(Arrays.asList(invoiceCode.split(", ")));
        if (CANCELSTATUS.equals(invoiceStatus)) {
            List removeNo = inNosList.stream().filter(t -> t.equals(cbinNo)).collect(Collectors.toList());
            List removeCode = inCodesList.stream().filter(t -> t.equals(cbinCode)).collect(Collectors.toList());
            if (removeNo.size() > 0) {
                int i;
                for (i = inNosList.size() - 1; i >= 0; --i) {
                    if (!((String)inNosList.get(i)).equals(cbinNo)) continue;
                    inNosList.remove(i);
                }
                if (removeCode.size() > 0) {
                    for (i = inCodesList.size() - 1; i >= 0; --i) {
                        if (!((String)inCodesList.get(i)).equals(cbinCode)) continue;
                        inCodesList.remove(i);
                    }
                }
            } else {
                returnMap.put("remNotExist", "yes");
            }
        } else if (StringUtils.isNotEmpty((String)cbinNo) && !inNosList.contains(cbinNo)) {
            inNosList.add(cbinNo);
            inCodesList.add(cbinCode);
        } else {
            returnMap.put("isexist", "yes");
        }
        inCodesList.remove("");
        inNosList.remove("");
        returnMap.put("invoiceCode", ((Object)inCodesList).toString().replace("[", "").replace("]", ""));
        returnMap.put("invoiceNo", ((Object)inNosList).toString().replace("[", "").replace("]", ""));
        return returnMap;
    }

    private void disposeEntryInvoiceRelate(FiBotpCallBackArBillItemVo itemVo, DynamicObject tarRow, boolean isBaseDonAmt) {
        BigDecimal influenceAmountIncludeTax = itemVo.getInfluenceAmountIncludeTax();
        BigDecimal includeTaxLocalAmt = itemVo.getInfluenceFromTaxAmount();
        BigDecimal influenceNum = itemVo.getInfluenceNum();
        BigDecimal recAmount = tarRow.getBigDecimal("e_recamount");
        BigDecimal recLocalAmount = tarRow.getBigDecimal("e_reclocalamt");
        BigDecimal quantity = tarRow.getBigDecimal("e_quantity");
        BigDecimal invoicedQty = tarRow.getBigDecimal("e_invoicedqty");
        BigDecimal invoicedAmt = tarRow.getBigDecimal("e_invoicedamt");
        BigDecimal invoicedLocalAmt = tarRow.getBigDecimal("e_invoicedlocalamt");
        BigDecimal newInvoicedAmt = invoicedAmt.add(influenceAmountIncludeTax);
        BigDecimal newInvoicedLocalAmt = invoicedLocalAmt.add(includeTaxLocalAmt);
        BigDecimal newUnInvoicedAmt = recAmount.subtract(newInvoicedAmt);
        BigDecimal newUnInvoicedLocalAmt = recLocalAmount.subtract(newInvoicedLocalAmt);
        tarRow.set("e_invoicedamt", (Object)newInvoicedAmt);
        tarRow.set("e_invoicedlocalamt", (Object)newInvoicedLocalAmt);
        tarRow.set("e_uninvoicedamt", (Object)newUnInvoicedAmt);
        tarRow.set("e_uninvoicedlocalamt", (Object)newUnInvoicedLocalAmt);
        if (isBaseDonAmt) {
            if (recAmount.compareTo(BigDecimal.ZERO) == 0 && tarRow.getBigDecimal("e_taxunitprice").compareTo(BigDecimal.ZERO) != 0) {
                if (itemVo.getInfluenceNum().compareTo(BigDecimal.ZERO) < 0) {
                    tarRow.set("e_uninvoicedqty", (Object)quantity);
                    tarRow.set("e_invoicedqty", (Object)BigDecimal.ZERO);
                } else {
                    tarRow.set("e_invoicedqty", (Object)quantity);
                    tarRow.set("e_uninvoicedqty", (Object)BigDecimal.ZERO);
                }
            } else if (recAmount.compareTo(newInvoicedAmt) == 0) {
                tarRow.set("e_invoicedqty", (Object)quantity);
                tarRow.set("e_uninvoicedqty", (Object)BigDecimal.ZERO);
            } else {
                tarRow.set("e_uninvoicedqty", (Object)quantity);
                tarRow.set("e_invoicedqty", (Object)BigDecimal.ZERO);
            }
        } else {
            tarRow.set("e_invoicedqty", (Object)invoicedQty.add(influenceNum));
            tarRow.set("e_uninvoicedqty", (Object)quantity.subtract(tarRow.getBigDecimal("e_invoicedqty")));
        }
    }

    private void disposeEntryIssueInvRelate(FiBotpCallBackArBillItemVo itemVo, DynamicObject tarRow, String invoiceStatus, boolean isBaseDonAmt, FiBotpCallBackVo result) {
        String entryinvoiceNo;
        BigDecimal influenceAmountIncludeTax = itemVo.getInfluenceAmountIncludeTax();
        BigDecimal influenceAmount = itemVo.getInfluenceAmount();
        BigDecimal influenceTax = itemVo.getInfluencetax();
        BigDecimal influenceNum = itemVo.getInfluenceNum();
        BigDecimal includeLocalTaxAmt = itemVo.getInfluenceFromTaxAmount();
        BigDecimal influenceLocalAmt = itemVo.getInfluenceFromAmount();
        BigDecimal influenceLocalTaxAmt = itemVo.getInfluenceFromTax();
        BigDecimal recAmount = tarRow.getBigDecimal("e_recamount");
        BigDecimal quantity = tarRow.getBigDecimal("e_quantity");
        String entryInvoiceCode = tarRow.getString("e_invoicecode");
        Map<String, String> returnEntryMap = this.setInvoiceCode(invoiceStatus, entryInvoiceCode, entryinvoiceNo = tarRow.getString("e_invoiceno"), result);
        if (("yes".equals(returnEntryMap.get("isexist")) || "yes".equals(returnEntryMap.get("remNotExist"))) && !this.isWriteNoFinByInvno) {
            return;
        }
        logger.info("finarbill target entryRowid is" + tarRow.getLong("id"));
        logger.info("finarbill entry old invoicecode , invoiceno is" + entryInvoiceCode + ";" + entryinvoiceNo);
        BigDecimal issueInvrecAmt = tarRow.getBigDecimal("e_issueinvrecamt");
        BigDecimal issueInvAmt = tarRow.getBigDecimal("e_issueinvamt");
        BigDecimal issueInvTax = tarRow.getBigDecimal("e_issueinvtax");
        BigDecimal issueInvQty = tarRow.getBigDecimal("e_issueinvqty");
        BigDecimal issueInvrecLocalAmt = tarRow.getBigDecimal("e_issueinvreclocalamt");
        BigDecimal issueInvLocalAmt = tarRow.getBigDecimal("e_issueinvlocalamt");
        BigDecimal issueInvLocalTax = tarRow.getBigDecimal("e_issueinvlocaltax");
        tarRow.set("e_invoicecode", (Object)returnEntryMap.get("invoiceCode"));
        tarRow.set("e_invoiceno", (Object)returnEntryMap.get("invoiceNo"));
        tarRow.set("e_issueinvamt", (Object)influenceAmount.add(issueInvAmt));
        tarRow.set("e_issueinvrecamt", (Object)influenceAmountIncludeTax.add(issueInvrecAmt));
        tarRow.set("e_issueinvtax", (Object)influenceTax.add(issueInvTax));
        tarRow.set("e_issueinvreclocalamt", (Object)includeLocalTaxAmt.add(issueInvrecLocalAmt));
        tarRow.set("e_issueinvlocalamt", (Object)influenceLocalAmt.add(issueInvLocalAmt));
        tarRow.set("e_issueinvlocaltax", (Object)influenceLocalTaxAmt.add(issueInvLocalTax));
        if (isBaseDonAmt) {
            if (recAmount.compareTo(BigDecimal.ZERO) == 0 && tarRow.getBigDecimal("e_taxunitprice").compareTo(BigDecimal.ZERO) != 0) {
                if (itemVo.getInfluenceNum().compareTo(BigDecimal.ZERO) < 0) {
                    tarRow.set("e_issueinvqty", (Object)BigDecimal.ZERO);
                } else {
                    tarRow.set("e_issueinvqty", (Object)quantity);
                }
            } else if (recAmount.compareTo(tarRow.getBigDecimal("e_issueinvrecamt")) == 0) {
                tarRow.set("e_issueinvqty", (Object)quantity);
            } else {
                tarRow.set("e_issueinvqty", (Object)BigDecimal.ZERO);
            }
        } else {
            boolean isMerge;
            String mergeLable = result.getMergeLable();
            boolean bl = isMerge = tarRow.getBigDecimal("e_recamount").compareTo(tarRow.getBigDecimal("e_issueinvrecamt")) == 0;
            if (EmptyUtils.isNotEmpty((Object)mergeLable) && ("1".equals(mergeLable) || "2".equals(mergeLable))) {
                tarRow.set("e_issueinvqty", (Object)(isMerge ? quantity : Integer.valueOf(0)));
            } else {
                tarRow.set("e_issueinvqty", (Object)influenceNum.add(issueInvQty));
            }
        }
    }

    @Deprecated
    public Object canRedrockOrCancel(Map<String, Object> param) {
        if (ObjectUtils.isEmpty(param)) {
            return true;
        }
        logger.info("FiBotpCallBackService.canRedrockOrCancel param is: " + JsonUtils.objToJson(param));
        Object listObj = param.get("list");
        if (listObj != null) {
            List params = (List)listObj;
            return this.batchValidateCanRedOrInvalid(params);
        }
        List<Map<String, Object>> resultList = this.batchValidateCanRedOrInvalid(Collections.singletonList(param));
        return resultList.get(0).get("canexecute");
    }

    public List<Map<String, Object>> batchValidateCanRedOrInvalid(List<Map<String, Object>> params) {
        logger.info("FiBotpCallBackService batchValidateCanRedOrInvalid params is :" + params);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(8);
        if (ObjectUtils.isEmpty(params)) {
            return resultList;
        }
        ArrayList<Long> allFinArBillIds = new ArrayList<Long>(8);
        ArrayList<Long> allFinArEntryIds = new ArrayList<Long>(8);
        ArrayList<Long> allSimBillIds = new ArrayList<Long>(8);
        ArrayList<Long> allSimEntryIds = new ArrayList<Long>(8);
        HashSet<String> invoiceCodes = new HashSet<String>(8);
        HashSet<String> invoiceNos = new HashSet<String>(8);
        for (Map<String, Object> param : params) {
            List simEntryIds;
            List simBillIds;
            List finArEntryIds;
            invoiceCodes.add((String)param.get("invoicecode"));
            invoiceNos.add((String)param.get("invoiceno"));
            List finArBillIds = (List)param.get("finarbillids");
            if (finArBillIds != null) {
                allFinArBillIds.addAll(finArBillIds);
            }
            if ((finArEntryIds = (List)param.get("finarentryids")) != null) {
                allFinArEntryIds.addAll(finArEntryIds);
            }
            if ((simBillIds = (List)param.get("simbillids")) != null) {
                allSimBillIds.addAll(simBillIds);
            }
            if ((simEntryIds = (List)param.get("simentryids")) == null) continue;
            allSimEntryIds.addAll(simEntryIds);
        }
        Map<Long, DynamicObject> adjustArSrcId4FinArMap = this.getFinArAdjustEntryInfo(allFinArBillIds, allFinArEntryIds, allSimBillIds, allSimEntryIds);
        Map<Long, DynamicObject> finArBillMap = this.getFinArAdjustBillInfo(allFinArBillIds);
        Tuple<Map<String, Long>, Map<Long, DynamicObject>> tuple = this.getFinApAdjustBillInfo(invoiceCodes, invoiceNos);
        Map invCodeAndNo4FinApIdMap = (Map)tuple.item1;
        Map adjustApSrcId4FinApMap = (Map)tuple.item2;
        for (Map<String, Object> param : params) {
            String message;
            List simEntryIds;
            String message2;
            HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
            resultMap.put("invoiceno", param.get("invoiceno"));
            resultMap.put("invoicecode", param.get("invoicecode"));
            resultMap.put("canexecute", true);
            List finArBillIds = (List)param.get("finarbillids");
            if (finArBillIds != null) {
                for (Object finArBillId : finArBillIds) {
                    DynamicObject finArBill = finArBillMap.get(finArBillId);
                    if (finArBill == null || (message2 = this.validateCanRedOrInvalidSceneTwo((Long)finArBillId, adjustArSrcId4FinArMap)) == null) continue;
                    resultMap.put("canexecute", false);
                    resultMap.put("message", message2);
                    break;
                }
            }
            if ((simEntryIds = (List)param.get("simentryids")) != null) {
                Object finArBillId;
                finArBillId = simEntryIds.iterator();
                while (finArBillId.hasNext()) {
                    Long simEntryId = (Long)finArBillId.next();
                    message2 = this.validateCanRedOrInvalidSceneTwo(simEntryId, adjustArSrcId4FinArMap);
                    if (message2 == null) continue;
                    resultMap.put("canexecute", false);
                    resultMap.put("message", message2);
                    break;
                }
            }
            if (((Boolean)resultMap.get("canexecute")).booleanValue() && (message = this.validateCanRedOrInvalidSceneThree(param, invCodeAndNo4FinApIdMap, adjustApSrcId4FinApMap)) != null) {
                resultMap.put("canexecute", false);
                resultMap.put("message", message);
            }
            resultList.add(resultMap);
        }
        logger.info("FiBotpCallBackService batchValidateCanRedOrInvalid end , resultList is : " + resultList);
        return resultList;
    }

    private String validateCanRedOrInvalidSceneTwo(Long billId, Map<Long, DynamicObject> adjustArSrcId4FinArMap) {
        DynamicObject arAdjustBill = adjustArSrcId4FinArMap.get(billId);
        if (arAdjustBill != null) {
            return ResManager.loadKDString((String)"\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\u4e0d\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968\u7533\u8bf7\u5355\u7ea2\u51b2\u3001\u4f5c\u5e9f\u3002\u8bf7\u5148\u5220\u9664\u6216\u51b2\u9500\u81ea\u52a8\u8c03\u5dee\u751f\u6210\u7684\u8c03\u6574\u5355\u540e\u91cd\u8bd5\u3002", (String)"FiBotpCallBackService_4", (String)"fi-ar-mservice", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u8d22\u52a1\u5e94\u6536\u5355\u4e0b\u6e38\u4e0d\u5b58\u5728\u81ea\u52a8\u8c03\u5dee\u751f\u6210\u7684\u8d22\u52a1\u5e94\u6536\u8c03\u6574\u5355\uff1b", (String)"FiBotpCallBackService_5", (String)"fi-ar-mservice", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u8d22\u52a1\u5e94\u6536\u5355\u4e0b\u6e38\u5b58\u5728\u81ea\u52a8\u8c03\u5dee\u751f\u6210\u7684\u8d22\u52a1\u5e94\u6536\u8c03\u6574\u5355\u5e76\u4e14\u8c03\u6574\u5355\u5df2\u51b2\u9500\u3002", (String)"FiBotpCallBackService_6", (String)"fi-ar-mservice", (Object[])new Object[0]);
        }
        return null;
    }

    private String validateCanRedOrInvalidSceneThree(Map<String, Object> param, Map<String, Long> invCodeAndNo4FinApIdMap, Map<Long, DynamicObject> adjustApSrcId4FinApMap) {
        String message = ResManager.loadKDString((String)"\u5173\u8054\u8d22\u52a1\u5e94\u6536\u5355\u4e0a\u6e38\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968\u7533\u8bf7\u5355\u7ea2\u51b2\u3001\u4f5c\u5e9f\u3002\u8bf7\u5148\u5220\u9664\u6216\u51b2\u9500\u8d22\u52a1\u5e94\u4ed8\u5355\u81ea\u52a8\u8c03\u5dee\u751f\u6210\u7684\u8c03\u6574\u5355\u540e\u91cd\u8bd5\u3002", (String)"FiBotpCallBackService_7", (String)"fi-ar-mservice", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"1.\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0b\u6e38\u4e0d\u5b58\u5728\u81ea\u52a8\u8c03\u5dee\u751f\u6210\u7684\u8d22\u52a1\u5e94\u4ed8\u8c03\u6574\u5355\uff1b", (String)"FiBotpCallBackService_8", (String)"fi-ar-mservice", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"2.\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0b\u6e38\u5b58\u5728\u81ea\u52a8\u8c03\u5dee\u751f\u6210\u7684\u8d22\u52a1\u5e94\u4ed8\u8c03\u6574\u5355\u5e76\u4e14\u8c03\u6574\u5355\u5df2\u51b2\u9500\u3002", (String)"FiBotpCallBackService_9", (String)"fi-ar-mservice", (Object[])new Object[0]);
        String key = String.valueOf(param.get("invoicecode")) + String.valueOf(param.get("invoiceno"));
        Long finApBillId = invCodeAndNo4FinApIdMap.get(key);
        if (finApBillId == null) {
            return null;
        }
        DynamicObject apAdjustBill = adjustApSrcId4FinApMap.get(finApBillId);
        if (apAdjustBill != null && !apAdjustBill.getBoolean("hadwrittenoff")) {
            return message;
        }
        return null;
    }

    private Map<Long, DynamicObject> getFinArAdjustEntryInfo(List<Long> allFinArBillIds, List<Long> allFinArEntryIds, List<Long> simOriginalBillIds, List<Long> simOriginalEntryIds) {
        HashSet<Long> finArBillIdSet = new HashSet<Long>(2);
        HashSet<Long> finArEntryIdSet = new HashSet<Long>(2);
        if (!allFinArBillIds.isEmpty()) {
            logger.info("FiBotpCallBackService.getFinArAdjustEntryInfo allFinArBillIds: " + allFinArBillIds.size());
            finArBillIdSet.addAll(allFinArBillIds);
            finArEntryIdSet.addAll(allFinArEntryIds);
        }
        HashMap<Long, Set> finArEntryId2SimMap = new HashMap<Long, Set>(8);
        if (!simOriginalBillIds.isEmpty()) {
            logger.info("FiBotpCallBackService.getFinArAdjustEntryInfo simOriginalBillIds: " + simOriginalBillIds.size());
            DynamicObjectCollection arOriginalColl = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"isvoucher,org.id,entry.billid,entry.billentryid,entry.assbillid,entry.assbillentryid", (QFilter[])new QFilter[]{new QFilter("entry.assbillid", "in", simOriginalBillIds), new QFilter("entry.assbillentryid", "in", simOriginalEntryIds)});
            for (DynamicObject arOriginal : arOriginalColl) {
                finArBillIdSet.add(arOriginal.getLong("entry.billid"));
                finArEntryIdSet.add(arOriginal.getLong("entry.billentryid"));
                Set assEntryIds = finArEntryId2SimMap.computeIfAbsent(arOriginal.getLong("entry.billentryid"), v -> new HashSet(2));
                assEntryIds.add(arOriginal.getLong("entry.assbillentryid"));
            }
        }
        QFilter filter = new QFilter("entry.e_srcid", "in", finArBillIdSet);
        filter.and(new QFilter("entry.e_srcentryid", "in", finArEntryIdSet));
        filter.and(new QFilter("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue()));
        filter.and(new QFilter("billtype.number", "=", (Object)"arfin_borrowar_BT_S"));
        filter.and(new QFilter("adjusttype", "=", (Object)"adjustinv"));
        filter.and(new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE));
        if (ArApXDBHelper.isSharding((String)"t_ar_finarbill")) {
            QFilter queryOrgFilter = new QFilter("id", "in", finArBillIdSet);
            DynamicObjectCollection orgBillColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"org.id", (QFilter[])queryOrgFilter.toArray());
            HashSet<Long> orgIdSet = new HashSet<Long>(2);
            for (DynamicObject orgBill : orgBillColl) {
                orgIdSet.add(orgBill.getLong("org.id"));
            }
            filter.and(new QFilter("org.id", "in", orgIdSet));
        }
        HashMap<Long, DynamicObject> adjustArSrcId4FinArMap = new HashMap<Long, DynamicObject>(8);
        DynamicObjectCollection adjustBillColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"entry.e_srcid,entry.e_srcentryid", (QFilter[])filter.toArray());
        if (adjustBillColl.isEmpty()) {
            return adjustArSrcId4FinArMap;
        }
        logger.info("FiBotpCallBackService.getFinArAdjustEntryInfo adjustBillColl: " + adjustBillColl.size());
        for (DynamicObject adjustBill : adjustBillColl) {
            Long srcId = adjustBill.getLong("entry.e_srcid");
            adjustArSrcId4FinArMap.put(srcId, adjustBill);
            Long srcEntryId = adjustBill.getLong("entry.e_srcentryid");
            Set simEntryIds = (Set)finArEntryId2SimMap.get(srcEntryId);
            if (simEntryIds == null) continue;
            for (Long simEntryId : simEntryIds) {
                adjustArSrcId4FinArMap.put(simEntryId, adjustBill);
            }
        }
        return adjustArSrcId4FinArMap;
    }

    private Map<Long, DynamicObject> getFinArAdjustBillInfo(List<Long> allFinArBillIds) {
        if (allFinArBillIds.isEmpty()) {
            return new HashMap<Long, DynamicObject>(2);
        }
        QFilter filter = new QFilter("id", "in", allFinArBillIds);
        filter.and(new QFilter("relationpay", "=", (Object)Boolean.TRUE));
        DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,entry.id,entry.e_invoicecode,entry.e_invoiceno,entry.e_issueinvrecamt,entry.e_issueinvreclocalamt", (QFilter[])new QFilter[]{new QFilter("id", "in", allFinArBillIds)});
        Map<Long, DynamicObject> finArBillMap = Arrays.stream(finArBills).collect(Collectors.toMap(bill -> bill.getLong("id"), Function.identity()));
        return finArBillMap;
    }

    private Tuple<Map<String, Long>, Map<Long, DynamicObject>> getFinApAdjustBillInfo(Set<String> invoiceCodes, Set<String> invoiceNos) {
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,invoicecode,invoiceno,org", (QFilter[])new QFilter[]{new QFilter("invoicecode", "in", invoiceCodes), new QFilter("invoiceno", "in", invoiceNos)});
        ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject invoice : invoices) {
            orgIds.add(invoice.getLong("org"));
            invoiceIds.add(invoice.getLong("id"));
        }
        QFilter filter1 = new QFilter("org", "in", orgIds);
        filter1.and("billsrctype", "<>", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue());
        filter1.and("inventry.i_srctype", "=", (Object)CANCELSTATUS);
        filter1.and("inventry.invid", "in", invoiceIds);
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,inventry.i_invoicecode,inventry.i_invoiceno", (QFilter[])new QFilter[]{filter1});
        HashMap<String, Long> invCodeAndNo4FinApIdMap = new HashMap<String, Long>(8);
        ArrayList<String> finApBillIds = new ArrayList<String>(8);
        for (DynamicObject finApBill : finApBills) {
            finApBillIds.add(finApBill.getString("id"));
            String key = finApBill.getString("inventry.i_invoicecode") + finApBill.getString("inventry.i_invoiceno");
            invCodeAndNo4FinApIdMap.put(key, finApBill.getLong("id"));
        }
        HashMap<Long, DynamicObject> adjustApSrcId4FinApMap = new HashMap<Long, DynamicObject>(8);
        if (!invCodeAndNo4FinApIdMap.isEmpty()) {
            QFilter filter3 = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
            filter3.and("sourcebillid", "in", finApBillIds);
            DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"sourcebillid", (QFilter[])new QFilter[]{filter3});
            ArrayList<Long> needProcessFinApIds = new ArrayList<Long>(8);
            for (DynamicObject finArBill : finArBills) {
                long sourceBillId = Long.parseLong(finArBill.getString("sourcebillid"));
                needProcessFinApIds.add(sourceBillId);
            }
            if (!needProcessFinApIds.isEmpty()) {
                QFilter filter2 = new QFilter("org", "in", orgIds);
                filter2.and("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue());
                filter2.and("sourcebillid", "in", needProcessFinApIds);
                DynamicObjectCollection apAdjustBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"sourcebillid,hadwrittenoff", (QFilter[])new QFilter[]{filter2});
                for (DynamicObject apAdjustBill : apAdjustBills) {
                    adjustApSrcId4FinApMap.put(apAdjustBill.getLong("sourcebillid"), apAdjustBill);
                }
            }
        }
        return Tuple.create(invCodeAndNo4FinApIdMap, adjustApSrcId4FinApMap);
    }
}

