/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FinArReconciliationService {
    private static final Log logger = LogFactory.getLog(FinArReconciliationService.class);

    public DataSet getArDapRelation(Map<String, Object> paramMap) {
        long begin = System.currentTimeMillis();
        logger.info("FinArReconciliationService getFinArRelation begin.");
        if (ObjectUtils.isEmpty(paramMap)) {
            return null;
        }
        String billType = String.valueOf(paramMap.get("billType"));
        if (!"ar_journal".equals(billType)) {
            return null;
        }
        Long orgId = (Long)paramMap.get("org");
        Long periodId = (Long)paramMap.get("period");
        Set billIds = (Set)paramMap.get("billIds");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period", (String)"begindate, enddate");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("bizdate", ">=", (Object)period.getDate("begindate"));
        dateFilter.and(new QFilter("bizdate", "<=", (Object)period.getDate("enddate")));
        dateFilter.and(new QFilter("id", "in", (Object)billIds));
        DataSet arJournalDataSet = QueryServiceHelper.queryDataSet((String)"query_ar_journal", (String)billType, (String)"id, sourcebilltype entity , sourcebillid", (QFilter[])new QFilter[]{orgFilter, dateFilter}, null);
        QFilter pFilter = new QFilter("period", "=", (Object)periodId);
        pFilter.and(new QFilter("sourcebillid", "in", (Object)billIds));
        DataSet aiDapTrackerDataSet = QueryServiceHelper.queryDataSet((String)"query_ai_daptracker", (String)"ai_daptracker", (String)"billtype.number entity1,sourcebillid sourcebillid1, voucherid voucherid1", (QFilter[])new QFilter[]{orgFilter, pFilter}, null);
        JoinDataSet dapDataSet = arJournalDataSet.join(aiDapTrackerDataSet, JoinType.INNER).on("sourcebillid", "sourcebillid1").on("entity", "entity1").select(new String[]{"id", "entity", "id sourcebillid", "voucherid1 voucherid"});
        logger.info("FinArReconciliationService getFinArRelation end,cost time is : " + (System.currentTimeMillis() - begin));
        return dapDataSet.finish();
    }
}

