/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.tx.AsyncTx;
import kd.fi.arapcommon.tx.AsyncTxService;

public class IssueInvoiceService {
    private static Log logger = LogFactory.getLog(IssueInvoiceService.class);

    public String issueInvoice(String param) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew((String)"IssueInvoiceService");){
            logger.info("IssueInvoiceService_issueInvoice" + param);
            List datas = (List)JSONObject.parseObject((String)param, List.class);
            HashMap seperateDatas = new HashMap(8);
            for (Object data : datas) {
                String string = (String)data.get("billNo");
                List targets = (List)seperateDatas.get(string);
                if (targets != null) {
                    targets.add(data);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>(64);
                list.add(data);
                seperateDatas.put(string, list);
            }
            ArrayList<AsyncTx> txs = new ArrayList<AsyncTx>(seperateDatas.size());
            for (Map.Entry entry : seperateDatas.entrySet()) {
                AsyncTx asyncTx = new AsyncTx();
                asyncTx.setGroup("ar_invoice");
                asyncTx.setAction("IssueCallBack");
                asyncTx.setTask("IssueCallBack");
                asyncTx.setParam(entry.getValue());
                asyncTx.setXid((String)entry.getKey());
                asyncTx.setExecuteClass("kd.fi.ar.business.invoice.IssueInvoiceApiPlugin");
                txs.add(asyncTx);
            }
            AsyncTxService asyncTxService = new AsyncTxService();
            asyncTxService.save(txs.toArray(new AsyncTx[0]));
            ThreadPools.executeOnceIncludeRequestContext((String)"Invoice.Issue.CallBack", () -> {
                for (AsyncTx tx : txs) {
                    asyncTxService.executeWithTx(tx);
                }
            });
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(true);
            apiResult.setMessage("Issue Invoice Success");
            LogUtil.addInvokeLog((String)"IssueInvoiceService.issueInvoice", (Object[])new Object[]{param}, null, (boolean)true);
            String string = JSONObject.toJSONString((Object)apiResult);
            return string;
        }
        catch (Exception e) {
            txHandle.markRollback();
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(false);
            apiResult.setMessage("Issue Invoice Fail:" + e.getMessage());
            LogUtil.addInvokeErrorLog((String)"IssueInvoiceService.issueInvoice", (Object[])new Object[]{param}, (Throwable)e, (boolean)true);
            String string = JSONObject.toJSONString((Object)apiResult);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }
}

