/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.mservice.LiquidationSettleService;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class LiquidationAutoSettleService
extends AbsAutoSettleService {
    private final LiquidationSettleService settleService = new LiquidationSettleService();

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        this.batchAutoSettle(new DynamicObject[]{obj}, isMain);
    }

    public void batchAutoSettle(DynamicObject[] objArr, boolean isMain) throws KDBizException {
        if (isMain) {
            String billNo = objArr[0].getString("billno");
            throw new KDBizException(ResManager.loadKDString((String)"%s:\u5355\u636e\u5df2\u7ecf\u751f\u6210\u6e05\u7b97\u5355\uff0c\u4e0d\u80fd\u53d1\u8d77\u7ed3\u7b97\u3002", (String)"LiquidationAutoSettleService_0", (String)"fi-ar-mservice", (Object[])new Object[]{billNo}));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        DynamicObject[] mains = this.getMainObjs(objArr, scheme);
        this.addSettleLock(mains, objArr);
        this.settleService.settle(mains, objArr, scheme, SettleTypeEnum.AUTO.getValue());
    }

    protected void unSettle4Main(DynamicObject[] objs) {
    }

    private DynamicObject[] getMainObjs(DynamicObject[] assts, SettleSchemeVO scheme) {
        HashSet<Long> souBillIdSet = new HashSet<Long>(1);
        for (DynamicObject asst : assts) {
            DynamicObjectCollection entries = asst.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                long sourBillId = entry.getLong("sourcebillid");
                souBillIdSet.add(sourBillId);
            }
        }
        if (souBillIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", souBillIdSet)};
            DynamicObject[] mainBills = FinArBillHandleHelper.load((QFilter[])filter);
            scheme.setLiquidateSettle(true);
            scheme.setOnlyByBotp(true);
            return mainBills;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u6e05\u7b97\u5355\u4e0e\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u5173\u8054\u5173\u7cfb\u3002", (String)"LiquidationAutoSettleService_1", (String)"fi-ar-mservice", (Object[])new Object[0]));
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }
}

