/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.mservice.FinArBillDisposer;
import kd.fi.arapcommon.api.param.NoAssignSettleParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.settle.ISettleService;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.CasCancelUnSettleServiceHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.StdConfig;

public class RecBillListener {
    public static final Log logger = LogFactory.getLog(RecBillListener.class);

    @Deprecated
    public void execute(List<Map<String, Object>> param) {
        block4: {
            DynamicObject[] dynamicObjectArray;
            FinArBillDisposer disposer;
            HashSet<Object> billPks;
            Object operate;
            block3: {
                operate = param.get(0).get("operate");
                logger.info("PayBillListener-execute operate:" + operate);
                billPks = new HashSet<Object>(param.size());
                HashSet<DynamicObject> bills = new HashSet<DynamicObject>(param.size());
                for (Map<String, Object> map : param) {
                    logger.info("PayBillListener-execute targetpk:" + map.get("targetpk"));
                    billPks.add(map.get("targetpk"));
                    bills.add((DynamicObject)map.get("info"));
                }
                disposer = new FinArBillDisposer();
                if ((bills.size() == 0 || !"save".equals(operate)) && !"submit".equals(operate)) break block3;
                for (DynamicObject bill : bills) {
                    logger.info("PayBillListener-execute actpayamt:" + bill.get("actpayamt"));
                    disposer.dispose(bill, BillStatus.A);
                }
                break block4;
            }
            if (!"delete".equals(operate)) break block4;
            for (DynamicObject deBill : dynamicObjectArray = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"org,sourcebillid,entry,e_payableamt", (QFilter[])new QFilter[]{new QFilter("id", "in", billPks)})) {
                disposer.dispose4Delete(deBill);
            }
        }
    }

    public void rec(List<Long> recBillPks) {
        logger.info("RecBillListener rec recBillPks is \uff1a" + recBillPks);
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            String selectors = String.join((CharSequence)",", this.getSelector());
            DynamicObject[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", recBillPks)});
            Object[] needSettleRecBills = (DynamicObject[])Arrays.stream(recBills).filter(recBill -> recBill.getBoolean("receivingtype.ispartreceivable")).toArray(DynamicObject[]::new);
            logger.info("confirmRec needSettleRecBills length :" + needSettleRecBills.length);
            if (ObjectUtils.isEmpty((Object[])needSettleRecBills)) {
                return;
            }
            try {
                if (this.isBatchExecute()) {
                    logger.info("confirmRec-isBatchExecute:true");
                    this.recBatchExecute((DynamicObject[])needSettleRecBills);
                } else {
                    logger.info("confirmRec-isBatchExecute:false");
                    for (Object needSettleRecBill : needSettleRecBills) {
                        this.recExecute((DynamicObject)needSettleRecBill);
                    }
                }
                LogUtil.addInvokeLog((String)"RecBillListener_rec", (Object[])new Object[]{recBillPks}, null, (boolean)true);
            }
            catch (Throwable e) {
                tx.markRollback();
                logger.info("RecBillListener confirmRec exception:" + e);
                LogUtil.addInvokeLog((String)"RecBillListener_rec_error", (Object[])new Object[]{recBillPks}, (Object)e, (boolean)true);
                throw e;
            }
            logger.info("RecBillListener confirmRec end");
        }
    }

    private void recExecute(DynamicObject needSettleRecBills) {
        this.recBatchExecute(new DynamicObject[]{needSettleRecBills});
    }

    private void recBatchExecute(DynamicObject[] needSettleRecBills) {
        HashSet<Long> billIdSet = new HashSet<Long>(8);
        HashSet<Long> billEntryIdSet = new HashSet<Long>(8);
        for (DynamicObject needSettleRecBill : needSettleRecBills) {
            billIdSet.add(needSettleRecBill.getLong("id"));
            DynamicObjectCollection entryColl = needSettleRecBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                billEntryIdSet.add(entry.getLong("id"));
            }
        }
        Map upBillIdMap = BOTPHelper.loadNearUpBillIds((String)"cas_recbill", (String)"entry", (Long[])billIdSet.toArray(new Long[0]), (Long[])billEntryIdSet.toArray(new Long[0]), (String)"ar_finarbill");
        ArrayList<DynamicObject> coreBillSettleRecBills = new ArrayList<DynamicObject>(64);
        for (DynamicObject recBill : needSettleRecBills) {
            if (upBillIdMap.containsKey(recBill.getLong("id"))) continue;
            coreBillSettleRecBills.add(recBill);
        }
        if (!upBillIdMap.isEmpty()) {
            this.doArRecSettleByBotp(upBillIdMap);
        }
        if (!coreBillSettleRecBills.isEmpty()) {
            this.doArRecSettleByCoreBill(coreBillSettleRecBills);
        }
        JournalService journalService = new JournalService();
        journalService.pushAndSaveJournals(needSettleRecBills);
    }

    public void cancelRec(List<Long> recBillPks) {
        logger.info("RecBillListener cancelRec recBillPks is :" + recBillPks);
        try (TXHandle tx = TX.required();){
            try {
                if (this.isBatchExecute()) {
                    logger.info("cancelRec-isBatchExecute:true");
                    CasCancelUnSettleServiceHelper.cancelRec(recBillPks);
                    JournalService journalService = new JournalService();
                    journalService.deleteJournals("cas_recbill", recBillPks.toArray(new Long[0]));
                } else {
                    logger.info("cancelRec-isBatchExecute:false");
                    for (Long recBillPk : recBillPks) {
                        ArrayList<Long> recBillIds = new ArrayList<Long>(1);
                        recBillIds.add(recBillPk);
                        CasCancelUnSettleServiceHelper.cancelRec(recBillIds);
                        JournalService journalService = new JournalService();
                        journalService.deleteJournals("cas_recbill", recBillIds.toArray(new Long[0]));
                    }
                }
                this.invalidLiquidation(recBillPks);
                LogUtil.addInvokeLog((String)"RecBillListener_cancelRec", (Object[])new Object[]{recBillPks}, null, (boolean)true);
            }
            catch (Exception e) {
                logger.info("RecBillListener cancelRec exception:" + e);
                LogUtil.addInvokeLog((String)"RecBillListener_cancelRec_error", (Object[])new Object[]{recBillPks}, (Object)e, (boolean)true);
                tx.markRollback();
                throw e;
            }
            logger.info("RecBillListener cancelRec end");
        }
    }

    private void doArRecSettleByBotp(Map<Long, List<Long>> upBillIdMap) {
        logger.info("RecInvokeArECService_doArRecSettleByBotp:" + upBillIdMap.size());
        HashSet<Long> finArBillIds = new HashSet<Long>(64);
        for (Map.Entry<Long, List<Long>> entrySet : upBillIdMap.entrySet()) {
            finArBillIds.addAll((Collection<Long>)entrySet.getValue());
        }
        Map<Long, Set<Long>> idMap = this.groupByOrg(finArBillIds, "ar_finarbill");
        ISettleService settleService = ArApServiceAPIFactory.getSettleService((String)ServiceNameEnum.ARRECSETTLE.getValue());
        for (Map.Entry<Long, Set<Long>> mapEntry : idMap.entrySet()) {
            Long orgId = mapEntry.getKey();
            Set<Long> arBillIds = mapEntry.getValue();
            NoAssignSettleParam settleParam = new NoAssignSettleParam(orgId.longValue(), SettleTypeEnum.AUTO.getValue());
            settleParam.setMainBillIds(arBillIds);
            settleParam.setAsstBillIds(upBillIdMap.keySet());
            settleParam.setOnlyByBotp(true);
            settleParam.setLockWait(true);
            settleService.settle(settleParam);
        }
    }

    private void doArRecSettleByCoreBill(List<DynamicObject> coreBillSettleRecBills) {
        logger.info("RecInvokeArECService_doArRecSettleByBotp:" + coreBillSettleRecBills.size());
        Set<Long> finArBillIds = this.getFinArBillIdsByCoreBill(coreBillSettleRecBills.toArray(new DynamicObject[0]));
        if (!ObjectUtils.isEmpty(finArBillIds)) {
            Set recBillIds = coreBillSettleRecBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet());
            Map<Long, Set<Long>> groupByOrgMap = this.groupByOrg(finArBillIds, "ar_finarbill");
            if (groupByOrgMap.isEmpty()) {
                return;
            }
            ISettleService settleService = ArApServiceAPIFactory.getSettleService((String)ServiceNameEnum.ARRECSETTLE.getValue());
            for (Map.Entry<Long, Set<Long>> entrySet : groupByOrgMap.entrySet()) {
                Long orgId = entrySet.getKey();
                NoAssignSettleParam settleParam = new NoAssignSettleParam(orgId.longValue(), SettleTypeEnum.AUTO.getValue());
                settleParam.setMainBillIds(entrySet.getValue());
                settleParam.setAsstBillIds(recBillIds);
                settleParam.setOnlyByCoreBill(true);
                settleParam.setLockWait(true);
                settleService.settle(settleParam);
            }
        }
    }

    private Map<Long, Set<Long>> groupByOrg(Set<Long> billIdSet, String billEntity) {
        HashMap<Long, Set<Long>> idMap = new HashMap<Long, Set<Long>>(2);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"groupByOrg", (String)billEntity, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)}, (String)"");
        for (Row row : dataSet) {
            Long orgId = row.getLong("org");
            Long id = row.getLong("id");
            HashSet<Long> ids = (HashSet<Long>)idMap.get(orgId);
            if (ids == null) {
                ids = new HashSet<Long>(billIdSet.size());
            }
            ids.add(id);
            idMap.put(orgId, ids);
        }
        return idMap;
    }

    private Set<Long> getFinArBillIdsByCoreBill(DynamicObject[] recBills) {
        DataSet queryDataSet;
        HashSet<String> coreBillNos = new HashSet<String>(64);
        HashSet<String> coreBillNoIsArs = new HashSet<String>(64);
        HashSet<Long> settleOrgIds = new HashSet<Long>(64);
        for (DynamicObject recBill : recBills) {
            DynamicObjectCollection entry = recBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String coreBillNo = row.getString("e_corebillno");
                String coreBillType = row.getString("e_corebilltype");
                long settleOrgId = row.getLong("e_settleorg.id");
                if (ObjectUtils.isEmpty((Object)coreBillNo)) continue;
                if ("ar_finarbill".equals(coreBillType)) {
                    coreBillNoIsArs.add(coreBillNo);
                } else {
                    coreBillNos.add(coreBillNo);
                }
                if (settleOrgId == 0L) continue;
                settleOrgIds.add(settleOrgId);
            }
        }
        HashSet needSettleOrgIds = new HashSet(2);
        Map ar013Map = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, new ArrayList(settleOrgIds), (String)"ar_013");
        for (Map.Entry entrySet : ar013Map.entrySet()) {
            if (!((Boolean)entrySet.getValue()).booleanValue()) continue;
            needSettleOrgIds.add(entrySet.getKey());
        }
        HashSet<Long> finArBillIds = new HashSet<Long>(64);
        if (!coreBillNoIsArs.isEmpty()) {
            logger.info("PayBillListener-execute:coreBillNoIsArs is not null");
            QFilter billNoFilter = new QFilter("billno", "in", coreBillNoIsArs);
            billNoFilter.and(new QFilter("entry.e_unsettleamt", "<>", (Object)0));
            billNoFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            queryDataSet = QueryServiceHelper.queryDataSet((String)"query_finar_id_by_confirm", (String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{billNoFilter}, (String)"");
            for (DynamicObject row : queryDataSet) {
                finArBillIds.add(row.getLong("id"));
            }
        }
        if (!coreBillNos.isEmpty() && needSettleOrgIds.size() > 0) {
            logger.info("PayBillListener-execute:coreBillNos is not null");
            QFilter coreBillNoFilter = new QFilter("entry.e_corebillno", "in", coreBillNos);
            coreBillNoFilter.and(new QFilter("entry.e_unsettleamt", "<>", (Object)0));
            coreBillNoFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            coreBillNoFilter.and(new QFilter("org", "in", needSettleOrgIds));
            queryDataSet = QueryServiceHelper.queryDataSet((String)"query_finar_id_by_corebill", (String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{coreBillNoFilter}, (String)"");
            for (DynamicObject row : queryDataSet) {
                finArBillIds.add(row.getLong("id"));
            }
        }
        return finArBillIds;
    }

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(50);
        lst.add("billno");
        lst.add("biztype");
        lst.add("bizdate");
        lst.add("billstatus");
        lst.add("txt_description");
        lst.add("receivingtype");
        lst.add("payertype");
        lst.add("org");
        lst.add("accountbank");
        lst.add("accountcash");
        lst.add("payeebank");
        lst.add("payer");
        lst.add("payerformid");
        lst.add("payeracctbank");
        lst.add("payeraccformid");
        lst.add("payername");
        lst.add("payeracctbanknum");
        lst.add("payerbankname");
        lst.add("f7_payerbank");
        lst.add("cashier");
        lst.add("payeedate");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("isagent");
        lst.add("accountcash");
        lst.add("actrecamt");
        lst.add("currency");
        lst.add("quotation");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("bankcheckflag");
        lst.add("entry");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("realreccompany");
        lst.add("e_receivableamt");
        lst.add("e_sourcebillentryid");
        lst.add("e_unsettledamt");
        lst.add("e_settledamt");
        lst.add("e_material");
        lst.add("e_expenseitem");
        lst.add("e_corebilltype");
        lst.add("e_corebillno");
        lst.add("e_corebillentryseq");
        lst.add("e_settleorg");
        lst.add("basecurrency");
        lst.add("e_receivingtype");
        List keys = SettleExtDataLoader.loadSettleRecordExtListKeys((String)"cas_recbill");
        keys.forEach(v -> lst.add(v.getBillKey()));
        return lst;
    }

    private boolean isBatchExecute() {
        String isBatchExecutePayOrRec = StdConfig.get((String)"isBatchExecutePayOrRec");
        return isBatchExecutePayOrRec == null || "true".equals(isBatchExecutePayOrRec);
    }

    private void invalidLiquidation(List<Long> paymentBillPks) {
        OperationResult result;
        QFilter filter = new QFilter("entryentity.sourcebillid", "in", paymentBillPks);
        filter.and(new QFilter("billstatus", "!=", (Object)"D"));
        DynamicObjectCollection liquidationbills = QueryServiceHelper.query((String)"ar_liquidation", (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
        if (liquidationbills.size() == 0) {
            return;
        }
        HashSet<Long> liquidationIds4Audit = new HashSet<Long>(liquidationbills.size());
        HashSet<Long> liquidationIds4submit = new HashSet<Long>(liquidationbills.size());
        for (DynamicObject liquidationbill : liquidationbills) {
            String billstatus = liquidationbill.getString("billstatus");
            long billId = liquidationbill.getLong("id");
            if ("C".equals(billstatus)) {
                liquidationIds4Audit.add(billId);
            }
            if (!"B".equals(billstatus)) continue;
            liquidationIds4submit.add(billId);
        }
        if (liquidationIds4Audit.size() > 0) {
            result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_liquidation", (Object[])liquidationIds4Audit.toArray(), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)result);
            liquidationIds4submit.addAll(result.getSuccessPkIds());
        }
        if (liquidationIds4submit.size() > 0) {
            result = OperationServiceHelper.executeOperate((String)"invalid", (String)"ar_liquidation", (Object[])liquidationIds4submit.toArray(), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)result);
        }
    }
}

