/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.writeback.bill.DisposerInfo;
import kd.fi.arapcommon.service.writeback.bill.FinArLockWBServiceHelper;

public class RecBillWriteBackLockAmtService {
    private static final Log logger = LogFactory.getLog(RecBillWriteBackLockAmtService.class);

    public void disposeLockAmt(List<Map<String, Object>> params) {
        logger.info("RecBillWriteBackLockAmtService disposeLockAmt start ");
        if (ObjectUtils.isEmpty(params)) {
            return;
        }
        logger.info("RecBillWriteBackLockAmtService params is : " + params);
        try (TXHandle tx = TX.required((String)"RecBillWriteBackLockAmtService");){
            try {
                String opType = (String)params.get(0).get("opType");
                boolean isRelease = this.isRelease(opType);
                HashMap<Long, List> srcWriteBackFinArMap = new HashMap<Long, List>(64);
                HashSet<Long> finArBillIds = new HashSet<Long>(64);
                for (Map<String, Object> param : params) {
                    Object entityName = param.get("entityName");
                    long sourceId = Long.parseLong(String.valueOf(param.get("sourceId")));
                    long sourceEntryId = Long.parseLong(String.valueOf(param.get("sourceEntryId")));
                    long tarRowId = Long.parseLong(String.valueOf(param.get("tarRowId")));
                    BigDecimal disposeAmt = (BigDecimal)param.get("disposeAmt");
                    if (isRelease) {
                        disposeAmt = disposeAmt.negate();
                    }
                    if (!"ar_finarbill".equals(entityName)) continue;
                    DisposerInfo info = new DisposerInfo(Long.valueOf(sourceId), Long.valueOf(sourceEntryId), disposeAmt);
                    List disposerInfos = srcWriteBackFinArMap.getOrDefault(tarRowId, new ArrayList(8));
                    disposerInfos.add(info);
                    srcWriteBackFinArMap.put(tarRowId, disposerInfos);
                    finArBillIds.add(sourceId);
                }
                Map writeBackFinArMap = ArApHelper.processWriteBackMap(srcWriteBackFinArMap);
                if (!writeBackFinArMap.isEmpty()) {
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX(finArBillIds, (String)"ar_finarbill", (boolean)false);
                    if (isRelease) {
                        FinArLockWBServiceHelper.inverseWriteBack(finArBillIds, (Map)writeBackFinArMap);
                    } else {
                        FinArLockWBServiceHelper.directWriteBack(finArBillIds, (Map)writeBackFinArMap);
                    }
                }
            }
            catch (Exception e1) {
                tx.markRollback();
                throw e1;
            }
        }
        logger.info("RecBillWriteBackLockAmtService disposeLockAmt end ");
    }

    private boolean isRelease(String opType) {
        return "delete".equalsIgnoreCase(opType) || "invalid".equalsIgnoreCase(opType);
    }
}

