/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.mservice.RecClearingSettleService;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class RecClearingAutoSettleService
extends AbsAutoSettleService {
    private final RecClearingSettleService settleService = new RecClearingSettleService();

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        this.batchAutoSettle(new DynamicObject[]{obj}, isMain);
    }

    public void batchAutoSettle(DynamicObject[] objArr, boolean isMain) throws KDBizException {
        if (isMain) {
            String billNo = objArr[0].getString("billno");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s:\u5355\u636e\u5df2\u7ecf\u751f\u6210\u6e05\u7b97\u5355\uff0c\u4e0d\u80fd\u53d1\u8d77\u7ed3\u7b97\u3002", (String)"RecClearingAutoSettleService_0", (String)"fi-ar-mservice", (Object[])new Object[0]), billNo));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        DynamicObject[] mains = this.getMainObjs(objArr, scheme);
        this.addSettleLock(mains, objArr);
        this.settleService.settle(mains, objArr, scheme, SettleTypeEnum.AUTO.getValue());
    }

    private DynamicObject[] getMainObjs(DynamicObject[] assts, SettleSchemeVO scheme) {
        HashSet<Long> recIdSet = new HashSet<Long>(1);
        HashSet<Long> recedIdSet = new HashSet<Long>(1);
        for (DynamicObject asst : assts) {
            long sourBillId;
            String sourcebilltype = asst.getString("sourcebilltype");
            DynamicObjectCollection entries = asst.getDynamicObjectCollection("entryentity");
            if ("cas_recbill".equals(sourcebilltype)) {
                for (DynamicObject entry : entries) {
                    sourBillId = entry.getLong("sourcebillid");
                    recIdSet.add(sourBillId);
                }
            }
            if (!"ar_receivedbill".equals(sourcebilltype)) continue;
            for (DynamicObject entry : entries) {
                sourBillId = entry.getLong("sourcebillid");
                recedIdSet.add(sourBillId);
            }
        }
        Object[] recArr = new DynamicObject[]{};
        if (recIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", recIdSet)};
            recArr = RecBillHandlerHelper.loadRec((QFilter[])filter);
        }
        Object[] recedArr = new DynamicObject[]{};
        if (recedIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", recedIdSet)};
            recedArr = RecBillHandlerHelper.loadReced((QFilter[])filter);
        }
        DynamicObject[] mainBills = (DynamicObject[])ArrayUtils.addAll((Object[])recArr, (Object[])recedArr);
        scheme.setLiquidateSettle(true);
        scheme.setOnlyByBotp(true);
        if (mainBills.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u6e05\u7b97\u5355\u4e0e\u6536\u6b3e\u5355\u6216\u671f\u521d\u9884\u6536\u5355\u7684\u5173\u8054\u5173\u7cfb\u3002", (String)"RecClearingAutoSettleService_1", (String)"fi-ar-mservice", (Object[])new Object[0]));
        }
        return mainBills;
    }

    protected void unSettle4Main(DynamicObject[] objs) {
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }
}

