/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.ar.mservice.RecPaySettleService;
import kd.fi.ar.mservice.RecSelfSettleService;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.ManualSettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class RecPayManualSettleService
implements IManualSettleService {
    protected static final String RECBILL = "cas_recbill";
    private static final String ASST_PAYBILL = "cas_paybill";
    private RecPaySettleService service;

    public RecPayManualSettleService() {
        this.service = new RecPaySettleService();
    }

    public RecPayManualSettleService(RecPaySettleService service) {
        this.service = service;
    }

    public void manualSettle(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualSettleParam manualParam) throws KDBizException {
        HashSet<Long> recBillIdSet = new HashSet<Long>();
        HashSet<Long> recEntryIdSet = new HashSet<Long>();
        HashSet<Long> recedBillIdSet = new HashSet<Long>();
        HashSet<Long> recedEntryIdSet = new HashSet<Long>();
        for (DynamicObject main : mainRows) {
            DynamicObject[] entityName = main.getString("billtype");
            if (RECBILL.equals(entityName)) {
                recBillIdSet.add(main.getLong("id"));
                recEntryIdSet.add(main.getLong("entryid"));
                continue;
            }
            recedBillIdSet.add(main.getLong("id"));
            recedEntryIdSet.add(main.getLong("entryid"));
        }
        HashSet<Long> payBillIdSet = new HashSet<Long>();
        HashSet<Long> payEntryIdSet = new HashSet<Long>();
        HashSet<Long> paidBillIdSet = new HashSet<Long>();
        HashSet<Long> paidEntryIdSet = new HashSet<Long>();
        for (DynamicObject asst : asstRows) {
            String entityName = asst.getString("asst_billtype");
            if (ASST_PAYBILL.equals(entityName)) {
                payBillIdSet.add(asst.getLong("asst_id"));
                payEntryIdSet.add(asst.getLong("asst_entryid"));
                continue;
            }
            paidBillIdSet.add(asst.getLong("asst_id"));
            paidEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setDiffCurrencySettle(manualParam.isDiffCurrencySettle());
        scheme.setSettleDate(manualParam.getSettleDate());
        Object[] recArr = this.reloadRecArr(recBillIdSet);
        Object[] recedArr = this.reloadRecedArr(recedBillIdSet);
        Object[] payArr = this.reloadPayArr(payBillIdSet);
        Object[] paidArr = this.reloadPaidArr(paidBillIdSet);
        DynamicObject[] recMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])recArr, (Object[])recedArr);
        DynamicObject[] payMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])payArr, (Object[])paidArr);
        List mainListVO = RecBillHandlerHelper.getMainListVO((DynamicObject[])recMergeArr);
        List asstListVO = PayBillHandleHelper.getAsstListVO((DynamicObject[])payMergeArr);
        if (manualParam.isSingleSettle()) {
            scheme.setSettleSelf(true);
            this.settleSelfFirst(mainListVO, asstListVO, scheme);
            return;
        }
        if ((manualParam.isSettleSelfFirst() || manualParam.isTotal()) && !manualParam.isDiffCurrencySettle()) {
            scheme.setSettleSelf(true);
            this.settleSelfFirst(mainListVO, asstListVO, scheme);
            recArr = this.reloadRecArr(recBillIdSet);
            recedArr = this.reloadRecedArr(recedBillIdSet);
            payArr = this.reloadPayArr(payBillIdSet);
            paidArr = this.reloadPaidArr(paidBillIdSet);
        }
        this.processRec((DynamicObject[])recArr, mainRows, recEntryIdSet, manualParam);
        this.processRec((DynamicObject[])recedArr, mainRows, recedEntryIdSet, manualParam);
        this.processAsst((DynamicObject[])payArr, asstRows, payEntryIdSet, manualParam);
        this.processAsst((DynamicObject[])paidArr, asstRows, paidEntryIdSet, manualParam);
        recMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])recArr, (Object[])recedArr);
        payMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])payArr, (Object[])paidArr);
        mainListVO = RecBillHandlerHelper.getMainListVO((DynamicObject[])recMergeArr);
        asstListVO = PayBillHandleHelper.getAsstListVO((DynamicObject[])payMergeArr);
        this.service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.MANUAL.getValue());
    }

    protected void processRec(DynamicObject[] recArr, DynamicObject[] rows, Set<Long> entryIdSet, ManualSettleParam param) {
        if (param.isTotal()) {
            for (DynamicObject row : rows) {
                BigDecimal curSettleAmt = row.getBigDecimal("cursettleamt");
                long id = row.getLong("id");
                for (DynamicObject obj : recArr) {
                    if (id != obj.getLong("id")) continue;
                    obj.set("exchangerate", (Object)row.getBigDecimal("exchangerate"));
                    DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (entryUnSettleAmt.compareTo(BigDecimal.ZERO) < 0) continue;
                        if (RECBILL.equals(obj.getDataEntityType().getName()) && (!param.getOrgPk().equals(entry.get("e_settleorg.id")) || ObjectUtils.isEmpty((Object)entry.getDynamicObject("e_receivingtype")) || !entry.getDynamicObject("e_receivingtype").getBoolean("ispartreceivable"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject obj : recArr) {
                long id = obj.getLong("id");
                DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (entryIdSet.contains(entryId)) {
                        for (DynamicObject row : rows) {
                            if (id != row.getLong("id") || entryId != row.getLong("entryid")) continue;
                            obj.set("exchangerate", (Object)row.getBigDecimal("exchangerate"));
                            BigDecimal curSettleAmt = row.getBigDecimal("cursettleamt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set("e_unsettledamt", (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    private void processAsst(DynamicObject[] asstArr, DynamicObject[] asstRows, Set<Long> asstEntryIdSet, ManualSettleParam param) {
        if (param.isTotal()) {
            for (DynamicObject asst : asstRows) {
                BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                long id = asst.getLong("asst_id");
                for (DynamicObject asstObj : asstArr) {
                    if (id != asstObj.getLong("id")) continue;
                    asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                    DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (ASST_PAYBILL.equals(asstObj.getDataEntityType().getName()) && (!param.getOrgPk().equals(entry.get("settleorg.id")) || ObjectUtils.isEmpty((Object)entry.getDynamicObject("e_paymenttype")) || !entry.getDynamicObject("e_paymenttype").getBoolean("ispartpayment"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject asstObj : asstArr) {
                long id = asstObj.getLong("id");
                DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (asstEntryIdSet.contains(entryId)) {
                        for (DynamicObject asst : asstRows) {
                            if (id != asst.getLong("asst_id") || entryId != asst.getLong("asst_entryid")) continue;
                            asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                            BigDecimal curSettleAmt = asst.getBigDecimal("asst_curSettleAmt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set("e_unsettledamt", (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    private void settleSelfFirst(List<BillSettleVO> mainListVO, List<BillSettleVO> asstListVO, SettleSchemeVO scheme) {
        List mainPositiveList = this.getPositiveList(mainListVO);
        List mainNegativeList = this.getNegativeList(mainListVO);
        if (mainPositiveList.size() > 0 && mainNegativeList.size() > 0) {
            RecSelfSettleService apSelfService = new RecSelfSettleService();
            apSelfService.settleByVO(mainPositiveList, mainNegativeList, scheme, SettleTypeEnum.MANUAL.getValue());
        }
        List asstPositiveList = this.getPositiveList(asstListVO);
        List asstNegativeList = this.getNegativeList(asstListVO);
        if (asstPositiveList.size() > 0 && asstNegativeList.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"payself", (String)"settleByVO", (Object[])new Object[]{asstPositiveList, asstNegativeList, scheme, SettleTypeEnum.MANUAL.getValue()});
        }
        scheme.setSettleSelf(false);
    }
}

