/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.fi.ar.mservice.RecPayManualSettleService;
import kd.fi.ar.mservice.RecSelfSettleService;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class RecSelfManualSettleService
extends RecPayManualSettleService {
    protected RecSelfSettleService selfService = new RecSelfSettleService();

    @Override
    public void manualSettle(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualSettleParam manualParam) throws KDBizException {
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainRecedIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject dynamicObject : mainRows) {
            String entityName = dynamicObject.getString("billtype");
            if ("cas_recbill".equals(entityName)) {
                mainBillIdSet.add(dynamicObject.getLong("id"));
            } else {
                mainRecedIdSet.add(dynamicObject.getLong("id"));
            }
            mainEntryIdSet.add(dynamicObject.getLong("entryid"));
        }
        HashSet<Long> asstBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> asstEntryIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> asstRecedIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            String entityName = asst.getString("asst_billtype");
            if ("cas_recbill".equals(entityName)) {
                asstBillIdSet.add(asst.getLong("asst_id"));
            } else {
                asstRecedIdSet.add(asst.getLong("asst_id"));
            }
            asstEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        SettleSchemeVO settleSchemeVO = new SettleSchemeVO();
        settleSchemeVO.setSettle(true);
        settleSchemeVO.setManual(true);
        settleSchemeVO.setDiffCurrencySettle(manualParam.isDiffCurrencySettle());
        settleSchemeVO.setSettleEntryParam(manualParam.getSettleEntryParam());
        settleSchemeVO.setSettleDate(manualParam.getSettleDate());
        Object[] mainArr = this.reloadRecArr(mainBillIdSet);
        Object[] mainRecedArr = this.reloadRecedArr(mainRecedIdSet);
        Object[] asstArr = this.reloadRecArr(asstBillIdSet);
        Object[] asstRecedArr = this.reloadRecedArr(asstRecedIdSet);
        DynamicObject[] mainMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])mainArr, (Object[])mainRecedArr);
        DynamicObject[] asstMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])asstArr, (Object[])asstRecedArr);
        this.processRec(mainMergeArr, mainRows, mainEntryIdSet, manualParam);
        this.processAsst(asstMergeArr, asstRows, asstEntryIdSet, manualParam);
        List mainListVO = RecBillHandlerHelper.getMainListVO((DynamicObject[])mainMergeArr);
        List asstListVO = RecBillHandlerHelper.getAsstListVO((DynamicObject[])asstMergeArr);
        mainListVO = mainListVO.stream().filter(mainVo -> mainVo.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        asstListVO = asstListVO.stream().filter(asstVo -> asstVo.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) < 0).collect(Collectors.toList());
        this.selfService.settleByVO(mainListVO, asstListVO, settleSchemeVO, SettleTypeEnum.MANUAL.getValue());
    }

    protected void processAsst(DynamicObject[] asstArr, DynamicObject[] asstRows, Set<Long> asstEntryIdSet, ManualSettleParam param) {
        if (param.isTotal()) {
            for (DynamicObject asst : asstRows) {
                BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                long id = asst.getLong("asst_id");
                for (DynamicObject asstObj : asstArr) {
                    if (id != asstObj.getLong("id")) continue;
                    asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                    DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (entryUnSettleAmt.compareTo(BigDecimal.ZERO) > 0) continue;
                        if ("cas_recbill".equals(asstObj.getDataEntityType().getName()) && (!param.getOrgPk().equals(entry.get("e_settleorg.id")) || ObjectUtils.isEmpty((Object)entry.getDynamicObject("e_receivingtype")) || !entry.getDynamicObject("e_receivingtype").getBoolean("ispartreceivable"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject asstObj : asstArr) {
                long id = asstObj.getLong("id");
                DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (asstEntryIdSet.contains(entryId)) {
                        for (DynamicObject asst : asstRows) {
                            if (id != asst.getLong("asst_id") || entryId != asst.getLong("asst_entryid")) continue;
                            asstObj.set("exchangerate", (Object)asst.getBigDecimal("asst_exchangerate"));
                            BigDecimal curSettleAmt = asst.getBigDecimal("asst_cursettleamt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set("e_unsettledamt", (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }
}

