/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.ar.consts.ArFinBillModel;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.ar.writeback.PlanEntryDisposer;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApTransferHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

@KSObject
public class RecTransferService {
    private String ruleId = "930297555022016512";
    private boolean isPlanSettle;
    private Map<Long, DynamicObject> finArEntryMap = new HashMap<Long, DynamicObject>(32);
    private final Map<Long, Boolean> srcBillIdToSettleVersion = new HashMap<Long, Boolean>(8);

    @KSMethod
    public DynamicObject transferSummly(DynamicObject transferInfo) {
        this.initTransferArgs(transferInfo);
        DynamicObjectCollection transferDetailEntry = transferInfo.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection transferPlanEntry = transferInfo.getDynamicObjectCollection("planentity");
        DynamicObject transferBill = this.transfer(transferInfo, (List<DynamicObject>)transferDetailEntry, (List<DynamicObject>)transferPlanEntry, Boolean.TRUE);
        if (this.isPlanSettle) {
            this.reSetSplitDimensionId(transferBill);
            this.reSetPlanEntryLocalAmt(transferBill);
        }
        return transferBill;
    }

    @KSMethod
    public List<DynamicObject> transferDispersedly(DynamicObject transferInfo) {
        this.initTransferArgs(transferInfo);
        DynamicObjectCollection entry = transferInfo.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection planEntry = transferInfo.getDynamicObjectCollection("planentity");
        Map<Long, List<DynamicObject>> groupByDetailEntry = entry.stream().collect(Collectors.groupingBy(row -> row.getLong("e_srcfinbillid")));
        Map<Long, List<DynamicObject>> groupByPlanEntry = planEntry.stream().collect(Collectors.groupingBy(row -> row.getLong("p_billid")));
        ArrayList<DynamicObject> finBills = new ArrayList<DynamicObject>(64);
        for (Map.Entry<Long, List<DynamicObject>> entrySet : groupByDetailEntry.entrySet()) {
            Long srcBillId = entrySet.getKey();
            DynamicObject transferBill = this.transfer(transferInfo, entrySet.getValue(), groupByPlanEntry.get(srcBillId), Boolean.FALSE);
            if (this.isPlanSettle) {
                this.reSetSplitDimensionId(transferBill);
                this.reSetPlanEntryLocalAmt(transferBill);
            }
            finBills.add(transferBill);
        }
        return finBills;
    }

    private DynamicObject transfer(DynamicObject transferInfo, List<DynamicObject> transferDetailEntry, List<DynamicObject> transferPlanEntry, Boolean isSummly) {
        DynamicObject finBill = null;
        HashSet<Long> srcIds = new HashSet<Long>();
        if (Boolean.TRUE.equals(isSummly)) {
            DynamicObjectCollection transferEntry = transferInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject transferRow : transferEntry) {
                long srcbillId = transferRow.getLong("e_srcfinbillid");
                srcIds.add(srcbillId);
            }
        } else if (this.isPlanSettle) {
            srcIds.add(transferPlanEntry.get(0).getLong("p_billid"));
        } else {
            srcIds.add(transferDetailEntry.get(0).getLong("e_srcfinbillid"));
        }
        List tarBills = BOTPHelper.push((String)"ar_finarbill", (String)"ar_finarbill", (String)this.ruleId, new ArrayList(srcIds));
        Map extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"ar_transferofcredit");
        finBill = (DynamicObject)tarBills.get(0);
        this.createFinBill(finBill, transferInfo, extendFieldMap);
        DynamicObjectCollection detailCollection = new DynamicObjectCollection();
        for (DynamicObject transferDetailRow : transferDetailEntry) {
            this.addDetailNewEntryRow(finBill, transferDetailRow, detailCollection, extendFieldMap);
        }
        finBill.set("entry", (Object)detailCollection);
        this.calculate(finBill);
        if (this.isPlanSettle) {
            DynamicObjectCollection planCollection = new DynamicObjectCollection();
            for (DynamicObject transferPlan : transferPlanEntry) {
                this.addPlanNewEntryRow(finBill, transferPlan, planCollection, extendFieldMap);
            }
            finBill.set("planentity", (Object)planCollection);
        } else {
            this.addPlanEntry(finBill);
        }
        this.setHeadDueDate(finBill);
        this.cutSourceInfoLength(finBill);
        return finBill;
    }

    private void setHeadDueDate(DynamicObject finArBill) {
        Date planMaxDuedate = finArBill.getDate("duedate");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finArBill.set("duedate", (Object)planMaxDuedate);
    }

    private void calculate(DynamicObject finBill) {
        BigDecimal amount;
        FinArBillHelper.setCustomersToBill((DynamicObject)finBill);
        BigDecimal exchangeRate = finBill.getBigDecimal("exchangerate");
        String quotation = finBill.getString("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        DynamicObject basecurrency = finBill.getDynamicObject("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        BigDecimal sumRecAmount = BigDecimal.ZERO;
        BigDecimal sumTax = BigDecimal.ZERO;
        BigDecimal sumUninvoicedamt = BigDecimal.ZERO;
        DynamicObjectCollection entry = finBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            BigDecimal rowRecAmount = row.getBigDecimal("e_recamount");
            sumRecAmount = sumRecAmount.add(rowRecAmount);
            sumTax = sumTax.add(row.getBigDecimal("e_tax"));
            sumUninvoicedamt = sumUninvoicedamt.add(row.getBigDecimal("e_uninvoicedamt"));
            for (int i = 0; i < ArFinBillModel.getAllEntryAmt().length; ++i) {
                amount = row.getBigDecimal(ArFinBillModel.getAllEntryAmt()[i]);
                if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                if ("0".equals(quotation)) {
                    row.set(ArFinBillModel.getAllEntryLocalAmt()[i], (Object)amount.multiply(exchangeRate).setScale(localprecision, RoundingMode.HALF_UP));
                    continue;
                }
                row.set(ArFinBillModel.getAllEntryLocalAmt()[i], (Object)amount.divide(exchangeRate, localprecision, RoundingMode.HALF_UP));
            }
            BigDecimal e_taxlocalamt = row.getBigDecimal("e_reclocalamt").subtract(row.getBigDecimal("e_localamt"));
            row.set("e_taxlocalamt", (Object)e_taxlocalamt);
        }
        finBill.set("uninvoicedamt", (Object)sumUninvoicedamt);
        finBill.set("recamount", (Object)sumRecAmount);
        finBill.set("amount", (Object)sumRecAmount.subtract(sumTax));
        finBill.set("tax", (Object)sumTax);
        finBill.set("unverifyamount", (Object)BigDecimal.ZERO);
        finBill.set("unsettleamount", (Object)sumRecAmount);
        HashMap<String, String> map = new HashMap<String, String>(4);
        for (int i = 0; i < ArFinBillModel.getAllHeadAmt().length; ++i) {
            map.put(ArFinBillModel.getHeadFormEntryLocAmt()[i], ArFinBillModel.getAllHeadLocalAmt()[i]);
        }
        Iterator iterator = map.entrySet().iterator();
        int count = entry.size();
        while (iterator.hasNext()) {
            Map.Entry mapping = iterator.next();
            amount = BigDecimal.ZERO;
            for (int i = 0; i < count; ++i) {
                amount = amount.add(((DynamicObject)entry.get(i)).getBigDecimal((String)mapping.getKey()));
            }
            finBill.set((String)mapping.getValue(), (Object)amount);
        }
    }

    private void cutSourceInfoLength(DynamicObject finBill) {
        String sourcebillno;
        String sourcebillid = finBill.getString("sourcebillid");
        if (sourcebillid.length() > 255) {
            sourcebillid = sourcebillid.substring(0, 252) + "...";
            finBill.set("sourcebillid", (Object)sourcebillid);
        }
        if ((sourcebillno = finBill.getString("sourcebillno")).length() > 255) {
            sourcebillno = sourcebillno.substring(0, 252) + "...";
            finBill.set("sourcebillno", (Object)sourcebillno);
        }
    }

    private void createFinBill(DynamicObject newFinBill, DynamicObject transferInfo, Map<String, Set<String>> extendFieldMap) {
        String sourcebillno;
        newFinBill.set("billtype", (Object)transferInfo.getDynamicObject("billtype"));
        newFinBill.set("asstacttype", (Object)transferInfo.getString("asstacttype"));
        newFinBill.set("asstact", (Object)transferInfo.getDynamicObject("asstact"));
        newFinBill.set("bizdate", (Object)transferInfo.getDate("bizdate"));
        newFinBill.set("duedate", (Object)transferInfo.getDate("duedate"));
        newFinBill.set("remark", (Object)transferInfo.getString("remark"));
        if (!ObjectUtils.isEmpty((Object)transferInfo.get("paycond"))) {
            newFinBill.set("paycond", transferInfo.get("paycond"));
        }
        if (!ObjectUtils.isEmpty((Object)transferInfo.get("settlementtype"))) {
            newFinBill.set("settlementtype", transferInfo.get("settlementtype"));
        }
        newFinBill.set("exratetable", transferInfo.get("exratetable"));
        newFinBill.set("exratedate", transferInfo.get("exratedate"));
        newFinBill.set("quotation", (Object)transferInfo.getString("quotation"));
        newFinBill.set("exchangerate", (Object)transferInfo.getString("head_exchangerate"));
        DynamicObject org = transferInfo.getDynamicObject("org");
        newFinBill.set("isperiod", (Object)Boolean.FALSE);
        newFinBill.set("istransfer", (Object)Boolean.TRUE);
        newFinBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        newFinBill.set("createtime", (Object)new Date());
        newFinBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newFinBill.set("modifytime", (Object)new Date());
        String number = CodeRuleServiceHelper.getNumber((String)"ar_finarbill", (DynamicObject)newFinBill, (String)org.getString("id"));
        newFinBill.set("billno", (Object)number);
        newFinBill.set("acctagecalcdate", (Object)transferInfo.getDate("bizdate"));
        String sourcebillid = newFinBill.getString("sourcebillid");
        if (sourcebillid.length() > 255) {
            sourcebillid = sourcebillid.substring(0, 252) + "...";
            newFinBill.set("sourcebillid", (Object)sourcebillid);
        }
        if ((sourcebillno = newFinBill.getString("sourcebillno")).length() > 255) {
            sourcebillno = sourcebillno.substring(0, 252) + "...";
            newFinBill.set("sourcebillno", (Object)sourcebillno);
        }
        for (String headExtendField : extendFieldMap.get("head")) {
            Object headExtendFieldValue = transferInfo.get(headExtendField);
            if (headExtendFieldValue == null) continue;
            newFinBill.set(headExtendField, headExtendFieldValue);
        }
    }

    private void addDetailNewEntryRow(DynamicObject newFinBill, DynamicObject transferEntryRow, DynamicObjectCollection dynamicObjectCollection, Map<String, Set<String>> extendFieldMap) {
        DynamicObject taxrate;
        DynamicObject transferBillNewEntryRow = null;
        DynamicObjectCollection newFinBillEntry = newFinBill.getDynamicObjectCollection("entry");
        if (this.isPlanSettle) {
            transferBillNewEntryRow = newFinBillEntry.addNew();
            Long srcEntryId = transferEntryRow.getLong("e_srcentryid");
            DynamicObject srcDetail = this.finArEntryMap.get(srcEntryId);
            if (srcDetail == null) {
                return;
            }
            Set<String> carryFieldByPlan = this.getCarryFieldByPlan();
            for (String fieldName : carryFieldByPlan) {
                transferBillNewEntryRow.set(fieldName, srcDetail.get(fieldName));
            }
            transferBillNewEntryRow.set("e_baseunitqty", (Object)srcDetail.getBigDecimal("e_quantity").multiply(srcDetail.getBigDecimal("e_unitcoefficient")));
            transferBillNewEntryRow.set("e_srcid", (Object)transferEntryRow.getLong("e_srcfinbillid"));
            transferBillNewEntryRow.set("e_srcentryid", (Object)srcEntryId);
            transferBillNewEntryRow.set("e_splitdimensionid", (Object)transferEntryRow.getInt("e_splitdimensionid"));
        } else {
            for (DynamicObject transferDetailRow : newFinBillEntry) {
                long sBillEntryId;
                DynamicObjectCollection entryLk = transferDetailRow.getDynamicObjectCollection("entry_lk");
                if (entryLk.isEmpty() || (sBillEntryId = ((DynamicObject)entryLk.get(0)).getLong("entry_lk_sid")) != transferEntryRow.getLong("e_srcentryid")) continue;
                transferBillNewEntryRow = transferDetailRow;
                break;
            }
        }
        if (transferBillNewEntryRow == null) {
            return;
        }
        BigDecimal quantity = transferEntryRow.getBigDecimal("e_quantity");
        BigDecimal transferAmount = transferEntryRow.getBigDecimal("e_transrecamount");
        String srcId = newFinBill.getString("sourcebillid");
        String rowSrcId = transferEntryRow.getString("e_srcfinbillid");
        String srcNo = newFinBill.getString("sourcebillno");
        String rowsrcNo = transferEntryRow.getString("e_billno");
        if (StringUtils.isEmpty((String)srcId)) {
            srcId = rowSrcId;
        } else if (!srcId.contains(rowSrcId)) {
            srcId = srcId + "," + rowSrcId;
        }
        if (StringUtils.isEmpty((String)srcNo)) {
            srcNo = rowsrcNo;
        } else if (!srcNo.contains(rowsrcNo)) {
            srcNo = srcNo + "," + rowsrcNo;
        }
        ArApHelper.setFieldValue((DynamicObject)newFinBill, (String)"sourcebillid", (Object)srcId);
        ArApHelper.setFieldValue((DynamicObject)newFinBill, (String)"sourcebillno", (Object)srcNo);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_srcid", (Object)rowSrcId);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_srcentryid", (Object)transferEntryRow.getLong("e_srcentryid"));
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_quantity", (Object)quantity);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_uninvoicedqty", (Object)quantity);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unconfirmqty", (Object)quantity);
        if (quantity == null) {
            quantity = BigDecimal.ZERO;
        }
        if (!ObjectUtils.isEmpty((Object)(taxrate = transferEntryRow.getDynamicObject("taxrateid")))) {
            taxrate = BusinessDataServiceHelper.loadSingleFromCache((Object)taxrate.getPkValue(), (String)taxrate.getDynamicObjectType().getName(), (String)"taxrate");
            ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_taxrate", (Object)taxrate.get("taxrate"));
            transferBillNewEntryRow.set("taxrateid", (Object)taxrate);
        }
        BigDecimal covertRate = transferBillNewEntryRow.getBigDecimal("e_unitcoefficient");
        DynamicObject material = transferBillNewEntryRow.getDynamicObject("e_material");
        DynamicObject measureUnit = transferBillNewEntryRow.getDynamicObject("e_measureunit");
        DynamicObject baseUnit = null;
        if (!ObjectUtils.isEmpty((Object)material)) {
            baseUnit = material.getDynamicObject("baseunit");
            transferBillNewEntryRow.set("e_baseunit", (Object)baseUnit);
            if (measureUnit == null) {
                measureUnit = baseUnit;
            }
            if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                covertRate = UnitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)measureUnit.getLong("id"), (Long)baseUnit.getLong("id"));
                covertRate = covertRate == null ? BigDecimal.ONE : covertRate;
            }
        } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        if (EmptyUtils.isEmpty((Object)transferBillNewEntryRow.getBigDecimal("e_unitcoefficient"))) {
            ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unitcoefficient", (Object)covertRate);
        }
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit));
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unconfirmbaseqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit));
        BigDecimal transamount = transferEntryRow.getBigDecimal("e_transamount");
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_amount", (Object)transamount);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_recamount", (Object)transferAmount);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_tax", (Object)transferEntryRow.get("e_transtax"));
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_discountmode", (Object)DiscountModeEnum.NULL.getValue());
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_discountrate", (Object)BigDecimal.ZERO);
        BigDecimal unitprice = transamount.divide(quantity, 10, RoundingMode.HALF_UP);
        BigDecimal taxUnitPrice = transferAmount.divide(quantity, 10, RoundingMode.HALF_UP);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unitprice", (Object)unitprice);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_taxunitprice", (Object)taxUnitPrice);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_actunitprice", (Object)unitprice);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_acttaxunitprice", (Object)taxUnitPrice);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_verifiedqty", (Object)BigDecimal.ZERO);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unverifyqty", (Object)BigDecimal.ZERO);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_verifiedamt", (Object)BigDecimal.ZERO);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unverifyamt", (Object)BigDecimal.ZERO);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unlockamt", (Object)transferAmount);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unsettleamt", (Object)transferAmount);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"taxrateid", (Object)transferEntryRow.get("taxrateid"));
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_uninvoicedamt", (Object)transferAmount);
        ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)"e_unconfirmamt", (Object)transamount);
        for (String materialExtendField : extendFieldMap.get("entry")) {
            Object materialExtendValue = transferEntryRow.get(materialExtendField);
            if (materialExtendValue == null) continue;
            ArApHelper.setFieldValue((DynamicObject)transferBillNewEntryRow, (String)materialExtendField, (Object)materialExtendValue);
        }
        dynamicObjectCollection.add((Object)transferBillNewEntryRow);
    }

    private void addPlanNewEntryRow(DynamicObject finArBill, DynamicObject transferPlan, DynamicObjectCollection planCollection, Map<String, Set<String>> extendFieldMap) {
        DynamicObjectCollection newPlanEntity = finArBill.getDynamicObjectCollection("planentity");
        DynamicObject transferInfo = (DynamicObject)transferPlan.getParent();
        int precision = 2;
        DynamicObject currency = finArBill.getDynamicObject("basecurrency");
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        BigDecimal exchangeRate = transferInfo.getBigDecimal("head_exchangerate");
        String quotation = transferInfo.getString("quotation");
        Date dueDate = transferInfo.getDate("duedate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        Set<String> planExtendFields = extendFieldMap.get("planentity");
        for (DynamicObject transPlanNewRow : newPlanEntity) {
            long pSrcBillPlanId = transPlanNewRow.getLong("p_sourcebillentryid");
            if (transferPlan.getLong("p_entryid") != pSrcBillPlanId) continue;
            BigDecimal pPriceTaxTotal = transferPlan.getBigDecimal("p_transpricetaxtotal");
            BigDecimal pPriceTaxTotalBase = BigDecimal.ZERO;
            pPriceTaxTotalBase = "1".equals(quotation) ? pPriceTaxTotal.divide(exchangeRate, precision, RoundingMode.HALF_UP) : pPriceTaxTotal.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            transPlanNewRow.set("planpricetax", (Object)pPriceTaxTotal);
            transPlanNewRow.set("planpricetaxloc", (Object)pPriceTaxTotalBase);
            transPlanNewRow.set("unplanlockamt", (Object)pPriceTaxTotal);
            transPlanNewRow.set("unplansettleamt", (Object)pPriceTaxTotal);
            transPlanNewRow.set("unplansettlelocamt", (Object)pPriceTaxTotalBase);
            transPlanNewRow.set("p_splitdimensionid", (Object)transferPlan.getInt("p_splitdimensionid"));
            transPlanNewRow.set("p_recrate", transferPlan.get("p_recrate"));
            for (String planExtendField : planExtendFields) {
                if ("planpricetax".equals(planExtendField) || "unplanlockamt".equals(planExtendField)) continue;
                Object planExtendValue = transferPlan.get(planExtendField);
                if ("planduedate".equals(planExtendField)) {
                    transPlanNewRow.set("planduedate", dueDate == null ? planExtendValue : dueDate);
                    continue;
                }
                if (ObjectUtils.isEmpty((Object)planExtendValue)) continue;
                transPlanNewRow.set(planExtendField, planExtendValue);
            }
            planCollection.add((Object)transPlanNewRow);
        }
    }

    public void addPlanEntry(DynamicObject transferBill) {
        PlanSplitAndBuilder.splitAndBuild((DynamicObject)transferBill);
    }

    private void reSetSplitDimensionId(DynamicObject transferBill) {
        String key;
        Boolean isOldVersion;
        long srcBillId;
        DynamicObjectCollection detailEntries = transferBill.getDynamicObjectCollection("entry");
        DynamicObjectCollection planEntries = transferBill.getDynamicObjectCollection("planentity");
        int splitDimensionIdIndex = 0;
        HashMap<String, Integer> planSrcIdToSplitDimensionId = new HashMap<String, Integer>(8);
        for (DynamicObject planEntry : planEntries) {
            srcBillId = planEntry.getLong("p_sourcebillid");
            isOldVersion = this.srcBillIdToSettleVersion.get(srcBillId);
            if (isOldVersion.booleanValue()) {
                key = String.valueOf(srcBillId);
            } else {
                int planSplitDimensionId = planEntry.getInt("p_splitdimensionid");
                key = srcBillId + "_" + planSplitDimensionId;
            }
            Integer newSplitDimensionId = (Integer)planSrcIdToSplitDimensionId.get(key);
            if (newSplitDimensionId == null) {
                planSrcIdToSplitDimensionId.put(key, splitDimensionIdIndex);
                planEntry.set("p_splitdimensionid", (Object)splitDimensionIdIndex);
                ++splitDimensionIdIndex;
                continue;
            }
            planEntry.set("p_splitdimensionid", (Object)newSplitDimensionId);
        }
        for (DynamicObject detailEntry : detailEntries) {
            srcBillId = detailEntry.getLong("e_srcid");
            isOldVersion = this.srcBillIdToSettleVersion.get(srcBillId);
            if (isOldVersion.booleanValue()) {
                key = String.valueOf(srcBillId);
            } else {
                int detailOldSplitDimensionId = detailEntry.getInt("e_splitdimensionid");
                key = srcBillId + "_" + detailOldSplitDimensionId;
            }
            detailEntry.set("e_splitdimensionid", planSrcIdToSplitDimensionId.get(key));
        }
    }

    private void reSetPlanEntryLocalAmt(DynamicObject transferBill) {
        DynamicObjectCollection detailEntries = transferBill.getDynamicObjectCollection("entry");
        HashMap<Integer, BigDecimal> detailEntrySplitDimensionIdToLocalAmt = new HashMap<Integer, BigDecimal>(8);
        for (DynamicObject detailEntry : detailEntries) {
            int splitdimensionId = detailEntry.getInt("e_splitdimensionid");
            BigDecimal localAmt = detailEntry.getBigDecimal("e_reclocalamt");
            detailEntrySplitDimensionIdToLocalAmt.merge(splitdimensionId, localAmt, BigDecimal::add);
        }
        DynamicObjectCollection planEntries = transferBill.getDynamicObjectCollection("planentity");
        HashMap<Integer, ArrayList<DynamicObject>> planEntrySplitDimensionIdToEntries = new HashMap<Integer, ArrayList<DynamicObject>>(8);
        for (DynamicObject planEntry : planEntries) {
            int planSplitDimensionId = planEntry.getInt("p_splitdimensionid");
            ArrayList<DynamicObject> remainPlanEntries = (ArrayList<DynamicObject>)planEntrySplitDimensionIdToEntries.get(planSplitDimensionId);
            if (remainPlanEntries == null) {
                remainPlanEntries = new ArrayList<DynamicObject>(1);
                remainPlanEntries.add(planEntry);
                planEntrySplitDimensionIdToEntries.put(planSplitDimensionId, remainPlanEntries);
                continue;
            }
            remainPlanEntries.add(planEntry);
        }
        for (Map.Entry entrySet : detailEntrySplitDimensionIdToLocalAmt.entrySet()) {
            Integer key = (Integer)entrySet.getKey();
            BigDecimal value = (BigDecimal)entrySet.getValue();
            List remainPlanEntries = (List)planEntrySplitDimensionIdToEntries.get(key);
            BigDecimal remainPlanEntryLocalAmtTotal = BigDecimal.ZERO;
            int count = 0;
            for (DynamicObject remainPlanEntry : remainPlanEntries) {
                if (++count == remainPlanEntries.size()) {
                    BigDecimal localAmt = value.subtract(remainPlanEntryLocalAmtTotal);
                    remainPlanEntry.set("planpricetaxloc", (Object)localAmt);
                    remainPlanEntry.set("unplansettlelocamt", (Object)localAmt);
                    continue;
                }
                remainPlanEntryLocalAmtTotal = remainPlanEntryLocalAmtTotal.add(remainPlanEntry.getBigDecimal("planpricetaxloc"));
            }
        }
    }

    @KSMethod
    public void dispose(DynamicObject transferInfo, DynamicObject[] sourceFinBills) {
        DynamicObjectCollection entry = transferInfo.getDynamicObjectCollection("entryentity");
        Map<Long, List<DynamicObject>> billGroupedEntry = entry.stream().collect(Collectors.groupingBy(row -> row.getLong("e_srcfinbillid")));
        PlanEntryDisposer planEntryDisposer = new PlanEntryDisposer();
        for (Map.Entry<Long, List<DynamicObject>> groupedTransferEntry : billGroupedEntry.entrySet()) {
            Long billId = groupedTransferEntry.getKey();
            DynamicObject sourceFinBill = this.matchSourceFinBill(billId, sourceFinBills);
            if (sourceFinBill == null) continue;
            BigDecimal totalDisposeAmount = BigDecimal.ZERO;
            DynamicObjectCollection sourceEntry = sourceFinBill.getDynamicObjectCollection("entry");
            List<DynamicObject> transferEntry = groupedTransferEntry.getValue();
            for (DynamicObject transferRow : transferEntry) {
                long sourceEntryId = transferRow.getLong("e_srcentryid");
                DynamicObject sourceEntryRow = this.matchSourceEntryRow(sourceEntryId, sourceEntry);
                if (sourceEntryRow == null) continue;
                BigDecimal rowDisposeAmount = transferRow.getBigDecimal("e_transrecamount");
                this.increaseAmount(sourceEntryRow, "e_lockedamt", rowDisposeAmount);
                this.reduceAmount(sourceEntryRow, "e_unlockamt", rowDisposeAmount);
                totalDisposeAmount = totalDisposeAmount.add(rowDisposeAmount);
            }
            planEntryDisposer.saveDispose(sourceFinBill, totalDisposeAmount);
        }
    }

    private DynamicObject matchSourceFinBill(Long billId, DynamicObject[] sourceFinBills) {
        List matchedBills = Arrays.stream(sourceFinBills).filter(finBill -> finBill.getLong("id") == billId.longValue()).collect(Collectors.toList());
        if (matchedBills.isEmpty()) {
            return null;
        }
        return (DynamicObject)matchedBills.get(0);
    }

    private DynamicObject matchSourceEntryRow(Long entryId, DynamicObjectCollection transferEntry) {
        for (DynamicObject row : transferEntry) {
            if (row.getLong("id") != entryId.longValue()) continue;
            return row;
        }
        return null;
    }

    private void increaseAmount(DynamicObject row, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = row.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.add(amount);
        row.set(amountKey, (Object)result);
    }

    private void reduceAmount(DynamicObject row, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = row.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.subtract(amount);
        row.set(amountKey, (Object)result);
    }

    private void initTransferArgs(DynamicObject transferInfo) {
        this.isPlanSettle = SystemParameterHelper.isPlanSettle((long)transferInfo.getLong("org.id"), (boolean)true);
        if (this.isPlanSettle) {
            DynamicObject[] finApBills;
            this.ruleId = "1636885873645910016";
            DynamicObjectCollection entry = transferInfo.getDynamicObjectCollection("entryentity");
            HashSet<Long> billIds = new HashSet<Long>(32);
            HashSet<Long> billEntryIds = new HashSet<Long>(32);
            for (DynamicObject row : entry) {
                billIds.add(Long.valueOf(row.getString("e_srcfinbillid")));
                billEntryIds.add(Long.valueOf(row.getString("e_srcentryid")));
            }
            QFilter filter = new QFilter("id", "in", billIds);
            filter.and(new QFilter("entry.id", "in", billEntryIds));
            Set<String> selectors = this.getCarryFieldByPlan();
            selectors.add("org");
            selectors.add("settleversion");
            for (DynamicObject finApBill : finApBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{filter})) {
                DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("entry");
                for (DynamicObject detail : detailEntry) {
                    this.finArEntryMap.put(detail.getLong("id"), detail);
                }
                this.srcBillIdToSettleVersion.put(finApBill.getLong("id"), SettleVersionServiceHelper.isOldVersion((DynamicObject)finApBill));
            }
        }
    }

    private Set<String> getCarryFieldByPlan() {
        HashSet<String> materialFields = new HashSet<String>(32);
        materialFields.add("e_material");
        materialFields.add("e_measureunit");
        materialFields.add("e_ispresent");
        materialFields.add("e_unitprice");
        materialFields.add("e_taxrate");
        materialFields.add("e_taxunitprice");
        materialFields.add("e_actunitprice");
        materialFields.add("e_acttaxunitprice");
        materialFields.add("e_corebilltype");
        materialFields.add("e_corebillno");
        materialFields.add("corebillid");
        materialFields.add("corebillentryid");
        materialFields.add("e_remark");
        materialFields.add("e_baseunit");
        materialFields.add("e_expenseitem");
        materialFields.add("e_quantity");
        materialFields.add("e_unitcoefficient");
        materialFields.add("e_corebillentryseq");
        materialFields.add("e_spectype");
        materialFields.add("taxrateid");
        materialFields.add("e_assistantattr");
        materialFields.add("project");
        materialFields.add("linetype");
        materialFields.add("materialname");
        materialFields.add("configuredcode");
        materialFields.add("tracknumber");
        materialFields.add("e_productline");
        return materialFields;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }
}

