/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.api.push;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ar.mservice.RecTransferService;
import kd.fi.ar.mservice.api.push.PushFinArBillServiceImpl;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ArApTransferHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.writeback.helper.ArTransferWBFinBillServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.DecimalScopeValidator;

@KSObject
public class FinArTransferServiceImpl
extends PushFinArBillServiceImpl {
    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList) {
        return this.assignBillPush(sourEntity, paramList, null);
    }

    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList, String ruleId) {
        this.checkParam(sourEntity, "", paramList, false);
        return this.transferLogic(sourEntity, "", paramList, ruleId, false);
    }

    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList) {
        return this.assignBillEntryPush(sourEntity, sourEntryEntity, paramList, null);
    }

    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId) {
        this.checkParam(sourEntity, sourEntryEntity, paramList, true);
        return this.transferLogic(sourEntity, sourEntryEntity, paramList, ruleId, true);
    }

    private List<Object> transferLogic(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, boolean assignEntry) {
        List<DynamicObject> finBills;
        DynamicObject transInfo = this.paramCovertDynamicObject(paramList, assignEntry);
        String transferType = transInfo.getString("transfertype");
        RecTransferService recTransfer = (RecTransferService)BeanFactory.getBean(RecTransferService.class, (Object[])new Object[0]);
        if (EmptyUtils.isNotEmpty((Object)ruleId)) {
            recTransfer.setRuleId(ruleId);
        }
        if ("sum".equals(transferType)) {
            DynamicObject finBill = recTransfer.transferSummly(transInfo);
            finBills = Collections.singletonList(finBill);
        } else {
            finBills = recTransfer.transferDispersedly(transInfo);
        }
        this.setHeadFieldByParam(finBills, paramList);
        this.setEntryFieldByParam(finBills, paramList);
        for (DynamicObject dynamicObject : finBills) {
            this.setHeadDueDate(dynamicObject);
        }
        DecimalScopeValidator decimalScopeValidator = new DecimalScopeValidator();
        for (DynamicObject bill : finBills) {
            decimalScopeValidator.validate(bill);
        }
        Throwable throwable = null;
        try (TXHandle tXHandle = TX.required();){
            List<Object> successIds = this.saveTargetBills(sourEntity, sourEntryEntity, paramList, ruleId, finBills);
            this.dispose(transInfo, finBills);
            List<Object> list = successIds;
            return list;
        }
        catch (Exception ex) {
            try {
                tXHandle.markRollback();
                throw new KDBizException(ex.getMessage());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected void checkParam(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, boolean assignEntry) {
        super.checkParam(sourEntity, sourEntryEntity, paramList, assignEntry);
        HashSet<String> transferTypes = new HashSet<String>(2);
        HashSet<Long> srcFinArBillIds = new HashSet<Long>(paramList.size());
        for (AssignBillPushParam assignBillPushParam : paramList) {
            String transferType = assignBillPushParam.getTransferType();
            if (StringUtils.isEmpty((String)transferType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u503a\u6743\u8f6c\u79fb\u65b9\u5f0f\u3002", (String)"FinArTransferServiceImpl_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
            }
            if (!"sum".equals(transferType) && !"bijection".equals(transferType)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u503a\u6743\u8f6c\u79fb\u65b9\u5f0f\u4e0d\u652f\u6301\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FinArTransferServiceImpl_1", (String)"fi-ar-mservice", (Object[])new Object[0]));
            }
            transferTypes.add(transferType);
            srcFinArBillIds.add(assignBillPushParam.getSourBillId());
        }
        if (transferTypes.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u503a\u6743\u8f6c\u79fb\u8c03\u7528\u65f6\u53ea\u652f\u6301\u6c47\u603b\u8f6c\u5165/\u5206\u6563\u8f6c\u5165\uff0c\u4e0d\u652f\u6301\u6df7\u5408\u8c03\u5165\u3002", (String)"FinArTransferServiceImpl_2", (String)"fi-ar-mservice", (Object[])new Object[0]));
        }
        if (!assignEntry && srcFinArBillIds.size() != paramList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6574\u5355\u5168\u90e8\u503a\u6743\u8f6c\u79fb\u65f6\uff0c\u8f93\u5165\u7684\u6e90\u5355id\u4e0d\u53ef\u91cd\u590d\u3002", (String)"FinArTransferServiceImpl_4", (String)"fi-ar-mservice", (Object[])new Object[0]));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"transfer", (String)sourEntity, (Object[])srcFinArBillIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)result);
        ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0017", null, (Object[])new Object[]{srcFinArBillIds});
    }

    private DynamicObject paramCovertDynamicObject(List<AssignBillPushParam> paramList, boolean assignEntry) {
        QFilter[] sourceBillFilters;
        AssignBillPushParam assignBillPushParam = paramList.get(0);
        Set srcFinBillIds = paramList.stream().map(AssignBillPushParam::getSourBillId).collect(Collectors.toSet());
        String sourceBillSelectors = String.join((CharSequence)",", this.getSourceBillSelectors());
        DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)sourceBillSelectors, (QFilter[])(sourceBillFilters = new QFilter[]{new QFilter("id", "in", srcFinBillIds)}));
        if (EmptyUtils.isEmpty((Object)finBills)) {
            throw new KDBizException("Query source bill data is empty.");
        }
        HashMap<Long, DynamicObject> finEntryMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> finBillMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject finArBill : finBills) {
            DynamicObjectCollection entry = finArBill.getDynamicObjectCollection(this.finArBillModel.ENTRY);
            for (DynamicObject detailRow : entry) {
                finEntryMap.put(detailRow.getLong("id"), detailRow);
            }
            finBillMap.put(finArBill.getLong("id"), finArBill);
        }
        DynamicObject finBill = finBills[0];
        DynamicObject transferInfo = BusinessDataServiceHelper.newDynamicObject((String)"ar_transferofcredit");
        transferInfo.set("transfertype", (Object)assignBillPushParam.getTransferType());
        Map tarFieldValueMap = assignBillPushParam.getTarFieldValueMap();
        transferInfo.set("asstacttype", (Object)(tarFieldValueMap.get(this.finArBillModel.HEAD_ASSTACTTYPE) == null ? finBill.getString(this.finArBillModel.HEAD_ASSTACTTYPE) : tarFieldValueMap.get(this.finArBillModel.HEAD_ASSTACTTYPE)));
        transferInfo.set("asstact", tarFieldValueMap.get(this.finArBillModel.HEAD_ASSTACT) == null ? finBill.getDynamicObject(this.finArBillModel.HEAD_ASSTACT) : tarFieldValueMap.get(this.finArBillModel.HEAD_ASSTACT));
        transferInfo.set("payproperty", tarFieldValueMap.get(this.finArBillModel.HEAD_PAYPROPERTY) == null ? finBill.getDynamicObject(this.finArBillModel.HEAD_PAYPROPERTY) : tarFieldValueMap.get(this.finArBillModel.HEAD_PAYPROPERTY));
        transferInfo.set("remark", tarFieldValueMap.get(this.finArBillModel.HEAD_REMARK));
        transferInfo.set("org", (Object)finBill.getDynamicObject(this.finArBillModel.HEAD_ORG));
        transferInfo.set("recorg", (Object)finBill.getDynamicObject(this.finArBillModel.HEAD_ORG));
        transferInfo.set("paycond", tarFieldValueMap.get(this.finArBillModel.HEAD_PAYCOND));
        transferInfo.set("settlementtype", tarFieldValueMap.get(this.finArBillModel.HEAD_SETTLEMENTTYPE));
        DynamicObject currency = finBill.getDynamicObject(this.finArBillModel.HEAD_CURRENCY);
        DynamicObject baseCurrency = finBill.getDynamicObject(this.finArBillModel.HEAD_BASECURRENCY);
        transferInfo.set("currency", (Object)currency);
        transferInfo.set("basecurrency", (Object)baseCurrency);
        InitHelper init = new InitHelper(finBill.getDynamicObject(this.finArBillModel.HEAD_ORG).getLong("id"), "ar_init");
        HashSet<Date> dates = new HashSet<Date>(2);
        for (DynamicObject fin : finBills) {
            dates.add(fin.getDate("exratedate"));
            if (dates.size() > 1) break;
        }
        if (dates.size() == 1) {
            transferInfo.set("exratedate", (Object)finBill.getDate("exratedate"));
        } else {
            transferInfo.set("exratedate", (Object)new Date());
        }
        HashSet<Long> exratetableIds = new HashSet<Long>(2);
        for (DynamicObject fin : finBills) {
            DynamicObject exratetable = fin.getDynamicObject("exratetable");
            exratetableIds.add(exratetable.getLong("id"));
            if (exratetableIds.size() > 1) break;
        }
        if (exratetableIds.size() == 1) {
            transferInfo.set("exratetable", finBill.get("exratetable"));
        } else {
            transferInfo.set("exratetable", (Object)init.getExrateTable());
        }
        transferInfo.set("billtype", tarFieldValueMap.get(this.finArBillModel.HEAD_BILLTYPE) == null ? finBill.getDynamicObject(this.finArBillModel.HEAD_BILLTYPE) : tarFieldValueMap.get(this.finArBillModel.HEAD_BILLTYPE));
        transferInfo.set("quotation", (Object)finBill.getString(this.finArBillModel.HEAD_QUOTATION));
        Object exchangeRate = tarFieldValueMap.get(this.finArBillModel.HEAD_EXCHANGERATE);
        if (currency.getLong("id") == baseCurrency.getLong("id")) {
            transferInfo.set("head_exchangerate", (Object)1);
            transferInfo.set("quotation", (Object)"0");
        } else {
            long exrateTableId = transferInfo.getLong("exratetable.id");
            Date exrateDate = transferInfo.getDate("exratedate");
            Map exrateMap = BaseDataHelper.getExchangeRateMap((Long)exrateTableId, (Long)currency.getLong("id"), (Long)baseCurrency.getLong("id"), (Date)exrateDate);
            if (exrateMap != null) {
                boolean quoteType = (Boolean)exrateMap.get("quoteType");
                String quotation = quoteType ? "1" : "0";
                transferInfo.set("quotation", (Object)quotation);
                if (EmptyUtils.isNotEmpty(exchangeRate)) {
                    transferInfo.set("head_exchangerate", exchangeRate);
                } else {
                    exchangeRate = exrateMap.get("exchangeRate");
                    if (EmptyUtils.isNotEmpty(exchangeRate)) {
                        transferInfo.set("head_exchangerate", exchangeRate);
                    }
                }
            }
        }
        Date currentDate = init.getCurrentDate();
        if (currentDate == null) {
            currentDate = init.getStartDate();
        }
        Date bizDate = new Date();
        transferInfo.set("bizdate", (Object)DateUtils.getDataFormat((Date)new Date(), (boolean)true));
        if (currentDate.after(bizDate)) {
            transferInfo.set("bizdate", (Object)currentDate);
        }
        transferInfo.set("bizdate", (Object)(tarFieldValueMap.get(this.finArBillModel.HEAD_BIZDATE) == null ? transferInfo.getDate("bizdate") : tarFieldValueMap.get(this.finArBillModel.HEAD_BIZDATE)));
        transferInfo.set("duedate", tarFieldValueMap.get(this.finArBillModel.HEAD_DUEDATE));
        Map extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"ar_transferofcredit");
        Set headExtendFields = (Set)extendFieldMap.get("head");
        Set materialExtendFields = (Set)extendFieldMap.get("entry");
        Set planExtendFields = (Set)extendFieldMap.get("planentity");
        for (String headExtendField : headExtendFields) {
            transferInfo.set(headExtendField, tarFieldValueMap.get(headExtendField));
        }
        DynamicObjectCollection entryEntity = transferInfo.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < paramList.size(); ++i) {
            int temp = i;
            AssignBillPushParam pushParam = paramList.get(i);
            Map fieldValueMap = pushParam.getTarFieldValueMap();
            DynamicObject detailRow = (DynamicObject)finEntryMap.get(pushParam.getSourBillEntryId());
            DynamicObject finArBill = (DynamicObject)finBillMap.get(pushParam.getSourBillId());
            if (finArBill == null) continue;
            if (assignEntry && detailRow != null) {
                DynamicObject aNew = entryEntity.addNew();
                aNew.set("seq", (Object)(++temp));
                aNew.set("e_srcfinbillid", (Object)pushParam.getSourBillId());
                aNew.set("e_srcentryid", (Object)detailRow.getLong("id"));
                aNew.set("e_billno", (Object)finArBill.getString("billno"));
                aNew.set("taxrateid", fieldValueMap.get(this.finArBillModel.E_TAXRATEID) == null ? detailRow.getDynamicObject(this.finArBillModel.E_TAXRATEID) : fieldValueMap.get(this.finArBillModel.E_TAXRATEID));
                aNew.set("e_quantity", (Object)(fieldValueMap.get(this.finArBillModel.E_QUANTITY) == null ? detailRow.getBigDecimal(this.finArBillModel.E_QUANTITY) : fieldValueMap.get(this.finArBillModel.E_QUANTITY)));
                aNew.set("e_transamount", (Object)(fieldValueMap.get(this.finArBillModel.E_AMOUNT) == null ? detailRow.getBigDecimal(this.finArBillModel.E_AMOUNT) : fieldValueMap.get(this.finArBillModel.E_AMOUNT)));
                aNew.set("e_transtax", (Object)(fieldValueMap.get(this.finArBillModel.E_TAX) == null ? detailRow.getBigDecimal(this.finArBillModel.E_TAX) : fieldValueMap.get(this.finArBillModel.E_TAX)));
                aNew.set("e_transrecamount", (Object)aNew.getBigDecimal("e_transamount").add(aNew.getBigDecimal("e_transtax")));
                aNew.set("e_splitdimensionid", fieldValueMap.get("e_splitdimensionid") == null ? Integer.valueOf(detailRow.getInt("e_splitdimensionid")) : fieldValueMap.get("e_splitdimensionid"));
                for (String materialExtendField : materialExtendFields) {
                    aNew.set(materialExtendField, tarFieldValueMap.get(materialExtendField));
                }
            }
            if (assignEntry) continue;
            DynamicObjectCollection detailEntry = finArBill.getDynamicObjectCollection(this.finArBillModel.ENTRY);
            for (DynamicObject detail : detailEntry) {
                DynamicObject aNew = entryEntity.addNew();
                aNew.set("seq", (Object)(++temp));
                aNew.set("e_srcfinbillid", (Object)pushParam.getSourBillId());
                aNew.set("e_srcentryid", (Object)detail.getLong("id"));
                aNew.set("e_billno", (Object)finArBill.getString("billno"));
                aNew.set("taxrateid", (Object)detail.getDynamicObject(this.finArBillModel.E_TAXRATEID));
                aNew.set("e_quantity", (Object)detail.getBigDecimal(this.finArBillModel.E_QUANTITY));
                aNew.set("e_transamount", (Object)detail.getBigDecimal(this.finArBillModel.E_AMOUNT));
                aNew.set("e_transtax", (Object)detail.getBigDecimal(this.finArBillModel.E_TAX));
                aNew.set("e_transrecamount", (Object)aNew.getBigDecimal("e_transamount").add(aNew.getBigDecimal("e_transtax")));
                for (String materialExtendField : (Set)extendFieldMap.get("entry")) {
                    aNew.set(materialExtendField, tarFieldValueMap.get(materialExtendField));
                }
            }
        }
        List containsPlanParams = paramList.stream().filter(param -> !ObjectUtils.isEmpty((Object)param.getTarInvEntrys())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(containsPlanParams)) {
            DynamicObjectCollection transferPlanEntry = transferInfo.getDynamicObjectCollection("planentity");
            for (AssignBillPushParam containsPlanParam : containsPlanParams) {
                List transPlanRows = containsPlanParam.getTarInvEntrys();
                for (Map transPlanRowMap : transPlanRows) {
                    DynamicObject newPlanRow = transferPlanEntry.addNew();
                    newPlanRow.set("p_billno", transPlanRowMap.get("p_billno"));
                    newPlanRow.set("p_billid", transPlanRowMap.get("p_billid"));
                    newPlanRow.set("p_transpricetaxtotal", transPlanRowMap.get("p_transpricetaxtotal"));
                    newPlanRow.set("p_entryid", transPlanRowMap.get("p_entryid"));
                    newPlanRow.set("p_splitdimensionid", transPlanRowMap.get("p_splitdimensionid"));
                    newPlanRow.set("p_recrate", transPlanRowMap.get("p_recrate"));
                    for (String fieldName : planExtendFields) {
                        newPlanRow.set(fieldName, transPlanRowMap.get(fieldName));
                    }
                }
            }
        }
        return this.checkTranInfo(transferInfo, finEntryMap, finBillMap);
    }

    private void setHeadDueDate(DynamicObject finArBill) {
        Date planMaxDuedate = finArBill.getDate("duedate");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finArBill.set("duedate", (Object)planMaxDuedate);
    }

    private DynamicObject checkTranInfo(DynamicObject transferInfo, Map<Long, DynamicObject> finEntryMap, Map<Long, DynamicObject> finBillMap) {
        if (EmptyUtils.isEmpty((Object)transferInfo.get("head_exchangerate"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"FinArTransferServiceImpl_5", (String)"fi-ar-mservice", (Object[])new Object[0]));
        }
        DynamicObjectCollection entryEntity = transferInfo.getDynamicObjectCollection("entryentity");
        for (DynamicObject transRow : entryEntity) {
            DynamicObject finArBill = finBillMap.get(transRow.getLong("e_srcfinbillid"));
            DynamicObject detailRow = finEntryMap.get(transRow.getLong("e_srcentryid"));
            if (detailRow == null || finArBill == null) continue;
            BigDecimal eTransAmt = transRow.getBigDecimal("e_transamount");
            BigDecimal eTransTax = transRow.getBigDecimal("e_transtax");
            BigDecimal eTransRecAmt = transRow.getBigDecimal("e_transrecamount");
            if (eTransRecAmt.compareTo(eTransAmt.add(eTransTax)) == 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u79fb\u5e94\u6536\u91d1\u989d\u5e94\u7b49\u4e8e\u8f6c\u79fb\u91d1\u989d\u4e0e\u8f6c\u79fb\u7a0e\u989d\u4e4b\u548c\u3002", (String)"FinArTransferServiceImpl_12", (String)"fi-ar-mservice", (Object[])new Object[0]));
        }
        DecimalScopeValidator decimalScopeValidator = new DecimalScopeValidator();
        decimalScopeValidator.validate(transferInfo);
        return transferInfo;
    }

    private void dispose(DynamicObject transferInfo, List<DynamicObject> transferBills) {
        DynamicObjectCollection entry = transferInfo.getDynamicObjectCollection("entryentity");
        Set sourceBillIds = entry.stream().map(row -> row.getLong("e_srcfinbillid")).collect(Collectors.toSet());
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(sourceBillIds, (String)"ar_finarbill", (boolean)false);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", sourceBillIds)};
        String selectors = String.join((CharSequence)",", FinArBillHandleHelper.getLockWBSelector());
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)selectors, (QFilter[])filters);
        this.validateSrcLockedAmtOver(sourceBills, transferBills);
        ArTransferWBFinBillServiceHelper.directWriteBack((DynamicObject[])sourceBills, transferBills);
    }

    /*
     * WARNING - void declaration
     */
    private void validateSrcLockedAmtOver(DynamicObject[] sourceBills, List<DynamicObject> transferBills) {
        void var6_8;
        HashMap<Long, BigDecimal> srcEntryIdToUnLockAmt = new HashMap<Long, BigDecimal>(sourceBills.length);
        DynamicObject[] dynamicObjectArray = sourceBills;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            DynamicObject sourceBill = dynamicObjectArray[var6_8];
            DynamicObjectCollection detailEntries = sourceBill.getDynamicObjectCollection("entry");
            Iterator iterator = detailEntries.iterator();
            while (iterator.hasNext()) {
                DynamicObject detailEntry = (DynamicObject)iterator.next();
                srcEntryIdToUnLockAmt.put(detailEntry.getLong("id"), detailEntry.getBigDecimal("e_unlockamt"));
            }
            ++var6_8;
        }
        HashMap<Long, BigDecimal> transferSrcEntryIdToNeedWBAmt = new HashMap<Long, BigDecimal>(transferBills.size());
        for (DynamicObject dynamicObject : transferBills) {
            DynamicObjectCollection detailEntries = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject detailEntry : detailEntries) {
                long srcEntryId = detailEntry.getLong("e_srcentryid");
                BigDecimal detailEntryPriceTaxTotal = detailEntry.getBigDecimal("e_recamount");
                transferSrcEntryIdToNeedWBAmt.merge(srcEntryId, detailEntryPriceTaxTotal, BigDecimal::add);
            }
        }
        for (Map.Entry entry : transferSrcEntryIdToNeedWBAmt.entrySet()) {
            Long srcEntryId = (Long)entry.getKey();
            BigDecimal needWBAmt = (BigDecimal)entry.getValue();
            BigDecimal unLockAmt = (BigDecimal)srcEntryIdToUnLockAmt.get(srcEntryId);
            if (unLockAmt == null || needWBAmt.abs().compareTo(unLockAmt.abs()) <= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u79fb\u5355\u7684\u5e94\u6536\u91d1\u989d\u8d85\u8fc7\u4e86\u6e90\u5355\u7684\u672a\u9501\u5b9a\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArTransferServiceImpl_13", (String)"fi-ar-mservice", (Object[])new Object[0]));
        }
    }

    @Override
    protected String getTargetEntity() {
        return "ar_finarbill";
    }

    protected List<Object> saveTargetBills(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getTargetEntity(), (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)saveResult);
        List successPkIds = saveResult.getSuccessPkIds();
        if (!"true".equals(StdConfig.get((String)"isTransferasSaved")) && !ObjectUtils.isEmpty((Object)successPkIds)) {
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.getTargetEntity(), (Object[])successPkIds.toArray(new Object[0]), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)submitResult);
            return submitResult.getSuccessPkIds();
        }
        return saveResult.getSuccessPkIds();
    }

    protected List<String> canModifyFields() {
        List fields = super.canModifyFields();
        fields.add("fhgk_orgfield");
        fields.add("fhgk_userfield");
        fields.add(this.finArBillModel.HEAD_REMARK);
        fields.add(this.finArBillModel.E_TAXRATEID);
        fields.add(this.finArBillModel.E_PRICETAXTOTAL);
        fields.add(this.finArBillModel.HEAD_PAYCOND);
        fields.add(this.finArBillModel.HEAD_SETTLEMENTTYPE);
        fields.add(this.finArBillModel.HEAD_SALESORG);
        fields.add(this.finArBillModel.HEAD_SALESMAN);
        fields.add(this.finArBillModel.HEAD_SALESGROUP);
        fields.add(this.finArBillModel.HEAD_ASSTACTTYPE);
        Map extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"ar_transferofcredit");
        fields.addAll((Collection)extendFieldMap.get("head"));
        fields.addAll((Collection)extendFieldMap.get("entry"));
        return fields;
    }

    protected List<String> getSourceBillSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(32);
        selectors.add(this.finArBillModel.HEAD_ORG);
        selectors.add(this.finArBillModel.HEAD_RECORG);
        selectors.add(this.finArBillModel.HEAD_BILLTYPE);
        selectors.add(this.finArBillModel.HEAD_BIZTYPE);
        selectors.add(this.finArBillModel.HEAD_CURRENCY);
        selectors.add(this.finArBillModel.HEAD_BASECURRENCY);
        selectors.add(this.finArBillModel.HEAD_QUOTATION);
        selectors.add(this.finArBillModel.HEAD_PAYPROPERTY);
        selectors.add(this.finArBillModel.HEAD_EXCHANGERATE);
        selectors.add(this.finArBillModel.HEAD_BILLNO);
        selectors.add(this.finArBillModel.HEAD_EXRATEDATE);
        selectors.add(this.finArBillModel.HEAD_BIZDATE);
        selectors.add(this.finArBillModel.HEAD_DUEDATE);
        selectors.add(this.finArBillModel.HEAD_ASSTACTTYPE);
        selectors.add(this.finArBillModel.HEAD_ASSTACT);
        selectors.add(this.finArBillModel.HEAD_EXRATETABLE);
        selectors.add(this.finArBillModel.E_MATERIAL);
        selectors.add(this.finArBillModel.E_ASSISTANTATTR);
        selectors.add(this.finArBillModel.E_SPECTYPE);
        selectors.add(this.finArBillModel.E_EXPENSEITEM);
        selectors.add(this.finArBillModel.E_MEASUREUNIT);
        selectors.add(this.finArBillModel.E_QUANTITY);
        selectors.add(this.finArBillModel.E_TAXRATE);
        selectors.add(this.finArBillModel.E_TAX);
        selectors.add(this.finArBillModel.E_AMOUNT);
        selectors.add(this.finArBillModel.E_TAXRATEID);
        selectors.add(this.finArBillModel.E_PRICETAXTOTAL);
        selectors.add(this.finArBillModel.E_UNLOCKAMT);
        selectors.add(this.finArBillModel.E_LOCKEDAMT);
        selectors.add(this.finArBillModel.P_UNPLANLOCKAMT);
        selectors.add(this.finArBillModel.P_PLANLOCKEDAMT);
        selectors.add(this.finArBillModel.HEAD_PRICETAXTOTAL);
        selectors.add(this.finArBillModel.E_SPLITDIMENSION_ID);
        selectors.add(this.finArBillModel.P_SPLITDIMENSION_ID);
        return selectors;
    }

    @Override
    public String getServiceName() {
        return ServiceNameEnum.FINARTRANSFER.getValue();
    }
}

