/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.api.push;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.script.annotations.KSObject;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.BillHeadAmtParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.push.AbstractPushBillService;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.model.BusArBillModel;

@KSObject
public class PushBusArBillServiceImpl
extends AbstractPushBillService {
    protected BusArBillModel busArBillModel = new BusArBillModel();

    protected void resetEntryAmtField(PriceLocalCalculator localCalculator, DynamicObject targetBillEntry, List<AssignBillPushParam> paramList) {
        super.resetEntryAmtField(localCalculator, targetBillEntry, paramList);
        targetBillEntry.set(this.busArBillModel.E_UNWOFFAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.busArBillModel.E_UNWOFFLOCAMT, (Object)localCalculator.getPricetaxtotallocal());
        targetBillEntry.set(this.busArBillModel.E_UNINVOICEDAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.busArBillModel.E_UNINVOICEDLOCAMT, (Object)localCalculator.getPricetaxtotallocal());
        targetBillEntry.set(this.busArBillModel.E_CONFIRMEDAMT, (Object)localCalculator.getAmount());
        targetBillEntry.set(this.busArBillModel.E_UNCONFIRMAMT, (Object)localCalculator.getAmount());
        targetBillEntry.set(this.busArBillModel.E_UNWOFFNOTAXAMT, (Object)localCalculator.getAmount());
        targetBillEntry.set(this.busArBillModel.E_UNWOFFNOTAXLOCAMT, (Object)localCalculator.getAmountlocal());
        targetBillEntry.set(this.busArBillModel.E_UNWOFFTAX, (Object)localCalculator.getTax());
        targetBillEntry.set(this.busArBillModel.E_UNWOFFTAXLOCAL, (Object)localCalculator.getTaxlocal());
        targetBillEntry.set(this.busArBillModel.E_UNINVNOTAXAMT, (Object)localCalculator.getAmount());
        targetBillEntry.set(this.busArBillModel.E_UNINVNOTAXLOCALAMT, (Object)localCalculator.getAmountlocal());
    }

    protected void resetHeadAmtField(DynamicObject targetBill, BillHeadAmtParam billHeadAmtParam) {
        super.resetHeadAmtField(targetBill, billHeadAmtParam);
        targetBill.set(this.busArBillModel.HEAD_UNINVOICEDAMT, (Object)billHeadAmtParam.getPriceTaxTotal());
        targetBill.set(this.busArBillModel.HEAD_UNINVOICEDLOCAMT, (Object)billHeadAmtParam.getPriceTaxTotalLocal());
        targetBill.set(this.busArBillModel.HEAD_UNWOFFAMT, (Object)billHeadAmtParam.getPriceTaxTotal());
        targetBill.set(this.busArBillModel.HEAD_UNWOFFLOCAMT, (Object)billHeadAmtParam.getPriceTaxTotalLocal());
        targetBill.set(this.busArBillModel.HEAD_UNWOFFNOTAXAMT, (Object)billHeadAmtParam.getAmount());
        targetBill.set(this.busArBillModel.HEAD_UNWOFFNOTAXLOCAMT, (Object)billHeadAmtParam.getAmountLocal());
        targetBill.set(this.busArBillModel.HEAD_UNWOFFTAX, (Object)billHeadAmtParam.getTaxAmt());
        targetBill.set(this.busArBillModel.HEAD_UNWOFFTAXLOCAL, (Object)billHeadAmtParam.getTaxAmtLocal());
    }

    protected void afterPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
        super.afterPush(sourEntity, sourEntryEntity, paramList, ruleId, targetBills);
        Optional<AssignBillPushParam> entryPushParamOptional = paramList.stream().filter(entryPushParam -> entryPushParam.getTarFieldValueMap().get(this.busArBillModel.E_QUANTITY) != null).findAny();
        if (entryPushParamOptional.isPresent()) {
            this.reSetEntryQty(targetBills);
        }
    }

    private void reSetEntryQty(List<DynamicObject> targetBills) {
        for (DynamicObject targetBill : targetBills) {
            DynamicObjectCollection entries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject entry : entries) {
                DynamicObject baseunit = entry.getDynamicObject(this.busArBillModel.E_BASEUNIT);
                BigDecimal quantity = entry.getBigDecimal(this.busArBillModel.E_QUANTITY);
                BigDecimal covertRate = entry.getBigDecimal(this.busArBillModel.E_UNITCOEFFICIENT);
                BigDecimal baseQty = InitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseunit);
                entry.set(this.busArBillModel.E_BASEUNITQTY, (Object)baseQty);
                entry.set(this.busArBillModel.E_UNWOFFQTY, (Object)quantity);
                entry.set(this.busArBillModel.E_UNINVOICEDQTY, (Object)quantity);
            }
        }
    }

    protected String getTargetEntity() {
        return "ar_busbill";
    }

    public String getServiceName() {
        return ServiceNameEnum.PUSHBUSAR.getValue();
    }
}

