/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.api.push;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.script.annotations.KSObject;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.BillHeadAmtParam;
import kd.fi.arapcommon.api.param.CalculatorParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.push.AbstractPushBillService;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.model.FinArBillModel;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;

@KSObject
public class PushFinArBillServiceImpl
extends AbstractPushBillService {
    protected FinArBillModel finArBillModel = new FinArBillModel();

    protected CalculatorParam genCalculatorParam(DynamicObject targetBill, DynamicObject targetBillEntry) {
        CalculatorParam calculatorParam = super.genCalculatorParam(targetBill, targetBillEntry);
        calculatorParam.setAdjustAmt(targetBillEntry.getBigDecimal(this.finArBillModel.E_ADJUSTAMOUNT));
        return calculatorParam;
    }

    protected void resetEntryAmtField(PriceLocalCalculator localCalculator, DynamicObject targetBillEntry, List<AssignBillPushParam> paramList) {
        super.resetEntryAmtField(localCalculator, targetBillEntry, paramList);
        targetBillEntry.set(this.finArBillModel.E_ADJUSTAMOUNT, (Object)localCalculator.getAdjustamt());
        targetBillEntry.set(this.finArBillModel.E_ADJUSTLOCALAMT, (Object)localCalculator.getAdjustamtlocal());
        targetBillEntry.set(this.finArBillModel.E_UNVERIFYAMT, (Object)localCalculator.getAmount());
        targetBillEntry.set(this.finArBillModel.E_UNINVOICEDAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.finArBillModel.E_UNLOCKAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.finArBillModel.E_UNSETTLEAMT, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.finArBillModel.E_UNSETTLELOCALAMT, (Object)localCalculator.getPricetaxtotallocal());
        targetBillEntry.set(this.finArBillModel.E_UNCONFIRMAMT, (Object)localCalculator.getAmount());
    }

    protected void resetHeadAmtField(DynamicObject targetBill, BillHeadAmtParam billHeadAmtParam) {
        super.resetHeadAmtField(targetBill, billHeadAmtParam);
        targetBill.set(this.finArBillModel.HEAD_ADJUSTAMOUNT, (Object)billHeadAmtParam.getAdjustAmt());
        targetBill.set(this.finArBillModel.HEAD_ADJUSTLOCALAMT, (Object)billHeadAmtParam.getAdjustAmtLocal());
        targetBill.set(this.finArBillModel.HEAD_UNVERIFYAMOUNT, (Object)billHeadAmtParam.getAmount());
        targetBill.set(this.finArBillModel.HEAD_UNINVOICEDAMT, (Object)billHeadAmtParam.getPriceTaxTotal());
        targetBill.set(this.finArBillModel.HEAD_UNINVOICEDLOCALAMT, (Object)billHeadAmtParam.getPriceTaxTotalLocal());
        targetBill.set(this.finArBillModel.HEAD_UNSETTLEAMOUNT, (Object)billHeadAmtParam.getPriceTaxTotal());
        targetBill.set(this.finArBillModel.HEAD_UNSETTLELOCALAMT, (Object)billHeadAmtParam.getPriceTaxTotalLocal());
    }

    protected void afterPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
        Optional<AssignBillPushParam> entryPushParamOptional;
        super.afterPush(sourEntity, sourEntryEntity, paramList, ruleId, targetBills);
        if ("ar_invoice".equals(sourEntity)) {
            this.reSetInvoicedAmt(targetBills);
        }
        if ((entryPushParamOptional = paramList.stream().filter(entryPushParam -> entryPushParam.getTarFieldValueMap().get(this.finArBillModel.E_QUANTITY) != null).findAny()).isPresent()) {
            this.reSetEntryQty(targetBills, sourEntity);
        }
        this.reSetPlanEntry(targetBills);
    }

    private void reSetInvoicedAmt(List<DynamicObject> targetBills) {
        for (DynamicObject targetBill : targetBills) {
            targetBill.set(this.finArBillModel.HEAD_INVOICEDAMT, (Object)targetBill.getBigDecimal(this.finArBillModel.HEAD_PRICETAXTOTAL));
            targetBill.set(this.finArBillModel.HEAD_INVOICEDLOCALAMT, (Object)targetBill.getBigDecimal(this.finArBillModel.HEAD_PRICETAXTOTALLOC));
            targetBill.set(this.finArBillModel.HEAD_UNINVOICEDAMT, (Object)BigDecimal.ZERO);
            targetBill.set(this.finArBillModel.HEAD_UNINVOICEDLOCALAMT, (Object)BigDecimal.ZERO);
            DynamicObjectCollection entries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject entry : entries) {
                entry.set(this.finArBillModel.E_UNINVOICEDAMT, (Object)BigDecimal.ZERO);
                entry.set(this.finArBillModel.E_UNINVOICEDLOCAMT, (Object)BigDecimal.ZERO);
                entry.set(this.finArBillModel.E_INVOICEDAMT, (Object)entry.getBigDecimal(this.finArBillModel.E_PRICETAXTOTAL));
                entry.set(this.finArBillModel.E_INVOICEDLOCAMT, (Object)entry.getBigDecimal(this.finArBillModel.E_PRICETAXTOTALLOC));
            }
        }
    }

    private void reSetEntryQty(List<DynamicObject> targetBills, String sourEntity) {
        for (DynamicObject targetBill : targetBills) {
            DynamicObjectCollection entries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject entry : entries) {
                DynamicObject baseunit = entry.getDynamicObject(this.finArBillModel.E_BASEUNIT);
                BigDecimal quantity = entry.getBigDecimal(this.finArBillModel.E_QUANTITY);
                BigDecimal covertRate = entry.getBigDecimal(this.finArBillModel.E_UNITCOEFFICIENT);
                BigDecimal baseQty = InitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseunit);
                entry.set(this.finArBillModel.E_BASEUNITQTY, (Object)baseQty);
                entry.set(this.finArBillModel.E_UNVERIFYQTY, (Object)quantity);
                entry.set(this.finArBillModel.E_UNCONFIRMQTY, (Object)quantity);
                if ("ar_invoice".equals(sourEntity)) {
                    entry.set(this.finArBillModel.E_INVOICEDQTY, (Object)quantity);
                    entry.set(this.finArBillModel.E_UNINVOICEDQTY, (Object)BigDecimal.ZERO);
                    continue;
                }
                entry.set(this.finArBillModel.E_INVOICEDQTY, (Object)BigDecimal.ZERO);
                entry.set(this.finArBillModel.E_UNINVOICEDQTY, (Object)quantity);
            }
        }
    }

    private void reSetPlanEntry(List<DynamicObject> targetBills) {
        PlanSplitAndBuilder.splitAndBuild((DynamicObject[])targetBills.toArray(new DynamicObject[0]));
    }

    protected String getTargetEntity() {
        return "ar_finarbill";
    }

    public String getServiceName() {
        return ServiceNameEnum.PUSHFINAR.getValue();
    }
}

