/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.api.settle;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.mservice.ArReceiveAutoSettleService;
import kd.fi.ar.mservice.ArReceiveSettleService;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.BaseSettleParam;
import kd.fi.arapcommon.api.param.NoAssignSettleParam;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.api.param.SettleResult;
import kd.fi.arapcommon.api.settle.AbstractSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ArRecSettleServiceImpl
extends AbstractSettleService {
    protected SettleResult doSettle(NoAssignSettleParam param) {
        if (param.isOnlyByBotp() || param.isOnlyByCoreBill()) {
            ArReceiveAutoSettleService settleService = new ArReceiveAutoSettleService();
            SettleSchemeVO scheme = param.genSchemeVO();
            settleService.batchAutoSettle(param.getMainBillIds(), param.getAsstEntity(), param.getAsstBillIds(), scheme);
            SettleResult result = new SettleResult();
            result.setSettleRecordPKs(scheme.getRecordPks());
            return result;
        }
        return super.doSettle(param);
    }

    protected String getMainEntity() {
        return "ar_finarbill";
    }

    protected String getAsstEntity() {
        return "cas_recbill";
    }

    protected DynamicObject[] getMainBills(BaseSettleParam param, Set<Long> billIds) {
        return FinArBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    protected DynamicObject[] getAsstBills(BaseSettleParam param, Set<Long> billIds) {
        Object[] recBills = RecBillHandlerHelper.load((String)param.getAsstEntity(), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        Object[] receivedBills = new DynamicObject[]{};
        if (param.isContainPre()) {
            receivedBills = RecBillHandlerHelper.load((String)"ar_receivedbill", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        return (DynamicObject[])ArrayUtils.addAll((Object[])recBills, (Object[])receivedBills);
    }

    protected void processMainBillByDetailParam(AssignSettleParam assignSettleParam, DynamicObject[] bills, List<SettleDetailParam> detailParamList, int settleModel) {
        FinArBillHandleHelper.processBillByDetailParam((AssignSettleParam)assignSettleParam, (DynamicObject[])bills, detailParamList, (int)settleModel);
    }

    protected void processAsstBillByDetailParam(AssignSettleParam assignSettleParam, DynamicObject[] bills, List<SettleDetailParam> detailParamList, int settleModel) {
        RecBillHandlerHelper.processBillByDetailParam((AssignSettleParam)assignSettleParam, (DynamicObject[])bills, detailParamList);
    }

    protected List<BillSettleVO> getMainSettleVOList(DynamicObject[] bills, SettleSchemeVO scheme) {
        return FinArBillHandleHelper.getMainListVO((DynamicObject[])bills, (SettleSchemeVO)scheme);
    }

    protected List<BillSettleVO> getAsstSettleVOList(DynamicObject[] bills, SettleSchemeVO scheme) {
        return RecBillHandlerHelper.getAsstListVO((DynamicObject[])bills);
    }

    protected AbstractSettleTemplate getService() {
        return new ArReceiveSettleService();
    }
}

