/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.api.writeoff;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.ar.helper.RevcfmWriteOffVerify;
import kd.fi.ar.vo.CheckResult;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.push.AbstractPushBillService;
import kd.fi.arapcommon.util.StringUtils;

public class RevcfmWriteOffServiceImpl
extends AbstractPushBillService {
    private String writeOffRuleId = "1281716490650811392";

    protected String getTargetEntity() {
        return "ar_revcfmbill";
    }

    public String getServiceName() {
        return ServiceNameEnum.REVCFMWRITEOFF.getValue();
    }

    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList) {
        return this.assignBillPush(sourEntity, paramList, this.writeOffRuleId);
    }

    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList, String ruleId) {
        return super.assignBillPush(sourEntity, paramList, ruleId);
    }

    protected void checkParam(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, boolean assignEntry) {
        CheckResult result;
        Set srcBillIds = paramList.stream().map(param -> param.getSourBillId()).collect(Collectors.toSet());
        if (srcBillIds.size() > 0 && !(result = RevcfmWriteOffVerify.check((Object[])srcBillIds.toArray())).isIspass()) {
            throw new KDBizException(result.getMessage());
        }
    }

    protected void setHeadFieldByParam(List<DynamicObject> targetBills, List<AssignBillPushParam> paramList) {
        block0: for (DynamicObject targetBill : targetBills) {
            DynamicObjectCollection targetBillEntries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject targetBillEntry : targetBillEntries) {
                Object sourIdObj = targetBillEntry.get(this.getTargetSourIdKey());
                if (sourIdObj == null || StringUtils.isEmpty((String)sourIdObj.toString()) || "0".equals(sourIdObj.toString())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u7684\u4e0b\u6e38\u5355\u636e\u5206\u5f55\u7684\u6e90\u5355id\u5c5e\u6027\u5b58\u5728\u7a7a\u503c\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u89c4\u5219\u662f\u5426\u914d\u7f6e\u3002", (String)"AbstractPushBillService_8", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                long sourId = Long.parseLong(sourIdObj.toString());
                Optional<AssignBillPushParam> pushBillParamOptional = paramList.stream().filter(assignBillPushParam -> sourId == assignBillPushParam.getSourBillId()).findFirst();
                if (!pushBillParamOptional.isPresent()) continue;
                AssignBillPushParam assignBillPushParam2 = pushBillParamOptional.get();
                Map tarFieldValueMap = assignBillPushParam2.getTarFieldValueMap();
                for (Map.Entry mapEntry : tarFieldValueMap.entrySet()) {
                    String fieldKey = (String)mapEntry.getKey();
                    if (!this.billModel.E_REMARK.equals(fieldKey)) continue;
                    Object fieldValue = mapEntry.getValue();
                    targetBill.set(fieldKey, fieldValue);
                }
                continue block0;
            }
        }
    }

    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList) {
        throw new KDBizException(ResManager.loadKDString((String)"\u6536\u5165\u786e\u8ba4\u5355\u51b2\u9500\u4e0d\u652f\u6301\u6307\u5b9a\u6e90\u5355\u5206\u5f55\u51b2\u9500\u3002", (String)"RevcfmWriteOffServiceImpl_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
    }

    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId) {
        throw new KDBizException(ResManager.loadKDString((String)"\u6536\u5165\u786e\u8ba4\u5355\u51b2\u9500\u4e0d\u652f\u6301\u6307\u5b9a\u6e90\u5355\u5206\u5f55\u51b2\u9500\u3002", (String)"RevcfmWriteOffServiceImpl_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
    }
}

