/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.event;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;

public class InventoryCostUpdateNoticeforOther
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(InventoryCostUpdateNoticeforOther.class);

    public Object handleEvent(KDBizEvent e) {
        String source = e.getSource();
        String eventNumber = e.getEventNumber();
        logger.info("\u5b58\u8d27\u6838\u7b97\u4e8b\u4ef6\u89e6\u53d1\uff1a\u4e8b\u4ef6\u7f16\u7801==>{}\uff0c\u4e8b\u4ef6\u53c2\u6570==>{}", (Object)eventNumber, (Object)source);
        List params = SerializationUtils.fromJsonStringToList((String)e.getSource(), Map.class);
        for (Map param : params) {
            Long orgId = (Long)param.get("org");
            Date startDate = new Date((Long)param.get("startDate"));
            Date endDate = new Date((Long)param.get("endDate"));
            List bizBillIds = (List)param.get("bizBillId");
            logger.info("\u5b58\u8d27\u6838\u7b97\u4e8b\u4ef6\u89e6\u53d1\uff1a\u4e8b\u4ef6\u7f16\u7801==>{}\uff0c\u5f00\u59cb\u65e5\u671f==>{}\uff0c\u7ed3\u675f\u65e5\u671f==>{}", new Object[]{eventNumber, startDate, endDate});
            boolean autoGetCost = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"ar_034");
            if (!autoGetCost) {
                logger.info("\u5b58\u8d27\u6838\u7b97\u4e8b\u4ef6\u89e6\u53d1\uff1a\u4e8b\u4ef6\u7f16\u7801==>{}\uff0c\u7ec4\u7ec7==>{}\u81ea\u52a8\u83b7\u53d6\u6210\u672c\u53c2\u6570\u4e3a\u5426\uff0c\u4e0d\u6267\u884c\u4e8b\u4ef6\u903b\u8f91", (Object)eventNumber, (Object)orgId);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)bizBillIds)) {
                QFilter startDateFilter = new QFilter("bookdate", ">=", (Object)startDate);
                QFilter endDateFilter = new QFilter("bookdate", "<=", (Object)endDate);
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                QFilter unverifyQtyFilter = new QFilter("billentry.unverifyqty", "=", (Object)BigDecimal.ZERO);
                QFilter logisticsBillFilter = new QFilter("billentry.logisticsbill", "=", (Object)Boolean.FALSE);
                DataSet salOutBills = QueryServiceHelper.queryDataSet((String)"InventoryCostUpdateNoticeforClosePeriod.querySalOutBills", (String)"im_saloutbill", (String)"id", (QFilter[])new QFilter[]{startDateFilter, endDateFilter, orgFilter, unverifyQtyFilter, logisticsBillFilter}, null);
                for (Row salOutBill : salOutBills) {
                    bizBillIds.add(salOutBill.getLong("id"));
                }
            }
            VerifyServiceHelper.autoGetInventoryCost(eventNumber, orgId, bizBillIds);
        }
        return e.getEventId();
    }
}

