/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordEntryVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public class ArFinVerifyHelper {
    private static final Log logger = LogFactory.getLog(ArFinVerifyHelper.class);

    public static void dispose4AsstBill(List<VerifyRecordEntryVO> entryList, SettleSchemeVO scheme, String verifyRelation) {
        HashSet<Long> finArBillIds = new HashSet<Long>(16);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (VerifyRecordEntryVO verifyRecordEntryVO : entryList) {
            if (EmptyUtils.isEmpty((Object)verifyRecordEntryVO.getBillId())) continue;
            orgIds.add(verifyRecordEntryVO.getOrgId());
            finArBillIds.add(verifyRecordEntryVO.getBillId());
        }
        Map confirmParams = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, orgIds, (String)"ar_005");
        for (VerifyRecordEntryVO entryVo : entryList) {
            long orgId = entryVo.getOrgId();
            Object ar_005 = confirmParams.get(orgId);
            if (ar_005 == null || ((Boolean)ar_005).booleanValue()) continue;
            finArBillIds.remove(entryVo.getBillId());
        }
        if (finArBillIds.size() == 0) {
            return;
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,verifystatus,unverifyamount,exchangerate,amount,entry.id,entry.e_amount,entry.e_verifiedamt,entry.e_unverifyamt,entry.e_verifiedqty,entry.e_unverifyqty,entry.e_corebilltype,entry.e_corebillno,entry.corebillid,entry.e_corebillentryseq,entry.corebillentryid,entry.e_conbillentity,entry.e_conbillnumber,entry.e_conbillrownum,entry.e_conbillid,entry.e_conbillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)});
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(dynamicObjectArray.length);
        HashMap<Long, DynamicObject> billEntryMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject bill : dynamicObjectArray) {
            billMap.put(bill.getLong("id"), bill);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                billEntryMap.put(entry.getLong("id"), entry);
            }
        }
        Object var6_9 = null;
        boolean isSettle = scheme.isSettle();
        long startTime1 = System.currentTimeMillis();
        for (VerifyRecordEntryVO entryVO : entryList) {
            long billId = entryVO.getBillId();
            long billEntryId = entryVO.getBillEntryId();
            BigDecimal settleAmt = entryVO.getSettleAmt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
            }
            DynamicObject bill = (DynamicObject)billMap.get(billId);
            DynamicObject asstEntry = (DynamicObject)billEntryMap.get(billEntryId);
            if (asstEntry == null) continue;
            BigDecimal settleamt = entryVO.getSettleAmt();
            BigDecimal verifyQty = entryVO.getVerifyQty();
            BigDecimal unverifyamount = bill.getBigDecimal("unverifyamount");
            BigDecimal entryAmount = asstEntry.getBigDecimal("e_amount");
            BigDecimal verifyquantity = asstEntry.getBigDecimal("e_verifiedqty");
            BigDecimal unverifyquantity = asstEntry.getBigDecimal("e_unverifyqty");
            BigDecimal verifyamount = asstEntry.getBigDecimal("e_verifiedamt");
            BigDecimal e_unverifyamount = asstEntry.getBigDecimal("e_unverifyamt");
            if (scheme.isSettle()) {
                if (unverifyquantity.compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.subtract(entryAmount);
                    e_unverifyamount = BigDecimal.ZERO;
                    verifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.subtract(settleamt);
                    verifyamount = verifyamount.add(settleamt);
                }
                verifyquantity = verifyquantity.add(verifyQty);
                unverifyquantity = unverifyquantity.subtract(verifyQty);
            } else {
                verifyquantity = verifyquantity.subtract(verifyQty);
                unverifyquantity = unverifyquantity.add(verifyQty);
                if (verifyquantity.compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = BigDecimal.ZERO;
                    e_unverifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = verifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.add(settleamt);
                }
            }
            bill.set("unverifyamount", (Object)unverifyamount);
            asstEntry.set("e_verifiedqty", (Object)verifyquantity);
            asstEntry.set("e_unverifyqty", (Object)unverifyquantity);
            asstEntry.set("e_verifiedamt", (Object)verifyamount);
            asstEntry.set("e_unverifyamt", (Object)e_unverifyamount);
            if (asstEntry.getLong("corebillid") != 0L || asstEntry.getLong("corebillentryid") != 0L || !scheme.isManual() || !scheme.isSettle() || !VerifyRelationEnum.ARSALOUT.getValue().equals(verifyRelation) && !VerifyRelationEnum.ARSALRETURN.getValue().equals(verifyRelation)) continue;
            asstEntry.set("e_corebilltype", (Object)entryVO.getMainBillEntity());
            asstEntry.set("e_corebillno", (Object)entryVO.getMainBillNumber());
            asstEntry.set("corebillid", (Object)entryVO.getMainBillId());
            asstEntry.set("e_corebillentryseq", (Object)entryVO.getMainBillEntrySeq());
            asstEntry.set("corebillentryid", (Object)entryVO.getMainBillEntryId());
            if (!StringUtils.isEmpty((String)asstEntry.getString("e_conbillrownum")) || asstEntry.getLong("e_conbillid") != 0L) continue;
            asstEntry.set("e_conbillentity", (Object)entryVO.getConBillEntity());
            asstEntry.set("e_conbillnumber", (Object)entryVO.getConBillNumber());
            asstEntry.set("e_conbillrownum", (Object)entryVO.getConBillRowNum());
            asstEntry.set("e_conbillid", (Object)entryVO.getConBillId());
            asstEntry.set("e_conbillentryid", (Object)entryVO.getConBillEntryId());
        }
        if (!ObjectUtils.isEmpty(billMap)) {
            for (DynamicObject bill : billMap.values()) {
                bill.set("verifystatus", (Object)VerifyServiceHelper.getBillVerifyStatus(bill));
            }
        }
        long endTime1 = System.currentTimeMillis();
        logger.info("loop ar_finarbill spend " + (endTime1 - startTime1));
        Collection objColl = billMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
    }

    public static void dispose4AsstBill(List<VerifyRecordEntryVO> entryList, SettleSchemeVO scheme) {
        ArFinVerifyHelper.dispose4AsstBill(entryList, scheme, "");
    }

    public static void dispose4MainBill(List<VerifyRecordVO> voList, SettleSchemeVO scheme) {
        HashSet<Long> finArBillIds = new HashSet<Long>(16);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (VerifyRecordVO verifyRecordVO : voList) {
            if (EmptyUtils.isEmpty((Object)verifyRecordVO.getMainBillId())) continue;
            finArBillIds.add(verifyRecordVO.getMainBillId());
            orgIds.add(verifyRecordVO.getOrgId());
        }
        Map confirmParams = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, orgIds, (String)"ar_005");
        for (VerifyRecordVO vo : voList) {
            long orgId = vo.getOrgId();
            Object ar_005 = confirmParams.get(orgId);
            if (ar_005 == null || ((Boolean)ar_005).booleanValue()) continue;
            finArBillIds.remove(vo.getMainBillId());
        }
        if (finArBillIds.size() == 0) {
            return;
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,verifystatus,unverifyamount,exchangerate,amount,entry.id,entry.e_amount,hadwrittenoff,entry.e_verifiedamt,entry.e_unverifyamt,entry.e_verifiedqty,entry.e_unverifyqty", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)});
        HashMap<Long, DynamicObject> apBillMap = new HashMap<Long, DynamicObject>(dynamicObjectArray.length);
        for (DynamicObject bill : dynamicObjectArray) {
            apBillMap.put(bill.getLong("id"), bill);
            logger.info("\u88ab\u51b2\u9500\u7684\u5e94\u6536\u5355\u5df2\u6838\u9500\u6570\u91cf\u4e3a" + bill.getBigDecimal("entry.e_verifiedqty"));
        }
        Object var5_8 = null;
        boolean isSettle = scheme.isSettle();
        for (VerifyRecordVO vo : voList) {
            DynamicObject bill;
            long billId = vo.getMainBillId();
            long billEntryId = vo.getMainBillEntryId();
            BigDecimal settleAmt = vo.getTotalSettleAmt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
            }
            if ((bill = (DynamicObject)apBillMap.get(billId)) == null) continue;
            DynamicObject asstEntry = null;
            DynamicObjectCollection collection = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : collection) {
                if (billEntryId != entry.getLong("id")) continue;
                asstEntry = entry;
                break;
            }
            if (asstEntry == null) continue;
            BigDecimal settleamt = vo.getTotalSettleAmt();
            BigDecimal verifyQty = vo.getVerifyQty();
            BigDecimal unverifyamount = bill.getBigDecimal("unverifyamount");
            BigDecimal verifyquantity = asstEntry.getBigDecimal("e_verifiedqty");
            BigDecimal entryAmount = asstEntry.getBigDecimal("e_amount");
            BigDecimal unverifyquantity = asstEntry.getBigDecimal("e_unverifyqty");
            BigDecimal verifyamount = asstEntry.getBigDecimal("e_verifiedamt");
            BigDecimal e_unverifyamount = asstEntry.getBigDecimal("e_unverifyamt");
            if (scheme.isSettle()) {
                verifyquantity = verifyquantity.add(verifyQty);
                if ((unverifyquantity = unverifyquantity.subtract(verifyQty)).compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = BigDecimal.ZERO;
                    verifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.subtract(settleamt);
                    verifyamount = verifyamount.add(settleamt);
                }
            } else {
                verifyquantity = verifyquantity.subtract(verifyQty);
                unverifyquantity = unverifyquantity.add(verifyQty);
                if (verifyquantity.compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = BigDecimal.ZERO;
                    e_unverifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = verifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.add(settleamt);
                }
            }
            bill.set("unverifyamount", (Object)unverifyamount);
            asstEntry.set("e_verifiedqty", (Object)verifyquantity);
            asstEntry.set("e_unverifyqty", (Object)unverifyquantity);
            asstEntry.set("e_verifiedamt", (Object)verifyamount);
            asstEntry.set("e_unverifyamt", (Object)e_unverifyamount);
            bill.set("verifystatus", (Object)VerifyServiceHelper.getBillVerifyStatus(bill));
        }
        Collection objColl = apBillMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
    }
}

