/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;
import kd.fi.arapcommon.service.settle.convert.BaddebtSettleVOConverter;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class BaddebtLossSettleHelper {
    public static final String SELECTOR = "id, org, billno, bizdate, billtype, sourcebillno, sourcebilltype, asstacttype, asstact, currency,quotation, exchangerate, recamt, baddebtcause, baddebtamt, baddebtlocamt, unsettleamt, remark, sourcebillid, basecurrency, entry.id, entry.e_srcentryid, entry.e_material, entry.e_expenseitem, entry.e_baddebtcause, entry.e_baddebtamt, entry.e_baddebtlocamt, entry.e_unlockamt, entry.e_lockedamt, entry.e_unsettleamt, entry.e_settledamt, entry.e_remark,planentry.p_baddebtamt,planentry.p_duedate,planentry.p_unsettleamt,planentry.p_settledamt,planentry.p_unlockamt,planentry.p_lockedamt,planentry.p_srcplanentryid";

    public static DynamicObject[] load(QFilter[] filter) {
        return BusinessDataServiceHelper.load((String)"ar_baddebtlossbill", (String)BaddebtLossSettleHelper.getSeletorOfBaddebtloss(), (QFilter[])filter, (String)"bizdate");
    }

    public static String getSeletorOfBaddebtloss() {
        String extFields = BaddebtLossSettleHelper.getExtFields("ar_baddebtlossbill");
        return SELECTOR + (StringUtils.isEmpty((String)extFields) ? "" : "," + extFields);
    }

    private static String getExtFields(String number) {
        ArrayList list = new ArrayList(1);
        List keys = SettleExtDataLoader.loadSettleRecordExtListKeys((String)number);
        keys.forEach(key -> list.add(key.getBillKey()));
        return String.join((CharSequence)",", list);
    }

    public static List<BillSettleVO> getMainListVO(DynamicObject[] mains, SettleSchemeVO scheme) {
        return BaddebtSettleVOConverter.convert2VO((DynamicObject[])mains, (SettleSchemeVO)scheme);
    }

    public static List<BillSettleVO> getAsstListVO(DynamicObject[] assts, SettleSchemeVO scheme) {
        return BaddebtLossSettleHelper.getMainListVO(assts, scheme);
    }

    public static void batchDisposeByMainBill(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
        HashSet<Long> billIdSet = new HashSet<Long>(voList.size());
        for (SettleRecordVO result : voList) {
            billIdSet.add(result.getMainBillId());
        }
        DynamicObject[] lossBills = BusinessDataServiceHelper.load((Object[])billIdSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ar_baddebtlossbill"));
        HashMap<Long, DynamicObject> idMap = new HashMap<Long, DynamicObject>(lossBills.length);
        for (DynamicObject bill : lossBills) {
            idMap.put(bill.getLong("id"), bill);
        }
        lossBills = null;
        boolean isSettle = scheme.isSettle();
        for (SettleRecordVO result : voList) {
            long mainBillId = result.getMainBillId();
            long mainBillEntryId = result.getMainBillEntryId();
            BigDecimal settleAmt = result.getTotalSettleAmt();
            BigDecimal exchangeRate = result.getExchangeRate();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
            }
            DynamicObject bill = (DynamicObject)idMap.get(mainBillId);
            scheme.setManual(SettleTypeEnum.MANUAL.getValue().equals(result.getSettleType()));
            scheme.setSchemeSettle(SettleTypeEnum.MATCH.getValue().equals(result.getSettleType()));
            if (2 == result.getSettleEntry()) {
                BaddebtLossSettleHelper.disposePlanFirst(bill, settleAmt, exchangeRate, mainBillEntryId, scheme);
                continue;
            }
            BaddebtLossSettleHelper.disposeBill(bill, settleAmt, exchangeRate, mainBillEntryId, scheme);
        }
        Collection objColl = idMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
    }

    private static void disposeBill(DynamicObject bill, BigDecimal settleAmt, BigDecimal exchangeRate, long entryId, SettleSchemeVO scheme) {
        boolean isSettle = scheme.isSettle();
        DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("entry");
        boolean needDisposeLock = false;
        for (DynamicObject detailEntry : detailColl) {
            if (detailEntry.getLong("id") != entryId) continue;
            detailEntry.set("e_settledamt", (Object)detailEntry.getBigDecimal("e_settledamt").add(settleAmt));
            detailEntry.set("e_unsettleamt", (Object)detailEntry.getBigDecimal("e_unsettleamt").subtract(settleAmt));
            if (isSettle) {
                if (scheme.isOnlyByBotp() || scheme.isTransferPay()) continue;
                detailEntry.set("e_lockedamt", (Object)detailEntry.getBigDecimal("e_lockedamt").add(settleAmt));
                detailEntry.set("e_unlockamt", (Object)detailEntry.getBigDecimal("e_unlockamt").subtract(settleAmt));
                needDisposeLock = true;
                continue;
            }
            if (!scheme.isManual() && !scheme.isSchemeSettle()) continue;
            detailEntry.set("e_lockedamt", (Object)detailEntry.getBigDecimal("e_lockedamt").add(settleAmt));
            detailEntry.set("e_unlockamt", (Object)detailEntry.getBigDecimal("e_unlockamt").subtract(settleAmt));
            needDisposeLock = true;
        }
        bill.set("unsettleamt", (Object)bill.getBigDecimal("unsettleamt").subtract(settleAmt));
        bill.set("settlestatus", (Object)BaddebtLossSettleHelper.getSettleStatus(bill.getDynamicObjectCollection("entry")));
        if (isSettle) {
            BaddebtLossSettleHelper.disposePlanEntry4Settle(settleAmt, bill.getDynamicObjectCollection("planentry"), needDisposeLock);
        } else {
            settleAmt = settleAmt.negate();
            BaddebtLossSettleHelper.disposePlanEntry4UnSettle(settleAmt, bill.getDynamicObjectCollection("planentry"), needDisposeLock);
        }
    }

    private static void disposePlanFirst(DynamicObject bill, BigDecimal settleAmt, BigDecimal exchangeRate, long entryId, SettleSchemeVO scheme) {
        boolean isSettle = scheme.isSettle();
        DynamicObjectCollection planColl = bill.getDynamicObjectCollection("planentry");
        boolean needDisposeLock = false;
        int precision = bill.getInt("currency.amtprecision");
        bill.set("unsettleamt", (Object)bill.getBigDecimal("unsettleamt").subtract(settleAmt));
        for (DynamicObject planEntry : planColl) {
            if (planEntry.getLong("id") != entryId) continue;
            planEntry.set("p_settledamt", (Object)planEntry.getBigDecimal("p_settledamt").add(settleAmt));
            planEntry.set("p_unsettleamt", (Object)planEntry.getBigDecimal("p_unsettleamt").subtract(settleAmt));
            if (isSettle) {
                if (scheme.isOnlyByBotp() || scheme.isTransferPay()) continue;
                planEntry.set("p_lockedamt", (Object)planEntry.getBigDecimal("p_lockedamt").add(settleAmt));
                planEntry.set("p_unlockamt", (Object)planEntry.getBigDecimal("p_unlockamt").subtract(settleAmt));
                needDisposeLock = true;
                continue;
            }
            if (!scheme.isManual() && !scheme.isSchemeSettle()) continue;
            planEntry.set("p_lockedamt", (Object)planEntry.getBigDecimal("p_lockedamt").add(settleAmt));
            planEntry.set("p_unlockamt", (Object)planEntry.getBigDecimal("p_unlockamt").subtract(settleAmt));
            needDisposeLock = true;
        }
        DynamicObjectCollection detailColl = bill.getDynamicObjectCollection("entry");
        BigDecimal headAmt = bill.getBigDecimal("baddebtamt");
        BigDecimal headUnSettleAmt = bill.getBigDecimal("unsettleamt");
        for (DynamicObject detailEntry : detailColl) {
            BigDecimal entryAmt = detailEntry.getBigDecimal("e_baddebtamt");
            if (isSettle && headUnSettleAmt.compareTo(BigDecimal.ZERO) == 0) {
                if (needDisposeLock) {
                    detailEntry.set("e_lockedamt", (Object)entryAmt);
                    detailEntry.set("e_unlockamt", (Object)BigDecimal.ZERO);
                }
                detailEntry.set("e_settledamt", (Object)entryAmt);
                detailEntry.set("e_unsettleamt", (Object)BigDecimal.ZERO);
                continue;
            }
            if (!isSettle && headAmt.compareTo(headUnSettleAmt) == 0) {
                if (needDisposeLock) {
                    detailEntry.set("e_lockedamt", (Object)BigDecimal.ZERO);
                    detailEntry.set("e_unlockamt", (Object)entryAmt);
                }
                detailEntry.set("e_settledamt", (Object)BigDecimal.ZERO);
                detailEntry.set("e_unsettleamt", (Object)entryAmt);
                continue;
            }
            BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
            BigDecimal curAmt = settleAmt.multiply(proportion).setScale(precision, RoundingMode.HALF_UP);
            curAmt = curAmt.abs().multiply(settleAmt.divide(settleAmt.abs()));
            if (needDisposeLock) {
                detailEntry.set("e_lockedamt", (Object)detailEntry.getBigDecimal("e_lockedamt").add(curAmt));
                detailEntry.set("e_unlockamt", (Object)detailEntry.getBigDecimal("e_unlockamt").subtract(curAmt));
            }
            detailEntry.set("e_settledamt", (Object)detailEntry.getBigDecimal("e_settledamt").add(curAmt));
            detailEntry.set("e_unsettleamt", (Object)detailEntry.getBigDecimal("e_unsettleamt").subtract(curAmt));
        }
        bill.set("settlestatus", (Object)BaddebtLossSettleHelper.getSettleStatus(bill.getDynamicObjectCollection("entry")));
    }

    private static void disposePlanEntry4Settle(BigDecimal settleAmt, DynamicObjectCollection planColl, boolean needDisposeLock) {
        for (DynamicObject planEntry : planColl) {
            BigDecimal unSettlePlanAmt = planEntry.getBigDecimal("p_unsettleamt");
            if (unSettlePlanAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal curAmt = unSettlePlanAmt.abs().compareTo(settleAmt.abs()) >= 0 ? settleAmt : unSettlePlanAmt;
            settleAmt = settleAmt.subtract(curAmt);
            planEntry.set("p_unsettleamt", (Object)unSettlePlanAmt.subtract(curAmt));
            planEntry.set("p_settledamt", (Object)planEntry.getBigDecimal("p_settledamt").add(curAmt));
            if (needDisposeLock) {
                planEntry.set("p_unlockamt", (Object)unSettlePlanAmt.subtract(curAmt));
                planEntry.set("p_lockedamt", (Object)planEntry.getBigDecimal("p_lockedamt").add(curAmt));
            }
            if (settleAmt.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
    }

    private static void disposePlanEntry4UnSettle(BigDecimal settleAmt, DynamicObjectCollection planColl, boolean needDisposeLock) {
        for (int i = planColl.size() - 1; i >= 0; --i) {
            DynamicObject planEntry = (DynamicObject)planColl.get(i);
            BigDecimal settlePlanAmt = planEntry.getBigDecimal("p_settledamt");
            if (settlePlanAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal curAmt = settlePlanAmt.abs().compareTo(settleAmt.abs()) >= 0 ? settleAmt : settlePlanAmt;
            settleAmt = settleAmt.subtract(curAmt);
            planEntry.set("p_settledamt", (Object)settlePlanAmt.subtract(curAmt));
            planEntry.set("p_unsettleamt", (Object)planEntry.getBigDecimal("p_unsettleamt").add(curAmt));
            if (needDisposeLock) {
                planEntry.set("p_lockedamt", (Object)planEntry.getBigDecimal("p_lockedamt").subtract(curAmt));
                planEntry.set("p_unlockamt", (Object)planEntry.getBigDecimal("p_unlockamt").add(curAmt));
            }
            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) break;
        }
    }

    public static String getSettleStatus(DynamicObjectCollection entryColl) {
        boolean settled = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal unsettleAmt = entry.getBigDecimal("e_unsettleamt");
            if (unsettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            settled = false;
            break;
        }
        if (settled) {
            return "settled";
        }
        boolean unSettle = true;
        for (DynamicObject entry : entryColl) {
            BigDecimal settledAmt = entry.getBigDecimal("e_settledamt");
            if (settledAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            unSettle = false;
            break;
        }
        if (unSettle) {
            return "unsettle";
        }
        return "partsettle";
    }
}

