/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.ar.mservice.SettleServiceFactory;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.UnSettleParam;

@Deprecated
public class UnSettleByReturnHelper {
    @Deprecated
    public static void unSettleByReturn(long pk) {
        UnSettleByReturnHelper.unSettle4Main(pk, null);
        UnSettleByReturnHelper.unSettle4Asst(null, pk, null);
    }

    public static void unSettleByReturn(String entityName, long pk) {
        UnSettleByReturnHelper.unSettle4Main(pk, null);
        UnSettleByReturnHelper.unSettle4Asst(entityName, pk, null);
    }

    public static void unSettleByReturn(String entityName, long pk, Date bookDate) {
        UnSettleByReturnHelper.unSettle4Main(pk, bookDate);
        UnSettleByReturnHelper.unSettle4Asst(entityName, pk, bookDate);
    }

    private static void unSettle4Main(long pk, Date bookDate) {
        QFilter filter = new QFilter("mainbillid", "=", (Object)pk);
        DynamicObject[] results = UnSettleByReturnHelper.getSettleRecords(filter, "ar_settlerecord");
        if (results != null && results.length > 0) {
            List resultIds = Arrays.stream(results).map(result -> result.getLong("id")).collect(Collectors.toList());
            String arSettleRecordRedRuleId = "750450292776019968";
            List redSettleRecords = BOTPHelper.push((String)"ar_settlerecord", (String)"ar_settlerecord", (String)arSettleRecordRedRuleId, resultIds);
            OperateOption option = OperateOption.create();
            option.setVariableValue("mutex_writeback", "false");
            if (EmptyUtils.isNotEmpty((Object)bookDate)) {
                option.setVariableValue("settleDate", DateUtils.formatString((Date)bookDate, (String)"yyyy-MM-dd HH:mm:ss"));
            }
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)saveResult);
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)submitResult);
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult((OperationResult)auditResult);
            UnSettleByReturnHelper.updateSettleRecord(results);
            Map map = SettleRecordOpHelper.classfySettleRecord((DynamicObject[])results);
            for (Map.Entry entry : map.entrySet()) {
                AbstractSettleTemplate service = UnSettleByReturnHelper.getSettleService((String)entry.getKey());
                UnSettleParam param = new UnSettleParam();
                param.setRedSettleRecord(true);
                param.setUnSettleByListOP(true);
                service.unSettle(((List)entry.getValue()).toArray(new DynamicObject[0]), param);
            }
        }
    }

    private static void unSettle4Asst(String entityName, long pk, Date bookDate) {
        AbstractSettleTemplate settle = null;
        QFilter filter = new QFilter("entry.billid", "=", (Object)pk);
        filter.and(new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE));
        DynamicObject[] results = SettleRecordQueryHelper.getSettleRecords((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (String)entityName, (Object[])new Object[]{pk}, (QFilter)filter);
        if (results.length > 0) {
            ArrayList<DynamicObject> deleteList = new ArrayList<DynamicObject>(64);
            ArrayList<Long> updateList = new ArrayList<Long>(64);
            ArrayList<Long> updateEntryList = new ArrayList<Long>(64);
            for (int j = results.length - 1; j >= 0; --j) {
                DynamicObject result2 = results[j];
                long billId = result2.getLong("id");
                DynamicObjectCollection entrys = result2.getDynamicObjectCollection("entry");
                String settleType = result2.getString("settletype");
                String settleRelation = result2.getString("settlerelation");
                settle = UnSettleByReturnHelper.getSettleService(settleRelation);
                ArrayList<SettleRecordEntryVO> entryVOList = new ArrayList<SettleRecordEntryVO>(64);
                BigDecimal totalUnsettleAmt = BigDecimal.ZERO;
                BigDecimal totalUnsettleLocalAmt = BigDecimal.ZERO;
                BigDecimal totalUnSwappl = BigDecimal.ZERO;
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if (entry.getLong("billid") != pk) continue;
                    SettleRecordEntryVO entryVO = new SettleRecordEntryVO();
                    BigDecimal settleAmt = entry.getBigDecimal("settleamt");
                    BigDecimal settleLocalAmt = entry.getBigDecimal("localsettleamt");
                    BigDecimal swappl = entry.getBigDecimal("e_swappl");
                    if (SettleRelationEnum.ARSELF.getValue().equals(settleRelation) || SettleRelationEnum.RECSELF.getValue().equals(settleRelation) || SettleRelationEnum.APSELF.getValue().equals(settleRelation) || SettleRelationEnum.PAYSELF.getValue().equals(settleRelation)) {
                        totalUnsettleAmt = totalUnsettleAmt.add(settleAmt.abs());
                        totalUnsettleLocalAmt = totalUnsettleLocalAmt.add(settleLocalAmt.abs());
                    } else {
                        totalUnsettleAmt = totalUnsettleAmt.add(settleAmt);
                        totalUnsettleLocalAmt = totalUnsettleLocalAmt.add(settleLocalAmt);
                    }
                    totalUnSwappl = totalUnSwappl.add(swappl);
                    entryVO.setSettleAmt(settleAmt);
                    entryVO.setLocalSettleAmt(settleLocalAmt);
                    entryVO.setCurrencyId(entry.getLong("currency.id"));
                    entryVO.setBillId(entry.getLong("billid"));
                    entryVO.setBillEntryId(entry.getLong("billentryid"));
                    entryVO.setBillType(entry.getString("billtype"));
                    entryVO.setExchangeRate(entry.getBigDecimal("e_exchangerate"));
                    entryVO.setSettleType(settleType);
                    entryVO.setSettleEntry(entry.getInt("e_settleentry"));
                    entryVOList.add(entryVO);
                    updateEntryList.add(entry.getLong("billid"));
                    entrys.remove((Object)entry);
                }
                SettleRecordVO resultVO = new SettleRecordVO();
                resultVO.setMainBillId(result2.getLong("mainbillid"));
                resultVO.setMainBillEntryId(result2.getLong("mainbillentryid"));
                resultVO.setBillType(result2.getString("mainbilltype"));
                resultVO.setSettleType(settleType);
                resultVO.setTotalSettleAmt(totalUnsettleAmt);
                resultVO.setLocalTotalSettleamt(totalUnsettleLocalAmt);
                resultVO.setSettleRela(settleRelation);
                resultVO.setExchangeRate(result2.getBigDecimal("exchangerate"));
                resultVO.setCorebillId(result2.getLong("corebillid"));
                resultVO.setCorebillEntryId(result2.getLong("corebillentryid"));
                resultVO.setSettleEntry(result2.getInt("settleentry"));
                resultVO.setEntrys(entryVOList);
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setSettle(false);
                scheme.setManual(SettleTypeEnum.MANUAL.getValue().equals(result2.getString("settletype")));
                scheme.setSchemeSettle(SettleTypeEnum.MATCH.getValue().equals(result2.getString("settletype")));
                scheme.setUnSettleByListOP(true);
                settle.disposeMainBill(resultVO, scheme);
                settle.disposeAsstBill(entryVOList, scheme);
                if (entrys.size() == 0) {
                    deleteList.add(result2);
                    continue;
                }
                updateList.add(result2.getLong("id"));
            }
            if (deleteList.size() > 0) {
                List resultIds = Arrays.stream(results).map(result -> result.getLong("id")).collect(Collectors.toList());
                String arSettleRecordRedRuleId = "750450292776019968";
                List redSettleRecords = BOTPHelper.push((String)"ar_settlerecord", (String)"ar_settlerecord", (String)arSettleRecordRedRuleId, resultIds);
                OperateOption option = OperateOption.create();
                option.setVariableValue("mutex_writeback", "false");
                if (EmptyUtils.isNotEmpty((Object)bookDate)) {
                    option.setVariableValue("settleDate", DateUtils.formatString((Date)bookDate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
                OperationHelper.assertResult((OperationResult)saveResult);
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
                OperationHelper.assertResult((OperationResult)submitResult);
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
                OperationHelper.assertResult((OperationResult)auditResult);
                UnSettleByReturnHelper.updateSettleRecord(results);
            }
            if (updateList.size() > 0) {
                List pushObjs = BOTPHelper.push((String)"ap_settlerecord", (String)"ap_settlerecord", (String)"733303037426151424", updateList);
                for (int i = pushObjs.size() - 1; i >= 0; --i) {
                    DynamicObject obj = (DynamicObject)pushObjs.get(i);
                    DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entry");
                    if (((DynamicObject)entrys.get(0)).getLong("billid") == pk) continue;
                    pushObjs.remove(i);
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("mutex_writeback", "false");
                if (EmptyUtils.isNotEmpty((Object)bookDate)) {
                    option.setVariableValue("settleDate", DateUtils.formatString((Date)bookDate, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_settlerecord", (DynamicObject[])pushObjs.toArray(new DynamicObject[0]), (OperateOption)option);
                OperationHelper.assertResult((OperationResult)saveResult);
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
                OperationHelper.assertResult((OperationResult)submitResult);
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
                OperationHelper.assertResult((OperationResult)auditResult);
                UnSettleByReturnHelper.updateSettleRecordEntry(updateList, updateEntryList);
            }
        }
    }

    private static DynamicObject[] getSettleRecords(QFilter filter, String entity) {
        if (!ObjectUtils.isEmpty((Object)filter)) {
            filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        }
        DynamicObject[] results = BusinessDataServiceHelper.load((String)entity, (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])filter.toArray());
        return results;
    }

    private static AbstractSettleTemplate getSettleService(String key) {
        return SettleServiceFactory.getService(key);
    }

    private static void updateSettleRecord(DynamicObject[] results) {
        if (!ObjectUtils.isEmpty((Object[])results)) {
            ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(results.length);
            ArrayList<Long> billIds = new ArrayList<Long>(results.length);
            for (int i = 0; i < results.length; ++i) {
                long billId = results[i].getLong("id");
                billIds.add(billId);
                SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)billId)};
                paramsList.add(param);
            }
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_settlerecord", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, billIds)});){
                String entrySql = "update t_ap_settlerecordentry set fhadwrittenoff='1' where fid=?";
                String sql = "update t_ap_settlerecord set fhadwrittenoff='1' where fid=?";
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)entrySql, paramsList);
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, paramsList);
            }
        }
    }

    private static void updateSettleRecordEntry(List<Long> updateList, List<Long> updateEntryList) {
        if (!ObjectUtils.isEmpty(updateEntryList)) {
            ArrayList<SqlParameter[]> entryParamsList = new ArrayList<SqlParameter[]>(updateEntryList.size());
            for (int i = 0; i < updateEntryList.size(); ++i) {
                SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fentryid", -5, (Object)updateEntryList.get(i))};
                entryParamsList.add(param);
            }
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_settlerecord", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, updateList)});){
                String sql = "update t_ap_settlerecordentry set fhadwrittenoff='1' where fentryid=?";
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, entryParamsList);
            }
        }
    }
}

