/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.service.log.OpLogInfo;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StdConfig;

public class FinArBillIssueCallbackService {
    private static final Log logger = LogFactory.getLog(FinArBillIssueCallbackService.class);
    private static final Long HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP = 1693748335779055616L;
    private static final Long HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP = 1693749472343164928L;
    private Map<Long, DynamicObject> prepareRevcfmBillMap = new HashMap<Long, DynamicObject>(8);
    private Map<Long, Map<String, Object>> orgIdParamMap = new HashMap<Long, Map<String, Object>>(8);

    public void afterProcess(DynamicObject[] finArBills) {
        this.repairFinArTailData(finArBills);
    }

    public void afterProcessSync(DynamicObject[] finArBills) {
        this.repairFinArTailDataSync(finArBills);
    }

    private void repairFinArTailData(DynamicObject[] finArBills) {
        ThreadPools.executeOnceIncludeRequestContext((String)"repairFinArTailData", () -> this.repairFinArTailDataSync(finArBills));
    }

    private void repairFinArTailDataSync(DynamicObject[] finArBills) {
        Set arPks = ((Stream)Arrays.stream(finArBills).sequential()).map(v -> v.getLong("id")).collect(Collectors.toSet());
        try (TXHandle tx = TX.required((String)"FiBotpCallBackService_repair");){
            try {
                ConcurrencyCtrlUtil.addCtrlInTX((String)"ar_finarbill", (String)"FiBotpCallBackService_repair", arPks);
                ArrayList<NeedRepairObjVO> repairObjVOS4AdjSrcBill = new ArrayList<NeedRepairObjVO>(2);
                ArrayList<NeedRepairObjVO> repairObjVOS4GenAdjBill = new ArrayList<NeedRepairObjVO>(2);
                this.filterNeedRepairFinAr(finArBills, repairObjVOS4AdjSrcBill, repairObjVOS4GenAdjBill);
                logger.info("FinArBillIssueCallbackService repairObjVOS is : " + repairObjVOS4AdjSrcBill);
                this.executeRepairTailData(repairObjVOS4AdjSrcBill);
                this.executeGenerateAdjBill(repairObjVOS4GenAdjBill);
                logger.info("FinArBillIssueCallbackService repairFinArTailData is over");
            }
            catch (Throwable e) {
                logger.error("FinArBillIssueCallbackService error " + e.getMessage());
                tx.markRollback();
            }
        }
    }

    private void executeGenerateAdjBill(List<NeedRepairObjVO> repairObjVOS) {
        logger.info("FinArBillIssueCallbackService executeGenerateAdjBill, repairObjVOS.size " + repairObjVOS.size());
        if (EmptyUtils.isEmpty(repairObjVOS)) {
            return;
        }
        HashMap<Long, Map> adjustMap = new HashMap<Long, Map>(8);
        for (NeedRepairObjVO needRepairObjVO : repairObjVOS) {
            DynamicObject dynamicObject = needRepairObjVO.getFinArBill();
            long finArBillId = dynamicObject.getLong("id");
            Map entryMap = adjustMap.getOrDefault(finArBillId, new HashMap(2));
            DynamicObject detail = (DynamicObject)dynamicObject.getDynamicObjectCollection("entry").get(needRepairObjVO.getIndex());
            long entryId = detail.getLong("id");
            entryMap.put(entryId, needRepairObjVO);
            adjustMap.put(finArBillId, entryMap);
        }
        ArrayList<DynamicObject> saveFinArBills = new ArrayList<DynamicObject>(1);
        for (Map.Entry entry : adjustMap.entrySet()) {
            Map entryMap = (Map)entry.getValue();
            PushArgs pushArgs = this.getPushArgs(entryMap.values());
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            boolean success = pushResult.isSuccess();
            if (!success) {
                throw new KDBizException(new ErrorCode("InvoiceAdjustBill", pushResult.getMessage()), new Object[]{pushResult.getBillReports()});
            }
            IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"ar_finarbill");
            List finArBills = pushResult.loadTargetDataObjects(refDataProvider, mainType);
            for (DynamicObject finArBill : finArBills) {
                BigDecimal priceTaxTotal = BigDecimal.ZERO;
                BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
                BigDecimal amount = BigDecimal.ZERO;
                BigDecimal amountBase = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                BigDecimal taxLocAmt = BigDecimal.ZERO;
                BigDecimal adjustamt = BigDecimal.ZERO;
                BigDecimal adjustamtlocal = BigDecimal.ZERO;
                DynamicObjectCollection entryColl = finArBill.getDynamicObjectCollection("entry");
                Iterator iterator = entryColl.iterator();
                while (iterator.hasNext()) {
                    DynamicObject detail = (DynamicObject)iterator.next();
                    long sourceBillId = detail.getLong("e_srcentryid");
                    NeedRepairObjVO repairObjVO = (NeedRepairObjVO)entryMap.get(sourceBillId);
                    if (repairObjVO != null) {
                        BigDecimal diffTax = repairObjVO.getSimIssuedFormTax().add(detail.getBigDecimal("e_tax"));
                        BigDecimal diffTaxLocal = repairObjVO.getSimIssuedTax().add(detail.getBigDecimal("e_taxlocalamt"));
                        BigDecimal diffAmount = repairObjVO.getSimIssuedFormAmount().add(detail.getBigDecimal("e_amount"));
                        BigDecimal diffLocalAmt = repairObjVO.getSimIssuedAmount().add(detail.getBigDecimal("e_localamt"));
                        BigDecimal diffRecAmount = repairObjVO.getSimIssuedTotalFormTaxAmount().add(detail.getBigDecimal("e_recamount"));
                        BigDecimal diffRecLocalAmt = repairObjVO.getSimIssuedTotalTaxAmount().add(detail.getBigDecimal("e_reclocalamt"));
                        detail.set("e_tax", (Object)diffTax);
                        detail.set("e_taxlocalamt", (Object)diffTaxLocal);
                        detail.set("e_amount", (Object)diffAmount);
                        detail.set("e_localamt", (Object)diffLocalAmt);
                        detail.set("e_recamount", (Object)diffRecAmount);
                        detail.set("e_reclocalamt", (Object)diffRecLocalAmt);
                        detail.set("e_unlockamt", (Object)diffRecAmount);
                        detail.set("e_unsettleamt", (Object)diffRecAmount);
                        detail.set("e_unsettlelocalamt", (Object)diffRecLocalAmt);
                        detail.set("e_uninvoicedamt", (Object)diffRecAmount);
                        detail.set("e_uninvoicedlocalamt", (Object)diffRecLocalAmt);
                        detail.set("e_unverifyamt", (Object)diffAmount);
                        detail.set("e_unconfirmamt", (Object)diffAmount);
                        priceTaxTotal = priceTaxTotal.add(detail.getBigDecimal("e_recamount"));
                        priceTaxTotalBase = priceTaxTotalBase.add(detail.getBigDecimal("e_reclocalamt"));
                        amount = amount.add(detail.getBigDecimal("e_amount"));
                        amountBase = amountBase.add(detail.getBigDecimal("e_localamt"));
                        tax = tax.add(detail.getBigDecimal("e_tax"));
                        taxLocAmt = taxLocAmt.add(detail.getBigDecimal("e_taxlocalamt"));
                        adjustamt = adjustamt.add(detail.getBigDecimal("e_adjustamount"));
                        adjustamtlocal = adjustamtlocal.add(detail.getBigDecimal("e_adjustlocalamt"));
                        continue;
                    }
                    iterator.remove();
                }
                finArBill.set("recamount", (Object)priceTaxTotal);
                finArBill.set("reclocalamt", (Object)priceTaxTotalBase);
                finArBill.set("amount", (Object)amount);
                finArBill.set("localamt", (Object)amountBase);
                finArBill.set("tax", (Object)tax);
                finArBill.set("taxlocamt", (Object)taxLocAmt);
                finArBill.set("unverifyamount", (Object)amount);
                finArBill.set("unsettleamount", (Object)priceTaxTotal);
                finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBase);
                finArBill.set("uninvoicedamt", (Object)priceTaxTotal);
                finArBill.set("uninvoicedlocalamt", (Object)priceTaxTotalBase);
                finArBill.set("adjustamount", (Object)adjustamt);
                finArBill.set("adjustlocalamt", (Object)adjustamtlocal);
                finArBill.set("billsrctype", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue());
                finArBill.set("adjusttype", (Object)"adjustinv");
                saveFinArBills.add(finArBill);
            }
        }
        if (saveFinArBills.isEmpty()) {
            return;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])saveFinArBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)operationResult);
        if (!"false".equals(StdConfig.get((String)"isInvoiceAdjustBillAutoAudit"))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "false");
            List successPkIds = operationResult.getSuccessPkIds();
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])successPkIds.toArray(new Object[0]), (OperateOption)operateOption);
            logger.info("FinArBillIssueCallbackService executeGenerateAdjBill submitResult is : " + submitResult.getAllErrorOrValidateInfo());
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])successPkIds.toArray(new Object[0]), (OperateOption)operateOption);
            logger.info("FinArBillIssueCallbackService executeGenerateAdjBill auditResult is : " + auditResult.getAllErrorOrValidateInfo());
            this.coordinateApAdjust(auditResult.getSuccessPkIds());
        }
        this.coorApAdjustSendMessage(operationResult.getSuccessPkIds());
    }

    private void coordinateApAdjust(List<Object> successPkIds) {
        logger.info("FinArBillIssueCallbackService coordinateApAdjust successPkIds is : " + successPkIds);
        if (ObjectUtils.isEmpty(successPkIds)) {
            return;
        }
        DataSet finArAdjustDataSet = QueryServiceHelper.queryDataSet((String)"query_ar_adjust", (String)"ar_finarbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", successPkIds)}, (String)"");
        HashMap<Long, Long> finAr4AdjustIdMap = new HashMap<Long, Long>(8);
        for (Row row : finArAdjustDataSet) {
            finAr4AdjustIdMap.put(Long.parseLong(row.getString("sourcebillid")), row.getLong("id"));
        }
        DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"query_fin_ar", (String)"ar_finarbill", (String)"id,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", finAr4AdjustIdMap.keySet())}, (String)"");
        ArrayList<Long> needCoordinateApAdjustIds = new ArrayList<Long>(8);
        for (Row row : finArDataSet) {
            if (!"ap_finapbill".equals(row.getString("sourcebilltype"))) continue;
            Long arAdjustIds = (Long)finAr4AdjustIdMap.get(row.getLong("id"));
            needCoordinateApAdjustIds.add(arAdjustIds);
        }
        logger.info("FinArBillIssueCallbackService coordinateApAdjust needCoordinateApAdjustIds is : " + needCoordinateApAdjustIds);
        if (needCoordinateApAdjustIds.isEmpty()) {
            return;
        }
        OperationResult coordinateapadjustResult = OperationServiceHelper.executeOperate((String)"coordinateapadjust", (String)"ar_finarbill", (Object[])needCoordinateApAdjustIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        logger.info("FinArBillIssueCallbackService coordinateApAdjust coordinateapadjustResult is : " + coordinateapadjustResult.getAllErrorOrValidateInfo());
    }

    private void coorApAdjustSendMessage(List<Object> arAdjustBillIds) {
        String invoiceCodeAndNoMessage;
        String invoiceCode;
        String invoiceNo;
        DataSet finApDataSet;
        logger.info("FinArBillIssueCallbackService coorApAdjustSendMessage begin");
        QFilter filter = new QFilter("id", "in", arAdjustBillIds);
        filter.and("billstatus", "in", Arrays.asList("A", "B"));
        DynamicObjectCollection arAdjustBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"sourcebillid", (QFilter[])new QFilter[]{filter});
        if (arAdjustBills.isEmpty()) {
            return;
        }
        ArrayList<Long> finArBillIds = new ArrayList<Long>(8);
        for (DynamicObject arAdjustBill : arAdjustBills) {
            finArBillIds.add(Long.parseLong(arAdjustBill.getString("sourcebillid")));
        }
        logger.info("FinArBillIssueCallbackService coorApAdjustSendMessage finArBillIds is : " + finArBillIds);
        DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"query_finar", (String)"ar_finarbill", (String)"id,sourcebillid,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)}, (String)"");
        ArrayList<Long> apArCoorApIds = new ArrayList<Long>(8);
        ArrayList<Long> arApCoorArIds = new ArrayList<Long>(8);
        HashSet<Long> userIds = new HashSet<Long>(8);
        for (Row arRow : finArDataSet) {
            if ("ap_finapbill".equals(arRow.getString("sourcebilltype"))) {
                apArCoorApIds.add(Long.parseLong(arRow.getString("sourcebillid")));
                continue;
            }
            arApCoorArIds.add(arRow.getLong("id"));
        }
        HashSet<String> noticeDiffApBillNos = new HashSet<String>(8);
        HashSet<String> invoiceCodeAndNoMessages = new HashSet<String>(8);
        if (!arApCoorArIds.isEmpty()) {
            finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"creator,billno,inventry.i_invoicecode,inventry.i_invoiceno,inventry.i_srctype", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", arApCoorArIds)}, (String)"");
            for (Row apRow : finApDataSet) {
                userIds.add(apRow.getLong("creator"));
                noticeDiffApBillNos.add(apRow.getString("billno"));
                if (!"6".equals(apRow.getString("inventry.i_srctype"))) continue;
                invoiceNo = apRow.getString("inventry.i_invoiceno");
                invoiceCode = apRow.getString("inventry.i_invoicecode");
                invoiceCodeAndNoMessage = this.invoiceCodeAndNoMessage(invoiceNo, invoiceCode);
                invoiceCodeAndNoMessages.add(invoiceCodeAndNoMessage);
            }
        }
        if (!apArCoorApIds.isEmpty()) {
            finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"creator,billno,inventry.i_invoicecode,inventry.i_invoiceno,inventry.i_srctype", (QFilter[])new QFilter[]{new QFilter("id", "in", apArCoorApIds)}, (String)"");
            for (Row apRow : finApDataSet) {
                userIds.add(apRow.getLong("creator"));
                noticeDiffApBillNos.add(apRow.getString("billno"));
                if (!"6".equals(apRow.getString("inventry.i_srctype"))) continue;
                invoiceNo = apRow.getString("inventry.i_invoiceno");
                invoiceCode = apRow.getString("inventry.i_invoicecode");
                invoiceCodeAndNoMessage = this.invoiceCodeAndNoMessage(invoiceNo, invoiceCode);
                invoiceCodeAndNoMessages.add(invoiceCodeAndNoMessage);
            }
        }
        logger.info("FinArBillIssueCallbackService coorApAdjustSendMessage invoiceCodeAndNoMessages is : " + invoiceCodeAndNoMessages);
        if (!userIds.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u5185\u90e8\u5f80\u6765\u4e1a\u52a1\u5f00\u7968\u63d0\u9192", (String)"FinArBillIssueCallbackService_6", (String)"fi-ar-mservice", (Object[])new Object[0]);
            String invoiceNo2 = (String)ConfigCache.get((String)"FiBotpCallBackService", (String)"invoiceNo", String.class);
            String invoiceCode2 = (String)ConfigCache.get((String)"FiBotpCallBackService", (String)"invoiceCode", String.class);
            String invoiceCodeAndNoMessage2 = this.invoiceCodeAndNoMessage(invoiceNo2, invoiceCode2);
            invoiceCodeAndNoMessages.add(invoiceCodeAndNoMessage2);
            String content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\u3002\u5185\u90e8\u5f80\u6765\u4e1a\u52a1\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\u5df2\u5168\u989d\u5f00\u7968\u3002\u4e3a\u907f\u514d\u5f80\u6765\u53cc\u65b9\u5165\u8d26\u5dee\u5f02\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3001\u5904\u7406\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0e\u53d1\u7968\u7684\u5dee\u5f02\u3002", (String)"FinArBillIssueCallbackService_2", (String)"fi-ar-mservice", (Object[])new Object[0]), String.join((CharSequence)",", noticeDiffApBillNos)) + "\n" + String.join((CharSequence)"\n", invoiceCodeAndNoMessages);
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setType("message");
            messageInfo.setTitle(title);
            messageInfo.setContent(content);
            messageInfo.setUserIds(new ArrayList(userIds));
            messageInfo.setSenderName(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91", (String)"FinArBillIssueCallbackService_1", (String)"fi-ar-mservice", (Object[])new Object[0]));
            messageInfo.setTag(ResManager.loadKDString((String)"\u5fc5\u8bfb", (String)"FinArBillIssueCallbackService_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
            messageInfo.setNotifyType(MessageChannels.MC.getNumber());
            messageInfo.setNestAppid("ap");
            messageInfo.setSource("ap");
            Map result = MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(messageInfo));
            logger.info("FinArBillIssueCallbackService coorApAdjustSendMessage sendMCMessage result : " + result);
        }
        logger.info("FinArBillIssueCallbackService coorApAdjustSendMessage end");
    }

    private String invoiceCodeAndNoMessage(String invoiceNo, String invoiceCode) {
        String invoiceCodeAndNoMessage = null;
        invoiceCodeAndNoMessage = ObjectUtils.isEmpty((Object)invoiceNo) && !ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s", (String)"FinArBillIssueCallbackService_5", (String)"fi-ar-mservice", (Object[])new Object[0]), invoiceCode) : (!ObjectUtils.isEmpty((Object)invoiceNo) && ObjectUtils.isEmpty((Object)invoiceCode) ? String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s", (String)"FinArBillIssueCallbackService_4", (String)"fi-ar-mservice", (Object[])new Object[0]), invoiceNo) : String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s\uff0c\u53d1\u7968\u4ee3\u7801\uff1a%2$s", (String)"FinArBillIssueCallbackService_3", (String)"fi-ar-mservice", (Object[])new Object[0]), invoiceNo, invoiceCode));
        return invoiceCodeAndNoMessage;
    }

    private PushArgs getPushArgs(Collection<NeedRepairObjVO> items) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(64);
        for (NeedRepairObjVO repairObjVO : items) {
            ListSelectedRow row = new ListSelectedRow();
            DynamicObject finArBill = repairObjVO.getFinArBill();
            DynamicObject detail = (DynamicObject)finArBill.getDynamicObjectCollection("entry").get(repairObjVO.getIndex());
            row.setPrimaryKeyValue(finArBill.get("id"));
            row.setEntryPrimaryKeyValue(detail.get("id"));
            row.setEntryEntityKey("ar_finarbill");
            selectedRows.add(row);
        }
        logger.info("FinArBillIssueCallbackService.getPushArgs selectedRows " + selectedRows.size());
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber("ar_finarbill");
        args.setTargetEntityNumber("ar_finarbill");
        args.setSelectedRows(selectedRows);
        args.setRuleId("646772185041512448");
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        return args;
    }

    public Map<Long, String> filterNeedRepairFinAr(DynamicObject[] finArBills, List<NeedRepairObjVO> repairObjVOS4AdjSrcBill, List<NeedRepairObjVO> repairObjVOS4GenAdjBill) {
        DynamicObjectCollection invoiceColl;
        boolean isOnlyFilter;
        HashMap<Long, String> msgMap = new HashMap<Long, String>(finArBills.length);
        if (EmptyUtils.isEmpty((Object)finArBills)) {
            return msgMap;
        }
        ArrayList<Long> finArOrgIds = new ArrayList<Long>(finArBills.length);
        ArrayList<Long> finArEntryIds = new ArrayList<Long>(finArBills.length);
        HashSet<Long> finArIds = new HashSet<Long>(finArBills.length);
        for (DynamicObject finArBill : finArBills) {
            finArOrgIds.add(finArBill.getLong("org.id"));
            finArIds.add(finArBill.getLong("id"));
            DynamicObjectCollection entry = finArBill.getDynamicObjectCollection("entry");
            List rowIds = entry.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            if (!EmptyUtils.isNotEmpty(rowIds)) continue;
            finArEntryIds.addAll(rowIds);
        }
        this.orgIdParamMap = SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.TRUE, finArOrgIds, (String[])new String[]{"ar_026", "ar_005", "ar026_type"});
        boolean bl = isOnlyFilter = repairObjVOS4GenAdjBill != null && repairObjVOS4AdjSrcBill != null;
        if (!isOnlyFilter && !(invoiceColl = QueryServiceHelper.query((String)"ar_invoice", (String)"entry.e_sourcebillid", (QFilter[])new QFilter[]{new QFilter("entry.e_sourcebillid", "in", finArIds)})).isEmpty()) {
            for (DynamicObject invoice : invoiceColl) {
                msgMap.put(invoice.getLong("entry.e_sourcebillid"), ResManager.loadKDString((String)"\u6b64\u529f\u80fd\u4ec5\u652f\u6301\u8d22\u52a1\u5e94\u6536\u5355\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u5f00\u7968\u7684\u6d41\u7a0b\u3002", (String)"ArFin4InvoiceAdjustValidator_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
            }
        }
        Map<Long, DynamicObject> adjustMap = this.prepareAdjustBill(finArOrgIds, finArIds, finArEntryIds);
        this.prepareRevcfmBillMap = this.prepareRevcfmBills(finArIds);
        Map targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap((String)"ar_finarbill", (String)"entry", (Long[])finArEntryIds.toArray(new Long[0]), (String)"sim_original_bill");
        Set<Long> botpExistOriIdSet = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map<Long, Set<DynamicObject>> recordEntryIdOriginalMap = this.getRecordEntryIdOriginalMap(finArEntryIds, targetRowIdsMap);
        logger.info("FinArBillIssueCallbackService targetRowIdsMap size is : " + targetRowIdsMap.size());
        Map<Long, DynamicObject> simEntryObjMap = this.prepareSimBills(targetRowIdsMap);
        this.updateSimEntryObj(simEntryObjMap, recordEntryIdOriginalMap, botpExistOriIdSet);
        Map<Long, Date> closeCountDateMap = this.getOrgCloseCountDate(finArOrgIds);
        for (DynamicObject finArBill : finArBills) {
            Date closeDate;
            ArrayList<NeedRepairObjVO> repairObjList = new ArrayList<NeedRepairObjVO>(2);
            boolean isNoRepair = false;
            long orgId = finArBill.getLong("org.id");
            long finArBillId = finArBill.getLong("id");
            Map<String, Object> paramMap = this.orgIdParamMap.get(orgId);
            if (ObjectUtils.isEmpty(paramMap)) continue;
            boolean isGenAdjBill = "1".equals(paramMap.get("ar026_type"));
            if (!isGenAdjBill && (closeDate = closeCountDateMap.get(orgId)) != null && closeDate.compareTo(finArBill.getDate("bookdate")) > 0) {
                logger.info("FinArBillIssueCallbackService is filtered , because by closeDate ;");
                continue;
            }
            Object ar026 = paramMap.get("ar_026");
            DynamicObject revcfmBill = this.prepareRevcfmBillMap.get(finArBillId);
            if (ar026 == null || !((Boolean)ar026).booleanValue()) {
                logger.info("FinArBillIssueCallbackService is filtered , because ar_026 is : " + ar026);
                msgMap.put(finArBillId, ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u672a\u542f\u7528\u201c\u662f\u5426\u6839\u636e\u53d1\u7968\u8c03\u5dee\u201d\u7684\u53c2\u6570\uff0c\u4e0d\u80fd\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_1", (String)"fi-ar-mservice", (Object[])new Object[0]));
                continue;
            }
            String currecyNo = finArBill.getString("basecurrency.number");
            if (!"CNY".equals(currecyNo)) {
                msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u672c\u4f4d\u5e01\u7684\u8d27\u5e01\u4ee3\u7801\u975eCNY\uff0c\u4e0d\u80fd\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_2", (String)"fi-ar-mservice", (Object[])new Object[0]));
                continue;
            }
            if (!isGenAdjBill) {
                if (finArBill.getBoolean("isvoucher")) {
                    logger.info("FinArBillIssueCallbackService is filtered , because finArBill isvoucher is true");
                    msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_3", (String)"fi-ar-mservice", (Object[])new Object[0]));
                    continue;
                }
                if (revcfmBill != null && revcfmBill.getBoolean("isvoucher")) {
                    logger.info("FinArBillIssueCallbackService is filtered , because revcfmBill isvoucher is true");
                    msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u901a\u8fc7\u7cfb\u7edf\u53c2\u6570\u201c\u5e94\u6536\u6536\u5165\u540c\u65f6\u786e\u8ba4\u201d\u81ea\u52a8\u751f\u6210\u7684\u6536\u5165\u786e\u8ba4\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_4", (String)"fi-ar-mservice", (Object[])new Object[0]));
                    continue;
                }
            }
            if (BigDecimal.ZERO.compareTo(finArBill.getBigDecimal("uninvoicedamt")) != 0 || finArBill.getBigDecimal("invoicedamt").compareTo(finArBill.getBigDecimal("recamount")) != 0) {
                logger.info("FinArBillIssueCallbackService is filtered,Because not fully invoiced");
                msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u672a\u5b8c\u5168\u5f00\u7968\uff0c\u4e0d\u80fd\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_5", (String)"fi-ar-mservice", (Object[])new Object[0]));
                continue;
            }
            if (finArBill.getBoolean("ispremium")) {
                logger.info("FinArBillIssueCallbackService is filtered , because ispremium is true");
                msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u4e3a\u8d28\u4fdd\u91d1\u5355\u636e\uff0c\u65e0\u9700\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_6", (String)"fi-ar-mservice", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection arEntry = finArBill.getDynamicObjectCollection("entry");
            for (int i = 0; i < arEntry.size(); ++i) {
                BigDecimal eSettledAmt;
                DynamicObject detail = (DynamicObject)arEntry.get(i);
                DynamicObject adjustBill = adjustMap.get(detail.getLong("id"));
                if (adjustBill != null) {
                    msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u5df2\u6839\u636e\u53d1\u7968\u5dee\u5f02\u751f\u6210\u5e94\u6536\u8c03\u6574\u5355\uff0c\u65e0\u9700\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_7", (String)"fi-ar-mservice", (Object[])new Object[0]));
                    isNoRepair = true;
                    break;
                }
                BigDecimal simIssuedAmount = BigDecimal.ZERO;
                BigDecimal simIssuedTax = BigDecimal.ZERO;
                BigDecimal simIssuedTotalTaxAmount = BigDecimal.ZERO;
                BigDecimal simIssuedLocalAmt = BigDecimal.ZERO;
                BigDecimal simIssuedLocalTax = BigDecimal.ZERO;
                BigDecimal simIssuedTotalTaxLocalAmt = BigDecimal.ZERO;
                BigDecimal eRecAmount = detail.getBigDecimal("e_recamount");
                BigDecimal eRecLocalAmt = detail.getBigDecimal("e_reclocalamt");
                Set simEntryIds = (Set)targetRowIdsMap.get(detail.getLong("id"));
                if (EmptyUtils.isNotEmpty((Object)simEntryIds)) {
                    for (Long simEntryId : simEntryIds) {
                        DynamicObject simEntryObj = simEntryObjMap.get(simEntryId);
                        if (simEntryObj == null) continue;
                        BigDecimal tempAmt = simEntryObj.getBigDecimal("issuedamount").add(simEntryObj.getBigDecimal("amountdeviation"));
                        String validState = simEntryObj.getString("validstate");
                        String closeState = simEntryObj.getString("closestatus");
                        BigDecimal entryAmount = simEntryObj.getBigDecimal("amount");
                        if (!(entryAmount.compareTo(tempAmt) == 0 || "0".equals(validState) && "1".equals(closeState))) {
                            isNoRepair = true;
                            break;
                        }
                        logger.info("FinArBillIssueCallbackService tempAmt  is : " + tempAmt);
                        BigDecimal exrate = simEntryObj.getBigDecimal("exrate");
                        if (BigDecimal.ONE.compareTo(exrate) == 0) {
                            simIssuedAmount = simIssuedAmount.add(simEntryObj.getBigDecimal("issuedamount"));
                            simIssuedTax = simIssuedTax.add(simEntryObj.getBigDecimal("issuedtax"));
                            simIssuedTotalTaxAmount = simIssuedTotalTaxAmount.add(simEntryObj.getBigDecimal("issuedtotaltaxamount"));
                        } else {
                            simIssuedAmount = simIssuedAmount.add(simEntryObj.getBigDecimal("fromissuedamount"));
                            simIssuedTax = simIssuedTax.add(simEntryObj.getBigDecimal("fromissuedtax"));
                            simIssuedTotalTaxAmount = simIssuedTotalTaxAmount.add(simEntryObj.getBigDecimal("fromissuedtaxamount"));
                        }
                        simIssuedLocalAmt = simIssuedLocalAmt.add(simEntryObj.getBigDecimal("issuedamount"));
                        simIssuedLocalTax = simIssuedLocalTax.add(simEntryObj.getBigDecimal("issuedtax"));
                        simIssuedTotalTaxLocalAmt = simIssuedTotalTaxLocalAmt.add(simEntryObj.getBigDecimal("issuedtotaltaxamount"));
                    }
                }
                if (isNoRepair) {
                    msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u4e0b\u6e38\u5f00\u7968\u7533\u8bf7\u5355\u672a\u5b8c\u5168\u5f00\u7968\uff0c\u4e0d\u80fd\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_8", (String)"fi-ar-mservice", (Object[])new Object[0]));
                    break;
                }
                if (!isGenAdjBill && simIssuedTotalTaxAmount.compareTo(eSettledAmt = detail.getBigDecimal("e_settledamt")) < 0) {
                    logger.info(String.format("FinArBillIssueCallbackService is filtered,simIssuedTotalTaxAmount is [%s],eSettledAmt is [%s]", simIssuedTotalTaxAmount, eSettledAmt));
                    msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u5df2\u5168\u90e8\u7ed3\u7b97\uff0c\u4e0d\u80fd\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_9", (String)"fi-ar-mservice", (Object[])new Object[0]));
                    continue;
                }
                BigDecimal eAmount = detail.getBigDecimal("e_amount");
                BigDecimal eLocalAmount = detail.getBigDecimal("e_localamt");
                BigDecimal eTax = detail.getBigDecimal("e_tax");
                if (eAmount.compareTo(simIssuedAmount) == 0 && eTax.compareTo(simIssuedTax) == 0 && eRecAmount.compareTo(simIssuedTotalTaxAmount) == 0 && eLocalAmount.compareTo(simIssuedLocalAmt) == 0 && eRecLocalAmt.compareTo(simIssuedTotalTaxLocalAmt) == 0) {
                    logger.info(String.format("FinArBillIssueCallbackService is filtered,eAmount is [%s],eTax is [%s],eRecAmount is [%s],simIssuedAmount is [%s],simIssuedTax is [%s],simIssuedTotalTaxAmount is [%s]", eAmount, eTax, eRecAmount, simIssuedAmount, simIssuedTax, simIssuedTotalTaxAmount));
                    msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u4e0e\u53d1\u7968\u6ca1\u6709\u5c3e\u5dee\uff0c\u65e0\u9700\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_10", (String)"fi-ar-mservice", (Object[])new Object[0]));
                    continue;
                }
                if (simIssuedAmount.compareTo(BigDecimal.ZERO) == 0 && simIssuedTax.compareTo(BigDecimal.ZERO) == 0 && simIssuedLocalAmt.compareTo(BigDecimal.ZERO) == 0 && simIssuedLocalTax.compareTo(BigDecimal.ZERO) == 0) {
                    logger.info("FinArBillIssueCallbackService is filtered, zero bill.");
                    msgMap.put(finArBillId, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u4e0e\u53d1\u7968\u6ca1\u6709\u5c3e\u5dee\uff0c\u65e0\u9700\u8c03\u5dee\u3002", (String)"ArFin4InvoiceAdjustValidator_10", (String)"fi-ar-mservice", (Object[])new Object[0]));
                    continue;
                }
                NeedRepairObjVO repairObjVO = new NeedRepairObjVO();
                repairObjVO.setFinArBill(finArBill);
                repairObjVO.setIndex(i);
                repairObjVO.setSimIssuedAmount(simIssuedLocalAmt);
                repairObjVO.setSimIssuedTax(simIssuedLocalTax);
                repairObjVO.setSimIssuedTotalTaxAmount(simIssuedTotalTaxLocalAmt);
                repairObjVO.setSimIssuedFormAmount(simIssuedAmount);
                repairObjVO.setSimIssuedFormTax(simIssuedTax);
                repairObjVO.setSimIssuedTotalFormTaxAmount(simIssuedTotalTaxAmount);
                repairObjList.add(repairObjVO);
            }
            if (isNoRepair) continue;
            if (!repairObjList.isEmpty()) {
                msgMap.remove(finArBillId);
            }
            if (!isOnlyFilter) continue;
            if (isGenAdjBill) {
                repairObjVOS4GenAdjBill.addAll(repairObjList);
                continue;
            }
            repairObjVOS4AdjSrcBill.addAll(repairObjList);
        }
        return msgMap;
    }

    private Map<Long, DynamicObject> prepareAdjustBill(List<Long> finArOrgIds, Set<Long> finArIds, List<Long> finArEntryIds) {
        DynamicObjectCollection adjustBillColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"entry.e_srcid,entry.e_srcentryid", (QFilter[])new QFilter[]{new QFilter("org.id", "in", finArOrgIds), new QFilter("entry.e_srcid", "in", finArIds), new QFilter("entry.e_srcentryid", "in", finArEntryIds), new QFilter("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue()), new QFilter("billtype.number", "=", (Object)"arfin_borrowar_BT_S"), new QFilter("adjusttype", "=", (Object)"adjustinv"), new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE)});
        return adjustBillColl.stream().collect(Collectors.toMap(bill -> bill.getLong("entry.e_srcentryid"), bill -> bill, (m, n) -> n));
    }

    protected void executeRepairTailData(List<NeedRepairObjVO> repairObjVOS) {
        if (EmptyUtils.isEmpty(repairObjVOS)) {
            return;
        }
        Map<Long, Set<DynamicObject>> arOriginalMap = this.prepareArOriginalRecords(repairObjVOS);
        HashMap<Long, DynamicObject> needToSaveFinArBillMap = new HashMap<Long, DynamicObject>(repairObjVOS.size());
        HashMap<Long, DynamicObject> needToSaveRevcfmBillMap = new HashMap<Long, DynamicObject>(this.prepareRevcfmBillMap.size());
        HashMap<Long, DynamicObject> needToSaveArOriginalRecordMap = new HashMap<Long, DynamicObject>(arOriginalMap.size());
        this.addFinArBillDiffLog(repairObjVOS, true);
        this.addArRevcfmBillDiffLog(this.prepareRevcfmBillMap.values().toArray(new DynamicObject[0]), true);
        this.addArOriginalRecordDiffLog(arOriginalMap, true);
        for (NeedRepairObjVO repairObjVO : repairObjVOS) {
            Object ar005;
            Object ar0052;
            DynamicObject finArBill = repairObjVO.getFinArBill();
            long finArBillId = finArBill.getLong("id");
            long orgId = finArBill.getLong("org.id");
            DynamicObject revcfmBill = this.prepareRevcfmBillMap.get(finArBillId);
            Set<DynamicObject> arOriginalSet = arOriginalMap.get(finArBillId);
            BigDecimal oldHeadRecAmount = finArBill.getBigDecimal("recamount");
            BigDecimal oldHeadRecLocalAmt = finArBill.getBigDecimal("reclocalamt");
            int precision = 2;
            DynamicObject currency = finArBill.getDynamicObject("currency");
            if (currency != null) {
                precision = currency.getInt("amtprecision");
            }
            int basePrecision = 2;
            DynamicObject baseCurrency = finArBill.getDynamicObject("basecurrency");
            if (baseCurrency != null) {
                basePrecision = baseCurrency.getInt("amtprecision");
            }
            if (repairObjVO.getSimIssuedTotalFormTaxAmount().compareTo(repairObjVO.getSimIssuedFormAmount().add(repairObjVO.getSimIssuedFormTax())) != 0) continue;
            DynamicObject detail = (DynamicObject)finArBill.getDynamicObjectCollection("entry").get(repairObjVO.getIndex());
            BigDecimal diffAmount = repairObjVO.getSimIssuedFormAmount().subtract(detail.getBigDecimal("e_amount"));
            BigDecimal diffTax = repairObjVO.getSimIssuedFormTax().subtract(detail.getBigDecimal("e_tax"));
            BigDecimal diffTaxLocal = repairObjVO.getSimIssuedTax().subtract(detail.getBigDecimal("e_taxlocalamt"));
            BigDecimal diffRecAmount = repairObjVO.getSimIssuedTotalFormTaxAmount().subtract(detail.getBigDecimal("e_recamount"));
            BigDecimal diffLocalAmt = repairObjVO.getSimIssuedAmount().subtract(detail.getBigDecimal("e_localamt"));
            BigDecimal diffRecLocalAmt = repairObjVO.getSimIssuedTotalTaxAmount().subtract(detail.getBigDecimal("e_reclocalamt"));
            detail.set("e_amount", (Object)repairObjVO.getSimIssuedFormAmount());
            detail.set("e_tax", (Object)repairObjVO.getSimIssuedFormTax());
            detail.set("e_taxlocalamt", (Object)repairObjVO.getSimIssuedTax());
            detail.set("e_localamt", (Object)repairObjVO.getSimIssuedAmount());
            Map<String, Object> paramMap = this.orgIdParamMap.get(orgId);
            if (!ObjectUtils.isEmpty(paramMap) && (ar0052 = paramMap.get("ar_005")) != null) {
                BigDecimal confirmedAmt = detail.getBigDecimal("e_confirmedamt");
                if (((Boolean)ar0052).booleanValue()) {
                    if (BigDecimal.ZERO.compareTo(confirmedAmt) == 0) {
                        detail.set("e_unconfirmamt", (Object)repairObjVO.getSimIssuedFormAmount());
                    } else {
                        detail.set("e_confirmedamt", (Object)repairObjVO.getSimIssuedFormAmount());
                    }
                } else {
                    BigDecimal amount = detail.getBigDecimal("e_amount");
                    BigDecimal verifiedAmt = detail.getBigDecimal("e_verifiedamt");
                    if (amount.compareTo(confirmedAmt) > 0) {
                        detail.set("e_unconfirmamt", (Object)amount.subtract(confirmedAmt));
                    }
                    if (amount.compareTo(verifiedAmt) > 0) {
                        detail.set("e_unverifyamt", (Object)amount.subtract(verifiedAmt));
                        finArBill.set("unverifyamount", (Object)finArBill.getBigDecimal("unverifyamount").add(diffAmount));
                    }
                }
            }
            BigDecimal headAmount = finArBill.getBigDecimal("amount").add(diffAmount);
            BigDecimal headLocalAmt = finArBill.getBigDecimal("localamt").add(diffLocalAmt);
            finArBill.set("amount", (Object)headAmount);
            finArBill.set("localamt", (Object)headLocalAmt);
            finArBill.set("tax", (Object)finArBill.getBigDecimal("tax").add(diffTax));
            finArBill.set("taxlocamt", (Object)finArBill.getBigDecimal("taxlocamt").add(diffTaxLocal));
            if (BigDecimal.ZERO.compareTo(diffRecAmount) != 0 || BigDecimal.ZERO.compareTo(diffRecLocalAmt) != 0) {
                detail.set("e_recamount", (Object)repairObjVO.getSimIssuedTotalFormTaxAmount());
                detail.set("e_reclocalamt", (Object)repairObjVO.getSimIssuedTotalTaxAmount());
                detail.set("e_unlockamt", (Object)detail.getBigDecimal("e_unlockamt").add(diffRecAmount));
                detail.set("e_unsettleamt", (Object)detail.getBigDecimal("e_unsettleamt").add(diffRecAmount));
                detail.set("e_unsettlelocalamt", (Object)detail.getBigDecimal("e_unsettlelocalamt").add(diffRecLocalAmt));
                detail.set("e_uninvoicedamt", (Object)detail.getBigDecimal("e_uninvoicedamt").add(diffRecAmount));
                detail.set("e_uninvoicedlocalamt", (Object)detail.getBigDecimal("e_uninvoicedlocalamt").add(diffRecLocalAmt));
                DynamicObjectCollection planEntity = finArBill.getDynamicObjectCollection("planentity");
                BigDecimal planHasUseAmt = BigDecimal.ZERO;
                BigDecimal planHasUseLocalAmt = BigDecimal.ZERO;
                for (int i = 0; i < planEntity.size(); ++i) {
                    DynamicObject planRow = (DynamicObject)planEntity.get(i);
                    BigDecimal oldPlanPriceTax = planRow.getBigDecimal("planpricetax");
                    BigDecimal oldPlanPriceLocalTax = planRow.getBigDecimal("planpricetaxloc");
                    BigDecimal diffPlanAmt = BigDecimal.ZERO;
                    BigDecimal diffPlanLocalAmt = BigDecimal.ZERO;
                    if (i == planEntity.size() - 1) {
                        diffPlanAmt = diffRecAmount.subtract(planHasUseAmt);
                        diffPlanLocalAmt = diffRecLocalAmt.subtract(planHasUseLocalAmt);
                    } else {
                        BigDecimal rate = oldPlanPriceTax.divide(oldHeadRecAmount, 10, 4);
                        diffPlanAmt = diffRecAmount.multiply(rate).setScale(precision, 4);
                        BigDecimal localRate = oldPlanPriceLocalTax.divide(oldHeadRecLocalAmt, 10, 4);
                        diffPlanLocalAmt = diffRecLocalAmt.multiply(localRate).setScale(basePrecision, 4);
                    }
                    planHasUseAmt = planHasUseAmt.add(diffPlanAmt);
                    planHasUseLocalAmt = planHasUseLocalAmt.add(diffPlanLocalAmt);
                    planRow.set("planpricetax", (Object)planRow.getBigDecimal("planpricetax").add(diffPlanAmt));
                    planRow.set("planpricetaxloc", (Object)planRow.getBigDecimal("planpricetaxloc").add(diffPlanLocalAmt));
                    planRow.set("unplanlockamt", (Object)planRow.getBigDecimal("unplanlockamt").add(diffPlanAmt));
                    planRow.set("unplansettleamt", (Object)planRow.getBigDecimal("unplansettleamt").add(diffPlanAmt));
                    planRow.set("unplansettlelocamt", (Object)planRow.getBigDecimal("unplansettlelocamt").add(diffPlanLocalAmt));
                }
                finArBill.set("recamount", (Object)oldHeadRecAmount.add(diffRecAmount));
                finArBill.set("reclocalamt", (Object)finArBill.getBigDecimal("reclocalamt").add(diffRecLocalAmt));
                finArBill.set("unsettleamount", (Object)finArBill.getBigDecimal("unsettleamount").add(diffRecAmount));
                finArBill.set("unsettlelocalamt", (Object)finArBill.getBigDecimal("unsettlelocalamt").add(diffRecLocalAmt));
                finArBill.set("uninvoicedamt", (Object)finArBill.getBigDecimal("uninvoicedamt").add(diffRecAmount));
                finArBill.set("uninvoicedlocalamt", (Object)finArBill.getBigDecimal("uninvoicedlocalamt").add(diffRecLocalAmt));
                if ("settled".equals(finArBill.getString("settlestatus"))) {
                    finArBill.set("settlestatus", (Object)"partsettle");
                }
            }
            if (!ObjectUtils.isEmpty(paramMap) && (ar005 = paramMap.get("ar_005")) != null && ((Boolean)ar005).booleanValue()) {
                DynamicObjectCollection revcfmEntry = revcfmBill.getDynamicObjectCollection("entry");
                for (DynamicObject revcfmRow : revcfmEntry) {
                    if (detail.getLong("id") != revcfmRow.getLong("e_sourcebillentryid")) continue;
                    BigDecimal confirmAmt = revcfmRow.getBigDecimal("e_confirmamt").add(diffAmount);
                    revcfmRow.set("e_amount", (Object)repairObjVO.getSimIssuedFormAmount());
                    revcfmRow.set("e_localamt", (Object)repairObjVO.getSimIssuedAmount());
                    revcfmRow.set("e_confirmamt", (Object)confirmAmt);
                    BigDecimal confirmTax = revcfmRow.getBigDecimal("e_confirmtax");
                    BigDecimal confirmTaxLoc = revcfmRow.getBigDecimal("e_confirmloctax");
                    BigDecimal confirmAmtLoc = revcfmRow.getBigDecimal("e_confirmlocamt");
                    if (confirmTax == null || confirmTaxLoc == null || confirmAmtLoc == null) continue;
                    confirmTax = confirmTax.add(diffTax);
                    revcfmRow.set("e_confirmtax", (Object)confirmTax);
                    revcfmRow.set("e_confirmloctax", (Object)confirmTaxLoc.add(diffTaxLocal));
                    revcfmRow.set("e_confirmlocamt", (Object)confirmAmtLoc.add(diffLocalAmt));
                    revcfmRow.set("e_cfmpricetax", (Object)confirmAmt.add(confirmTax));
                    revcfmRow.set("e_cfmpricetaxbase", (Object)confirmAmtLoc.add(diffLocalAmt).add(confirmTaxLoc.add(diffTaxLocal)));
                    revcfmRow.set("e_recamt", (Object)confirmAmt);
                    revcfmRow.set("e_tax", (Object)revcfmRow.getBigDecimal("e_tax").add(diffTax));
                    revcfmRow.set("e_taxlocalamt", (Object)revcfmRow.getBigDecimal("e_taxlocalamt").add(diffTaxLocal));
                    revcfmRow.set("e_pricetaxtotal", (Object)revcfmRow.getBigDecimal("e_pricetaxtotal").add(diffRecAmount));
                    revcfmRow.set("e_pricetaxtotalbase", (Object)revcfmRow.getBigDecimal("e_pricetaxtotalbase").add(diffRecLocalAmt));
                }
                revcfmBill.set("amount", (Object)revcfmBill.getBigDecimal("amount").add(diffAmount));
                revcfmBill.set("localamt", (Object)revcfmBill.getBigDecimal("localamt").add(diffLocalAmt));
                revcfmBill.set("confirmamt", (Object)revcfmBill.getBigDecimal("confirmamt").add(diffAmount));
                revcfmBill.set("confirmlocamt", (Object)revcfmBill.getBigDecimal("confirmlocamt").add(diffLocalAmt));
                revcfmBill.set("tax", (Object)revcfmBill.getBigDecimal("tax").add(diffTax));
                revcfmBill.set("taxlocamt", (Object)revcfmBill.getBigDecimal("taxlocamt").add(diffTaxLocal));
                revcfmBill.set("pricetaxtotal", (Object)revcfmBill.getBigDecimal("pricetaxtotal").add(diffRecAmount));
                revcfmBill.set("pricetaxtotalbase", (Object)revcfmBill.getBigDecimal("pricetaxtotalbase").add(diffRecLocalAmt));
                needToSaveRevcfmBillMap.put(revcfmBill.getLong("id"), revcfmBill);
            }
            if (arOriginalSet != null && arOriginalSet.size() != 0) {
                logger.info("ArOriginalWFRecordWriteOffPlugin executeRepired arOriginalSet size:" + arOriginalSet.size());
                long finArBillEntryId = detail.getLong("id");
                for (DynamicObject arOriginal : arOriginalSet) {
                    boolean verifyFieldRepaired = false;
                    long arOriginalId = arOriginal.getLong("id");
                    long finArEntryId = detail.getLong("id");
                    DynamicObjectCollection entryColl = arOriginal.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entryColl) {
                        boolean isWrittenoff = entry.getBoolean("e_iswrittenoff");
                        boolean hasWrittenoff = entry.getBoolean("e_hadwrittenoff");
                        long mainBillEntryId = entry.getLong("billentryid");
                        if (mainBillEntryId != finArBillEntryId) continue;
                        entry.set("amount", (Object)repairObjVO.getSimIssuedFormAmount());
                        entry.set("localamt", (Object)repairObjVO.getSimIssuedAmount());
                        entry.set("tax", (Object)repairObjVO.getSimIssuedFormTax());
                        entry.set("loctax", (Object)repairObjVO.getSimIssuedTax());
                        if (BigDecimal.ZERO.compareTo(diffRecAmount) != 0 || BigDecimal.ZERO.compareTo(diffRecLocalAmt) != 0) {
                            entry.set("pricetaxtotal", (Object)repairObjVO.getSimIssuedTotalFormTaxAmount());
                            entry.set("locpricetaxtotal", (Object)repairObjVO.getSimIssuedTotalTaxAmount());
                        }
                        if (isWrittenoff || hasWrittenoff || mainBillEntryId != finArEntryId || verifyFieldRepaired) continue;
                        entry.set("verifyamt", (Object)entry.getBigDecimal("verifyamt").add(diffAmount));
                        entry.set("verifylocamt", (Object)entry.getBigDecimal("verifylocamt").add(diffLocalAmt));
                        entry.set("verifytax", (Object)entry.getBigDecimal("verifytax").add(diffTax));
                        entry.set("verifyloctax", (Object)entry.getBigDecimal("verifyloctax").add(diffTaxLocal));
                        entry.set("verifypricetax", (Object)entry.getBigDecimal("verifypricetax").add(diffRecAmount));
                        entry.set("verifylocpricetax", (Object)entry.getBigDecimal("verifylocpricetax").add(diffRecLocalAmt));
                        verifyFieldRepaired = true;
                    }
                    needToSaveArOriginalRecordMap.put(arOriginalId, arOriginal);
                }
            }
            needToSaveFinArBillMap.put(finArBill.getLong("id"), finArBill);
        }
        if (EmptyUtils.isNotEmpty(needToSaveFinArBillMap)) {
            DynamicObject[] needSaveFinArArray = needToSaveFinArBillMap.values().toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])needSaveFinArArray);
            this.addFinArBillDiffLog(repairObjVOS, false);
        }
        if (EmptyUtils.isNotEmpty(needToSaveRevcfmBillMap)) {
            DynamicObject[] needToSaveRevcfArray = needToSaveRevcfmBillMap.values().toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])needToSaveRevcfArray);
            this.addArRevcfmBillDiffLog(this.prepareRevcfmBillMap.values().toArray(new DynamicObject[0]), false);
        }
        if (!ObjectUtils.isEmpty(needToSaveArOriginalRecordMap)) {
            DynamicObject[] needToSaveArOriginalArray = needToSaveArOriginalRecordMap.values().toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])needToSaveArOriginalArray);
            this.addArOriginalRecordDiffLog(arOriginalMap, false);
        }
        this.sendMessageByNotice(repairObjVOS);
    }

    private void sendMessageByNotice(List<NeedRepairObjVO> repairObjVOS) {
        String invoiceCodeAndNoMessage;
        String invoiceCode;
        String invoiceNo;
        DataSet finApDataSet;
        if (ObjectUtils.isEmpty(repairObjVOS)) {
            return;
        }
        List finArBillIds = repairObjVOS.stream().map(vo -> vo.getFinArBill().getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,sourcebilltype,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)});
        ArrayList<Long> aparApBillIds = new ArrayList<Long>(8);
        ArrayList<Long> arapArBillIds = new ArrayList<Long>(8);
        for (DynamicObject finArBill : finArBills) {
            String sourceBillType = finArBill.getString("sourcebilltype");
            if ("ap_finapbill".equals(sourceBillType)) {
                aparApBillIds.add(Long.parseLong(finArBill.getString("sourcebillid")));
                continue;
            }
            arapArBillIds.add(finArBill.getLong("id"));
        }
        logger.info("FinArBillIssueCallbackService sendMessageByNotice aparApBillIds is : " + aparApBillIds);
        logger.info("FinArBillIssueCallbackService sendMessageByNotice arapArBillIds is : " + arapArBillIds);
        HashSet<String> noticeDiffApBillNos = new HashSet<String>(8);
        HashSet<Long> userIds = new HashSet<Long>(8);
        HashSet<String> invoiceCodeAndNoMessages = new HashSet<String>(8);
        if (!arapArBillIds.isEmpty()) {
            finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"creator,billno,inventry.i_invoicecode,inventry.i_invoiceno,inventry.i_srctype", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", arapArBillIds)}, (String)"");
            for (Row apRow : finApDataSet) {
                userIds.add(apRow.getLong("creator"));
                noticeDiffApBillNos.add(apRow.getString("billno"));
                if (!"6".equals(apRow.getString("inventry.i_srctype"))) continue;
                invoiceNo = apRow.getString("inventry.i_invoiceno");
                invoiceCode = apRow.getString("inventry.i_invoicecode");
                invoiceCodeAndNoMessage = this.invoiceCodeAndNoMessage(invoiceNo, invoiceCode);
                invoiceCodeAndNoMessages.add(invoiceCodeAndNoMessage);
            }
        }
        if (!aparApBillIds.isEmpty()) {
            finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"creator,billno,inventry.i_invoicecode,inventry.i_invoiceno,inventry.i_srctype", (QFilter[])new QFilter[]{new QFilter("id", "in", aparApBillIds)}, (String)"");
            for (Row apRow : finApDataSet) {
                userIds.add(apRow.getLong("creator"));
                noticeDiffApBillNos.add(apRow.getString("billno"));
                if (!"6".equals(apRow.getString("inventry.i_srctype"))) continue;
                invoiceNo = apRow.getString("inventry.i_invoiceno");
                invoiceCode = apRow.getString("inventry.i_invoicecode");
                invoiceCodeAndNoMessage = this.invoiceCodeAndNoMessage(invoiceNo, invoiceCode);
                invoiceCodeAndNoMessages.add(invoiceCodeAndNoMessage);
            }
        }
        logger.info("FinArBillIssueCallbackService sendMessageByNotice invoiceCodeAndNoMessages is : " + invoiceCodeAndNoMessages);
        if (invoiceCodeAndNoMessages.isEmpty()) {
            return;
        }
        String content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\u3002\u5185\u90e8\u5f80\u6765\u4e1a\u52a1\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\u5df2\u5168\u989d\u5f00\u7968\u3002\u4e3a\u907f\u514d\u5f80\u6765\u53cc\u65b9\u5165\u8d26\u5dee\u5f02\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u3001\u5904\u7406\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0e\u53d1\u7968\u7684\u5dee\u5f02\u3002", (String)"FinArBillIssueCallbackService_7", (String)"fi-ap-business", (Object[])new Object[0]), String.join((CharSequence)",", noticeDiffApBillNos)) + "\n" + String.join((CharSequence)"\n", invoiceCodeAndNoMessages);
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setType("message");
        messageInfo.setTitle(ResManager.loadKDString((String)"\u5185\u90e8\u5f80\u6765\u4e1a\u52a1\u5f00\u7968\u63d0\u9192\u3002", (String)"CoordinationInvoiceService_6", (String)"fi-ap-business", (Object[])new Object[0]));
        messageInfo.setContent(content);
        messageInfo.setUserIds(new ArrayList(userIds));
        messageInfo.setSenderName(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91", (String)"FinArBillIssueCallbackService_1", (String)"fi-ar-mservice", (Object[])new Object[0]));
        messageInfo.setTag(ResManager.loadKDString((String)"\u5fc5\u8bfb", (String)"FinArBillIssueCallbackService_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
        messageInfo.setNotifyType(MessageChannels.MC.getNumber());
        messageInfo.setNestAppid("ap");
        messageInfo.setSource("ap");
        Map result = MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(messageInfo));
        logger.info("FinArBillIssueCallbackService sendMessageByNotice messageInfo result : " + result);
    }

    private Map<Long, DynamicObject> prepareRevcfmBills(Set<Long> arBillIdSet) {
        DynamicObject[] revcfmBillArray = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"billno,sourcebillid,amount,localamt,confirmamt,confirmlocamt,verifystatus,entry.e_sourcebillentryid,entry.e_amount,entry.e_localamt,entry.e_confirmamt,entry.e_unverifyamt,org,unverifyamt,entry.e_recamt,entry.e_cfmpricetax,entry.e_cfmpricetaxbase,entry.e_confirmtax,entry.e_confirmloctax,entry.e_confirmlocamt,isvoucher,entry.e_tax,entry.e_taxlocalamt,entry.e_pricetaxtotal,entry.e_pricetaxtotalbase,tax,taxlocamt,pricetaxtotal,pricetaxtotalbase", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", arBillIdSet)});
        HashMap<Long, DynamicObject> revcfmMap = new HashMap<Long, DynamicObject>(revcfmBillArray.length);
        for (DynamicObject revcfmBill : revcfmBillArray) {
            Object ar005;
            long orgId = revcfmBill.getLong("org.id");
            Map<String, Object> paramMap = this.orgIdParamMap.get(orgId);
            if (ObjectUtils.isEmpty(paramMap) || (ar005 = paramMap.get("ar_005")) == null || !((Boolean)ar005).booleanValue()) continue;
            revcfmMap.put(revcfmBill.getLong("sourcebillid"), revcfmBill);
        }
        return revcfmMap;
    }

    private Map<Long, Set<DynamicObject>> prepareArOriginalRecords(List<NeedRepairObjVO> repairObjVOS) {
        Set repairFinArIds = repairObjVOS.stream().map(vo -> vo.getFinArBill().getLong("id")).collect(Collectors.toSet());
        DynamicObject[] arOriginalArray = BusinessDataServiceHelper.load((String)"ar_originalwfrecord", (String)"entry.billno,entry.amount,entry.localamt,entry.tax,entry.loctax,entry.pricetaxtotal,entry.locpricetaxtotal,entry.verifyqty,entry.verifyamt,entry.verifylocamt,entry.verifytax,entry.verifyloctax,entry.verifypricetax,entry.verifylocpricetax,entry.billid,entry.billentryid,entry.assverifyqty,entry.assverifyamt,entry.assverifylocamt,entry.assverifytax,entry.assverifyloctax,entry.assverifypricetax,entry.assverifylocpricetax,entry.assbillid,entry.assbillentryid,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", repairFinArIds)});
        HashMap<Long, Set<DynamicObject>> resultMap = new HashMap<Long, Set<DynamicObject>>(arOriginalArray.length);
        for (DynamicObject arOriginal : arOriginalArray) {
            DynamicObjectCollection entryColl = arOriginal.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                long arBillId = entry.getLong("billid");
                Set arOriginalSet = resultMap.getOrDefault(arBillId, new HashSet(8));
                arOriginalSet.add(arOriginal);
                resultMap.put(arBillId, arOriginalSet);
            }
        }
        return resultMap;
    }

    private Map<Long, DynamicObject> prepareSimBills(Map<Long, Set<Long>> targetRowIdsMap) {
        Set simBillEntryId = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObjectCollection simBillEntry = QueryServiceHelper.query((String)"sim_original_bill", (String)"sim_original_bill_item.id entryId,sim_original_bill_item.issuedamount issuedamount,sim_original_bill_item.issuedtax issuedtax,sim_original_bill_item.issuedtotaltaxamount issuedtotaltaxamount,sim_original_bill_item.amountdeviation amountdeviation,validstate,sim_original_bill_item.amount amount,sim_original_bill_item.fromissuedamount fromissuedamount,sim_original_bill_item.fromissuedtax fromissuedtax,sim_original_bill_item.fromissuedtaxamount fromissuedtaxamount,sim_original_bill.exrate exrate,closestatus", (QFilter[])new QFilter[]{new QFilter("sim_original_bill_item.id", "in", simBillEntryId)});
        return simBillEntry.stream().collect(Collectors.toMap(sim -> sim.getLong("entryId"), sim -> sim));
    }

    private Map<Long, Set<DynamicObject>> getRecordEntryIdOriginalMap(List<Long> finArEntryIds, Map<Long, Set<Long>> targetRowIdsMap) {
        HashMap<Long, Set<DynamicObject>> recordEntryIdOriginalMap = new HashMap<Long, Set<DynamicObject>>(8);
        HashSet<Long> hxlbSet = new HashSet<Long>(2);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,entry.billentryid,entry.assbillentryid,entry.asslocamt,entry.assverifyamt,entry.assverifylocamt,entry.assverifytax,entry.assverifyloctax,entry.assverifypricetax,entry.assverifylocpricetax,entry.asscurrency,entry.assbasecurrency", (QFilter[])new QFilter[]{new QFilter("writeofftypeid", "not in", hxlbSet), new QFilter("entry.billentryid", "in", finArEntryIds)});
        for (DynamicObject record : records) {
            Long arEntryId = record.getLong("entry.billentryid");
            long oriId = record.getLong("entry.assbillentryid");
            Set originalEntryIdSet = targetRowIdsMap.getOrDefault(arEntryId, new HashSet(8));
            Set recordEntrySet = recordEntryIdOriginalMap.getOrDefault(oriId, new HashSet(8));
            originalEntryIdSet.add(oriId);
            recordEntrySet.add(record);
            recordEntryIdOriginalMap.put(oriId, recordEntrySet);
            targetRowIdsMap.put(arEntryId, originalEntryIdSet);
        }
        return recordEntryIdOriginalMap;
    }

    private void updateSimEntryObj(Map<Long, DynamicObject> simEntryObjMap, Map<Long, Set<DynamicObject>> recordEntryIdOriginalMap, Set<Long> botpExistOriIdSet) {
        if (ObjectUtils.isEmpty(recordEntryIdOriginalMap) || botpExistOriIdSet == null) {
            return;
        }
        for (Map.Entry<Long, Set<DynamicObject>> entry : recordEntryIdOriginalMap.entrySet()) {
            Long oriId = entry.getKey();
            Set<DynamicObject> recordOriginalSet = recordEntryIdOriginalMap.get(oriId);
            DynamicObject botpOriginal = simEntryObjMap.get(oriId);
            if (recordOriginalSet == null || botpOriginal == null) continue;
            BigDecimal issuedAmount = botpOriginal.getBigDecimal("issuedamount");
            BigDecimal issuedTax = botpOriginal.getBigDecimal("issuedtax");
            BigDecimal issuedPriceTax = botpOriginal.getBigDecimal("issuedtotaltaxamount");
            BigDecimal issuedLocAmount = botpOriginal.getBigDecimal("fromissuedamount");
            BigDecimal issuedLocTax = botpOriginal.getBigDecimal("fromissuedtax");
            BigDecimal issuedLocPriceTax = botpOriginal.getBigDecimal("fromissuedtaxamount");
            BigDecimal recordIssuedAmount = BigDecimal.ZERO;
            BigDecimal recordIssuedTax = BigDecimal.ZERO;
            BigDecimal recordIssuedPriceTax = BigDecimal.ZERO;
            BigDecimal recordIssuedLocAmount = BigDecimal.ZERO;
            BigDecimal recordIssuedLocTax = BigDecimal.ZERO;
            BigDecimal recordIssuedLocPriceTax = BigDecimal.ZERO;
            for (DynamicObject recordOriginal : recordOriginalSet) {
                long baseCurrency;
                boolean isSameCurr;
                BigDecimal recordAssLocAmt = recordOriginal.getBigDecimal("entry.asslocamt");
                BigDecimal recordAmount = recordOriginal.getBigDecimal("entry.assverifyamt");
                BigDecimal recordTax = recordOriginal.getBigDecimal("entry.assverifytax");
                BigDecimal recordPriceTax = recordOriginal.getBigDecimal("entry.assverifypricetax");
                BigDecimal recordLocAmount = recordOriginal.getBigDecimal("entry.assverifylocamt");
                BigDecimal recordLocTax = recordOriginal.getBigDecimal("entry.assverifyloctax");
                BigDecimal recordLocPriceTax = recordOriginal.getBigDecimal("entry.assverifylocpricetax");
                long currency = recordOriginal.getLong("entry.asscurrency");
                boolean bl = isSameCurr = currency == (baseCurrency = recordOriginal.getLong("entry.assbasecurrency"));
                if (botpExistOriIdSet.contains(oriId)) {
                    botpOriginal.set("issuedamount", (Object)issuedAmount.add(recordAmount));
                    botpOriginal.set("issuedtax", (Object)issuedTax.add(recordTax));
                    botpOriginal.set("issuedtotaltaxamount", (Object)issuedPriceTax.add(recordPriceTax));
                    botpOriginal.set("fromissuedamount", (Object)issuedLocAmount.add(recordLocAmount));
                    botpOriginal.set("fromissuedtax", (Object)issuedLocTax.add(recordLocTax));
                    botpOriginal.set("fromissuedtaxamount", (Object)issuedLocPriceTax.add(recordLocPriceTax));
                    simEntryObjMap.put(oriId, botpOriginal);
                    continue;
                }
                recordIssuedAmount = recordIssuedAmount.add(recordAmount);
                recordIssuedTax = recordIssuedTax.add(recordTax);
                recordIssuedPriceTax = recordIssuedPriceTax.add(recordPriceTax);
                recordIssuedLocAmount = recordIssuedLocAmount.add(recordLocAmount);
                recordIssuedLocTax = recordIssuedLocTax.add(recordLocTax);
                recordIssuedLocPriceTax = recordIssuedLocPriceTax.add(recordLocPriceTax);
                logger.info("ArOriginalWFRecordWriteOffPlugin updateSimEntryObj recordLocAmount " + recordLocAmount);
                logger.info("ArOriginalWFRecordWriteOffPlugin updateSimEntryObj recordAssLocAmt " + recordAssLocAmt);
                botpOriginal.set("issuedamount", (Object)recordIssuedLocAmount);
                botpOriginal.set("issuedtax", (Object)recordIssuedLocTax);
                botpOriginal.set("issuedtotaltaxamount", (Object)recordIssuedLocPriceTax);
                botpOriginal.set("fromissuedamount", (Object)(isSameCurr ? recordIssuedLocAmount : recordIssuedAmount));
                botpOriginal.set("fromissuedtax", (Object)(isSameCurr ? recordIssuedLocTax : recordIssuedTax));
                botpOriginal.set("fromissuedtaxamount", (Object)(isSameCurr ? recordIssuedLocPriceTax : recordIssuedPriceTax));
                botpOriginal.set("amount", (Object)recordAssLocAmt);
                botpOriginal.set("amountdeviation", (Object)BigDecimal.ZERO);
                simEntryObjMap.put(oriId, botpOriginal);
            }
        }
    }

    private void addLog(String opName, Object opDescription, DynamicObject[] dataEntities) {
        if (EmptyUtils.isEmpty((Object)dataEntities)) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            OpLogInfo logInfo = new OpLogInfo();
            logInfo.setClientIP(RequestContext.get().getLoginIP()).setObj(dataEntity).setOpTime(new Date()).setOpName(opName).setOpDescription(opDescription).setEntity(dataEntity.getDataEntityType().getName()).setNeedReload(false).setSaveJson(true).setUserID(Long.valueOf(RequestContext.get().getCurrUserId())).setIgnoreLogParam(true);
            OpLogServiceHelper.addLog((OpLogInfo)logInfo);
        }
    }

    private Map<Long, Date> getOrgCloseCountDate(List<Long> finArOrgIds) {
        HashMap<Long, Date> result = new HashMap<Long, Date>(finArOrgIds.size());
        if (!ObjectUtils.isEmpty(finArOrgIds)) {
            DataSet closeDateDataSet = QueryServiceHelper.queryDataSet((String)"queryCloseDateDataSet", (String)"ar_closeaccount", (String)"org,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", finArOrgIds)}, (String)"");
            for (Row row : closeDateDataSet) {
                result.put(row.getLong("org"), row.getDate("currentdate"));
            }
        }
        return result;
    }

    private void addFinArBillDiffLog(List<NeedRepairObjVO> repairObjVOS, boolean isBeforeDiff) {
        HashMap<String, List> billNoAndEntryLogMap = new HashMap<String, List>(repairObjVOS.size());
        for (NeedRepairObjVO needRepairObjVO : repairObjVOS) {
            DynamicObject finArBill = needRepairObjVO.getFinArBill();
            String billNo = finArBill.getString("billno");
            BigDecimal headAmount = finArBill.getBigDecimal("amount");
            BigDecimal headLocAmount = finArBill.getBigDecimal("localamt");
            BigDecimal headTax = finArBill.getBigDecimal("tax");
            BigDecimal headLocTax = finArBill.getBigDecimal("taxlocamt");
            BigDecimal headRecAmount = finArBill.getBigDecimal("recamount");
            BigDecimal headRecLocAmount = finArBill.getBigDecimal("reclocalamt");
            DynamicObject detail = (DynamicObject)finArBill.getDynamicObjectCollection("entry").get(needRepairObjVO.getIndex());
            List entryLogList = billNoAndEntryLogMap.getOrDefault(billNo, new ArrayList(8));
            HashMap<String, Number> entryAmountLogMap = new HashMap<String, Number>(8);
            long entryId = detail.getLong("id");
            BigDecimal entryAmount = detail.getBigDecimal("e_amount");
            BigDecimal entryLocAmt = detail.getBigDecimal("e_localamt");
            BigDecimal entryTaxLocAmt = detail.getBigDecimal("e_taxlocalamt");
            BigDecimal entryTax = detail.getBigDecimal("e_tax");
            BigDecimal entryRecAmount = detail.getBigDecimal("e_recamount");
            BigDecimal entryRecLocAmt = detail.getBigDecimal("e_reclocalamt");
            entryAmountLogMap.put("entryAmount", entryAmount);
            entryAmountLogMap.put("entryLocAmt", entryLocAmt);
            entryAmountLogMap.put("entryTaxLocAmt", entryTaxLocAmt);
            entryAmountLogMap.put("entryTax", entryTax);
            entryAmountLogMap.put("entryRecAmount", entryRecAmount);
            entryAmountLogMap.put("entryRecLocAmt", entryRecLocAmt);
            entryAmountLogMap.put("entryId", entryId);
            entryAmountLogMap.put("headAmount", headAmount);
            entryAmountLogMap.put("headLocAmount", headLocAmount);
            entryAmountLogMap.put("headTax", headTax);
            entryAmountLogMap.put("headLocTax", headLocTax);
            entryAmountLogMap.put("headRecAmount", headRecAmount);
            entryAmountLogMap.put("headRecLocAmount", headRecLocAmount);
            entryLogList.add(entryAmountLogMap);
            billNoAndEntryLogMap.put(billNo, entryLogList);
        }
        if (isBeforeDiff) {
            logger.info("FinArBillIssueCallbackService addFinArBillDiffLog diff before billNoAndEntryInfo value is :" + JsonUtils.objToJson(billNoAndEntryLogMap));
        } else {
            logger.info("FinArBillIssueCallbackService addFinArBillDiffLog diff after billNoAndEntryInfo value is :" + JsonUtils.objToJson(billNoAndEntryLogMap));
        }
        for (Map.Entry entry : billNoAndEntryLogMap.entrySet()) {
            String billNo = (String)entry.getKey();
            List finArBillDiffLogList = (List)entry.getValue();
            if (isBeforeDiff) {
                LogUtil.addOpLog((String)"ar_finarbill", (Object)billNo, (String)"beforeRepairTailData", (String)JsonUtils.objToJson((Object)finArBillDiffLogList), (boolean)true);
                continue;
            }
            LogUtil.addOpLog((String)"ar_finarbill", (Object)billNo, (String)"afterRepairTailData", (String)JsonUtils.objToJson((Object)finArBillDiffLogList), (boolean)true);
        }
    }

    private void addArRevcfmBillDiffLog(DynamicObject[] arRevcfmBillArray, boolean isBeforeDiff) {
        HashMap<String, List> billNoAndEntryLogMap = new HashMap<String, List>(arRevcfmBillArray.length);
        for (DynamicObject arRevcfmBill : arRevcfmBillArray) {
            String billNo = arRevcfmBill.getString("billno");
            BigDecimal headAmount = arRevcfmBill.getBigDecimal("amount");
            BigDecimal headLocAmount = arRevcfmBill.getBigDecimal("localamt");
            BigDecimal headTax = arRevcfmBill.getBigDecimal("tax");
            BigDecimal headLocTax = arRevcfmBill.getBigDecimal("taxlocamt");
            BigDecimal headPriceTax = arRevcfmBill.getBigDecimal("pricetaxtotal");
            BigDecimal headLocPriceTax = arRevcfmBill.getBigDecimal("pricetaxtotalbase");
            DynamicObjectCollection revcfmBillEntryColl = arRevcfmBill.getDynamicObjectCollection("entry");
            List entryLogList = billNoAndEntryLogMap.getOrDefault(billNo, new ArrayList(8));
            for (DynamicObject entry : revcfmBillEntryColl) {
                long entryId = entry.getLong("id");
                BigDecimal entryAmount = entry.getBigDecimal("e_amount");
                BigDecimal entryLocAmt = entry.getBigDecimal("e_localamt");
                BigDecimal entryTax = entry.getBigDecimal("e_tax");
                BigDecimal entryLocTax = entry.getBigDecimal("e_taxlocalamt");
                BigDecimal entryPriceTax = entry.getBigDecimal("e_pricetaxtotal");
                BigDecimal entryLocPriceTax = entry.getBigDecimal("e_pricetaxtotalbase");
                HashMap<String, Number> entryAmountLogMap = new HashMap<String, Number>(8);
                entryAmountLogMap.put("entryAmount", entryAmount);
                entryAmountLogMap.put("entryLocAmt", entryLocAmt);
                entryAmountLogMap.put("entryTax", entryTax);
                entryAmountLogMap.put("entryLocTax", entryLocTax);
                entryAmountLogMap.put("entryPriceTax", entryPriceTax);
                entryAmountLogMap.put("entryLocPriceTax", entryLocPriceTax);
                entryAmountLogMap.put("entryId", entryId);
                entryAmountLogMap.put("headAmount", headAmount);
                entryAmountLogMap.put("headLocAmount", headLocAmount);
                entryAmountLogMap.put("headTax", headTax);
                entryAmountLogMap.put("headLocTax", headLocTax);
                entryAmountLogMap.put("headPriceTax", headPriceTax);
                entryAmountLogMap.put("headLocPriceTax", headLocPriceTax);
                entryLogList.add(entryAmountLogMap);
            }
            billNoAndEntryLogMap.put(billNo, entryLogList);
        }
        if (isBeforeDiff) {
            logger.info("FinArBillIssueCallbackService addArRevcfmBillDiffLog diff before billNoAndEntryInfo value is :" + JsonUtils.objToJson(billNoAndEntryLogMap));
        } else {
            logger.info("FinArBillIssueCallbackService addArRevcfmBillDiffLog diff after billNoAndEntryInfo value is :" + JsonUtils.objToJson(billNoAndEntryLogMap));
        }
        for (Map.Entry entry : billNoAndEntryLogMap.entrySet()) {
            List arRevcfmBillRecordList = (List)entry.getValue();
            String billNo = (String)entry.getKey();
            if (isBeforeDiff) {
                LogUtil.addOpLog((String)"ar_revcfmbill", (Object)billNo, (String)"beforeRepairTailData", (String)JsonUtils.objToJson((Object)arRevcfmBillRecordList), (boolean)true);
                continue;
            }
            LogUtil.addOpLog((String)"ar_revcfmbill", (Object)billNo, (String)"afterRepairTailData", (String)JsonUtils.objToJson((Object)arRevcfmBillRecordList), (boolean)true);
        }
    }

    private void addArOriginalRecordDiffLog(Map<Long, Set<DynamicObject>> arOriginalRecordMap, boolean isBeforeDiff) {
        HashMap<String, List> billNoAndEntryLogMap = new HashMap<String, List>(arOriginalRecordMap.size());
        HashSet allArOriginalRecordSet = new HashSet(8);
        for (Map.Entry<Long, Set<DynamicObject>> entry : arOriginalRecordMap.entrySet()) {
            allArOriginalRecordSet.addAll(entry.getValue());
        }
        for (DynamicObject dynamicObject : allArOriginalRecordSet) {
            DynamicObjectCollection recordEntryColl = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject recordEntry : recordEntryColl) {
                String billNo = recordEntry.getString("billno") + "-record";
                BigDecimal finArAmount = recordEntry.getBigDecimal("amount");
                BigDecimal finArLocAmount = recordEntry.getBigDecimal("localamt");
                BigDecimal finArTax = recordEntry.getBigDecimal("tax");
                BigDecimal finArLocTax = recordEntry.getBigDecimal("loctax");
                BigDecimal finArPriceTax = recordEntry.getBigDecimal("pricetaxtotal");
                BigDecimal finArLocPriceTax = recordEntry.getBigDecimal("locpricetaxtotal");
                BigDecimal finArVerifyAmt = recordEntry.getBigDecimal("verifyamt");
                BigDecimal finArVerifyLocAmt = recordEntry.getBigDecimal("verifylocamt");
                BigDecimal finArVerifyTax = recordEntry.getBigDecimal("verifytax");
                BigDecimal finArVerifyLocTax = recordEntry.getBigDecimal("verifyloctax");
                BigDecimal finArVerifyPriceTax = recordEntry.getBigDecimal("verifypricetax");
                BigDecimal finArVerifyLocPriceTax = recordEntry.getBigDecimal("verifylocpricetax");
                long entryId = recordEntry.getLong("id");
                List entryLogList = billNoAndEntryLogMap.getOrDefault(billNo, new ArrayList(8));
                HashMap<String, Number> entryAmountLogMap = new HashMap<String, Number>(8);
                entryAmountLogMap.put("entryId", entryId);
                entryAmountLogMap.put("finArAmount", finArAmount);
                entryAmountLogMap.put("finArLocAmount", finArLocAmount);
                entryAmountLogMap.put("finArTax", finArTax);
                entryAmountLogMap.put("finArLocTax", finArLocTax);
                entryAmountLogMap.put("finArPriceTax", finArPriceTax);
                entryAmountLogMap.put("finArLocPriceTax", finArLocPriceTax);
                entryAmountLogMap.put("finArVerifyAmt", finArVerifyAmt);
                entryAmountLogMap.put("finArVerifyLocAmt", finArVerifyLocAmt);
                entryAmountLogMap.put("finArVerifyTax", finArVerifyTax);
                entryAmountLogMap.put("finArVerifyLocTax", finArVerifyLocTax);
                entryAmountLogMap.put("finArVerifyPriceTax", finArVerifyPriceTax);
                entryAmountLogMap.put("finArVerifyLocPriceTax", finArVerifyLocPriceTax);
                entryLogList.add(entryAmountLogMap);
                billNoAndEntryLogMap.put(billNo, entryLogList);
            }
        }
        if (isBeforeDiff) {
            logger.info("FinArBillIssueCallbackService addArOriginalRecordDiffLog diff before billNoAndRecordInfo value is :" + JsonUtils.objToJson(billNoAndEntryLogMap));
        } else {
            logger.info("FinArBillIssueCallbackService addArOriginalRecordDiffLog diff after billNoAndRecordInfo value is :" + JsonUtils.objToJson(billNoAndEntryLogMap));
        }
        for (Map.Entry<Long, Set<Object>> entry : billNoAndEntryLogMap.entrySet()) {
            List arRevcfmBillRecordList = (List)((Object)entry.getValue());
            String billNo = (String)((Object)entry.getKey());
            if (isBeforeDiff) {
                LogUtil.addOpLog((String)"ar_originalwfrecord", (Object)billNo, (String)"beforeRepairTailData", (String)JsonUtils.objToJson((Object)arRevcfmBillRecordList), (boolean)true);
                continue;
            }
            LogUtil.addOpLog((String)"ar_originalwfrecord", (Object)billNo, (String)"afterRepairTailData", (String)JsonUtils.objToJson((Object)arRevcfmBillRecordList), (boolean)true);
        }
    }

    protected static class NeedRepairObjVO {
        private DynamicObject finArBill;
        private int index;
        private BigDecimal simIssuedAmount;
        private BigDecimal simIssuedTax;
        private BigDecimal simIssuedTotalTaxAmount;
        private BigDecimal simIssuedFormAmount;
        private BigDecimal simIssuedFormTax;
        private BigDecimal simIssuedTotalFormTaxAmount;

        protected NeedRepairObjVO() {
        }

        public DynamicObject getFinArBill() {
            return this.finArBill;
        }

        public void setFinArBill(DynamicObject finArBill) {
            this.finArBill = finArBill;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public BigDecimal getSimIssuedAmount() {
            return this.simIssuedAmount;
        }

        public void setSimIssuedAmount(BigDecimal simIssuedAmount) {
            this.simIssuedAmount = simIssuedAmount;
        }

        public BigDecimal getSimIssuedTax() {
            return this.simIssuedTax;
        }

        public void setSimIssuedTax(BigDecimal simIssuedTax) {
            this.simIssuedTax = simIssuedTax;
        }

        public BigDecimal getSimIssuedTotalTaxAmount() {
            return this.simIssuedTotalTaxAmount;
        }

        public void setSimIssuedTotalTaxAmount(BigDecimal simIssuedTotalTaxAmount) {
            this.simIssuedTotalTaxAmount = simIssuedTotalTaxAmount;
        }

        public BigDecimal getSimIssuedFormAmount() {
            return this.simIssuedFormAmount;
        }

        public void setSimIssuedFormAmount(BigDecimal simIssuedFormAmount) {
            this.simIssuedFormAmount = simIssuedFormAmount;
        }

        public BigDecimal getSimIssuedFormTax() {
            return this.simIssuedFormTax;
        }

        public void setSimIssuedFormTax(BigDecimal simIssuedFormTax) {
            this.simIssuedFormTax = simIssuedFormTax;
        }

        public BigDecimal getSimIssuedTotalFormTaxAmount() {
            return this.simIssuedTotalFormTaxAmount;
        }

        public void setSimIssuedTotalFormTaxAmount(BigDecimal simIssuedTotalFormTaxAmount) {
            this.simIssuedTotalFormTaxAmount = simIssuedTotalFormTaxAmount;
        }

        public String toString() {
            return "NeedRepairObjVO{finArBill.id=" + this.finArBill.getLong("id") + ", index=" + this.index + ", simIssuedAmount=" + this.simIssuedAmount + ", simIssuedTax=" + this.simIssuedTax + ", simIssuedTotalTaxAmount=" + this.simIssuedTotalTaxAmount + ", simIssuedFormAmount=" + this.simIssuedFormAmount + ", simIssuedFormTax=" + this.simIssuedFormTax + ", simIssuedTotalFormTaxAmount=" + this.simIssuedTotalFormTaxAmount + '}';
        }
    }
}

