/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.invoice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.invoice.FinArBillIssueCallbackService;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArToInvoiceDiffAmtService
extends FinArBillIssueCallbackService {
    private static final Log logger = LogFactory.getLog(FinArToInvoiceDiffAmtService.class);

    public void repairFinArTailData(DynamicObject[] finArBills) {
        List<FinArBillIssueCallbackService.NeedRepairObjVO> repairObjVOS = this.filterNeedRepairFinAr(finArBills);
        logger.info("FinArToInvoiceDiffAmtService repairObjVOS is : " + repairObjVOS);
        this.executeRepairTailData(repairObjVOS);
        logger.info("FinArToInvoiceDiffAmtService repairFinArTailData is over");
    }

    protected List<FinArBillIssueCallbackService.NeedRepairObjVO> filterNeedRepairFinAr(DynamicObject[] finArBills) {
        ArrayList<FinArBillIssueCallbackService.NeedRepairObjVO> repairObjVOS = new ArrayList<FinArBillIssueCallbackService.NeedRepairObjVO>(finArBills.length);
        if (EmptyUtils.isEmpty((Object)finArBills)) {
            return repairObjVOS;
        }
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"amtprecision,number,id", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0)});
        ArrayList finArEntryIds = new ArrayList(finArBills.length);
        for (DynamicObject finArBill : finArBills) {
            DynamicObjectCollection entry;
            List rowIds;
            if (finArBill.getBoolean("ispremium") || !EmptyUtils.isNotEmpty(rowIds = (entry = finArBill.getDynamicObjectCollection("entry")).stream().map(row -> row.getLong("id")).collect(Collectors.toList()))) continue;
            finArEntryIds.addAll(rowIds);
        }
        Map targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap((String)"ar_finarbill", (String)"entry", (Long[])finArEntryIds.toArray(new Long[0]), (String)"ar_invoice");
        logger.info("FiBotpCallBackService targetRowIdsMap size is : " + targetRowIdsMap.size());
        Map<Long, DynamicObject> simEntryObjMap = this.prepareInvoiceBills(targetRowIdsMap);
        for (DynamicObject finArBill : finArBills) {
            DynamicObjectCollection arEntry = finArBill.getDynamicObjectCollection("entry");
            for (int i = 0; i < arEntry.size(); ++i) {
                FinArBillIssueCallbackService.NeedRepairObjVO repairObjVO = new FinArBillIssueCallbackService.NeedRepairObjVO();
                DynamicObject detail = (DynamicObject)arEntry.get(i);
                BigDecimal invIssuedAmount = BigDecimal.ZERO;
                BigDecimal invIssuedTax = BigDecimal.ZERO;
                BigDecimal invIssuedTotalTaxAmount = BigDecimal.ZERO;
                BigDecimal invIssuedLocalAmt = BigDecimal.ZERO;
                BigDecimal invIssuedLocalTax = BigDecimal.ZERO;
                BigDecimal invIssuedTotalTaxLocalAmt = BigDecimal.ZERO;
                Set InvEntryIds = (Set)targetRowIdsMap.get(detail.getLong("id"));
                if (EmptyUtils.isNotEmpty((Object)InvEntryIds)) {
                    for (Long invEntryId : InvEntryIds) {
                        BigDecimal edifftax;
                        BigDecimal ediffamt;
                        DynamicObject invEntryObj = simEntryObjMap.get(invEntryId);
                        if (invEntryObj == null) continue;
                        BigDecimal exrate = invEntryObj.getBigDecimal("exchangerate");
                        BigDecimal elocalamt = invEntryObj.getBigDecimal("elocalamt");
                        BigDecimal ereclocalamt = invEntryObj.getBigDecimal("ereclocalamt");
                        BigDecimal eamt = invEntryObj.getBigDecimal("eamount");
                        BigDecimal etax = invEntryObj.getBigDecimal("etax");
                        BigDecimal erecamount = invEntryObj.getBigDecimal("erecamount");
                        Object currencyId = invEntryObj.get("currency");
                        DynamicObject currency = (DynamicObject)currencyMap.get(currencyId);
                        int scale = currency.getInt("amtprecision");
                        BigDecimal ediffamtLocal = invEntryObj.getBigDecimal("ediffamt");
                        BigDecimal edifftaxLocal = invEntryObj.getBigDecimal("edifftax");
                        if (BigDecimal.ONE.compareTo(exrate) == 0) {
                            ediffamt = ediffamtLocal;
                            edifftax = edifftaxLocal;
                        } else {
                            String quotation = invEntryObj.getString("quotation");
                            if ("0".equals(quotation)) {
                                ediffamt = ediffamtLocal.divide(exrate, scale, RoundingMode.HALF_UP);
                                edifftax = edifftaxLocal.divide(exrate, scale, RoundingMode.HALF_UP);
                            } else {
                                ediffamt = ediffamtLocal.multiply(exrate).setScale(scale, RoundingMode.HALF_UP);
                                edifftax = edifftaxLocal.multiply(exrate).setScale(scale, RoundingMode.HALF_UP);
                            }
                        }
                        invIssuedAmount = invIssuedAmount.add(eamt.subtract(ediffamt));
                        invIssuedTax = invIssuedTax.add(etax.subtract(edifftax));
                        invIssuedTotalTaxAmount = invIssuedTotalTaxAmount.add(erecamount.subtract(ediffamt).subtract(edifftax));
                        invIssuedLocalAmt = invIssuedLocalAmt.add(elocalamt.subtract(ediffamtLocal));
                        BigDecimal eTaxInv = ereclocalamt.subtract(elocalamt);
                        invIssuedLocalTax = invIssuedLocalTax.add(eTaxInv.subtract(edifftaxLocal));
                        invIssuedTotalTaxLocalAmt = invIssuedTotalTaxLocalAmt.add(ereclocalamt.subtract(ediffamtLocal).subtract(edifftaxLocal));
                    }
                }
                repairObjVO.setFinArBill(finArBill);
                repairObjVO.setIndex(i);
                repairObjVO.setSimIssuedAmount(invIssuedLocalAmt);
                repairObjVO.setSimIssuedTax(invIssuedLocalTax);
                repairObjVO.setSimIssuedTotalTaxAmount(invIssuedTotalTaxLocalAmt);
                repairObjVO.setSimIssuedFormAmount(invIssuedAmount);
                repairObjVO.setSimIssuedFormTax(invIssuedTax);
                repairObjVO.setSimIssuedTotalFormTaxAmount(invIssuedTotalTaxAmount);
                repairObjVOS.add(repairObjVO);
            }
        }
        return repairObjVOS;
    }

    private Map<Long, DynamicObject> prepareInvoiceBills(Map<Long, Set<Long>> targetRowIdsMap) {
        Set invBillEntryId = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObjectCollection simBillEntry = QueryServiceHelper.query((String)"ar_invoice", (String)"entry.id entryId,entry.e_amount eamount,entry.e_tax etax,entry.e_recamount erecamount,entry.e_diffamount ediffamt,entry.e_difftax edifftax,entry.e_reclocalamt ereclocalamt,entry.e_localamt elocalamt,currency,exchangerate,quotation,basecurrency", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", invBillEntryId).and("invoicestatus", "=", (Object)"1")});
        return simBillEntry.stream().collect(Collectors.toMap(invoice -> invoice.getLong("entryId"), invoice -> invoice));
    }
}

