/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.kdtx.ec;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.api.settle.ISettleService;
import kd.fi.arapcommon.enums.SettleDetailTypeEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.kdtx.ec.service.DefaultECServiceIdempotentProperties;
import kd.fi.arapcommon.service.ext.SettleExtDataLoader;

public class ReceitpClaimSettleESCService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(ReceitpClaimSettleESCService.class);

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        CommonParam ecParam = (CommonParam)param;
        List claimMaps = (List)param;
        HashSet<Long> recBillIds = new HashSet<Long>(16);
        AssignSettleParam settleParam = new AssignSettleParam(0L, SettleTypeEnum.AUTO.getValue(), SettleDetailTypeEnum.BYENTRY.getValue());
        settleParam.setClaim(true);
        ArrayList<SettleDetailParam> mainDetailParam = new ArrayList<SettleDetailParam>(2);
        ArrayList<SettleDetailParam> asstDetailParam = new ArrayList<SettleDetailParam>(2);
        for (Map recParam : claimMaps) {
            Long arBillId = (Long)recParam.get("corebillid");
            Long recBillId = (Long)recParam.get("recbillid");
            Long arEntryId = (Long)recParam.get("corebillentryid");
            Long recBillEntryId = (Long)recParam.get("recbillentryid");
            recBillIds.add(recBillId);
            BigDecimal settleAmt = (BigDecimal)recParam.get("receivableamt");
            String matchKey = arEntryId + "_" + recBillEntryId;
            SettleDetailParam mainParam = new SettleDetailParam(arBillId.longValue(), arEntryId.longValue(), settleAmt);
            mainParam.setMatchFieldValue("entryidstr", (Object)matchKey);
            SettleDetailParam asstParam = new SettleDetailParam(recBillId.longValue(), recBillEntryId.longValue(), settleAmt);
            asstParam.setMatchFieldValue("entryidstr", (Object)matchKey);
            mainDetailParam.add(mainParam);
            asstDetailParam.add(asstParam);
        }
        settleParam.setMainDetailParamList(mainDetailParam);
        settleParam.setAsstDetailParamList(asstDetailParam);
        settleParam.setMatchServiceClass("kd.fi.arapcommon.service.match.RecepitClaimMatchService");
        ISettleService service = ArApServiceAPIFactory.getSettleService((String)ServiceNameEnum.ARRECSETTLE.getValue());
        service.assignSettle(settleParam);
        this.assignJournal(recBillIds);
        return null;
    }

    private void assignJournal(Set<Long> recBillIds) {
        String selectors = String.join((CharSequence)",", this.getSelector());
        DynamicObject[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", recBillIds)});
        Object[] needSettleRecBills = (DynamicObject[])Arrays.stream(recBills).filter(recBill -> recBill.getBoolean("receivingtype.ispartreceivable")).toArray(DynamicObject[]::new);
        logger.info("confirmRec needSettleRecBills length :" + needSettleRecBills.length);
        if (ObjectUtils.isEmpty((Object[])needSettleRecBills)) {
            return;
        }
        JournalService journalService = new JournalService();
        journalService.pushAndSaveJournals((DynamicObject[])needSettleRecBills);
    }

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(50);
        lst.add("billno");
        lst.add("biztype");
        lst.add("bizdate");
        lst.add("billstatus");
        lst.add("txt_description");
        lst.add("receivingtype");
        lst.add("payertype");
        lst.add("org");
        lst.add("accountbank");
        lst.add("accountcash");
        lst.add("payeebank");
        lst.add("payer");
        lst.add("payerformid");
        lst.add("payeracctbank");
        lst.add("payeraccformid");
        lst.add("payername");
        lst.add("payeracctbanknum");
        lst.add("payerbankname");
        lst.add("f7_payerbank");
        lst.add("cashier");
        lst.add("payeedate");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("isagent");
        lst.add("accountcash");
        lst.add("actrecamt");
        lst.add("currency");
        lst.add("quotation");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("bankcheckflag");
        lst.add("entry");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("realreccompany");
        lst.add("e_receivableamt");
        lst.add("e_sourcebillentryid");
        lst.add("e_unsettledamt");
        lst.add("e_settledamt");
        lst.add("e_material");
        lst.add("e_expenseitem");
        lst.add("e_corebilltype");
        lst.add("e_corebillno");
        lst.add("e_corebillentryseq");
        lst.add("e_settleorg");
        lst.add("basecurrency");
        List keys = SettleExtDataLoader.loadSettleRecordExtListKeys((String)"cas_recbill");
        keys.forEach(v -> lst.add(v.getBillKey()));
        return lst;
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultECServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

