/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.kdtx.ec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.kdtx.ec.service.DefaultECServiceIdempotentProperties;
import kd.fi.arapcommon.util.StringUtils;

public class VerifyDisposeCollBillECService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(VerifyDisposeCollBillECService.class);

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultECServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        CommonParam ecParam = (CommonParam)param;
        List disposeList = (List)ecParam.get((Object)"disposeList");
        if (disposeList == null || disposeList.size() == 0) {
            return null;
        }
        Boolean isAr = (Boolean)((Map)disposeList.get(0)).get("isar");
        if (isAr.booleanValue()) {
            this.disposeRevcfmBill(disposeList);
        } else {
            this.disposeFinApBill(disposeList);
        }
        return null;
    }

    private void disposeFinApBill(List<Map<String, Object>> disposeList) {
        HashSet<Long> finApBillIds = new HashSet<Long>(disposeList.size());
        for (Map<String, Object> disposeInfo : disposeList) {
            Long finApBillId = (Long)disposeInfo.get("id");
            if (finApBillId == null || finApBillId == 0L) continue;
            finApBillIds.add(finApBillId);
        }
        if (finApBillIds.size() == 0) {
            return;
        }
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,detailentry.corebilltype,detailentry.corebillno,detailentry.corebillid,detailentry.corebillentryseq,detailentry.corebillentryid,detailentry.e_conbillentity,detailentry.e_conbillnumber,detailentry.e_conbillrownum,detailentry.e_conbillid,detailentry.e_conbillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
        HashMap<Long, DynamicObject> finApBillMap = new HashMap<Long, DynamicObject>(apBills.length);
        HashMap<Long, DynamicObject> finApEntryMap = new HashMap<Long, DynamicObject>(apBills.length);
        for (DynamicObject bill : apBills) {
            finApBillMap.put(bill.getLong("id"), bill);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                finApEntryMap.put(row.getLong("id"), row);
            }
        }
        for (Map map : disposeList) {
            boolean flag;
            Long id = (Long)map.get("id");
            Long entryId = (Long)map.get("entryid");
            boolean isManual = (Boolean)map.get("ismanual");
            String verifyRelation = (String)map.get("verifyrelation");
            DynamicObject finApBill = (DynamicObject)finApBillMap.get(id);
            DynamicObject entry = (DynamicObject)finApEntryMap.get(entryId);
            if (finApBill == null || entry == null) continue;
            boolean bl = flag = isManual && (VerifyRelationEnum.APPURIN.getValue().equals(verifyRelation) || VerifyRelationEnum.APPURRECED.getValue().equals(verifyRelation) || VerifyRelationEnum.APPURRETURN.getValue().equals(verifyRelation));
            if (flag && entry.getLong("corebillid") == 0L && entry.getLong("corebillentryid") == 0L) {
                entry.set("corebilltype", map.get("corebilltype"));
                entry.set("corebillno", map.get("corebillno"));
                entry.set("corebillid", map.get("corebillid"));
                entry.set("corebillentryseq", map.get("corebillentryseq"));
                entry.set("corebillentryid", map.get("corebillentryid"));
            }
            if (!flag || entry.getLong("e_conbillid") != 0L || !StringUtils.isEmpty((String)entry.getString("e_conbillnumber"))) continue;
            entry.set("e_conbillentity", map.get("conbillentity"));
            entry.set("e_conbillnumber", map.get("conbillnumber"));
            entry.set("e_conbillrownum", map.get("conbillrownum"));
            entry.set("e_conbillid", map.get("conbillid"));
            entry.set("e_conbillentryid", map.get("conbillentryid"));
        }
        Collection objColl = finApBillMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
    }

    private void disposeRevcfmBill(List<Map<String, Object>> disposeList) {
        HashSet<Long> revcBillIds = new HashSet<Long>(disposeList.size());
        for (Map<String, Object> disposeInfo : disposeList) {
            Long revcfmBillId = (Long)disposeInfo.get("id");
            if (revcfmBillId == null || revcfmBillId == 0L) continue;
            revcBillIds.add(revcfmBillId);
        }
        if (revcBillIds.size() == 0) {
            return;
        }
        DynamicObject[] revcfmBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"id,sourcebilltype,entry.id,entry.e_sourcebillid,entry.e_sourcebillentryid,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillid,entry.e_corebillentryseq,entry.e_corebillentryid,entry.e_conbillentity,entry.e_conbillnumber,entry.e_conbillrownum,entry.e_conbillid,entry.e_conbillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", revcBillIds)});
        logger.info("\u6536\u5165\u786e\u8ba4\u5355\u6570\u91cf\u4e3a\uff1a" + revcfmBills.length);
        ArrayList<Map<String, Object>> finArDisList = new ArrayList<Map<String, Object>>(revcfmBills.length);
        HashMap<Long, DynamicObject> revcBillMap = new HashMap<Long, DynamicObject>(revcfmBills.length);
        HashMap<Long, DynamicObject> revcEntryMap = new HashMap<Long, DynamicObject>(revcfmBills.length);
        for (DynamicObject bill : revcfmBills) {
            revcBillMap.put(bill.getLong("id"), bill);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                revcEntryMap.put(row.getLong("id"), row);
            }
        }
        for (Map map : disposeList) {
            Long id = (Long)map.get("id");
            Long entryId = (Long)map.get("entryid");
            boolean isManual = (Boolean)map.get("ismanual");
            String verifyRelation = (String)map.get("verifyrelation");
            DynamicObject revcfmBill = (DynamicObject)revcBillMap.get(id);
            DynamicObject entry = (DynamicObject)revcEntryMap.get(entryId);
            if (revcfmBill == null || entry == null) continue;
            Long finArBillId = entry.getLong("e_sourcebillid");
            Long finArEntryId = entry.getLong("e_sourcebillentryid");
            if (entry.getLong("e_corebillid") != 0L || entry.getLong("e_corebillentryid") != 0L || !isManual || !VerifyRelationEnum.ARSALOUT.getValue().equals(verifyRelation) && !VerifyRelationEnum.ARSALRETURN.getValue().equals(verifyRelation)) continue;
            entry.set("e_corebilltype", map.get("corebilltype"));
            entry.set("e_corebillno", map.get("corebillno"));
            entry.set("e_corebillid", map.get("corebillid"));
            entry.set("e_corebillentryseq", map.get("corebillentryseq"));
            entry.set("e_corebillentryid", map.get("corebillentryid"));
            if (StringUtils.isEmpty((String)entry.getString("e_conbillnumber")) && entry.getLong("e_conbillid") == 0L) {
                entry.set("e_conbillentity", map.get("conbillentity"));
                entry.set("e_conbillnumber", map.get("conbillnumber"));
                entry.set("e_conbillrownum", map.get("conbillrownum"));
                entry.set("e_conbillid", map.get("conbillid"));
                entry.set("e_conbillentryid", map.get("conbillentryid"));
            }
            map.put("id", finArBillId);
            map.put("entryid", finArEntryId);
            finArDisList.add(map);
        }
        Collection objColl = revcBillMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
        this.disposeFinArBill(finArDisList);
    }

    private void disposeFinArBill(List<Map<String, Object>> finArDisList) {
        HashSet<Long> finArBillIds = new HashSet<Long>(finArDisList.size());
        for (Map<String, Object> disposeInfo : finArDisList) {
            Long finArBillId = (Long)disposeInfo.get("id");
            if (finArBillId == null || finArBillId == 0L) continue;
            finArBillIds.add(finArBillId);
        }
        if (finArBillIds.size() == 0) {
            return;
        }
        DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,entry.e_corebilltype,entry.e_corebillno,entry.corebillid,entry.e_corebillentryseq,entry.corebillentryid,entry.e_conbillentity,entry.e_conbillnumber,entry.e_conbillrownum,entry.e_conbillid,entry.e_conbillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", finArBillIds)});
        HashMap<Long, DynamicObject> finArBillMap = new HashMap<Long, DynamicObject>(arBills.length);
        HashMap<Long, DynamicObject> finArEntryMap = new HashMap<Long, DynamicObject>(arBills.length);
        for (DynamicObject bill : arBills) {
            finArBillMap.put(bill.getLong("id"), bill);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                finArEntryMap.put(row.getLong("id"), row);
            }
        }
        for (Map map : finArDisList) {
            Long id = (Long)map.get("id");
            Long entryId = (Long)map.get("entryid");
            DynamicObject finArBill = (DynamicObject)finArBillMap.get(id);
            DynamicObject entry = (DynamicObject)finArEntryMap.get(entryId);
            if (finArBill == null || entry == null || entry.getLong("corebillid") != 0L || entry.getLong("corebillentryid") != 0L) continue;
            entry.set("e_corebilltype", map.get("corebilltype"));
            entry.set("e_corebillno", map.get("corebillno"));
            entry.set("corebillid", map.get("corebillid"));
            entry.set("e_corebillentryseq", map.get("corebillentryseq"));
            entry.set("corebillentryid", map.get("corebillentryid"));
            entry.set("e_conbillentity", map.get("conbillentity"));
            entry.set("e_conbillnumber", map.get("conbillnumber"));
            entry.set("e_conbillrownum", map.get("conbillrownum"));
            entry.set("e_conbillid", map.get("conbillid"));
            entry.set("e_conbillentryid", map.get("conbillentryid"));
        }
        Collection objColl = finArBillMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
    }
}

