/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.ar.mservice.ArApManualSettleService;
import kd.fi.ar.mservice.ArPayManualSettleService;
import kd.fi.ar.mservice.ArRecManualSettleService;
import kd.fi.ar.mservice.ArSelfManualSettleService;
import kd.fi.ar.mservice.BaddebtRecoveryManualSettleService;
import kd.fi.ar.mservice.RecPayManualSettleService;
import kd.fi.ar.mservice.RecSelfManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.BaddebtlossBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaddebtlossBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AR014_001ArRecManualSettleIndirectUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e")
    @Test
    public void testArRec_001_1() {
        DynamicObject[] apBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(2);
        FinArBillDataVO billInfo = new FinArBillDataVO();
        billInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(BigDecimal.valueOf(100L)).setBillNo("ArRecManualSettle_FinAr_ind_1").setOrg(org);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)billInfo, entryInfoApList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(1);
        CasRecBillDataVO recBillInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("ArRecManualSettle_CasRec_ind_1").setOrg(org);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recBillInfo, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(80L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(80L), (boolean)true);
        ArRecManualSettleService service = new ArRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{arBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        for (DynamicObject bill : apBills = FinArBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])apBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult cancelRusult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRusult);
        this.checkForUnSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u9000\u6b3e")
    @Test
    public void testArPay_001_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        FinArBillDataVO billInfo = new FinArBillDataVO();
        billInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(BigDecimal.valueOf(-200L)).setBillNo("ArPayManualSettle_FinAr_ind_1").setOrg(org);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)billInfo, entryInfoArList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        CasPayBillDataVO CasPayBillInfo = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("ArPayManualSettle_CasPay_ind_1").setOrg(org);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)CasPayBillInfo, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(-150L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        ArPayManualSettleService service = new ArPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForSettleForTestArPay_001_1(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArPay_001_1(mainIds, asstIds);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u6536\u51b2\u5e94\u4ed8")
    @Test
    public void testArAp_001_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        FinArBillDataVO billInfo = new FinArBillDataVO();
        billInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(BigDecimal.valueOf(200L)).setBillNo("ArApManualSettle_FinAr_ind_1").setOrg(org);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)billInfo, entryInfoArList);
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(new BigDecimal(150)).setBillNo("ArApManualSettle_FinAp_ind_1").setOrg(org);
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo, entryInfoApList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        ArApManualSettleService service = new ArApManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Object[] asstIds = new Long[]{apBill.getLong("id")};
        this.checkForSettleForTestArAp_001_1(mainIds, (Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArAp_001_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u6536\u7ea2\u84dd\u5bf9\u51b2")
    @Test
    public void testArSelf_001_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        FinArBillDataVO billInfo = new FinArBillDataVO();
        billInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(BigDecimal.valueOf(200L)).setBillNo("ArSelfManualSettle_Ar_ind_1").setOrg(org);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)billInfo, entryInfoArList);
        ArrayList<FinArBillDataDetailVO> entryInfoArList1 = new ArrayList<FinArBillDataDetailVO>(2);
        FinArBillDataVO billInfo1 = new FinArBillDataVO();
        billInfo1.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setPricetaxTotal(BigDecimal.valueOf(-150L)).setBillNo("ArSelfManualSettle_Ar_ind_1_1").setOrg(org);
        entryInfoArList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        entryInfoArList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill1 = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)billInfo1, entryInfoArList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)arBill1, (BigDecimal)BigDecimal.valueOf(-150L), (boolean)false);
        ArSelfManualSettleService service = new ArSelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Object[] asstIds = new Long[]{arBill1.getLong("id")};
        this.checkForSettleForTestArSelf_001_1(mainIds, (Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArSelf_001_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6536\u6b3e\u51b2\u4ed8\u6b3e")
    @Test
    public void testRecPay_001_1() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        CasRecBillDataVO recBillInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("RecPayMSettle_CasRec_ind_1").setOrg(org);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recBillInfo, entryInfoRecList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        CasPayBillDataVO CasPayBillInfo = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("RecPayMSettle_CasPay_ind_1").setOrg(org);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)CasPayBillInfo, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        RecPayManualSettleService service = new RecPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{recBill.getLong("id")};
        Object[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForSettleForTestRecPay_001_1(mainIds, (Long[])asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestRecPay_001_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u6536\u6b3e\u7ea2\u84dd\u5bf9\u51b2")
    @Test
    public void testRecSelf_001_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        CasRecBillDataVO recBillInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("RecSelfMSettle_CasRec_ind_1").setOrg(org);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recBillInfo, entryInfoRecList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasRecBillDataDetailVO>(2);
        CasRecBillDataVO recBillInfo1 = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("RecSelfMSettle_CasRec_ind_1_1").setOrg(org);
        entryInfoPayList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-100L)).setSeq(1));
        entryInfoPayList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-50L)).setSeq(2));
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recBillInfo1, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill1, (BigDecimal)BigDecimal.valueOf(-150L), (boolean)false);
        RecSelfManualSettleService service = new RecSelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{recBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill1.getLong("id")};
        this.checkForSettleForTestRecSelf_001_1(mainIds, (Long[])asstIds);
        OperationResult cancelRecRusult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRecRusult);
        this.checkForUnSettleForTestRecSelf_001_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u574f\u8d26\u6536\u56de")
    @Test
    public void testBadRec_001_1() {
        DynamicObject[] badBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        DynamicObject baddebtlossBill = BaddebtlossBillTestDataProvider.buildBill((String)"BadRec_MS_Bad_ind_1", (DynamicObject)org, (BigDecimal)BigDecimal.valueOf(100L), (boolean)true);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        CasRecBillDataVO recBillInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("BadRec_MS_Rec_ind_1").setOrg(org);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1));
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList1 = new ArrayList<CasRecBillDataDetailVO>(2);
        CasRecBillDataVO recBillInfo1 = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.ONE).setBillNo("BadRec_MS_Rec_ind_2").setOrg(org);
        entryInfoRecList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recBillInfo, entryInfoRecList);
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recBillInfo1, entryInfoRecList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)baddebtlossBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)true);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(recBill, BigDecimal.valueOf(50L));
        BillRowVO rowModel0 = new BillRowVO(recBill1, BigDecimal.valueOf(50L));
        asstBills.add(rowModel);
        asstBills.add(rowModel0);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)true);
        BaddebtRecoveryManualSettleService service = new BaddebtRecoveryManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{baddebtlossBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill.getLong("id"), recBill1.getLong("id")};
        this.checkForSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_baddebtlossbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        for (DynamicObject bill : badBills = BaddebtlossBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])badBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult cancelResult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelResult);
        this.checkForUnSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
    }

    private void checkForUnSettleForTestArRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestArRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        this.validateFinishBill(needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    public void validateFinishBill(DynamicObject casPayBill) {
        KDAssert.assertEquals((String)"\u6536\u6b3e\u5355\u5206\u5f55\u72b6\u6001\u4e0e\u671f\u5f85\u503c\u4e0d\u4e00\u81f4", (String)"D", (String)casPayBill.getString("billstatus"));
        DynamicObjectCollection entry = casPayBill.getDynamicObjectCollection("entry");
        for (DynamicObject detail : entry) {
            CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)detail, (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(80L), (BigDecimal)BigDecimal.valueOf(20L), (BigDecimal)BigDecimal.valueOf(20L));
        }
    }

    private void checkForSettleForTestArPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-25L), (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-25L), (BigDecimal)BigDecimal.valueOf(-25L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-25L), (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-25L), (BigDecimal)BigDecimal.valueOf(-25L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestArPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestArAp_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(150L), (BigDecimal)BigDecimal.valueOf(150L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestArAp_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestArSelf_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(150L), (BigDecimal)BigDecimal.valueOf(150L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestArSelf_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestRecPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestRecPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestRecSelf_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestRecSelf_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestBadRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = BaddebtlossBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        BaddebtlossBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForUnSettleForTestBadRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = BaddebtlossBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        BaddebtlossBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }
}

