/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.ar.mservice.ArPayManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AR014_001_ArPayManualSettleSameUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u6536\u9000\u6b3e-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testArPay_001_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArPayManualSettle_FinAr_001_1", (DynamicObject)org, entryInfoArList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArPayManualSettle_CasPay_001_1", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(-150L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        ArPayManualSettleService service = new ArPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForSettleForTestArPay_001_1(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArPay_001_1(mainIds, asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u9000\u6b3e-\u8ba1\u5212\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testArPay_001_2() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArPayManualSettle_FinAr_001_2", (DynamicObject)org, entryInfoArList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArPayManualSettle_CasPay_001_2_0", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList1.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArPayManualSettle_CasPay_001_2_1", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(-100L), (boolean)true);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(payBill0, (DynamicObject)payBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(payBill1, (DynamicObject)payBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        ArPayManualSettleService service = new ArPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestArPay_001_2((Long[])mainIds, asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArPay_001_2((Long[])mainIds, asstIds);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e-\u7269\u6599\u884c-\u6574\u5355-\u4e00\u5bf9\u591a\uff0c\u540c\u91d1\u989d\uff0c\u5355\u5206\u5f55")
    @Test
    public void testArPay_001_3() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArPayManualSettle_FinAr_001_3", (DynamicObject)org, entryInfoApList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArPayMSettle_CasPay_001_3_0", (DynamicObject)org, entryInfoPayList);
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArPayMSettle_CasPay_001_3_1", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(-100L), (boolean)true);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(payBill0, BigDecimal.valueOf(50L));
        BillRowVO rowModel0 = new BillRowVO(payBill1, BigDecimal.valueOf(50L));
        asstBills.add(rowModel);
        asstBills.add(rowModel0);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)false);
        ArPayManualSettleService service = new ArPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestArPay_001_3(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArPay_001_3(mainIds, asstIds);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u6536\u9000\u6b3e-\u7269\u6599\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u540c\u91d1\u989d")
    @Test
    public void testArPay_001_4() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArPayManualSettle_FinAr_001_4", (DynamicObject)org, entryInfoApList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArPayManualSettle_CasPay_001_4_1", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList1.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArPayManualSettle_CasPay_001_4_2", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("entry").get(0)), (BigDecimal)BigDecimal.valueOf(-100L), (boolean)true);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(payBill0, (DynamicObject)payBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(payBill1, (DynamicObject)payBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        ArPayManualSettleService service = new ArPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestArPay_001_4(mainIds, asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{asstIds[0]}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestArPay_001_4(mainIds, asstIds, asstIds[0]);
    }

    private void checkForSettleForTestArPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-25L), (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-25L), (BigDecimal)BigDecimal.valueOf(-25L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-25L), (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-75L), (BigDecimal)BigDecimal.valueOf(-25L), (BigDecimal)BigDecimal.valueOf(-25L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-150L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestArPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestArPay_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestArPay_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestArPay_001_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestArPay_001_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestArPay_001_4(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestArPay_001_4(Long[] mainIds, Long[] asstIds, Long cancelPayAsstId) {
        DynamicObject[] needCheckAsstBills;
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L), (BigDecimal)BigDecimal.valueOf(-50L));
        for (DynamicObject needCheckAsstBill : needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds)) {
            Long asstBillId = needCheckAsstBill.getLong("id");
            if (asstBillId.equals(cancelPayAsstId)) {
                CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
                continue;
            }
            CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        }
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)false);
        KDAssert.assertEquals((boolean)true, (settleRecords.length == 1 ? 1 : 0) != 0);
        DynamicObject settleRecord = settleRecords[0];
        SettleRecordTestChecker.checkSettleAmt((DynamicObject)settleRecord, (BigDecimal)BigDecimal.valueOf(-50L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }
}

