/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.ar.mservice.ArRecManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.ReceivedSettleTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.ReceivedBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.ReceivedBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AR014_001_ArRecManualSettleSameUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testArRec_001_1() {
        DynamicObject[] apBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArRecManualSettle_FinAr_001_1", (DynamicObject)org, entryInfoApList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecManualSettle_CasRec_001_1", (DynamicObject)org, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)true);
        ArRecManualSettleService service = new ArRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{arBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        for (DynamicObject bill : apBills = FinArBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])apBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult cancelRusult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRusult);
        this.checkForUnSettleForTestArRec_001_1((Long[])mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testArRec_001_2() {
        DynamicObject[] apBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArRecManualSettle_FinAr_001_2", (DynamicObject)org, entryInfoApList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill0 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecManualSettle_CasRec_001_2_0", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecManualSettle_CasRec_001_2_1", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)true);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(recBill0, BigDecimal.valueOf(50L));
        BillRowVO rowModel0 = new BillRowVO(recBill1, BigDecimal.valueOf(50L));
        asstBills.add(rowModel);
        asstBills.add(rowModel0);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)true);
        ArRecManualSettleService service = new ArRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill0.getLong("id"), recBill1.getLong("id")};
        this.checkForSettleForTestArRec_001_2((Long[])mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArRec_001_2((Long[])mainIds, asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestArRec_001_2((Long[])mainIds, asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArRec_001_2((Long[])mainIds, asstIds);
        for (DynamicObject bill : apBills = FinArBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])apBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestArRec_001_2((Long[])mainIds, asstIds);
        OperationResult cancelResult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{asstIds[0]}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelResult);
        this.checkForUnSettleForTestArRec_001_2_0((Long[])mainIds, asstIds, asstIds[0]);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e-\u8ba1\u5212\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testArRec_001_3() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArRecManualSettle_FinAr_001_3", (DynamicObject)org, entryInfoApList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill0 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecManualSettle_CasRec_001_3_0", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecManualSettle_CasRec_001_3_1", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)true);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(recBill0, (DynamicObject)recBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(recBill1, (DynamicObject)recBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)true);
        ArRecManualSettleService service = new ArRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill0.getLong("id"), recBill1.getLong("id")};
        this.checkForSettleForTestArRec_001_3(mainIds, asstIds);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e-\u8ba1\u5212\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d-\u4e0d\u540c\u6c47\u7387")
    @Test
    public void testArRec_001_4() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        FinArBillDataVO arInfo = FinArBillDataVO.New().setBillNo("ArRecManualSettle_FinAr_001_4").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.ONE).setOrg(org);
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)arInfo, entryInfoApList);
        CasRecBillDataVO casInfo0 = CasRecBillDataVO.New().setBillNo("ArRecManualSettle_CasRec_001_4_0").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList0 = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList0.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject casBill0 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)casInfo0, entryInfoPayList0);
        CasRecBillDataVO casInfo1 = CasRecBillDataVO.New().setBillNo("ArRecManualSettle_CasRec_001_4_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject casBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)casInfo1, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)true);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(casBill0, (DynamicObject)casBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(casBill1, (DynamicObject)casBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)true);
        ArRecManualSettleService service = new ArRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{casBill0.getLong("id"), casBill1.getLong("id")};
        this.checkForSettleForTestArRec_001_4(mainIds, asstIds);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e(\u9884\u4ed8)-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testArRec_001_5() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArRecManualSettle_FinAr_001_5", (DynamicObject)org, entryInfoApList);
        ArrayList<ReceivedBillDataDetailVO> entryInfoPayList = new ArrayList<ReceivedBillDataDetailVO>(1);
        entryInfoPayList.add(ReceivedBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill0 = ReceivedBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecMS_Reced_001_5_1", (DynamicObject)org, entryInfoPayList);
        ArrayList<ReceivedBillDataDetailVO> entryInfoPayList1 = new ArrayList<ReceivedBillDataDetailVO>(1);
        entryInfoPayList1.add(ReceivedBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill1 = ReceivedBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecMS_Reced_001_5_2", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)true);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(recBill0, (DynamicObject)recBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(recBill1, (DynamicObject)recBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)true);
        ArRecManualSettleService service = new ArRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill0.getLong("id"), recBill1.getLong("id")};
        this.checkForSettleForTestArRec_001_5(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArRec_001_5(mainIds, asstIds);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e-\u7269\u6599\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u540c\u91d1\u989d")
    @Test
    public void testArRec_001_6() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArRecManualSettle_FinAr_001_6", (DynamicObject)org, entryInfoApList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecManualSettle_CasRec_001_6", (DynamicObject)org, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        ArRecManualSettleService service = new ArRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForSettleForTestArRec_001_6(mainIds, (Long[])asstIds);
        OperationResult cancelResult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelResult);
        this.checkForUnSettleForTestArRec_001_6(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=7)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e-\u7269\u6599\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u540c\u91d1\u989d-\u6b63\u8d1f\u5206\u5f55")
    @Test
    public void testArRec_001_7() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(2L)).setSeq(1));
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArRecManualSettle_FinAr_001_7", (DynamicObject)org, entryInfoApList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(200L)).setSeq(1));
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-100L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecManualSettle_CasRec_001_7", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)true);
        ArRecManualSettleService service = new ArRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForSettleForTestArRec_001_7(mainIds, (Long[])asstIds);
        OperationResult cancelResult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelResult);
        this.checkForUnSettleForTestArRec_001_7(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=8)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e-\u7269\u6599\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u540c\u91d1\u989d")
    @Test
    public void testArRec_001_8() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArRecMS_FinAr_001_8", (DynamicObject)org, entryInfoApList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill0 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecMS_CasRec_001_8_1", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"ArRecMS_CasRec_001_8_2", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("entry").get(0)), (BigDecimal)BigDecimal.valueOf(50L), (boolean)true);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(recBill0, (DynamicObject)recBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(25L));
        EntryRowVO row2 = new EntryRowVO(recBill1, (DynamicObject)recBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(25L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        ArRecManualSettleService service = new ArRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill0.getLong("id"), recBill1.getLong("id")};
        this.checkForSettleForTestArRec_001_8_1(mainIds, asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestArRec_001_8_2(mainIds, asstIds);
    }

    private void checkForSettleForTestArRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(150L), (BigDecimal)BigDecimal.valueOf(150L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(75L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject planEntry1 = (DynamicObject)planEntries.get(1);
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForUnSettleForTestArRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestArRec_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForUnSettleForTestArRec_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForUnSettleForTestArRec_001_2_0(Long[] mainIds, Long[] asstIds, Long cancelRecAsstId) {
        DynamicObject[] needCheckAsstBills;
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        for (DynamicObject needCheckAsstBill : needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds)) {
            Long asstBillId = needCheckAsstBill.getLong("id");
            DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
            DynamicObject entry = (DynamicObject)entries.get(0);
            if (asstBillId.equals(cancelRecAsstId)) {
                CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
                continue;
            }
            CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        }
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)false);
        KDAssert.assertEquals((boolean)true, (settleRecords.length == 1 ? 1 : 0) != 0);
        DynamicObject settleRecord = settleRecords[0];
        SettleRecordTestChecker.checkSettleAmt((DynamicObject)settleRecord, (BigDecimal)BigDecimal.valueOf(50L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArRec_001_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArRec_001_4(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        KDAssert.assertEquals((boolean)true, (settleRecords.length == 1 ? 1 : 0) != 0);
        DynamicObject settleRecord = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord, (BigDecimal)BigDecimal.valueOf(100L));
    }

    private void checkForSettleForTestArRec_001_5(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = ReceivedBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        ReceivedSettleTestChecker.checkEntry((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        ReceivedSettleTestChecker.checkEntry((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForUnSettleForTestArRec_001_5(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = ReceivedBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        ReceivedSettleTestChecker.checkEntry((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        ReceivedSettleTestChecker.checkEntry((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(50L));
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArRec_001_6(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForUnSettleForTestArRec_001_6(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArRec_001_7(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"settled");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(200L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForUnSettleForTestArRec_001_7(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L));
        DynamicObject detailEntry1 = (DynamicObject)detailEntries.get(1);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry1, (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(-100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArRec_001_8_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateHeadSettleStatus((DynamicObject)needCheckMainBill, (String)"partsettle");
        FinArBillTestChecker.validateHeadSettleAmt((DynamicObject)needCheckMainBill, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection detailEntries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject detailEntry0 = (DynamicObject)detailEntries.get(0);
        FinArBillTestChecker.validateDetailLockAndSettleAmt((DynamicObject)detailEntry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObjectCollection planEntries = needCheckMainBill.getDynamicObjectCollection("planentity");
        DynamicObject planEntry0 = (DynamicObject)planEntries.get(0);
        FinArBillTestChecker.validatePlanLockAndSettleAmt((DynamicObject)planEntry0, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        DynamicObjectCollection entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        DynamicObjectCollection entries0 = needCheckAsstBill0.getDynamicObjectCollection("entry");
        DynamicObject entry0_0 = (DynamicObject)entries0.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry0_0, (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L), (BigDecimal)BigDecimal.valueOf(25L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArRec_001_8_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }
}

