/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.ar.mservice.BaddebtRecoveryManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.BaddebtlossBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaddebtlossBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AR014_001_BadRecManualSettleSameUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u574f\u8d26\u635f\u5931-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u591a-\u540c\u91d1\u989d")
    @Test
    public void testBadRec_001_1() {
        DynamicObject[] badBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        DynamicObject baddebtlossBill = BaddebtlossBillTestDataProvider.buildBill((String)"BadRec_MS_Bad_001_1", (DynamicObject)org, (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill0 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"BadRec_MS_Rec_001_1", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList1 = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoPayList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"BadRec_MS_Rec_001_2", (DynamicObject)org, entryInfoPayList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)baddebtlossBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)true);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(recBill0, BigDecimal.valueOf(50L));
        BillRowVO rowModel0 = new BillRowVO(recBill1, BigDecimal.valueOf(50L));
        asstBills.add(rowModel);
        asstBills.add(rowModel0);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)true);
        BaddebtRecoveryManualSettleService service = new BaddebtRecoveryManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{baddebtlossBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill0.getLong("id"), recBill1.getLong("id")};
        this.checkForSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_baddebtlossbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        for (DynamicObject bill : badBills = BaddebtlossBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"C");
        }
        SaveServiceHelper.save((DynamicObject[])badBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
        OperationResult cancelResult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelResult);
        this.checkForUnSettleForTestBadRec_001_1((Long[])mainIds, (Long[])asstIds);
    }

    private void checkForSettleForTestBadRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = BaddebtlossBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        BaddebtlossBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForUnSettleForTestBadRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = BaddebtlossBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        BaddebtlossBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }
}

