/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.ar.mservice.RecPayManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PaidSettleTestChecker;
import kd.fi.arapcommon.unittest.framework.check.ReceivedSettleTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PaidBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.ReceivedBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PaidBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.ReceivedBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AR014_001_RecPayManualSettleSameUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u6536\u6b3e\u51b2\u4ed8\u6b3e-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testRecPay_001_1() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_CasRec_001_1", (DynamicObject)org, entryInfoRecList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_CasPay_001_1", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        RecPayManualSettleService service = new RecPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{recBill.getLong("id")};
        Object[] asstIds = new Long[]{payBill.getLong("id")};
        this.checkForSettleForTestRecPay_001_1(mainIds, (Long[])asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(10000L);
        this.checkForUnSettleForTestRecPay_001_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6536\u6b3e\u51b2\u4ed8\u6b3e-\u6574\u5355-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testRecPay_001_2() throws InterruptedException {
        DynamicObject[] recBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_CasRec_001_2_0", (DynamicObject)org, entryInfoRecList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_CasPay_001_2_0", (DynamicObject)org, entryInfoPayList);
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_CasPay_001_2_1", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(payBill0, BigDecimal.valueOf(50L));
        BillRowVO rowModel0 = new BillRowVO(payBill1, BigDecimal.valueOf(50L));
        asstBills.add(rowModel);
        asstBills.add(rowModel0);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)false);
        RecPayManualSettleService service = new RecPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{recBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestRecPay_001_2((Long[])mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestRecPay_001_2((Long[])mainIds, asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestRecPay_001_2((Long[])mainIds, asstIds);
        OperationResult cancelRecRusult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRecRusult);
        Thread.sleep(10000L);
        this.checkForUnSettleForTestRecPay_001_2((Long[])mainIds, asstIds);
        for (DynamicObject bill : recBills = CasRecBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"D");
        }
        SaveServiceHelper.save((DynamicObject[])recBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestRecPay_001_2((Long[])mainIds, asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Long[]{asstIds[0]}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestRecPay_001_2_0((Long[])mainIds, asstIds, asstIds[0]);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6536\u6b3e\u51b2\u4ed8\u6b3e-\u5206\u5f55-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testRecPay_001_3() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_CasRec_001_3_0", (DynamicObject)org, entryInfoRecList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1));
        DynamicObject payBill0 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_CasPay_001_3_0", (DynamicObject)org, entryInfoPayList);
        DynamicObject payBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_CasPay_001_3_1", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)recBill, (DynamicObject)((DynamicObject)recBill.getDynamicObjectCollection("entry").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(payBill0, (DynamicObject)payBill0.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(payBill1, (DynamicObject)payBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        RecPayManualSettleService service = new RecPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{recBill.getLong("id")};
        Long[] asstIds = new Long[]{payBill0.getLong("id"), payBill1.getLong("id")};
        this.checkForSettleForTestRecPay_001_3(mainIds, asstIds);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u4ed8\u6b3e(\u9884\u4ed8)\u51b2\u6536\u6b3e(\u9884\u6536)-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testRecPay_001_4() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<ReceivedBillDataDetailVO> entryInfoRecList = new ArrayList<ReceivedBillDataDetailVO>(1);
        entryInfoRecList.add(ReceivedBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)));
        entryInfoRecList.add(ReceivedBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)));
        DynamicObject receivedBill = ReceivedBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_Paid_001_5_0", (DynamicObject)org, entryInfoRecList);
        ArrayList<PaidBillDataDetailVO> entryInfoPayList = new ArrayList<PaidBillDataDetailVO>(1);
        entryInfoPayList.add(PaidBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)));
        entryInfoPayList.add(PaidBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject paidBill = PaidBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecPayMSettle_Paid_001_5_0", (DynamicObject)org, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)receivedBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)paidBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        RecPayManualSettleService service = new RecPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{receivedBill.getLong("id")};
        Long[] asstIds = new Long[]{paidBill.getLong("id")};
        this.checkForSettleForTestRecPay_001_4(mainIds, asstIds);
    }

    private void checkForSettleForTestRecPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestRecPay_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestRecPay_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestRecPay_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestRecPay_001_2_0(Long[] mainIds, Long[] asstIds, Long cancelPayAsstId) {
        DynamicObject[] needCheckAsstBills;
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry = (DynamicObject)entries.get(0);
        CasRecBillTestChecker.validateBillLockAndSettleAmt((DynamicObject)entry, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        for (DynamicObject needCheckAsstBill : needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds)) {
            Long asstBillId = needCheckAsstBill.getLong("id");
            if (asstBillId.equals(cancelPayAsstId)) {
                CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
                continue;
            }
            CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        }
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)false);
        KDAssert.assertEquals((boolean)true, (settleRecords.length == 1 ? 1 : 0) != 0);
        DynamicObject settleRecord = settleRecords[0];
        SettleRecordTestChecker.checkSettleAmt((DynamicObject)settleRecord, (BigDecimal)BigDecimal.valueOf(50L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestRecPay_001_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestRecPay_001_4(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = ReceivedBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        ReceivedSettleTestChecker.checkEntry((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        ReceivedSettleTestChecker.checkEntry((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = PaidBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        entry0 = (DynamicObject)entries.get(0);
        PaidSettleTestChecker.checkEntry((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L));
        entry1 = (DynamicObject)entries.get(1);
        PaidSettleTestChecker.checkEntry((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }
}

