/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.ar.mservice.ArApManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AR014_002_ArApManualSettleDiffUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u6536\u51b2\u5e94\u4ed8-\u5f02\u5e01\u522b-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d-\u53cc\u5206\u5f55")
    @Test
    public void testArAp_002_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArAp_Diff_MS_Ar_002_1", (DynamicObject)org, entryInfoArList);
        FinApBillDataVO apInfo = FinApBillDataVO.New().setBillNo("ArAp_Diff_MS_Ap_002_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)apInfo, entryInfoApList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)true);
        ArApManualSettleService service = new ArApManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Object[] asstIds = new Long[]{apBill.getLong("id")};
        this.checkForSettleForTestArAp_002_1(mainIds, (Long[])asstIds);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArAp_002_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u51b2\u5e94\u4ed8-\u5f02\u5e01\u522b-\u8ba1\u5212\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testArAp_002_2() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArAp_Diff_MS_Ar_002_2", (DynamicObject)org, entryInfoArList);
        FinApBillDataVO apInfo = FinApBillDataVO.New().setBillNo("ArAp_Diff_MS_Ap_002_2_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        FinApBillDataVO apInfo1 = FinApBillDataVO.New().setBillNo("ArAp_Diff_MS_Ap_002_2_2").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject apBill0 = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)apInfo, entryInfoApList);
        DynamicObject apBill1 = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)apInfo1, entryInfoApList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(apBill0, (DynamicObject)apBill0.getDynamicObjectCollection("planentity").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(apBill1, (DynamicObject)apBill1.getDynamicObjectCollection("planentity").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)true);
        ArApManualSettleService service = new ArApManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{apBill0.getLong("id"), apBill1.getLong("id")};
        this.checkForSettleForTestArAp_002_2(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArAp_002_2(mainIds, asstIds);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u6536\u51b2\u5e94\u4ed8-\u5f02\u5e01\u522b-\u7269\u6599\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d-\u53cc\u5206\u5f55")
    @Test
    public void testArAp_002_3() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArAp_Diff_MS_Ar_002_3", (DynamicObject)org, entryInfoArList);
        FinApBillDataVO apInfo = FinApBillDataVO.New().setBillNo("ArAp_Diff_MS_Ap_002_2_3").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)apInfo, entryInfoApList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)true);
        ArApManualSettleService service = new ArApManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Object[] asstIds = new Long[]{apBill.getLong("id")};
        this.checkForSettleForTestArAp_002_3(mainIds, (Long[])asstIds);
        Thread.sleep(20000L);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArAp_002_3(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u6536\u51b2\u5e94\u4ed8-\u7269\u6599\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testArAp_002_4() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArAp_Diff_MS_Ar_002_4", (DynamicObject)org, entryInfoArList);
        FinApBillDataVO apInfo = FinApBillDataVO.New().setBillNo("ArAp_Diff_MS_Ap_002_4_0").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        FinApBillDataVO apInfo1 = FinApBillDataVO.New().setBillNo("ArAp_Diff_MS_Ap_002_4_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject apBill0 = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)apInfo, entryInfoApList);
        DynamicObject apBill1 = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)apInfo1, entryInfoApList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("entry").get(0)), (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(apBill0, (DynamicObject)apBill0.getDynamicObjectCollection("detailentry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(apBill1, (DynamicObject)apBill1.getDynamicObjectCollection("detailentry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        ArApManualSettleService service = new ArApManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{apBill0.getLong("id"), apBill1.getLong("id")};
        this.checkForSettleForTestArAp_002_4(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArAp_002_4(mainIds, asstIds);
    }

    private void checkForSettleForTestArAp_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject settleRecord1 = settleRecords[1];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord1, (BigDecimal)BigDecimal.valueOf(50L));
    }

    private void checkForUnSettleForTestArAp_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArAp_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill0, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(0L));
    }

    private void checkForUnSettleForTestArAp_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArAp_002_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject settleRecord1 = settleRecords[1];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord1, (BigDecimal)BigDecimal.valueOf(50L));
    }

    private void checkForUnSettleForTestArAp_002_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArAp_002_4(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill0, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(0L));
    }

    private void checkForUnSettleForTestArAp_002_4(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }
}

