/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.ar.mservice.ArPayManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AR014_002_ArPayManualSettleDiffUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u6536\u9000\u6b3e-\u5f02\u5e01\u522b-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testArPay_002_1() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject apBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArPay_Diff_MS_Ar_002_1", (DynamicObject)org, entryInfoArList);
        CasPayBillDataVO recInfo = CasPayBillDataVO.New().setBillNo("ArPay_Diff_MS_Pay_002_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        DynamicObject recBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)recInfo, entryInfoPayList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)true);
        ArPayManualSettleService service = new ArPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForSettleForTestArPay_002_1(mainIds, (Long[])asstIds);
        OperationResult cancelRecRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRecRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestArPay_002_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u9000\u6b3e-\u5f02\u5e01\u522b-\u7269\u6599\u884c-\u6574\u5355-\u4e00\u5bf9\u591a-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testArPay_002_2() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoMainList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoMainList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(-1L)));
        DynamicObject mainBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArPay_Diff_MS_Ar_002_2", (DynamicObject)org, entryInfoMainList);
        CasPayBillDataVO payInfo = CasPayBillDataVO.New().setBillNo("ArPay_Diff_MS_Pay_002_2_0").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        CasPayBillDataVO payInfo1 = CasPayBillDataVO.New().setBillNo("ArPay_Diff_MS_Pay_002_2_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasPayBillDataDetailVO> entryInfoAsstList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoAsstList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1));
        DynamicObject asstBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)payInfo, entryInfoAsstList);
        DynamicObject asstBill1 = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)payInfo1, entryInfoAsstList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(asstBill, BigDecimal.valueOf(50L));
        BillRowVO rowModel0 = new BillRowVO(asstBill1, BigDecimal.valueOf(50L));
        asstBills.add(rowModel);
        asstBills.add(rowModel0);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)true);
        ArPayManualSettleService service = new ArPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id"), asstBill1.getLong("id")};
        this.checkForSettleForTestArPay_002_2(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArPay_002_2(mainIds, asstIds);
    }

    private void checkForSettleForTestArPay_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(-100L));
    }

    private void checkForUnSettleForTestArPay_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArPay_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(0L));
    }

    private void checkForUnSettleForTestArPay_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }
}

