/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.ar.mservice.ArSelfManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AR014_002_ArSelfManualSettleDiffUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    private static final long sleepTime = 5000L;

    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u6536\u7ea2\u84dd\u5bf9\u51b2-\u5f02\u5e01\u522b-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d-\u53cc\u5206\u5f55")
    @Test
    public void testArSelf_002_1() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill0 = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArSelf_Diff_MS_Ar_002_1_0", (DynamicObject)org, entryInfoArList);
        FinArBillDataVO arInfo1 = FinArBillDataVO.New().setBillNo("ArSelf_Diff_MS_Ar_002_1_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<FinArBillDataDetailVO> entryInfoArList1 = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        entryInfoArList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill1 = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)arInfo1, entryInfoArList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill0, (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)arBill1, (BigDecimal)BigDecimal.valueOf(-150L), (boolean)true);
        ArSelfManualSettleService service = new ArSelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill0.getLong("id")};
        Object[] asstIds = new Long[]{arBill1.getLong("id")};
        this.checkForSettleForTestArSelf_002_1(mainIds, (Long[])asstIds);
        Thread.sleep(5000L);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArSelf_002_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u7ea2\u84dd\u5bf9\u51b2-\u5f02\u5e01\u522b-\u8ba1\u5212\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testArSelf_002_2() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArSelf_Diff_MS_Ar_002_2_0", (DynamicObject)org, entryInfoArList);
        FinArBillDataVO arInfo1 = FinArBillDataVO.New().setBillNo("ArSelf_Diff_MS_Ar_002_2_1_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        FinArBillDataVO arInfo2 = FinArBillDataVO.New().setBillNo("ArSelf_Diff_MS_Ar_002_2_1_2").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<FinArBillDataDetailVO> entryInfoArList1 = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoArList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(-1L)));
        DynamicObject arBill1 = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)arInfo1, entryInfoArList1);
        DynamicObject arBill2 = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)arInfo2, entryInfoArList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("planentity").get(0)), (BigDecimal)BigDecimal.valueOf(200L), (boolean)false);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(arBill1, (DynamicObject)arBill1.getDynamicObjectCollection("planentity").get(0), BigDecimal.valueOf(-50L));
        EntryRowVO row2 = new EntryRowVO(arBill2, (DynamicObject)arBill2.getDynamicObjectCollection("planentity").get(0), BigDecimal.valueOf(-50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)true);
        ArSelfManualSettleService service = new ArSelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{arBill1.getLong("id"), arBill2.getLong("id")};
        this.checkForSettleForTestArSelf_002_2(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArSelf_002_2(mainIds, asstIds);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u6536\u7ea2\u84dd\u5bf9\u51b2-\u5f02\u5e01\u522b-\u7269\u6599\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d-\u53cc\u5206\u5f55")
    @Test
    public void testArSelf_002_3() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject arBill0 = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArSelf_Diff_MS_Ar_002_3_0", (DynamicObject)org, entryInfoArList);
        FinArBillDataVO arInfo1 = FinArBillDataVO.New().setBillNo("ApSelf_Diff_MS_Ap_002_3_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<FinArBillDataDetailVO> entryInfoArList1 = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        entryInfoArList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject arBill1 = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)arInfo1, entryInfoArList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)arBill0, (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)arBill1, (BigDecimal)BigDecimal.valueOf(-150L), (boolean)true);
        ArSelfManualSettleService service = new ArSelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{arBill0.getLong("id")};
        Long[] asstIds = new Long[]{arBill1.getLong("id")};
        this.checkForSettleForTestArSelf_002_3((Long[])mainIds, asstIds);
        Thread.sleep(5000L);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        this.checkForUnSettleForTestArSelf_002_3((Long[])mainIds, asstIds);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u6536\u7ea2\u84dd\u5bf9\u51b2-\u5f02\u5e01\u522b-\u7269\u6599\u884c-\u5206\u5f55-\u4e00\u5bf9\u591a-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testArSelf_002_4() {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(1L)));
        DynamicObject arBill = FinArBillTestDataProvider.buildByPriceAndQuantity((String)"ArSelf_Diff_MS_Ar_002_4_0_0", (DynamicObject)org, entryInfoArList);
        FinArBillDataVO arInfo1 = FinArBillDataVO.New().setBillNo("ArSelf_Diff_MS_Ar_002_4_1_0").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        FinArBillDataVO arInfo2 = FinArBillDataVO.New().setBillNo("ArSelf_Diff_MS_Ar_002_4_1_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<FinArBillDataDetailVO> entryInfoArList1 = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoArList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(-1L)));
        DynamicObject arBill1 = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)arInfo1, entryInfoArList1);
        DynamicObject arBill2 = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)arInfo2, entryInfoArList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)arBill, (DynamicObject)((DynamicObject)arBill.getDynamicObjectCollection("entry").get(0)), (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(arBill1, (DynamicObject)arBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(-50L));
        EntryRowVO row2 = new EntryRowVO(arBill2, (DynamicObject)arBill2.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(-50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)true);
        ArSelfManualSettleService service = new ArSelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{arBill.getLong("id")};
        Long[] asstIds = new Long[]{arBill1.getLong("id"), arBill2.getLong("id")};
        this.checkForSettleForTestArSelf_002_4(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestArSelf_002_4(mainIds, asstIds);
    }

    private void checkForSettleForTestArSelf_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject settleRecord1 = settleRecords[1];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord1, (BigDecimal)BigDecimal.valueOf(50L));
    }

    private void checkForUnSettleForTestArSelf_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArSelf_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill0, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(0L));
    }

    private void checkForUnSettleForTestArSelf_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArSelf_002_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject settleRecord1 = settleRecords[1];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord1, (BigDecimal)BigDecimal.valueOf(50L));
    }

    private void checkForUnSettleForTestArSelf_002_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestArSelf_002_4(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill0, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(0L));
    }

    private void checkForUnSettleForTestArSelf_002_4(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        FinArBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }
}

