/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.ar.mservice.RecSelfManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AR014_002_RecSelfManualSettleDiffUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u6536\u6b3e\u7ea2\u84dd\u5bf9\u51b2-\u5f02\u5e01\u522b-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testRecSelf_002_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject recBill0 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecSelf_Diff_MS_Rec_002_1_0", (DynamicObject)org, entryInfoRecList);
        CasRecBillDataVO recInfo = CasRecBillDataVO.New().setBillNo("RecSelf_Diff_MS_Rec_002_1_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList1 = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoRecList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-100L)).setSeq(1));
        entryInfoRecList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-50L)).setSeq(2));
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recInfo, entryInfoRecList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)recBill0, (BigDecimal)BigDecimal.valueOf(200L), (boolean)true);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill1, (BigDecimal)BigDecimal.valueOf(-150L), (boolean)true);
        RecSelfManualSettleService service = new RecSelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{recBill0.getLong("id")};
        Object[] asstIds = new Long[]{recBill1.getLong("id")};
        this.checkForSettleForTestRecSelf_002_1(mainIds, (Long[])asstIds);
        OperationResult cancelRecRusult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRecRusult);
        this.checkForUnSettleForTestRecSelf_002_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6536\u6b3e\u7ea2\u84dd\u5bf9\u51b2-\u5f02\u5e01\u522b-\u5206\u5f55-\u4e00\u5bf9\u591a-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testRecSelf_002_2() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecSelf_Diff_MS_Rec_002_2_0", (DynamicObject)org, entryInfoRecList);
        CasRecBillDataVO recInfo1 = CasRecBillDataVO.New().setBillNo("RecSelf_Diff_MS_Rec_002_2_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList1 = new ArrayList<CasRecBillDataDetailVO>(1);
        entryInfoRecList1.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-50L)));
        DynamicObject recBill2 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recInfo1, entryInfoRecList1);
        CasRecBillDataVO recInfo2 = CasRecBillDataVO.New().setBillNo("PaySelf_Diff_MS_Pay_002_2_2").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        DynamicObject recBill3 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recInfo2, entryInfoRecList1);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)recBill1, (DynamicObject)((DynamicObject)recBill1.getDynamicObjectCollection("entry").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(recBill2, (DynamicObject)recBill2.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(-50L));
        EntryRowVO row2 = new EntryRowVO(recBill3, (DynamicObject)recBill3.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(-50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)true);
        RecSelfManualSettleService service = new RecSelfManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getArSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{recBill1.getLong("id")};
        Long[] asstIds = new Long[]{recBill2.getLong("id"), recBill3.getLong("id")};
        this.checkForSettleForTestRecSelf_002_2(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)true);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ar_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestRecSelf_002_2(mainIds, asstIds);
    }

    private void checkForSettleForTestRecSelf_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject settleRecord1 = settleRecords[1];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord1, (BigDecimal)BigDecimal.valueOf(50L));
    }

    private void checkForUnSettleForTestRecSelf_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForSettleForTestRecSelf_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)true);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(100L));
    }

    private void checkForUnSettleForTestRecSelf_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }
}

