/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.ar.mservice.ArSchemeSettleService;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.scene.process.settle.SchemeSettleUnitTestHelper;
import org.junit.Test;

public class AR015_001_NewSchemeSettleUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u6536\u6536\u6b3e\uff08\u65b0\u7b97\u6cd5\uff09")
    @Test
    public void testArRec() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject mainBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity((String)"ArRecSchemeSettle_FinAr", (DynamicObject)org, entryInfoApList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("ArRecSchemeSettle_CasRec").setOrg(org).setAsstact(mainBill.getDynamicObject("asstact"));
        DynamicObject asstBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)billInfo, entryInfoRecList);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.RECSETTLE.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)true);
        ArSchemeSettleService service = new ArSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForArRec(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u51b2\u5e94\u4ed8\uff08\u65b0\u7b97\u6cd5\uff09")
    @Test
    public void testArAp() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        FinArBillDataVO billInfo = FinArBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("ArApSchemeSettle_FinAr").setOrg(org).setCustomer(BaseDataTestProvider.getCoordinationCustomer()).setSettleVersion("1");
        DynamicObject mainBill = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)billInfo, entryInfoArList);
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        FinApBillDataVO billApInfo = new FinApBillDataVO();
        billApInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("ArApSchemeSettle_FinAp").setOrg(org).setSupplier(BaseDataTestProvider.getCoordinationSupplier()).setSettleVersion("1");
        DynamicObject asstBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)billApInfo, entryInfoApList);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.ARAPSETTLE.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)true);
        ArSchemeSettleService service = new ArSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForArAp(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u6536\u7ea2\u84dd\u5bf9\u51b2\uff08\u65b0\u7b97\u6cd5\uff09")
    @Test
    public void testArSelf() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoApList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject mainBill = FinArBillTestDataProvider.buildNewByPriceAndQuantity((String)"ArSelfSchemeSettle_FinAr_1", (DynamicObject)org, entryInfoApList);
        ArrayList<FinArBillDataDetailVO> entryInfoApList1 = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoApList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)));
        entryInfoApList1.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)));
        FinArBillDataVO billAsstInfo = new FinArBillDataVO();
        billAsstInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("ArSelfSchemeSettle_FinAr_2").setOrg(org).setCustomer(mainBill.getDynamicObject("asstact")).setSettleVersion("1");
        DynamicObject asstBill = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)billAsstInfo, entryInfoApList1);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.ARSELF.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)true);
        ArSchemeSettleService service = new ArSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForArSelf(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6536\u6b3e\u7ea2\u84dd\u5bf9\u51b2")
    @Test
    public void testRecSelf() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject mainBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"RecSelfSchemeSettle_CasRec_1", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList0 = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoPayList0.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-100L)).setSeq(1));
        entryInfoPayList0.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-100L)).setSeq(2));
        CasRecBillDataVO billInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("RecSelfSchemeSettle_CasRec_2").setOrg(org).setAsstact(mainBill.getDynamicObject("customerf7"));
        DynamicObject asstBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)billInfo, entryInfoPayList0);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.RECSELF.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)true);
        ArSchemeSettleService service = new ArSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForRecSelf(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6536\u6b3e\u51b2\u4ed8\u6b3e")
    @Test
    public void testRecPay() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasRecBillDataDetailVO> entryInfoPayList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        CasRecBillDataVO recInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("RecPaySchemeSettle_CasRec").setOrg(org).setAsstact(BaseDataTestProvider.getCoordinationCustomer());
        DynamicObject mainBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recInfo, entryInfoPayList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList0 = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList0.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList0.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("RecPaySchemeSettle_CasPay").setOrg(org).setAsstactId(Long.valueOf(BaseDataTestProvider.getCoordinationSupplier().getLong("id")));
        DynamicObject asstBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)billInfo, entryInfoPayList0);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.RECPAYSETTLE.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)true);
        ArSchemeSettleService service = new ArSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForRecPay(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    private void checkForArRec(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForArAp(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForArSelf(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinArBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForRecSelf(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }

    private void checkForRecPay(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasRecBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)true);
    }
}

