/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApJournalUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryArIsNotInit() && ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        try {
            this.updateArJournal();
            this.updateArBalance();
            this.updateApJournal();
            this.updateApBalance();
        }
        catch (Exception e) {
            String traceMessage = ArApHelper.getStackTraceMessage((Throwable)e);
            result.setErrorInfo(traceMessage);
            result.setLog(traceMessage);
        }
        return result;
    }

    private void updateApBalance() {
        DynamicObject[] arJournals = BusinessDataServiceHelper.load((String)"ap_journal", (String)"id,sourcebillid,prepaidamt,localprepaidamt,org,asstact,bizdate,asstacttype,currency", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"cas_paybill")});
        List apJournalListNotNull = Arrays.asList(arJournals).stream().filter(e -> e.get("org") != null && e.get("asstact") != null && e.get("bizdate") != null && e.get("currency") != null).collect(Collectors.toList());
        DynamicObject[] apBalances = BusinessDataServiceHelper.load((String)"ap_newbalance", (String)"id,periodprepaidamt,localperiodprepaidamt,prepaidamt,localprepaidamt,prepaidbalance,localprepaidbalance,org,asstact,startdate,stopdate,asstacttype,currency", null);
        List arBalanceListNotNull = Arrays.asList(apBalances).stream().filter(e -> e.get("org") != null && e.get("asstact") != null && e.get("stopdate") != null && e.get("currency") != null).collect(Collectors.toList());
        ArrayList<DynamicObject> toSaveBalances = new ArrayList<DynamicObject>(apBalances.length);
        for (DynamicObject apBalance : arBalanceListNotNull) {
            List<DynamicObject> arJournalList;
            DynamicObject org = apBalance.getDynamicObject("org");
            DynamicObject asstact = apBalance.getDynamicObject("asstact");
            Date startdate = apBalance.getDate("startdate");
            Date stopdate = apBalance.getDate("stopdate");
            DynamicObject currency = apBalance.getDynamicObject("currency");
            if (EmptyUtils.isEmpty((Object)startdate)) {
                arJournalList = apJournalListNotNull.stream().filter(e -> org.getPkValue().equals(e.getDynamicObject("org").getPkValue()) && asstact.getPkValue().equals(e.getDynamicObject("asstact").getPkValue()) && e.getDate("bizdate").compareTo(stopdate) < 0 && currency.getPkValue().equals(e.getDynamicObject("currency").getPkValue())).collect(Collectors.toList());
                BigDecimal prepaidamt = this.getAccount(arJournalList, "prepaidamt");
                BigDecimal localprepaidamt = this.getAccount(arJournalList, "localprepaidamt");
                if (prepaidamt.abs().compareTo(apBalance.getBigDecimal("prepaidamt").abs()) == 0 && localprepaidamt.abs().compareTo(apBalance.getBigDecimal("localprepaidamt").abs()) == 0) continue;
                apBalance.set("periodprepaidamt", (Object)BigDecimal.ZERO);
                apBalance.set("localperiodprepaidamt", (Object)BigDecimal.ZERO);
                apBalance.set("prepaidamt", (Object)prepaidamt);
                apBalance.set("localprepaidamt", (Object)localprepaidamt);
                apBalance.set("prepaidbalance", (Object)prepaidamt);
                apBalance.set("localprepaidbalance", (Object)localprepaidamt);
            } else {
                arJournalList = apJournalListNotNull.stream().filter(e -> org.getPkValue().equals(e.getDynamicObject("org").getPkValue()) && asstact.getPkValue().equals(e.getDynamicObject("asstact").getPkValue()) && e.getDate("bizdate").compareTo(stopdate) < 0 && e.getDate("bizDate").compareTo(startdate) >= 0 && currency.getPkValue().equals(e.getDynamicObject("currency").getPkValue())).collect(Collectors.toList());
                Stream<DynamicObject> stream = arBalanceListNotNull.stream().filter(e -> org.getPkValue().equals(e.getDynamicObject("org").getPkValue()) && asstact.getPkValue().equals(e.getDynamicObject("asstact").getPkValue()) && e.getDate("stopdate").compareTo(stopdate) < 0);
                DynamicObject beforeBalance = null;
                Optional<DynamicObject> beforeOne = stream.sorted((o1, o2) -> {
                    Date o1Date = o1.getDate("stopdate");
                    Date o2Date = o2.getDate("stopdate");
                    return o2Date.compareTo(o1Date);
                }).findFirst();
                if (beforeOne.isPresent()) {
                    beforeBalance = beforeOne.get();
                }
                if (beforeBalance != null) {
                    BigDecimal prepaidbalance = beforeBalance.getBigDecimal("prepaidbalance");
                    BigDecimal localprepaidbalance = beforeBalance.getBigDecimal("localprepaidbalance");
                    BigDecimal prepaidamt = this.getAccount(arJournalList, "prepaidamt");
                    BigDecimal localprepaidamt = this.getAccount(arJournalList, "localprepaidamt");
                    if (prepaidamt.abs().compareTo(apBalance.getBigDecimal("prepaidamt").abs()) == 0 && localprepaidamt.abs().compareTo(apBalance.getBigDecimal("localprepaidamt").abs()) == 0) continue;
                    apBalance.set("periodprepaidamt", (Object)prepaidbalance);
                    apBalance.set("localperiodprepaidamt", (Object)localprepaidbalance);
                    apBalance.set("prepaidamt", (Object)prepaidamt);
                    apBalance.set("localprepaidamt", (Object)localprepaidamt);
                    apBalance.set("prepaidbalance", (Object)prepaidamt.add(prepaidbalance));
                    apBalance.set("localprepaidbalance", (Object)localprepaidamt.add(localprepaidbalance));
                } else {
                    BigDecimal prepaidamt = this.getAccount(arJournalList, "prepaidamt");
                    BigDecimal localprepaidamt = this.getAccount(arJournalList, "localprepaidamt");
                    if (prepaidamt.abs().compareTo(apBalance.getBigDecimal("prepaidamt").abs()) == 0 && localprepaidamt.abs().compareTo(apBalance.getBigDecimal("localprepaidamt").abs()) == 0) continue;
                    apBalance.set("periodprepaidamt", (Object)BigDecimal.ZERO);
                    apBalance.set("localperiodprepaidamt", (Object)BigDecimal.ZERO);
                    apBalance.set("prepaidamt", (Object)prepaidamt);
                    apBalance.set("localprepaidamt", (Object)localprepaidamt);
                    apBalance.set("prepaidbalance", (Object)prepaidamt);
                    apBalance.set("localprepaidbalance", (Object)localprepaidamt);
                }
            }
            toSaveBalances.add(apBalance);
        }
        if (EmptyUtils.isNotEmpty(toSaveBalances)) {
            SaveServiceHelper.save((DynamicObject[])toSaveBalances.toArray(new DynamicObject[0]));
        }
    }

    private void updateArBalance() {
        DynamicObject[] arJournals = BusinessDataServiceHelper.load((String)"ar_journal", (String)"id,sourcebillid,receivedamt,localreceivedamt,org,asstact,bizdate,asstacttype,currency", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"cas_recbill")});
        List arJournalListNotNull = Arrays.asList(arJournals).stream().filter(e -> e.get("org") != null && e.get("asstact") != null && e.get("bizdate") != null && e.get("currency") != null).collect(Collectors.toList());
        DynamicObject[] arBalances = BusinessDataServiceHelper.load((String)"ar_balance", (String)"id,periodreceivedamt,receivedamt,receivedbalance,localperiodreceivedamt,localreceivedamt,localreceivedbalance,org,asstact,startdate,stopdate,asstacttype,currency", null);
        List arBalanceListNotNull = Arrays.asList(arBalances).stream().filter(e -> e.get("org") != null && e.get("asstact") != null && e.get("stopdate") != null && e.get("currency") != null).collect(Collectors.toList());
        ArrayList<DynamicObject> toSaveBalances = new ArrayList<DynamicObject>(arBalances.length);
        for (DynamicObject arBalance : arBalanceListNotNull) {
            List<DynamicObject> arJournalList;
            DynamicObject org = arBalance.getDynamicObject("org");
            DynamicObject asstact = arBalance.getDynamicObject("asstact");
            Date startdate = arBalance.getDate("startdate");
            Date stopdate = arBalance.getDate("stopdate");
            DynamicObject currency = arBalance.getDynamicObject("currency");
            if (EmptyUtils.isEmpty((Object)startdate)) {
                arJournalList = arJournalListNotNull.stream().filter(e -> org.getPkValue().equals(e.getDynamicObject("org").getPkValue()) && asstact.getPkValue().equals(e.getDynamicObject("asstact").getPkValue()) && e.getDate("bizdate").compareTo(stopdate) < 0 && currency.getPkValue().equals(e.getDynamicObject("currency").getPkValue())).collect(Collectors.toList());
                BigDecimal receivedamt = this.getAccount(arJournalList, "receivedamt");
                BigDecimal localreceivedamt = this.getAccount(arJournalList, "localreceivedamt");
                if (receivedamt.abs().compareTo(arBalance.getBigDecimal("receivedamt").abs()) == 0 && localreceivedamt.abs().compareTo(arBalance.getBigDecimal("localreceivedamt").abs()) == 0) continue;
                arBalance.set("periodreceivedamt", (Object)BigDecimal.ZERO);
                arBalance.set("localperiodreceivedamt", (Object)BigDecimal.ZERO);
                arBalance.set("receivedamt", (Object)receivedamt);
                arBalance.set("localreceivedamt", (Object)localreceivedamt);
                arBalance.set("receivedbalance", (Object)receivedamt);
                arBalance.set("localreceivedbalance", (Object)localreceivedamt);
            } else {
                arJournalList = arJournalListNotNull.stream().filter(e -> org.getPkValue().equals(e.getDynamicObject("org").getPkValue()) && asstact.getPkValue().equals(e.getDynamicObject("asstact").getPkValue()) && e.getDate("bizdate").compareTo(stopdate) < 0 && e.getDate("bizDate").compareTo(startdate) >= 0 && currency.getPkValue().equals(e.getDynamicObject("currency").getPkValue())).collect(Collectors.toList());
                Stream<DynamicObject> stream = arBalanceListNotNull.stream().filter(e -> org.getPkValue().equals(e.getDynamicObject("org").getPkValue()) && asstact.getPkValue().equals(e.getDynamicObject("asstact").getPkValue()) && e.getDate("stopdate").compareTo(stopdate) < 0);
                DynamicObject beforeBalance = null;
                Optional<DynamicObject> beforeOne = stream.sorted((o1, o2) -> {
                    Date o1Date = o1.getDate("stopdate");
                    Date o2Date = o2.getDate("stopdate");
                    return o2Date.compareTo(o1Date);
                }).findFirst();
                if (beforeOne.isPresent()) {
                    beforeBalance = beforeOne.get();
                }
                if (beforeBalance != null) {
                    BigDecimal receivedbalance = beforeBalance.getBigDecimal("receivedbalance");
                    BigDecimal localreceivedbalance = beforeBalance.getBigDecimal("localreceivedbalance");
                    BigDecimal receivedamt = this.getAccount(arJournalList, "receivedamt");
                    BigDecimal localreceivedamt = this.getAccount(arJournalList, "localreceivedamt");
                    if (receivedamt.abs().compareTo(arBalance.getBigDecimal("receivedamt").abs()) == 0 && localreceivedamt.abs().compareTo(arBalance.getBigDecimal("localreceivedamt").abs()) == 0) continue;
                    arBalance.set("periodreceivedamt", (Object)receivedbalance);
                    arBalance.set("localperiodreceivedamt", (Object)localreceivedbalance);
                    arBalance.set("receivedamt", (Object)receivedamt);
                    arBalance.set("localreceivedamt", (Object)localreceivedamt);
                    arBalance.set("receivedbalance", (Object)receivedamt.add(receivedbalance));
                    arBalance.set("localreceivedbalance", (Object)localreceivedamt.add(localreceivedbalance));
                } else {
                    BigDecimal receivedamt = this.getAccount(arJournalList, "receivedamt");
                    BigDecimal localreceivedamt = this.getAccount(arJournalList, "localreceivedamt");
                    if (receivedamt.abs().compareTo(arBalance.getBigDecimal("receivedamt").abs()) == 0 && localreceivedamt.abs().compareTo(arBalance.getBigDecimal("localreceivedamt").abs()) == 0) continue;
                    arBalance.set("periodreceivedamt", (Object)BigDecimal.ZERO);
                    arBalance.set("localperiodreceivedamt", (Object)BigDecimal.ZERO);
                    arBalance.set("receivedamt", (Object)receivedamt);
                    arBalance.set("localreceivedamt", (Object)localreceivedamt);
                    arBalance.set("receivedbalance", (Object)receivedamt);
                    arBalance.set("localreceivedbalance", (Object)localreceivedamt);
                }
            }
            toSaveBalances.add(arBalance);
        }
        if (EmptyUtils.isNotEmpty(toSaveBalances)) {
            SaveServiceHelper.save((DynamicObject[])toSaveBalances.toArray(new DynamicObject[0]));
        }
    }

    private void updateApJournal() {
        DynamicObject[] payBills;
        DynamicObject[] apJournals = BusinessDataServiceHelper.load((String)"ap_journal", (String)"id,sourcebillid,prepaidamt,localprepaidamt", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"cas_paybill")});
        Map<Object, DynamicObject> apJournalsMap = this.toMap(apJournals, false);
        HashMap<Object, DynamicObject> toSaveApJournalsMap = new HashMap<Object, DynamicObject>(apJournals.length);
        HashSet<Long> payBillIds = new HashSet<Long>(apJournals.length);
        for (DynamicObject arJournal : apJournals) {
            payBillIds.add(arJournal.getLong("sourcebillid"));
        }
        for (DynamicObject payBill : payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,entry.e_payableamt,entry.e_payablelocamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIds)})) {
            DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
            if (!EmptyUtils.isNotEmpty((Object)entry)) continue;
            BigDecimal payableAmt = BigDecimal.ZERO;
            BigDecimal payableLocAmt = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                payableAmt = payableAmt.add(row.getBigDecimal("e_payableamt"));
                payableLocAmt = payableLocAmt.add(row.getBigDecimal("e_payablelocamt"));
            }
            DynamicObject apJournal = apJournalsMap.get(payBill.getPkValue());
            apJournal.set("prepaidamt", (Object)payableAmt);
            apJournal.set("localprepaidamt", (Object)payableLocAmt);
            toSaveApJournalsMap.put(apJournal.getPkValue(), apJournal);
        }
        if (EmptyUtils.isNotEmpty(toSaveApJournalsMap)) {
            SaveServiceHelper.save((DynamicObject[])toSaveApJournalsMap.values().toArray(new DynamicObject[0]));
        }
    }

    private void updateArJournal() {
        DynamicObject[] recBills;
        DynamicObject[] arJournals = BusinessDataServiceHelper.load((String)"ar_journal", (String)"id,sourcebillid,receivedamt,localreceivedamt", (QFilter[])new QFilter[]{new QFilter("sourcebilltype", "=", (Object)"cas_recbill")});
        Map<Object, DynamicObject> arJournalsMap = this.toMap(arJournals, false);
        HashMap<Object, DynamicObject> toSaveArJournalsMap = new HashMap<Object, DynamicObject>(arJournals.length);
        HashSet<Long> recBillIds = new HashSet<Long>(arJournals.length);
        for (DynamicObject arJournal : arJournals) {
            recBillIds.add(arJournal.getLong("sourcebillid"));
        }
        for (DynamicObject recBill : recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,entry.e_receivableamt,entry.e_receivablelocamt", (QFilter[])new QFilter[]{new QFilter("id", "in", recBillIds)})) {
            DynamicObjectCollection entry = recBill.getDynamicObjectCollection("entry");
            if (!EmptyUtils.isNotEmpty((Object)entry)) continue;
            BigDecimal receivableAmt = BigDecimal.ZERO;
            BigDecimal receivableLocAmt = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                receivableAmt = receivableAmt.add(row.getBigDecimal("e_receivableamt"));
                receivableLocAmt = receivableLocAmt.add(row.getBigDecimal("e_receivablelocamt"));
            }
            DynamicObject arJournal = arJournalsMap.get(recBill.getPkValue());
            arJournal.set("receivedamt", (Object)receivableAmt);
            arJournal.set("localreceivedamt", (Object)receivableLocAmt);
            toSaveArJournalsMap.put(arJournal.getPkValue(), arJournal);
        }
        if (EmptyUtils.isNotEmpty(toSaveArJournalsMap)) {
            SaveServiceHelper.save((DynamicObject[])toSaveArJournalsMap.values().toArray(new DynamicObject[0]));
        }
    }

    private BigDecimal getAccount(List<DynamicObject> rows, String str) {
        BigDecimal account = BigDecimal.ZERO;
        for (DynamicObject row : rows) {
            account = account.add(row.getBigDecimal(str));
        }
        return account;
    }

    private Map<Object, DynamicObject> toMap(DynamicObject[] bills, boolean isPk) {
        if (EmptyUtils.isNotEmpty((Object)bills)) {
            if (isPk) {
                return Arrays.stream(bills).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e));
            }
            return Arrays.stream(bills).collect(Collectors.toMap(e -> e.get("sourcebillid"), e -> e));
        }
        return new HashMap<Object, DynamicObject>(0);
    }
}

