/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;

public class ArBadDebtPlanUpgradePlugin
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ArBadDebtPlanUpgradePlugin.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        boolean success = true;
        String log = "agingstartdate Upgrade SUCCESS!";
        try (TXHandle tx = TX.requiresNew((String)"updateParam");){
            try {
                String qrySql = "select fentryid,fagingstartdatefield from t_ar_accrualplanentry where faccrualentityobjid = 1405616784618318848";
                DataSet upgradeDatas = DB.queryDataSet((String)"ArBadDebtPlanUpgradePlugin", (DBRoute)DBRouteConst.AR, (String)qrySql);
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ar_finarbill");
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>(8);
                for (Row upgradeData : upgradeDatas) {
                    String agingDate = upgradeData.getString("fagingstartdatefield");
                    IDataEntityProperty property = entityType.findProperty(agingDate);
                    if (property == null) continue;
                    String parentName = property.getParent().getName();
                    if ("entry".equals(parentName)) {
                        agingDate = "entry." + agingDate;
                    } else {
                        if (!"planentity".equals(parentName)) continue;
                        agingDate = "planentity." + agingDate;
                    }
                    Object[] params = new Object[]{agingDate, upgradeData.getLong("fentryid")};
                    updateParams.add(params);
                }
                if (!updateParams.isEmpty()) {
                    String updateSql = "update t_ar_accrualplanentry set fagingstartdatefield = ? where fentryid = ? ";
                    DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateSql, updateParams);
                }
            }
            catch (Throwable t) {
                tx.markRollback();
                logger.error("--\u8ba1\u63d0\u65b9\u6848\u8d26\u9f84\u8d77\u7b97\u65e5\u5347\u7ea7\u5931\u8d25--", t);
            }
        }
        catch (Exception e) {
            log = ArApHelper.getStackTraceMessage((Throwable)e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", log);
        return new UpgradeResult(resultMap);
    }
}

