/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.service.upgrade.AbstractUpgradeHandle;

public class ArBadDebtPrepareAgingAndPercentUpgradeHandle
extends AbstractUpgradeHandle {
    protected void upgrade(List<Long> billIds) {
        String billQuerySql = "select fid,fagingrange,faccrualpercent from t_ar_baddebtprepare where fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ");";
        DataSet billDataSet = DB.queryDataSet((String)"badDebtEntryId", (DBRoute)DBRouteConst.AR, (String)billQuerySql);
        HashMap<Long, String> idAndAging = new HashMap<Long, String>(8);
        HashMap<Long, BigDecimal> idAndPercent = new HashMap<Long, BigDecimal>(8);
        for (Row row : billDataSet) {
            Long id = row.getLong("fid");
            String agingRange = row.getString("fagingrange");
            BigDecimal percent = row.getBigDecimal("faccrualpercent");
            idAndAging.put(id, agingRange);
            idAndPercent.put(id, percent);
        }
        String querySql = "select fid,fentryid,fagingrange,faccrualpercent from t_ar_baddebtprepareentry where fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ") order by fentryid;";
        DataSet entryDataSet = DB.queryDataSet((String)"badDebtEntryId", (DBRoute)DBRouteConst.AR, (String)querySql);
        ArrayList<Object[]> params = new ArrayList<Object[]>(1024);
        for (Row row : entryDataSet) {
            Long id = row.getLong("fid");
            Long entryId = row.getLong("fentryid");
            String agingRange = (String)idAndAging.get(id);
            BigDecimal percent = (BigDecimal)idAndPercent.get(id);
            Object[] param = new Object[]{agingRange, percent, entryId};
            params.add(param);
        }
        String updateSql = "update t_ar_baddebtprepareentry set fagingrange = ?,faccrualpercent = ? where fentryid = ?";
        DB.executeBatch((DBRoute)DBRouteConst.AR, (String)updateSql, params);
    }

    public String getDateFieldName() {
        return "fcreatetime";
    }

    public String getUpgradeEntryName() {
        return "t_ar_baddebtprepareentry";
    }
}

