/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.arapcommon.balance.BalanceRebuildService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.service.log.OpLogInfo;
import kd.fi.arapcommon.util.DateUtils;

public class ArCloseRecordandBalanceRepairPlugin
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ArCloseRecordandBalanceRepairPlugin.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        DynamicObject closeRecord = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)"ar_closerecord")});
        DynamicObject balance = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)"ar_balance")});
        if (ArApHelper.queryArIsNotInit() || closeRecord == null || balance == null) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
            resultMap.put("info", "do without this upgrade plugin");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        String log = "ArCloseRecordandBalanceRepairPlugin exe success";
        String info = "ArCloseRecordandBalanceRepairPlugin exe success";
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.repair();
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            log = ArApHelper.getStackTraceMessage((Throwable)e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", log);
        }
        return new UpgradeResult(resultMap);
    }

    private void repair() {
        Date repairStartDate = DateUtils.getDate((int)2021, (int)12, (int)1);
        QFilter closeDateFilter = new QFilter("closedate", ">", (Object)DateUtils.getDataFormat((Date)repairStartDate, (boolean)true));
        DataSet closeRecords = QueryServiceHelper.queryDataSet((String)"arcloserecord.load", (String)"ar_closerecord", (String)"id,org,closedate", (QFilter[])new QFilter[]{closeDateFilter}, (String)"closedate asc");
        ArrayList<Long> repeatCloseRecordIds = new ArrayList<Long>(10);
        HashSet<Long> rebuildOrgIds = new HashSet<Long>(10);
        Date rebuildDate = new Date();
        HashMap<Long, Date> orgCloseDateMap = new HashMap<Long, Date>(8);
        for (Row closeRecord : closeRecords) {
            Long orgId = closeRecord.getLong("org");
            Date date = DateUtils.getDataFormat((Date)closeRecord.getDate("closedate"), (boolean)true);
            Date date2 = (Date)orgCloseDateMap.get(orgId);
            if (date2 == null) {
                orgCloseDateMap.put(orgId, date);
                continue;
            }
            if (date.compareTo(date2) == 0) {
                repeatCloseRecordIds.add(closeRecord.getLong("id"));
                rebuildOrgIds.add(orgId);
                if (date.compareTo(rebuildDate) >= 0) continue;
                rebuildDate = date2;
                continue;
            }
            if (date.compareTo(date2) <= 0) continue;
            orgCloseDateMap.put(orgId, date);
        }
        if (!ObjectUtils.isEmpty(repeatCloseRecordIds)) {
            DataSet backUpCloseRecords = QueryServiceHelper.queryDataSet((String)"arbackupcloserecord.load", (String)"ar_closerecord", (String)"id,org,closedate", (QFilter[])new QFilter[]{closeDateFilter}, (String)"closedate asc");
            this.addLogforBackUp("arBackUpCloseRecord", backUpCloseRecords);
            DeleteServiceHelper.delete((String)"ar_closerecord", (QFilter[])new QFilter[]{new QFilter("id", "in", repeatCloseRecordIds)});
            QFilter stopDateFilter = new QFilter("stopdate", ">=", (Object)rebuildDate);
            QFilter orgFilter = new QFilter("org", "in", rebuildOrgIds);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"arbackupbalance.load", (String)"ar_balance", (String)"closeid,org,startdate,stopdate", (QFilter[])new QFilter[]{stopDateFilter, orgFilter}, (String)"closeid asc");
            this.addLogforBackUp("arBackUpBalance", dataSet);
            DeleteServiceHelper.delete((String)"ar_balance", (QFilter[])new QFilter[]{stopDateFilter, orgFilter});
            for (Long rebuildOrgId : rebuildOrgIds) {
                BalanceRebuildService service = new BalanceRebuildService(rebuildOrgId, rebuildDate, "ar");
                service.rebuild();
            }
        }
        HashMap<Long, DynamicObject> orgCurPeriodMap = new HashMap<Long, DynamicObject>(8);
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)"ar_init", (String)"org, curperiod", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)});
        for (DynamicObject init : inits) {
            orgCurPeriodMap.put(init.getLong("org.id"), init.getDynamicObject("curperiod"));
        }
        if (ObjectUtils.isEmpty(orgCurPeriodMap)) {
            return;
        }
        for (Map.Entry entry : orgCurPeriodMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Date curPeriodEndDate = ((DynamicObject)entry.getValue()).getDate("enddate");
            QFilter orgIdFilter = new QFilter("org", "=", (Object)orgId);
            QFilter dateFilter = new QFilter("closedate", ">=", (Object)DateUtils.getDataFormat((Date)curPeriodEndDate, (boolean)true));
            DataSet backUpCloseRecords = QueryServiceHelper.queryDataSet((String)"arbackupcloserecordagain.load", (String)"ar_closerecord", (String)"id,org,closedate", (QFilter[])new QFilter[]{orgIdFilter, dateFilter}, (String)"closedate asc");
            this.addLogforBackUp("arBackUpCloseRecord", backUpCloseRecords);
            DeleteServiceHelper.delete((String)"ar_closerecord", (QFilter[])new QFilter[]{orgIdFilter, dateFilter});
            Date curPeriodStartDate = ((DynamicObject)entry.getValue()).getDate("begindate");
            QFilter balanceDateFilter = new QFilter("startdate", ">=", (Object)DateUtils.getDataFormat((Date)curPeriodStartDate, (boolean)true));
            DataSet backUpBalances = QueryServiceHelper.queryDataSet((String)"arbackupbalanceagain.load", (String)"ar_balance", (String)"closeid,org,startdate,stopdate", (QFilter[])new QFilter[]{orgIdFilter, balanceDateFilter}, (String)"closeid asc");
            this.addLogforBackUp("arBackUpBalance", backUpBalances);
            DeleteServiceHelper.delete((String)"ar_balance", (QFilter[])new QFilter[]{balanceDateFilter, orgIdFilter});
        }
    }

    private void addLogforBackUp(String opName, DataSet backUpDatas) {
        try {
            StringBuilder param = new StringBuilder();
            for (Row backUpData : backUpDatas) {
                if ("arBackUpCloseRecord".equals(opName)) {
                    param.append("id:").append(backUpData.getLong("id")).append('\n');
                    param.append("orgId:").append(backUpData.getLong("org")).append('\n');
                    param.append("closedate:").append(backUpData.getDate("closedate")).append('\n');
                    continue;
                }
                param.append("closeId:").append(backUpData.getLong("closeid")).append('\n');
                param.append("orgId:").append(backUpData.getLong("org")).append('\n');
                param.append("startDate:").append(backUpData.getDate("startdate")).append('\n');
                param.append("stopDate:").append(backUpData.getDate("stopdate")).append('\n');
            }
            this.addLogforBackUp(opName, param);
        }
        catch (Exception e) {
            logger.info(ArApHelper.getStackTraceMessage((Throwable)e));
        }
    }

    private void addLogforBackUp(String opName, StringBuilder param) {
        String str = param.toString();
        OpLogInfo log = new OpLogInfo();
        log.setOpName(opName).setBillNo(opName).setOpDescription((Object)str).setObjJsonStr(str).setIgnoreLogParam(true);
        OpLogServiceHelper.addLog((OpLogInfo)log);
    }
}

