/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice.upgrade;

import java.util.HashMap;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.helper.ArApHelper;

public class ArConcdataruleUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (!ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgrade();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    private void upgrade() {
        try (TXHandle h = TX.requiresNew();){
            try {
                DBRoute ai = DBRoute.of((String)"ai");
                String updSql = "UPDATE T_AI_RECDATARULE SET FENABLE = 0 WHERE FID = 874515865658216448";
                DB.execute((DBRoute)ai, (String)updSql);
            }
            catch (Exception ex) {
                h.markRollback();
            }
        }
    }

    public String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

